<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PretraziOnto StructType
 * @subpackage Structs
 */
class PretraziOnto extends AbstractStructBase
{
    /**
     * The ontoPretragaInput
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OntoPretragaInput
     */
    public $ontoPretragaInput;
    /**
     * The lokacijaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lokacijaID;
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * The securityToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityToken;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $limit;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $offset;
    /**
     * Constructor method for PretraziOnto
     * @uses PretraziOnto::setOntoPretragaInput()
     * @uses PretraziOnto::setLokacijaID()
     * @uses PretraziOnto::setUsername()
     * @uses PretraziOnto::setSecurityToken()
     * @uses PretraziOnto::setLimit()
     * @uses PretraziOnto::setOffset()
     * @param \StructType\OntoPretragaInput $ontoPretragaInput
     * @param int $lokacijaID
     * @param string $username
     * @param string $securityToken
     * @param int $limit
     * @param int $offset
     */
    public function __construct(\StructType\OntoPretragaInput $ontoPretragaInput = null, $lokacijaID = null, $username = null, $securityToken = null, $limit = null, $offset = null)
    {
        $this
            ->setOntoPretragaInput($ontoPretragaInput)
            ->setLokacijaID($lokacijaID)
            ->setUsername($username)
            ->setSecurityToken($securityToken)
            ->setLimit($limit)
            ->setOffset($offset);
    }
    /**
     * Get ontoPretragaInput value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OntoPretragaInput|null
     */
    public function getOntoPretragaInput()
    {
        return isset($this->ontoPretragaInput) ? $this->ontoPretragaInput : null;
    }
    /**
     * Set ontoPretragaInput value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OntoPretragaInput $ontoPretragaInput
     * @return \StructType\PretraziOnto
     */
    public function setOntoPretragaInput(\StructType\OntoPretragaInput $ontoPretragaInput = null)
    {
        if (is_null($ontoPretragaInput) || (is_array($ontoPretragaInput) && empty($ontoPretragaInput))) {
            unset($this->ontoPretragaInput);
        } else {
            $this->ontoPretragaInput = $ontoPretragaInput;
        }
        return $this;
    }
    /**
     * Get lokacijaID value
     * @return int|null
     */
    public function getLokacijaID()
    {
        return $this->lokacijaID;
    }
    /**
     * Set lokacijaID value
     * @param int $lokacijaID
     * @return \StructType\PretraziOnto
     */
    public function setLokacijaID($lokacijaID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaID) && !is_numeric($lokacijaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lokacijaID)), __LINE__);
        }
        $this->lokacijaID = $lokacijaID;
        return $this;
    }
    /**
     * Get username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->username) ? $this->username : null;
    }
    /**
     * Set username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\PretraziOnto
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->username);
        } else {
            $this->username = $username;
        }
        return $this;
    }
    /**
     * Get securityToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityToken()
    {
        return isset($this->securityToken) ? $this->securityToken : null;
    }
    /**
     * Set securityToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityToken
     * @return \StructType\PretraziOnto
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($securityToken)), __LINE__);
        }
        if (is_null($securityToken) || (is_array($securityToken) && empty($securityToken))) {
            unset($this->securityToken);
        } else {
            $this->securityToken = $securityToken;
        }
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\PretraziOnto
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\PretraziOnto
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PretraziOnto
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
