<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOntoResponse ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfOntoResponse
 * @subpackage Arrays
 */
class ArrayOfOntoResponse extends AbstractStructArrayBase
{
    /**
     * The OntoResponse
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OntoResponse[]
     */
    public $OntoResponse;
    /**
     * Constructor method for ArrayOfOntoResponse
     * @uses ArrayOfOntoResponse::setOntoResponse()
     * @param \StructType\OntoResponse[] $ontoResponse
     */
    public function __construct(array $ontoResponse = array())
    {
        $this
            ->setOntoResponse($ontoResponse);
    }
    /**
     * Get OntoResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OntoResponse[]|null
     */
    public function getOntoResponse()
    {
        return isset($this->OntoResponse) ? $this->OntoResponse : null;
    }
    /**
     * Set OntoResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OntoResponse[] $ontoResponse
     * @return \ArrayType\ArrayOfOntoResponse
     */
    public function setOntoResponse(array $ontoResponse = array())
    {
        foreach ($ontoResponse as $arrayOfOntoResponseOntoResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfOntoResponseOntoResponseItem instanceof \StructType\OntoResponse) {
                throw new \InvalidArgumentException(sprintf('The OntoResponse property can only contain items of \StructType\OntoResponse, "%s" given', is_object($arrayOfOntoResponseOntoResponseItem) ? get_class($arrayOfOntoResponseOntoResponseItem) : gettype($arrayOfOntoResponseOntoResponseItem)), __LINE__);
            }
        }
        if (is_null($ontoResponse) || (is_array($ontoResponse) && empty($ontoResponse))) {
            unset($this->OntoResponse);
        } else {
            $this->OntoResponse = $ontoResponse;
        }
        return $this;
    }
    /**
     * Add item to OntoResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\OntoResponse $item
     * @return \ArrayType\ArrayOfOntoResponse
     */
    public function addToOntoResponse(\StructType\OntoResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OntoResponse) {
            throw new \InvalidArgumentException(sprintf('The OntoResponse property can only contain items of \StructType\OntoResponse, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->OntoResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OntoResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OntoResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OntoResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OntoResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OntoResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OntoResponse
     */
    public function getAttributeName()
    {
        return 'OntoResponse';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfOntoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
