<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipOtpada StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TipOtpada
 * @subpackage Structs
 */
class TipOtpada extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The Naziv
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The TipOtpadaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TipOtpadaID;
    /**
     * Constructor method for TipOtpada
     * @uses TipOtpada::setAktivan()
     * @uses TipOtpada::setNaziv()
     * @uses TipOtpada::setTipOtpadaID()
     * @param bool $aktivan
     * @param string $naziv
     * @param int $tipOtpadaID
     */
    public function __construct($aktivan = null, $naziv = null, $tipOtpadaID = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setNaziv($naziv)
            ->setTipOtpadaID($tipOtpadaID);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\TipOtpada
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\TipOtpada
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get TipOtpadaID value
     * @return int|null
     */
    public function getTipOtpadaID()
    {
        return $this->TipOtpadaID;
    }
    /**
     * Set TipOtpadaID value
     * @param int $tipOtpadaID
     * @return \StructType\TipOtpada
     */
    public function setTipOtpadaID($tipOtpadaID = null)
    {
        // validation for constraint: int
        if (!is_null($tipOtpadaID) && !is_numeric($tipOtpadaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tipOtpadaID)), __LINE__);
        }
        $this->TipOtpadaID = $tipOtpadaID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TipOtpada
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
