<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZatvoriOntoP StructType
 * @subpackage Structs
 */
class ZatvoriOntoP extends AbstractStructBase
{
    /**
     * The ontoPID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ontoPID;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityToken;
    /**
     * Constructor method for ZatvoriOntoP
     * @uses ZatvoriOntoP::setOntoPID()
     * @uses ZatvoriOntoP::setUsername()
     * @uses ZatvoriOntoP::setSecurityToken()
     * @param int $ontoPID
     * @param string $username
     * @param string $securityToken
     */
    public function __construct($ontoPID = null, $username = null, $securityToken = null)
    {
        $this
            ->setOntoPID($ontoPID)
            ->setUsername($username)
            ->setSecurityToken($securityToken);
    }
    /**
     * Get ontoPID value
     * @return int|null
     */
    public function getOntoPID()
    {
        return $this->ontoPID;
    }
    /**
     * Set ontoPID value
     * @param int $ontoPID
     * @return \StructType\ZatvoriOntoP
     */
    public function setOntoPID($ontoPID = null)
    {
        // validation for constraint: int
        if (!is_null($ontoPID) && !(is_int($ontoPID) || ctype_digit($ontoPID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ontoPID, true), gettype($ontoPID)), __LINE__);
        }
        $this->ontoPID = $ontoPID;
        return $this;
    }
    /**
     * Get username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->username) ? $this->username : null;
    }
    /**
     * Set username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\ZatvoriOntoP
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->username);
        } else {
            $this->username = $username;
        }
        return $this;
    }
    /**
     * Get securityToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityToken()
    {
        return isset($this->securityToken) ? $this->securityToken : null;
    }
    /**
     * Set securityToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityToken
     * @return \StructType\ZatvoriOntoP
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityToken, true), gettype($securityToken)), __LINE__);
        }
        if (is_null($securityToken) || (is_array($securityToken) && empty($securityToken))) {
            unset($this->securityToken);
        } else {
            $this->securityToken = $securityToken;
        }
        return $this;
    }
}
