<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrateciListHOznake StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PrateciListHOznake
 * @subpackage Structs
 */
class PrateciListHOznake extends AbstractStructBase
{
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The OznakaH
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OznakaH
     */
    public $OznakaH;
    /**
     * The OznakaHID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OznakaHID;
    /**
     * The PrateciList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PrateciList
     */
    public $PrateciList;
    /**
     * The PrateciListHOznakeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PrateciListHOznakeID;
    /**
     * The PrateciListID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PrateciListID;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * Constructor method for PrateciListHOznake
     * @uses PrateciListHOznake::setDatumKreiranja()
     * @uses PrateciListHOznake::setDatumPromjene()
     * @uses PrateciListHOznake::setKreirao()
     * @uses PrateciListHOznake::setOznakaH()
     * @uses PrateciListHOznake::setOznakaHID()
     * @uses PrateciListHOznake::setPrateciList()
     * @uses PrateciListHOznake::setPrateciListHOznakeID()
     * @uses PrateciListHOznake::setPrateciListID()
     * @uses PrateciListHOznake::setPromijenio()
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param string $kreirao
     * @param \StructType\OznakaH $oznakaH
     * @param int $oznakaHID
     * @param \StructType\PrateciList $prateciList
     * @param int $prateciListHOznakeID
     * @param int $prateciListID
     * @param string $promijenio
     */
    public function __construct($datumKreiranja = null, $datumPromjene = null, $kreirao = null, \StructType\OznakaH $oznakaH = null, $oznakaHID = null, \StructType\PrateciList $prateciList = null, $prateciListHOznakeID = null, $prateciListID = null, $promijenio = null)
    {
        $this
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setKreirao($kreirao)
            ->setOznakaH($oznakaH)
            ->setOznakaHID($oznakaHID)
            ->setPrateciList($prateciList)
            ->setPrateciListHOznakeID($prateciListHOznakeID)
            ->setPrateciListID($prateciListID)
            ->setPromijenio($promijenio);
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\PrateciListHOznake
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\PrateciListHOznake
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\PrateciListHOznake
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get OznakaH value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OznakaH|null
     */
    public function getOznakaH()
    {
        return isset($this->OznakaH) ? $this->OznakaH : null;
    }
    /**
     * Set OznakaH value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OznakaH $oznakaH
     * @return \StructType\PrateciListHOznake
     */
    public function setOznakaH(\StructType\OznakaH $oznakaH = null)
    {
        if (is_null($oznakaH) || (is_array($oznakaH) && empty($oznakaH))) {
            unset($this->OznakaH);
        } else {
            $this->OznakaH = $oznakaH;
        }
        return $this;
    }
    /**
     * Get OznakaHID value
     * @return int|null
     */
    public function getOznakaHID()
    {
        return $this->OznakaHID;
    }
    /**
     * Set OznakaHID value
     * @param int $oznakaHID
     * @return \StructType\PrateciListHOznake
     */
    public function setOznakaHID($oznakaHID = null)
    {
        // validation for constraint: int
        if (!is_null($oznakaHID) && !(is_int($oznakaHID) || ctype_digit($oznakaHID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oznakaHID, true), gettype($oznakaHID)), __LINE__);
        }
        $this->OznakaHID = $oznakaHID;
        return $this;
    }
    /**
     * Get PrateciList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PrateciList|null
     */
    public function getPrateciList()
    {
        return isset($this->PrateciList) ? $this->PrateciList : null;
    }
    /**
     * Set PrateciList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PrateciList $prateciList
     * @return \StructType\PrateciListHOznake
     */
    public function setPrateciList(\StructType\PrateciList $prateciList = null)
    {
        if (is_null($prateciList) || (is_array($prateciList) && empty($prateciList))) {
            unset($this->PrateciList);
        } else {
            $this->PrateciList = $prateciList;
        }
        return $this;
    }
    /**
     * Get PrateciListHOznakeID value
     * @return int|null
     */
    public function getPrateciListHOznakeID()
    {
        return $this->PrateciListHOznakeID;
    }
    /**
     * Set PrateciListHOznakeID value
     * @param int $prateciListHOznakeID
     * @return \StructType\PrateciListHOznake
     */
    public function setPrateciListHOznakeID($prateciListHOznakeID = null)
    {
        // validation for constraint: int
        if (!is_null($prateciListHOznakeID) && !(is_int($prateciListHOznakeID) || ctype_digit($prateciListHOznakeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prateciListHOznakeID, true), gettype($prateciListHOznakeID)), __LINE__);
        }
        $this->PrateciListHOznakeID = $prateciListHOznakeID;
        return $this;
    }
    /**
     * Get PrateciListID value
     * @return int|null
     */
    public function getPrateciListID()
    {
        return $this->PrateciListID;
    }
    /**
     * Set PrateciListID value
     * @param int $prateciListID
     * @return \StructType\PrateciListHOznake
     */
    public function setPrateciListID($prateciListID = null)
    {
        // validation for constraint: int
        if (!is_null($prateciListID) && !(is_int($prateciListID) || ctype_digit($prateciListID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prateciListID, true), gettype($prateciListID)), __LINE__);
        }
        $this->PrateciListID = $prateciListID;
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\PrateciListHOznake
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
}
