<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PLOPretragaInput StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PLOPretragaInput
 * @subpackage Structs
 */
class PLOPretragaInput extends AbstractStructBase
{
    /**
     * The BrojPL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrojPL;
    /**
     * The CekaMojeZakljucenje
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CekaMojeZakljucenje;
    /**
     * The CekaTudeZakljucenje
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CekaTudeZakljucenje;
    /**
     * The CekaZakljucenjeNeaktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CekaZakljucenjeNeaktivan;
    /**
     * The DatumZadnjeSinkronizacije
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumZadnjeSinkronizacije;
    /**
     * The FizikalnaSvojstvaList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $FizikalnaSvojstvaList;
    /**
     * The KljucniBrojeviList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $KljucniBrojeviList;
    /**
     * The KolicinaOtpadaDo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KolicinaOtpadaDo;
    /**
     * The KolicinaOtpadaOd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KolicinaOtpadaOd;
    /**
     * The LokacijeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $LokacijeList;
    /**
     * The NaciniPakiranjaOtpadaList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $NaciniPakiranjaOtpadaList;
    /**
     * The NastanakDo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NastanakDo;
    /**
     * The NastanakOd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NastanakOd;
    /**
     * The Odrediste
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Odrediste;
    /**
     * The OpasnostiOtpadaList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $OpasnostiOtpadaList;
    /**
     * The OvlastiZaObraduList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $OvlastiZaObraduList;
    /**
     * The OvlastiZaPreuzimanjeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $OvlastiZaPreuzimanjeList;
    /**
     * The OznakeHList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $OznakeHList;
    /**
     * The PLStatusi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $PLStatusi;
    /**
     * The Polaziste
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Polaziste;
    /**
     * The PorijekloOtpadaList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNaseljeJLSZupanija
     */
    public $PorijekloOtpadaList;
    /**
     * The Povrat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Povrat;
    /**
     * The PredavateljERPId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PredavateljERPId;
    /**
     * The PredavateljList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $PredavateljList;
    /**
     * The PreuzimateljERPId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreuzimateljERPId;
    /**
     * The PreuzimateljList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $PreuzimateljList;
    /**
     * The PrijevoznikERPId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrijevoznikERPId;
    /**
     * The PrijevoznikList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $PrijevoznikList;
    /**
     * The Storno
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Storno;
    /**
     * The TipoviOtpadaList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $TipoviOtpadaList;
    /**
     * The TvrtkeList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $TvrtkeList;
    /**
     * Constructor method for PLOPretragaInput
     * @uses PLOPretragaInput::setBrojPL()
     * @uses PLOPretragaInput::setCekaMojeZakljucenje()
     * @uses PLOPretragaInput::setCekaTudeZakljucenje()
     * @uses PLOPretragaInput::setCekaZakljucenjeNeaktivan()
     * @uses PLOPretragaInput::setDatumZadnjeSinkronizacije()
     * @uses PLOPretragaInput::setFizikalnaSvojstvaList()
     * @uses PLOPretragaInput::setKljucniBrojeviList()
     * @uses PLOPretragaInput::setKolicinaOtpadaDo()
     * @uses PLOPretragaInput::setKolicinaOtpadaOd()
     * @uses PLOPretragaInput::setLokacijeList()
     * @uses PLOPretragaInput::setNaciniPakiranjaOtpadaList()
     * @uses PLOPretragaInput::setNastanakDo()
     * @uses PLOPretragaInput::setNastanakOd()
     * @uses PLOPretragaInput::setOdrediste()
     * @uses PLOPretragaInput::setOpasnostiOtpadaList()
     * @uses PLOPretragaInput::setOvlastiZaObraduList()
     * @uses PLOPretragaInput::setOvlastiZaPreuzimanjeList()
     * @uses PLOPretragaInput::setOznakeHList()
     * @uses PLOPretragaInput::setPLStatusi()
     * @uses PLOPretragaInput::setPolaziste()
     * @uses PLOPretragaInput::setPorijekloOtpadaList()
     * @uses PLOPretragaInput::setPovrat()
     * @uses PLOPretragaInput::setPredavateljERPId()
     * @uses PLOPretragaInput::setPredavateljList()
     * @uses PLOPretragaInput::setPreuzimateljERPId()
     * @uses PLOPretragaInput::setPreuzimateljList()
     * @uses PLOPretragaInput::setPrijevoznikERPId()
     * @uses PLOPretragaInput::setPrijevoznikList()
     * @uses PLOPretragaInput::setStorno()
     * @uses PLOPretragaInput::setTipoviOtpadaList()
     * @uses PLOPretragaInput::setTvrtkeList()
     * @param string $brojPL
     * @param bool $cekaMojeZakljucenje
     * @param bool $cekaTudeZakljucenje
     * @param bool $cekaZakljucenjeNeaktivan
     * @param string $datumZadnjeSinkronizacije
     * @param \ArrayType\ArrayOfint $fizikalnaSvojstvaList
     * @param \ArrayType\ArrayOfint $kljucniBrojeviList
     * @param int $kolicinaOtpadaDo
     * @param int $kolicinaOtpadaOd
     * @param \ArrayType\ArrayOfint $lokacijeList
     * @param \ArrayType\ArrayOfint $naciniPakiranjaOtpadaList
     * @param string $nastanakDo
     * @param string $nastanakOd
     * @param string $odrediste
     * @param \ArrayType\ArrayOfint $opasnostiOtpadaList
     * @param \ArrayType\ArrayOfint $ovlastiZaObraduList
     * @param \ArrayType\ArrayOfint $ovlastiZaPreuzimanjeList
     * @param \ArrayType\ArrayOfint $oznakeHList
     * @param \ArrayType\ArrayOfint $pLStatusi
     * @param string $polaziste
     * @param \ArrayType\ArrayOfNaseljeJLSZupanija $porijekloOtpadaList
     * @param bool $povrat
     * @param string $predavateljERPId
     * @param \ArrayType\ArrayOfstring $predavateljList
     * @param string $preuzimateljERPId
     * @param \ArrayType\ArrayOfstring $preuzimateljList
     * @param string $prijevoznikERPId
     * @param \ArrayType\ArrayOfstring $prijevoznikList
     * @param bool $storno
     * @param \ArrayType\ArrayOfint $tipoviOtpadaList
     * @param \ArrayType\ArrayOfstring $tvrtkeList
     */
    public function __construct($brojPL = null, $cekaMojeZakljucenje = null, $cekaTudeZakljucenje = null, $cekaZakljucenjeNeaktivan = null, $datumZadnjeSinkronizacije = null, \ArrayType\ArrayOfint $fizikalnaSvojstvaList = null, \ArrayType\ArrayOfint $kljucniBrojeviList = null, $kolicinaOtpadaDo = null, $kolicinaOtpadaOd = null, \ArrayType\ArrayOfint $lokacijeList = null, \ArrayType\ArrayOfint $naciniPakiranjaOtpadaList = null, $nastanakDo = null, $nastanakOd = null, $odrediste = null, \ArrayType\ArrayOfint $opasnostiOtpadaList = null, \ArrayType\ArrayOfint $ovlastiZaObraduList = null, \ArrayType\ArrayOfint $ovlastiZaPreuzimanjeList = null, \ArrayType\ArrayOfint $oznakeHList = null, \ArrayType\ArrayOfint $pLStatusi = null, $polaziste = null, \ArrayType\ArrayOfNaseljeJLSZupanija $porijekloOtpadaList = null, $povrat = null, $predavateljERPId = null, \ArrayType\ArrayOfstring $predavateljList = null, $preuzimateljERPId = null, \ArrayType\ArrayOfstring $preuzimateljList = null, $prijevoznikERPId = null, \ArrayType\ArrayOfstring $prijevoznikList = null, $storno = null, \ArrayType\ArrayOfint $tipoviOtpadaList = null, \ArrayType\ArrayOfstring $tvrtkeList = null)
    {
        $this
            ->setBrojPL($brojPL)
            ->setCekaMojeZakljucenje($cekaMojeZakljucenje)
            ->setCekaTudeZakljucenje($cekaTudeZakljucenje)
            ->setCekaZakljucenjeNeaktivan($cekaZakljucenjeNeaktivan)
            ->setDatumZadnjeSinkronizacije($datumZadnjeSinkronizacije)
            ->setFizikalnaSvojstvaList($fizikalnaSvojstvaList)
            ->setKljucniBrojeviList($kljucniBrojeviList)
            ->setKolicinaOtpadaDo($kolicinaOtpadaDo)
            ->setKolicinaOtpadaOd($kolicinaOtpadaOd)
            ->setLokacijeList($lokacijeList)
            ->setNaciniPakiranjaOtpadaList($naciniPakiranjaOtpadaList)
            ->setNastanakDo($nastanakDo)
            ->setNastanakOd($nastanakOd)
            ->setOdrediste($odrediste)
            ->setOpasnostiOtpadaList($opasnostiOtpadaList)
            ->setOvlastiZaObraduList($ovlastiZaObraduList)
            ->setOvlastiZaPreuzimanjeList($ovlastiZaPreuzimanjeList)
            ->setOznakeHList($oznakeHList)
            ->setPLStatusi($pLStatusi)
            ->setPolaziste($polaziste)
            ->setPorijekloOtpadaList($porijekloOtpadaList)
            ->setPovrat($povrat)
            ->setPredavateljERPId($predavateljERPId)
            ->setPredavateljList($predavateljList)
            ->setPreuzimateljERPId($preuzimateljERPId)
            ->setPreuzimateljList($preuzimateljList)
            ->setPrijevoznikERPId($prijevoznikERPId)
            ->setPrijevoznikList($prijevoznikList)
            ->setStorno($storno)
            ->setTipoviOtpadaList($tipoviOtpadaList)
            ->setTvrtkeList($tvrtkeList);
    }
    /**
     * Get BrojPL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrojPL()
    {
        return isset($this->BrojPL) ? $this->BrojPL : null;
    }
    /**
     * Set BrojPL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brojPL
     * @return \StructType\PLOPretragaInput
     */
    public function setBrojPL($brojPL = null)
    {
        // validation for constraint: string
        if (!is_null($brojPL) && !is_string($brojPL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brojPL, true), gettype($brojPL)), __LINE__);
        }
        if (is_null($brojPL) || (is_array($brojPL) && empty($brojPL))) {
            unset($this->BrojPL);
        } else {
            $this->BrojPL = $brojPL;
        }
        return $this;
    }
    /**
     * Get CekaMojeZakljucenje value
     * @return bool|null
     */
    public function getCekaMojeZakljucenje()
    {
        return $this->CekaMojeZakljucenje;
    }
    /**
     * Set CekaMojeZakljucenje value
     * @param bool $cekaMojeZakljucenje
     * @return \StructType\PLOPretragaInput
     */
    public function setCekaMojeZakljucenje($cekaMojeZakljucenje = null)
    {
        // validation for constraint: boolean
        if (!is_null($cekaMojeZakljucenje) && !is_bool($cekaMojeZakljucenje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cekaMojeZakljucenje, true), gettype($cekaMojeZakljucenje)), __LINE__);
        }
        $this->CekaMojeZakljucenje = $cekaMojeZakljucenje;
        return $this;
    }
    /**
     * Get CekaTudeZakljucenje value
     * @return bool|null
     */
    public function getCekaTudeZakljucenje()
    {
        return $this->CekaTudeZakljucenje;
    }
    /**
     * Set CekaTudeZakljucenje value
     * @param bool $cekaTudeZakljucenje
     * @return \StructType\PLOPretragaInput
     */
    public function setCekaTudeZakljucenje($cekaTudeZakljucenje = null)
    {
        // validation for constraint: boolean
        if (!is_null($cekaTudeZakljucenje) && !is_bool($cekaTudeZakljucenje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cekaTudeZakljucenje, true), gettype($cekaTudeZakljucenje)), __LINE__);
        }
        $this->CekaTudeZakljucenje = $cekaTudeZakljucenje;
        return $this;
    }
    /**
     * Get CekaZakljucenjeNeaktivan value
     * @return bool|null
     */
    public function getCekaZakljucenjeNeaktivan()
    {
        return $this->CekaZakljucenjeNeaktivan;
    }
    /**
     * Set CekaZakljucenjeNeaktivan value
     * @param bool $cekaZakljucenjeNeaktivan
     * @return \StructType\PLOPretragaInput
     */
    public function setCekaZakljucenjeNeaktivan($cekaZakljucenjeNeaktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($cekaZakljucenjeNeaktivan) && !is_bool($cekaZakljucenjeNeaktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($cekaZakljucenjeNeaktivan, true), gettype($cekaZakljucenjeNeaktivan)), __LINE__);
        }
        $this->CekaZakljucenjeNeaktivan = $cekaZakljucenjeNeaktivan;
        return $this;
    }
    /**
     * Get DatumZadnjeSinkronizacije value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumZadnjeSinkronizacije()
    {
        return isset($this->DatumZadnjeSinkronizacije) ? $this->DatumZadnjeSinkronizacije : null;
    }
    /**
     * Set DatumZadnjeSinkronizacije value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumZadnjeSinkronizacije
     * @return \StructType\PLOPretragaInput
     */
    public function setDatumZadnjeSinkronizacije($datumZadnjeSinkronizacije = null)
    {
        // validation for constraint: string
        if (!is_null($datumZadnjeSinkronizacije) && !is_string($datumZadnjeSinkronizacije)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumZadnjeSinkronizacije, true), gettype($datumZadnjeSinkronizacije)), __LINE__);
        }
        if (is_null($datumZadnjeSinkronizacije) || (is_array($datumZadnjeSinkronizacije) && empty($datumZadnjeSinkronizacije))) {
            unset($this->DatumZadnjeSinkronizacije);
        } else {
            $this->DatumZadnjeSinkronizacije = $datumZadnjeSinkronizacije;
        }
        return $this;
    }
    /**
     * Get FizikalnaSvojstvaList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getFizikalnaSvojstvaList()
    {
        return isset($this->FizikalnaSvojstvaList) ? $this->FizikalnaSvojstvaList : null;
    }
    /**
     * Set FizikalnaSvojstvaList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $fizikalnaSvojstvaList
     * @return \StructType\PLOPretragaInput
     */
    public function setFizikalnaSvojstvaList(\ArrayType\ArrayOfint $fizikalnaSvojstvaList = null)
    {
        if (is_null($fizikalnaSvojstvaList) || (is_array($fizikalnaSvojstvaList) && empty($fizikalnaSvojstvaList))) {
            unset($this->FizikalnaSvojstvaList);
        } else {
            $this->FizikalnaSvojstvaList = $fizikalnaSvojstvaList;
        }
        return $this;
    }
    /**
     * Get KljucniBrojeviList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getKljucniBrojeviList()
    {
        return isset($this->KljucniBrojeviList) ? $this->KljucniBrojeviList : null;
    }
    /**
     * Set KljucniBrojeviList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $kljucniBrojeviList
     * @return \StructType\PLOPretragaInput
     */
    public function setKljucniBrojeviList(\ArrayType\ArrayOfint $kljucniBrojeviList = null)
    {
        if (is_null($kljucniBrojeviList) || (is_array($kljucniBrojeviList) && empty($kljucniBrojeviList))) {
            unset($this->KljucniBrojeviList);
        } else {
            $this->KljucniBrojeviList = $kljucniBrojeviList;
        }
        return $this;
    }
    /**
     * Get KolicinaOtpadaDo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKolicinaOtpadaDo()
    {
        return isset($this->KolicinaOtpadaDo) ? $this->KolicinaOtpadaDo : null;
    }
    /**
     * Set KolicinaOtpadaDo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $kolicinaOtpadaDo
     * @return \StructType\PLOPretragaInput
     */
    public function setKolicinaOtpadaDo($kolicinaOtpadaDo = null)
    {
        // validation for constraint: int
        if (!is_null($kolicinaOtpadaDo) && !(is_int($kolicinaOtpadaDo) || ctype_digit($kolicinaOtpadaDo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kolicinaOtpadaDo, true), gettype($kolicinaOtpadaDo)), __LINE__);
        }
        if (is_null($kolicinaOtpadaDo) || (is_array($kolicinaOtpadaDo) && empty($kolicinaOtpadaDo))) {
            unset($this->KolicinaOtpadaDo);
        } else {
            $this->KolicinaOtpadaDo = $kolicinaOtpadaDo;
        }
        return $this;
    }
    /**
     * Get KolicinaOtpadaOd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKolicinaOtpadaOd()
    {
        return isset($this->KolicinaOtpadaOd) ? $this->KolicinaOtpadaOd : null;
    }
    /**
     * Set KolicinaOtpadaOd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $kolicinaOtpadaOd
     * @return \StructType\PLOPretragaInput
     */
    public function setKolicinaOtpadaOd($kolicinaOtpadaOd = null)
    {
        // validation for constraint: int
        if (!is_null($kolicinaOtpadaOd) && !(is_int($kolicinaOtpadaOd) || ctype_digit($kolicinaOtpadaOd))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kolicinaOtpadaOd, true), gettype($kolicinaOtpadaOd)), __LINE__);
        }
        if (is_null($kolicinaOtpadaOd) || (is_array($kolicinaOtpadaOd) && empty($kolicinaOtpadaOd))) {
            unset($this->KolicinaOtpadaOd);
        } else {
            $this->KolicinaOtpadaOd = $kolicinaOtpadaOd;
        }
        return $this;
    }
    /**
     * Get LokacijeList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getLokacijeList()
    {
        return isset($this->LokacijeList) ? $this->LokacijeList : null;
    }
    /**
     * Set LokacijeList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $lokacijeList
     * @return \StructType\PLOPretragaInput
     */
    public function setLokacijeList(\ArrayType\ArrayOfint $lokacijeList = null)
    {
        if (is_null($lokacijeList) || (is_array($lokacijeList) && empty($lokacijeList))) {
            unset($this->LokacijeList);
        } else {
            $this->LokacijeList = $lokacijeList;
        }
        return $this;
    }
    /**
     * Get NaciniPakiranjaOtpadaList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getNaciniPakiranjaOtpadaList()
    {
        return isset($this->NaciniPakiranjaOtpadaList) ? $this->NaciniPakiranjaOtpadaList : null;
    }
    /**
     * Set NaciniPakiranjaOtpadaList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $naciniPakiranjaOtpadaList
     * @return \StructType\PLOPretragaInput
     */
    public function setNaciniPakiranjaOtpadaList(\ArrayType\ArrayOfint $naciniPakiranjaOtpadaList = null)
    {
        if (is_null($naciniPakiranjaOtpadaList) || (is_array($naciniPakiranjaOtpadaList) && empty($naciniPakiranjaOtpadaList))) {
            unset($this->NaciniPakiranjaOtpadaList);
        } else {
            $this->NaciniPakiranjaOtpadaList = $naciniPakiranjaOtpadaList;
        }
        return $this;
    }
    /**
     * Get NastanakDo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNastanakDo()
    {
        return isset($this->NastanakDo) ? $this->NastanakDo : null;
    }
    /**
     * Set NastanakDo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nastanakDo
     * @return \StructType\PLOPretragaInput
     */
    public function setNastanakDo($nastanakDo = null)
    {
        // validation for constraint: string
        if (!is_null($nastanakDo) && !is_string($nastanakDo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nastanakDo, true), gettype($nastanakDo)), __LINE__);
        }
        if (is_null($nastanakDo) || (is_array($nastanakDo) && empty($nastanakDo))) {
            unset($this->NastanakDo);
        } else {
            $this->NastanakDo = $nastanakDo;
        }
        return $this;
    }
    /**
     * Get NastanakOd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNastanakOd()
    {
        return isset($this->NastanakOd) ? $this->NastanakOd : null;
    }
    /**
     * Set NastanakOd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nastanakOd
     * @return \StructType\PLOPretragaInput
     */
    public function setNastanakOd($nastanakOd = null)
    {
        // validation for constraint: string
        if (!is_null($nastanakOd) && !is_string($nastanakOd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nastanakOd, true), gettype($nastanakOd)), __LINE__);
        }
        if (is_null($nastanakOd) || (is_array($nastanakOd) && empty($nastanakOd))) {
            unset($this->NastanakOd);
        } else {
            $this->NastanakOd = $nastanakOd;
        }
        return $this;
    }
    /**
     * Get Odrediste value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOdrediste()
    {
        return isset($this->Odrediste) ? $this->Odrediste : null;
    }
    /**
     * Set Odrediste value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $odrediste
     * @return \StructType\PLOPretragaInput
     */
    public function setOdrediste($odrediste = null)
    {
        // validation for constraint: string
        if (!is_null($odrediste) && !is_string($odrediste)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($odrediste, true), gettype($odrediste)), __LINE__);
        }
        if (is_null($odrediste) || (is_array($odrediste) && empty($odrediste))) {
            unset($this->Odrediste);
        } else {
            $this->Odrediste = $odrediste;
        }
        return $this;
    }
    /**
     * Get OpasnostiOtpadaList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getOpasnostiOtpadaList()
    {
        return isset($this->OpasnostiOtpadaList) ? $this->OpasnostiOtpadaList : null;
    }
    /**
     * Set OpasnostiOtpadaList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $opasnostiOtpadaList
     * @return \StructType\PLOPretragaInput
     */
    public function setOpasnostiOtpadaList(\ArrayType\ArrayOfint $opasnostiOtpadaList = null)
    {
        if (is_null($opasnostiOtpadaList) || (is_array($opasnostiOtpadaList) && empty($opasnostiOtpadaList))) {
            unset($this->OpasnostiOtpadaList);
        } else {
            $this->OpasnostiOtpadaList = $opasnostiOtpadaList;
        }
        return $this;
    }
    /**
     * Get OvlastiZaObraduList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getOvlastiZaObraduList()
    {
        return isset($this->OvlastiZaObraduList) ? $this->OvlastiZaObraduList : null;
    }
    /**
     * Set OvlastiZaObraduList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $ovlastiZaObraduList
     * @return \StructType\PLOPretragaInput
     */
    public function setOvlastiZaObraduList(\ArrayType\ArrayOfint $ovlastiZaObraduList = null)
    {
        if (is_null($ovlastiZaObraduList) || (is_array($ovlastiZaObraduList) && empty($ovlastiZaObraduList))) {
            unset($this->OvlastiZaObraduList);
        } else {
            $this->OvlastiZaObraduList = $ovlastiZaObraduList;
        }
        return $this;
    }
    /**
     * Get OvlastiZaPreuzimanjeList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getOvlastiZaPreuzimanjeList()
    {
        return isset($this->OvlastiZaPreuzimanjeList) ? $this->OvlastiZaPreuzimanjeList : null;
    }
    /**
     * Set OvlastiZaPreuzimanjeList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $ovlastiZaPreuzimanjeList
     * @return \StructType\PLOPretragaInput
     */
    public function setOvlastiZaPreuzimanjeList(\ArrayType\ArrayOfint $ovlastiZaPreuzimanjeList = null)
    {
        if (is_null($ovlastiZaPreuzimanjeList) || (is_array($ovlastiZaPreuzimanjeList) && empty($ovlastiZaPreuzimanjeList))) {
            unset($this->OvlastiZaPreuzimanjeList);
        } else {
            $this->OvlastiZaPreuzimanjeList = $ovlastiZaPreuzimanjeList;
        }
        return $this;
    }
    /**
     * Get OznakeHList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getOznakeHList()
    {
        return isset($this->OznakeHList) ? $this->OznakeHList : null;
    }
    /**
     * Set OznakeHList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $oznakeHList
     * @return \StructType\PLOPretragaInput
     */
    public function setOznakeHList(\ArrayType\ArrayOfint $oznakeHList = null)
    {
        if (is_null($oznakeHList) || (is_array($oznakeHList) && empty($oznakeHList))) {
            unset($this->OznakeHList);
        } else {
            $this->OznakeHList = $oznakeHList;
        }
        return $this;
    }
    /**
     * Get PLStatusi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getPLStatusi()
    {
        return isset($this->PLStatusi) ? $this->PLStatusi : null;
    }
    /**
     * Set PLStatusi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $pLStatusi
     * @return \StructType\PLOPretragaInput
     */
    public function setPLStatusi(\ArrayType\ArrayOfint $pLStatusi = null)
    {
        if (is_null($pLStatusi) || (is_array($pLStatusi) && empty($pLStatusi))) {
            unset($this->PLStatusi);
        } else {
            $this->PLStatusi = $pLStatusi;
        }
        return $this;
    }
    /**
     * Get Polaziste value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPolaziste()
    {
        return isset($this->Polaziste) ? $this->Polaziste : null;
    }
    /**
     * Set Polaziste value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $polaziste
     * @return \StructType\PLOPretragaInput
     */
    public function setPolaziste($polaziste = null)
    {
        // validation for constraint: string
        if (!is_null($polaziste) && !is_string($polaziste)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($polaziste, true), gettype($polaziste)), __LINE__);
        }
        if (is_null($polaziste) || (is_array($polaziste) && empty($polaziste))) {
            unset($this->Polaziste);
        } else {
            $this->Polaziste = $polaziste;
        }
        return $this;
    }
    /**
     * Get PorijekloOtpadaList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNaseljeJLSZupanija|null
     */
    public function getPorijekloOtpadaList()
    {
        return isset($this->PorijekloOtpadaList) ? $this->PorijekloOtpadaList : null;
    }
    /**
     * Set PorijekloOtpadaList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNaseljeJLSZupanija $porijekloOtpadaList
     * @return \StructType\PLOPretragaInput
     */
    public function setPorijekloOtpadaList(\ArrayType\ArrayOfNaseljeJLSZupanija $porijekloOtpadaList = null)
    {
        if (is_null($porijekloOtpadaList) || (is_array($porijekloOtpadaList) && empty($porijekloOtpadaList))) {
            unset($this->PorijekloOtpadaList);
        } else {
            $this->PorijekloOtpadaList = $porijekloOtpadaList;
        }
        return $this;
    }
    /**
     * Get Povrat value
     * @return bool|null
     */
    public function getPovrat()
    {
        return $this->Povrat;
    }
    /**
     * Set Povrat value
     * @param bool $povrat
     * @return \StructType\PLOPretragaInput
     */
    public function setPovrat($povrat = null)
    {
        // validation for constraint: boolean
        if (!is_null($povrat) && !is_bool($povrat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($povrat, true), gettype($povrat)), __LINE__);
        }
        $this->Povrat = $povrat;
        return $this;
    }
    /**
     * Get PredavateljERPId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPredavateljERPId()
    {
        return isset($this->PredavateljERPId) ? $this->PredavateljERPId : null;
    }
    /**
     * Set PredavateljERPId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $predavateljERPId
     * @return \StructType\PLOPretragaInput
     */
    public function setPredavateljERPId($predavateljERPId = null)
    {
        // validation for constraint: string
        if (!is_null($predavateljERPId) && !is_string($predavateljERPId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($predavateljERPId, true), gettype($predavateljERPId)), __LINE__);
        }
        if (is_null($predavateljERPId) || (is_array($predavateljERPId) && empty($predavateljERPId))) {
            unset($this->PredavateljERPId);
        } else {
            $this->PredavateljERPId = $predavateljERPId;
        }
        return $this;
    }
    /**
     * Get PredavateljList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getPredavateljList()
    {
        return isset($this->PredavateljList) ? $this->PredavateljList : null;
    }
    /**
     * Set PredavateljList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $predavateljList
     * @return \StructType\PLOPretragaInput
     */
    public function setPredavateljList(\ArrayType\ArrayOfstring $predavateljList = null)
    {
        if (is_null($predavateljList) || (is_array($predavateljList) && empty($predavateljList))) {
            unset($this->PredavateljList);
        } else {
            $this->PredavateljList = $predavateljList;
        }
        return $this;
    }
    /**
     * Get PreuzimateljERPId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreuzimateljERPId()
    {
        return isset($this->PreuzimateljERPId) ? $this->PreuzimateljERPId : null;
    }
    /**
     * Set PreuzimateljERPId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preuzimateljERPId
     * @return \StructType\PLOPretragaInput
     */
    public function setPreuzimateljERPId($preuzimateljERPId = null)
    {
        // validation for constraint: string
        if (!is_null($preuzimateljERPId) && !is_string($preuzimateljERPId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preuzimateljERPId, true), gettype($preuzimateljERPId)), __LINE__);
        }
        if (is_null($preuzimateljERPId) || (is_array($preuzimateljERPId) && empty($preuzimateljERPId))) {
            unset($this->PreuzimateljERPId);
        } else {
            $this->PreuzimateljERPId = $preuzimateljERPId;
        }
        return $this;
    }
    /**
     * Get PreuzimateljList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getPreuzimateljList()
    {
        return isset($this->PreuzimateljList) ? $this->PreuzimateljList : null;
    }
    /**
     * Set PreuzimateljList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $preuzimateljList
     * @return \StructType\PLOPretragaInput
     */
    public function setPreuzimateljList(\ArrayType\ArrayOfstring $preuzimateljList = null)
    {
        if (is_null($preuzimateljList) || (is_array($preuzimateljList) && empty($preuzimateljList))) {
            unset($this->PreuzimateljList);
        } else {
            $this->PreuzimateljList = $preuzimateljList;
        }
        return $this;
    }
    /**
     * Get PrijevoznikERPId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrijevoznikERPId()
    {
        return isset($this->PrijevoznikERPId) ? $this->PrijevoznikERPId : null;
    }
    /**
     * Set PrijevoznikERPId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prijevoznikERPId
     * @return \StructType\PLOPretragaInput
     */
    public function setPrijevoznikERPId($prijevoznikERPId = null)
    {
        // validation for constraint: string
        if (!is_null($prijevoznikERPId) && !is_string($prijevoznikERPId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prijevoznikERPId, true), gettype($prijevoznikERPId)), __LINE__);
        }
        if (is_null($prijevoznikERPId) || (is_array($prijevoznikERPId) && empty($prijevoznikERPId))) {
            unset($this->PrijevoznikERPId);
        } else {
            $this->PrijevoznikERPId = $prijevoznikERPId;
        }
        return $this;
    }
    /**
     * Get PrijevoznikList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getPrijevoznikList()
    {
        return isset($this->PrijevoznikList) ? $this->PrijevoznikList : null;
    }
    /**
     * Set PrijevoznikList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $prijevoznikList
     * @return \StructType\PLOPretragaInput
     */
    public function setPrijevoznikList(\ArrayType\ArrayOfstring $prijevoznikList = null)
    {
        if (is_null($prijevoznikList) || (is_array($prijevoznikList) && empty($prijevoznikList))) {
            unset($this->PrijevoznikList);
        } else {
            $this->PrijevoznikList = $prijevoznikList;
        }
        return $this;
    }
    /**
     * Get Storno value
     * @return bool|null
     */
    public function getStorno()
    {
        return $this->Storno;
    }
    /**
     * Set Storno value
     * @param bool $storno
     * @return \StructType\PLOPretragaInput
     */
    public function setStorno($storno = null)
    {
        // validation for constraint: boolean
        if (!is_null($storno) && !is_bool($storno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($storno, true), gettype($storno)), __LINE__);
        }
        $this->Storno = $storno;
        return $this;
    }
    /**
     * Get TipoviOtpadaList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getTipoviOtpadaList()
    {
        return isset($this->TipoviOtpadaList) ? $this->TipoviOtpadaList : null;
    }
    /**
     * Set TipoviOtpadaList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $tipoviOtpadaList
     * @return \StructType\PLOPretragaInput
     */
    public function setTipoviOtpadaList(\ArrayType\ArrayOfint $tipoviOtpadaList = null)
    {
        if (is_null($tipoviOtpadaList) || (is_array($tipoviOtpadaList) && empty($tipoviOtpadaList))) {
            unset($this->TipoviOtpadaList);
        } else {
            $this->TipoviOtpadaList = $tipoviOtpadaList;
        }
        return $this;
    }
    /**
     * Get TvrtkeList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getTvrtkeList()
    {
        return isset($this->TvrtkeList) ? $this->TvrtkeList : null;
    }
    /**
     * Set TvrtkeList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $tvrtkeList
     * @return \StructType\PLOPretragaInput
     */
    public function setTvrtkeList(\ArrayType\ArrayOfstring $tvrtkeList = null)
    {
        if (is_null($tvrtkeList) || (is_array($tvrtkeList) && empty($tvrtkeList))) {
            unset($this->TvrtkeList);
        } else {
            $this->TvrtkeList = $tvrtkeList;
        }
        return $this;
    }
}
