<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MRDLokacija StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MRDLokacija
 * @subpackage Structs
 */
class MRDLokacija extends AbstractStructBase
{
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The Lokacija
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Lokacija
     */
    public $Lokacija;
    /**
     * The LokacijaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LokacijaId;
    /**
     * The MRD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MRD
     */
    public $MRD;
    /**
     * The MRDId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MRDId;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * Constructor method for MRDLokacija
     * @uses MRDLokacija::setDatumKreiranja()
     * @uses MRDLokacija::setDatumPromjene()
     * @uses MRDLokacija::setId()
     * @uses MRDLokacija::setKreirao()
     * @uses MRDLokacija::setLokacija()
     * @uses MRDLokacija::setLokacijaId()
     * @uses MRDLokacija::setMRD()
     * @uses MRDLokacija::setMRDId()
     * @uses MRDLokacija::setPromijenio()
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param int $id
     * @param string $kreirao
     * @param \StructType\Lokacija $lokacija
     * @param int $lokacijaId
     * @param \StructType\MRD $mRD
     * @param int $mRDId
     * @param string $promijenio
     */
    public function __construct($datumKreiranja = null, $datumPromjene = null, $id = null, $kreirao = null, \StructType\Lokacija $lokacija = null, $lokacijaId = null, \StructType\MRD $mRD = null, $mRDId = null, $promijenio = null)
    {
        $this
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setId($id)
            ->setKreirao($kreirao)
            ->setLokacija($lokacija)
            ->setLokacijaId($lokacijaId)
            ->setMRD($mRD)
            ->setMRDId($mRDId)
            ->setPromijenio($promijenio);
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\MRDLokacija
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\MRDLokacija
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\MRDLokacija
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\MRDLokacija
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get Lokacija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Lokacija|null
     */
    public function getLokacija()
    {
        return isset($this->Lokacija) ? $this->Lokacija : null;
    }
    /**
     * Set Lokacija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Lokacija $lokacija
     * @return \StructType\MRDLokacija
     */
    public function setLokacija(\StructType\Lokacija $lokacija = null)
    {
        if (is_null($lokacija) || (is_array($lokacija) && empty($lokacija))) {
            unset($this->Lokacija);
        } else {
            $this->Lokacija = $lokacija;
        }
        return $this;
    }
    /**
     * Get LokacijaId value
     * @return int|null
     */
    public function getLokacijaId()
    {
        return $this->LokacijaId;
    }
    /**
     * Set LokacijaId value
     * @param int $lokacijaId
     * @return \StructType\MRDLokacija
     */
    public function setLokacijaId($lokacijaId = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaId) && !(is_int($lokacijaId) || ctype_digit($lokacijaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaId, true), gettype($lokacijaId)), __LINE__);
        }
        $this->LokacijaId = $lokacijaId;
        return $this;
    }
    /**
     * Get MRD value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MRD|null
     */
    public function getMRD()
    {
        return isset($this->MRD) ? $this->MRD : null;
    }
    /**
     * Set MRD value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\MRD $mRD
     * @return \StructType\MRDLokacija
     */
    public function setMRD(\StructType\MRD $mRD = null)
    {
        if (is_null($mRD) || (is_array($mRD) && empty($mRD))) {
            unset($this->MRD);
        } else {
            $this->MRD = $mRD;
        }
        return $this;
    }
    /**
     * Get MRDId value
     * @return int|null
     */
    public function getMRDId()
    {
        return $this->MRDId;
    }
    /**
     * Set MRDId value
     * @param int $mRDId
     * @return \StructType\MRDLokacija
     */
    public function setMRDId($mRDId = null)
    {
        // validation for constraint: int
        if (!is_null($mRDId) && !(is_int($mRDId) || ctype_digit($mRDId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mRDId, true), gettype($mRDId)), __LINE__);
        }
        $this->MRDId = $mRDId;
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\MRDLokacija
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
}
