<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LokacijaROOExport StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LokacijaROOExport
 * @subpackage Structs
 */
class LokacijaROOExport extends AbstractStructBase
{
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The Lokacija
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Lokacija
     */
    public $Lokacija;
    /**
     * The LokacijaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LokacijaID;
    /**
     * The LokacijaROOExportID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LokacijaROOExportID;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * The ROOExport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ROOExport
     */
    public $ROOExport;
    /**
     * The ROOExportID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ROOExportID;
    /**
     * Constructor method for LokacijaROOExport
     * @uses LokacijaROOExport::setDatumKreiranja()
     * @uses LokacijaROOExport::setDatumPromjene()
     * @uses LokacijaROOExport::setKreirao()
     * @uses LokacijaROOExport::setLokacija()
     * @uses LokacijaROOExport::setLokacijaID()
     * @uses LokacijaROOExport::setLokacijaROOExportID()
     * @uses LokacijaROOExport::setPromijenio()
     * @uses LokacijaROOExport::setROOExport()
     * @uses LokacijaROOExport::setROOExportID()
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param string $kreirao
     * @param \StructType\Lokacija $lokacija
     * @param int $lokacijaID
     * @param int $lokacijaROOExportID
     * @param string $promijenio
     * @param \StructType\ROOExport $rOOExport
     * @param int $rOOExportID
     */
    public function __construct($datumKreiranja = null, $datumPromjene = null, $kreirao = null, \StructType\Lokacija $lokacija = null, $lokacijaID = null, $lokacijaROOExportID = null, $promijenio = null, \StructType\ROOExport $rOOExport = null, $rOOExportID = null)
    {
        $this
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setKreirao($kreirao)
            ->setLokacija($lokacija)
            ->setLokacijaID($lokacijaID)
            ->setLokacijaROOExportID($lokacijaROOExportID)
            ->setPromijenio($promijenio)
            ->setROOExport($rOOExport)
            ->setROOExportID($rOOExportID);
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\LokacijaROOExport
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\LokacijaROOExport
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\LokacijaROOExport
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get Lokacija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Lokacija|null
     */
    public function getLokacija()
    {
        return isset($this->Lokacija) ? $this->Lokacija : null;
    }
    /**
     * Set Lokacija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Lokacija $lokacija
     * @return \StructType\LokacijaROOExport
     */
    public function setLokacija(\StructType\Lokacija $lokacija = null)
    {
        if (is_null($lokacija) || (is_array($lokacija) && empty($lokacija))) {
            unset($this->Lokacija);
        } else {
            $this->Lokacija = $lokacija;
        }
        return $this;
    }
    /**
     * Get LokacijaID value
     * @return int|null
     */
    public function getLokacijaID()
    {
        return $this->LokacijaID;
    }
    /**
     * Set LokacijaID value
     * @param int $lokacijaID
     * @return \StructType\LokacijaROOExport
     */
    public function setLokacijaID($lokacijaID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaID) && !(is_int($lokacijaID) || ctype_digit($lokacijaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaID, true), gettype($lokacijaID)), __LINE__);
        }
        $this->LokacijaID = $lokacijaID;
        return $this;
    }
    /**
     * Get LokacijaROOExportID value
     * @return int|null
     */
    public function getLokacijaROOExportID()
    {
        return $this->LokacijaROOExportID;
    }
    /**
     * Set LokacijaROOExportID value
     * @param int $lokacijaROOExportID
     * @return \StructType\LokacijaROOExport
     */
    public function setLokacijaROOExportID($lokacijaROOExportID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaROOExportID) && !(is_int($lokacijaROOExportID) || ctype_digit($lokacijaROOExportID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaROOExportID, true), gettype($lokacijaROOExportID)), __LINE__);
        }
        $this->LokacijaROOExportID = $lokacijaROOExportID;
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\LokacijaROOExport
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
    /**
     * Get ROOExport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ROOExport|null
     */
    public function getROOExport()
    {
        return isset($this->ROOExport) ? $this->ROOExport : null;
    }
    /**
     * Set ROOExport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ROOExport $rOOExport
     * @return \StructType\LokacijaROOExport
     */
    public function setROOExport(\StructType\ROOExport $rOOExport = null)
    {
        if (is_null($rOOExport) || (is_array($rOOExport) && empty($rOOExport))) {
            unset($this->ROOExport);
        } else {
            $this->ROOExport = $rOOExport;
        }
        return $this;
    }
    /**
     * Get ROOExportID value
     * @return int|null
     */
    public function getROOExportID()
    {
        return $this->ROOExportID;
    }
    /**
     * Set ROOExportID value
     * @param int $rOOExportID
     * @return \StructType\LokacijaROOExport
     */
    public function setROOExportID($rOOExportID = null)
    {
        // validation for constraint: int
        if (!is_null($rOOExportID) && !(is_int($rOOExportID) || ctype_digit($rOOExportID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rOOExportID, true), gettype($rOOExportID)), __LINE__);
        }
        $this->ROOExportID = $rOOExportID;
        return $this;
    }
}
