<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Konfiguracija StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Konfiguracija
 * @subpackage Structs
 */
class Konfiguracija extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The DatumBrisanja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumBrisanja;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumPromjene;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Korisnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Korisnik
     */
    public $Korisnik;
    /**
     * The KorisnikId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KorisnikId;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The Opis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Opis;
    /**
     * The Vrijednost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Vrijednost;
    /**
     * Constructor method for Konfiguracija
     * @uses Konfiguracija::setAktivan()
     * @uses Konfiguracija::setDatumBrisanja()
     * @uses Konfiguracija::setDatumKreiranja()
     * @uses Konfiguracija::setDatumPromjene()
     * @uses Konfiguracija::setID()
     * @uses Konfiguracija::setKorisnik()
     * @uses Konfiguracija::setKorisnikId()
     * @uses Konfiguracija::setNaziv()
     * @uses Konfiguracija::setOpis()
     * @uses Konfiguracija::setVrijednost()
     * @param bool $aktivan
     * @param string $datumBrisanja
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param int $iD
     * @param \StructType\Korisnik $korisnik
     * @param int $korisnikId
     * @param string $naziv
     * @param string $opis
     * @param string $vrijednost
     */
    public function __construct($aktivan = null, $datumBrisanja = null, $datumKreiranja = null, $datumPromjene = null, $iD = null, \StructType\Korisnik $korisnik = null, $korisnikId = null, $naziv = null, $opis = null, $vrijednost = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setDatumBrisanja($datumBrisanja)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setID($iD)
            ->setKorisnik($korisnik)
            ->setKorisnikId($korisnikId)
            ->setNaziv($naziv)
            ->setOpis($opis)
            ->setVrijednost($vrijednost);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\Konfiguracija
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get DatumBrisanja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumBrisanja()
    {
        return isset($this->DatumBrisanja) ? $this->DatumBrisanja : null;
    }
    /**
     * Set DatumBrisanja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumBrisanja
     * @return \StructType\Konfiguracija
     */
    public function setDatumBrisanja($datumBrisanja = null)
    {
        // validation for constraint: string
        if (!is_null($datumBrisanja) && !is_string($datumBrisanja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumBrisanja, true), gettype($datumBrisanja)), __LINE__);
        }
        if (is_null($datumBrisanja) || (is_array($datumBrisanja) && empty($datumBrisanja))) {
            unset($this->DatumBrisanja);
        } else {
            $this->DatumBrisanja = $datumBrisanja;
        }
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\Konfiguracija
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return isset($this->DatumPromjene) ? $this->DatumPromjene : null;
    }
    /**
     * Set DatumPromjene value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumPromjene
     * @return \StructType\Konfiguracija
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        if (is_null($datumPromjene) || (is_array($datumPromjene) && empty($datumPromjene))) {
            unset($this->DatumPromjene);
        } else {
            $this->DatumPromjene = $datumPromjene;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Konfiguracija
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Korisnik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Korisnik|null
     */
    public function getKorisnik()
    {
        return isset($this->Korisnik) ? $this->Korisnik : null;
    }
    /**
     * Set Korisnik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Korisnik $korisnik
     * @return \StructType\Konfiguracija
     */
    public function setKorisnik(\StructType\Korisnik $korisnik = null)
    {
        if (is_null($korisnik) || (is_array($korisnik) && empty($korisnik))) {
            unset($this->Korisnik);
        } else {
            $this->Korisnik = $korisnik;
        }
        return $this;
    }
    /**
     * Get KorisnikId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKorisnikId()
    {
        return isset($this->KorisnikId) ? $this->KorisnikId : null;
    }
    /**
     * Set KorisnikId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $korisnikId
     * @return \StructType\Konfiguracija
     */
    public function setKorisnikId($korisnikId = null)
    {
        // validation for constraint: int
        if (!is_null($korisnikId) && !(is_int($korisnikId) || ctype_digit($korisnikId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($korisnikId, true), gettype($korisnikId)), __LINE__);
        }
        if (is_null($korisnikId) || (is_array($korisnikId) && empty($korisnikId))) {
            unset($this->KorisnikId);
        } else {
            $this->KorisnikId = $korisnikId;
        }
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\Konfiguracija
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get Opis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpis()
    {
        return isset($this->Opis) ? $this->Opis : null;
    }
    /**
     * Set Opis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opis
     * @return \StructType\Konfiguracija
     */
    public function setOpis($opis = null)
    {
        // validation for constraint: string
        if (!is_null($opis) && !is_string($opis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opis, true), gettype($opis)), __LINE__);
        }
        if (is_null($opis) || (is_array($opis) && empty($opis))) {
            unset($this->Opis);
        } else {
            $this->Opis = $opis;
        }
        return $this;
    }
    /**
     * Get Vrijednost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVrijednost()
    {
        return isset($this->Vrijednost) ? $this->Vrijednost : null;
    }
    /**
     * Set Vrijednost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vrijednost
     * @return \StructType\Konfiguracija
     */
    public function setVrijednost($vrijednost = null)
    {
        // validation for constraint: string
        if (!is_null($vrijednost) && !is_string($vrijednost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vrijednost, true), gettype($vrijednost)), __LINE__);
        }
        if (is_null($vrijednost) || (is_array($vrijednost) && empty($vrijednost))) {
            unset($this->Vrijednost);
        } else {
            $this->Vrijednost = $vrijednost;
        }
        return $this;
    }
}
