<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DozvoleRDOznake StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DozvoleRDOznake
 * @subpackage Structs
 */
class DozvoleRDOznake extends AbstractStructBase
{
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumPromjene;
    /**
     * The Dozvola
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Dozvola
     */
    public $Dozvola;
    /**
     * The DozvolaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DozvolaID;
    /**
     * The IDDozvoleRDOznake
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDDozvoleRDOznake;
    /**
     * The RDPostupak
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RDPostupak
     */
    public $RDPostupak;
    /**
     * The RDPostupakID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RDPostupakID;
    /**
     * Constructor method for DozvoleRDOznake
     * @uses DozvoleRDOznake::setDatumKreiranja()
     * @uses DozvoleRDOznake::setDatumPromjene()
     * @uses DozvoleRDOznake::setDozvola()
     * @uses DozvoleRDOznake::setDozvolaID()
     * @uses DozvoleRDOznake::setIDDozvoleRDOznake()
     * @uses DozvoleRDOznake::setRDPostupak()
     * @uses DozvoleRDOznake::setRDPostupakID()
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param \StructType\Dozvola $dozvola
     * @param int $dozvolaID
     * @param int $iDDozvoleRDOznake
     * @param \StructType\RDPostupak $rDPostupak
     * @param int $rDPostupakID
     */
    public function __construct($datumKreiranja = null, $datumPromjene = null, \StructType\Dozvola $dozvola = null, $dozvolaID = null, $iDDozvoleRDOznake = null, \StructType\RDPostupak $rDPostupak = null, $rDPostupakID = null)
    {
        $this
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setDozvola($dozvola)
            ->setDozvolaID($dozvolaID)
            ->setIDDozvoleRDOznake($iDDozvoleRDOznake)
            ->setRDPostupak($rDPostupak)
            ->setRDPostupakID($rDPostupakID);
    }
    /**
     * Get DatumKreiranja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return isset($this->DatumKreiranja) ? $this->DatumKreiranja : null;
    }
    /**
     * Set DatumKreiranja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumKreiranja
     * @return \StructType\DozvoleRDOznake
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        if (is_null($datumKreiranja) || (is_array($datumKreiranja) && empty($datumKreiranja))) {
            unset($this->DatumKreiranja);
        } else {
            $this->DatumKreiranja = $datumKreiranja;
        }
        return $this;
    }
    /**
     * Get DatumPromjene value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return isset($this->DatumPromjene) ? $this->DatumPromjene : null;
    }
    /**
     * Set DatumPromjene value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumPromjene
     * @return \StructType\DozvoleRDOznake
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        if (is_null($datumPromjene) || (is_array($datumPromjene) && empty($datumPromjene))) {
            unset($this->DatumPromjene);
        } else {
            $this->DatumPromjene = $datumPromjene;
        }
        return $this;
    }
    /**
     * Get Dozvola value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Dozvola|null
     */
    public function getDozvola()
    {
        return isset($this->Dozvola) ? $this->Dozvola : null;
    }
    /**
     * Set Dozvola value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Dozvola $dozvola
     * @return \StructType\DozvoleRDOznake
     */
    public function setDozvola(\StructType\Dozvola $dozvola = null)
    {
        if (is_null($dozvola) || (is_array($dozvola) && empty($dozvola))) {
            unset($this->Dozvola);
        } else {
            $this->Dozvola = $dozvola;
        }
        return $this;
    }
    /**
     * Get DozvolaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDozvolaID()
    {
        return isset($this->DozvolaID) ? $this->DozvolaID : null;
    }
    /**
     * Set DozvolaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dozvolaID
     * @return \StructType\DozvoleRDOznake
     */
    public function setDozvolaID($dozvolaID = null)
    {
        // validation for constraint: int
        if (!is_null($dozvolaID) && !(is_int($dozvolaID) || ctype_digit($dozvolaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dozvolaID, true), gettype($dozvolaID)), __LINE__);
        }
        if (is_null($dozvolaID) || (is_array($dozvolaID) && empty($dozvolaID))) {
            unset($this->DozvolaID);
        } else {
            $this->DozvolaID = $dozvolaID;
        }
        return $this;
    }
    /**
     * Get IDDozvoleRDOznake value
     * @return int|null
     */
    public function getIDDozvoleRDOznake()
    {
        return $this->IDDozvoleRDOznake;
    }
    /**
     * Set IDDozvoleRDOznake value
     * @param int $iDDozvoleRDOznake
     * @return \StructType\DozvoleRDOznake
     */
    public function setIDDozvoleRDOznake($iDDozvoleRDOznake = null)
    {
        // validation for constraint: int
        if (!is_null($iDDozvoleRDOznake) && !(is_int($iDDozvoleRDOznake) || ctype_digit($iDDozvoleRDOznake))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDDozvoleRDOznake, true), gettype($iDDozvoleRDOznake)), __LINE__);
        }
        $this->IDDozvoleRDOznake = $iDDozvoleRDOznake;
        return $this;
    }
    /**
     * Get RDPostupak value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RDPostupak|null
     */
    public function getRDPostupak()
    {
        return isset($this->RDPostupak) ? $this->RDPostupak : null;
    }
    /**
     * Set RDPostupak value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RDPostupak $rDPostupak
     * @return \StructType\DozvoleRDOznake
     */
    public function setRDPostupak(\StructType\RDPostupak $rDPostupak = null)
    {
        if (is_null($rDPostupak) || (is_array($rDPostupak) && empty($rDPostupak))) {
            unset($this->RDPostupak);
        } else {
            $this->RDPostupak = $rDPostupak;
        }
        return $this;
    }
    /**
     * Get RDPostupakID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRDPostupakID()
    {
        return isset($this->RDPostupakID) ? $this->RDPostupakID : null;
    }
    /**
     * Set RDPostupakID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rDPostupakID
     * @return \StructType\DozvoleRDOznake
     */
    public function setRDPostupakID($rDPostupakID = null)
    {
        // validation for constraint: int
        if (!is_null($rDPostupakID) && !(is_int($rDPostupakID) || ctype_digit($rDPostupakID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rDPostupakID, true), gettype($rDPostupakID)), __LINE__);
        }
        if (is_null($rDPostupakID) || (is_array($rDPostupakID) && empty($rDPostupakID))) {
            unset($this->RDPostupakID);
        } else {
            $this->RDPostupakID = $rDPostupakID;
        }
        return $this;
    }
}
