<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DozvolaRolaOIB StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DozvolaRolaOIB
 * @subpackage Structs
 */
class DozvolaRolaOIB extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The OIB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OIB;
    /**
     * The Rola
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Rola
     */
    public $Rola;
    /**
     * The RolaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RolaId;
    /**
     * Constructor method for DozvolaRolaOIB
     * @uses DozvolaRolaOIB::setID()
     * @uses DozvolaRolaOIB::setOIB()
     * @uses DozvolaRolaOIB::setRola()
     * @uses DozvolaRolaOIB::setRolaId()
     * @param int $iD
     * @param string $oIB
     * @param \StructType\Rola $rola
     * @param int $rolaId
     */
    public function __construct($iD = null, $oIB = null, \StructType\Rola $rola = null, $rolaId = null)
    {
        $this
            ->setID($iD)
            ->setOIB($oIB)
            ->setRola($rola)
            ->setRolaId($rolaId);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\DozvolaRolaOIB
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get OIB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOIB()
    {
        return isset($this->OIB) ? $this->OIB : null;
    }
    /**
     * Set OIB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oIB
     * @return \StructType\DozvolaRolaOIB
     */
    public function setOIB($oIB = null)
    {
        // validation for constraint: string
        if (!is_null($oIB) && !is_string($oIB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oIB, true), gettype($oIB)), __LINE__);
        }
        if (is_null($oIB) || (is_array($oIB) && empty($oIB))) {
            unset($this->OIB);
        } else {
            $this->OIB = $oIB;
        }
        return $this;
    }
    /**
     * Get Rola value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Rola|null
     */
    public function getRola()
    {
        return isset($this->Rola) ? $this->Rola : null;
    }
    /**
     * Set Rola value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Rola $rola
     * @return \StructType\DozvolaRolaOIB
     */
    public function setRola(\StructType\Rola $rola = null)
    {
        if (is_null($rola) || (is_array($rola) && empty($rola))) {
            unset($this->Rola);
        } else {
            $this->Rola = $rola;
        }
        return $this;
    }
    /**
     * Get RolaId value
     * @return int|null
     */
    public function getRolaId()
    {
        return $this->RolaId;
    }
    /**
     * Set RolaId value
     * @param int $rolaId
     * @return \StructType\DozvolaRolaOIB
     */
    public function setRolaId($rolaId = null)
    {
        // validation for constraint: int
        if (!is_null($rolaId) && !(is_int($rolaId) || ctype_digit($rolaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rolaId, true), gettype($rolaId)), __LINE__);
        }
        $this->RolaId = $rolaId;
        return $this;
    }
}
