<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Prenesi ServiceType
 * @subpackage Services
 */
class Prenesi extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PrenesiDokument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrenesiDokument $parameters
     * @return \StructType\PrenesiDokumentResponse|bool
     */
    public function PrenesiDokument(\StructType\PrenesiDokument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PrenesiDokument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PrenesiDokumentResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
