<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDozvola ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDozvola
 * @subpackage Arrays
 */
class ArrayOfDozvola extends AbstractStructArrayBase
{
    /**
     * The Dozvola
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Dozvola[]
     */
    public $Dozvola;
    /**
     * Constructor method for ArrayOfDozvola
     * @uses ArrayOfDozvola::setDozvola()
     * @param \StructType\Dozvola[] $dozvola
     */
    public function __construct(array $dozvola = array())
    {
        $this
            ->setDozvola($dozvola);
    }
    /**
     * Get Dozvola value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Dozvola[]|null
     */
    public function getDozvola()
    {
        return isset($this->Dozvola) ? $this->Dozvola : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDozvola method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDozvola method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDozvolaForArrayConstraintsFromSetDozvola(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDozvolaDozvolaItem) {
            // validation for constraint: itemType
            if (!$arrayOfDozvolaDozvolaItem instanceof \StructType\Dozvola) {
                $invalidValues[] = is_object($arrayOfDozvolaDozvolaItem) ? get_class($arrayOfDozvolaDozvolaItem) : sprintf('%s(%s)', gettype($arrayOfDozvolaDozvolaItem), var_export($arrayOfDozvolaDozvolaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dozvola property can only contain items of type \StructType\Dozvola, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dozvola value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Dozvola[] $dozvola
     * @return \ArrayType\ArrayOfDozvola
     */
    public function setDozvola(array $dozvola = array())
    {
        // validation for constraint: array
        if ('' !== ($dozvolaArrayErrorMessage = self::validateDozvolaForArrayConstraintsFromSetDozvola($dozvola))) {
            throw new \InvalidArgumentException($dozvolaArrayErrorMessage, __LINE__);
        }
        if (is_null($dozvola) || (is_array($dozvola) && empty($dozvola))) {
            unset($this->Dozvola);
        } else {
            $this->Dozvola = $dozvola;
        }
        return $this;
    }
    /**
     * Add item to Dozvola value
     * @throws \InvalidArgumentException
     * @param \StructType\Dozvola $item
     * @return \ArrayType\ArrayOfDozvola
     */
    public function addToDozvola(\StructType\Dozvola $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Dozvola) {
            throw new \InvalidArgumentException(sprintf('The Dozvola property can only contain items of type \StructType\Dozvola, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dozvola[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Dozvola|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Dozvola|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Dozvola|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Dozvola|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Dozvola|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Dozvola
     */
    public function getAttributeName()
    {
        return 'Dozvola';
    }
}
