<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VrstaDjelatnosti StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:VrstaDjelatnosti
 * @subpackage Structs
 */
class VrstaDjelatnosti extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The VrstaDjelatnostiID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VrstaDjelatnostiID;
    /**
     * Constructor method for VrstaDjelatnosti
     * @uses VrstaDjelatnosti::setAktivan()
     * @uses VrstaDjelatnosti::setNaziv()
     * @uses VrstaDjelatnosti::setVrstaDjelatnostiID()
     * @param bool $aktivan
     * @param string $naziv
     * @param int $vrstaDjelatnostiID
     */
    public function __construct($aktivan = null, $naziv = null, $vrstaDjelatnostiID = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setNaziv($naziv)
            ->setVrstaDjelatnostiID($vrstaDjelatnostiID);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\VrstaDjelatnosti
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\VrstaDjelatnosti
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get VrstaDjelatnostiID value
     * @return int|null
     */
    public function getVrstaDjelatnostiID()
    {
        return $this->VrstaDjelatnostiID;
    }
    /**
     * Set VrstaDjelatnostiID value
     * @param int $vrstaDjelatnostiID
     * @return \StructType\VrstaDjelatnosti
     */
    public function setVrstaDjelatnostiID($vrstaDjelatnostiID = null)
    {
        // validation for constraint: int
        if (!is_null($vrstaDjelatnostiID) && !(is_int($vrstaDjelatnostiID) || ctype_digit($vrstaDjelatnostiID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vrstaDjelatnostiID, true), gettype($vrstaDjelatnostiID)), __LINE__);
        }
        $this->VrstaDjelatnostiID = $vrstaDjelatnostiID;
        return $this;
    }
}
