<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipPriloga StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TipPriloga
 * @subpackage Structs
 */
class TipPriloga extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The Prilog
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPrilog
     */
    public $Prilog;
    /**
     * Constructor method for TipPriloga
     * @uses TipPriloga::setID()
     * @uses TipPriloga::setNaziv()
     * @uses TipPriloga::setPrilog()
     * @param int $iD
     * @param string $naziv
     * @param \ArrayType\ArrayOfPrilog $prilog
     */
    public function __construct($iD = null, $naziv = null, \ArrayType\ArrayOfPrilog $prilog = null)
    {
        $this
            ->setID($iD)
            ->setNaziv($naziv)
            ->setPrilog($prilog);
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\TipPriloga
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\TipPriloga
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get Prilog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPrilog|null
     */
    public function getPrilog()
    {
        return isset($this->Prilog) ? $this->Prilog : null;
    }
    /**
     * Set Prilog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPrilog $prilog
     * @return \StructType\TipPriloga
     */
    public function setPrilog(\ArrayType\ArrayOfPrilog $prilog = null)
    {
        if (is_null($prilog) || (is_array($prilog) && empty($prilog))) {
            unset($this->Prilog);
        } else {
            $this->Prilog = $prilog;
        }
        return $this;
    }
}
