<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KorisnikOpciDokument StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:KorisnikOpciDokument
 * @subpackage Structs
 */
class KorisnikOpciDokument extends AbstractStructBase
{
    /**
     * The Accepted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Accepted;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpirationDate;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Korisnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Korisnik
     */
    public $Korisnik;
    /**
     * The KorisnikId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KorisnikId;
    /**
     * The OpciDokument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OpciDokument
     */
    public $OpciDokument;
    /**
     * The OpciDokumentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OpciDokumentId;
    /**
     * The ValidFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidFrom;
    /**
     * Constructor method for KorisnikOpciDokument
     * @uses KorisnikOpciDokument::setAccepted()
     * @uses KorisnikOpciDokument::setExpirationDate()
     * @uses KorisnikOpciDokument::setID()
     * @uses KorisnikOpciDokument::setKorisnik()
     * @uses KorisnikOpciDokument::setKorisnikId()
     * @uses KorisnikOpciDokument::setOpciDokument()
     * @uses KorisnikOpciDokument::setOpciDokumentId()
     * @uses KorisnikOpciDokument::setValidFrom()
     * @param bool $accepted
     * @param string $expirationDate
     * @param int $iD
     * @param \StructType\Korisnik $korisnik
     * @param int $korisnikId
     * @param \StructType\OpciDokument $opciDokument
     * @param int $opciDokumentId
     * @param string $validFrom
     */
    public function __construct($accepted = null, $expirationDate = null, $iD = null, \StructType\Korisnik $korisnik = null, $korisnikId = null, \StructType\OpciDokument $opciDokument = null, $opciDokumentId = null, $validFrom = null)
    {
        $this
            ->setAccepted($accepted)
            ->setExpirationDate($expirationDate)
            ->setID($iD)
            ->setKorisnik($korisnik)
            ->setKorisnikId($korisnikId)
            ->setOpciDokument($opciDokument)
            ->setOpciDokumentId($opciDokumentId)
            ->setValidFrom($validFrom);
    }
    /**
     * Get Accepted value
     * @return bool|null
     */
    public function getAccepted()
    {
        return $this->Accepted;
    }
    /**
     * Set Accepted value
     * @param bool $accepted
     * @return \StructType\KorisnikOpciDokument
     */
    public function setAccepted($accepted = null)
    {
        // validation for constraint: boolean
        if (!is_null($accepted) && !is_bool($accepted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accepted, true), gettype($accepted)), __LINE__);
        }
        $this->Accepted = $accepted;
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expirationDate
     * @return \StructType\KorisnikOpciDokument
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\KorisnikOpciDokument
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Korisnik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Korisnik|null
     */
    public function getKorisnik()
    {
        return isset($this->Korisnik) ? $this->Korisnik : null;
    }
    /**
     * Set Korisnik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Korisnik $korisnik
     * @return \StructType\KorisnikOpciDokument
     */
    public function setKorisnik(\StructType\Korisnik $korisnik = null)
    {
        if (is_null($korisnik) || (is_array($korisnik) && empty($korisnik))) {
            unset($this->Korisnik);
        } else {
            $this->Korisnik = $korisnik;
        }
        return $this;
    }
    /**
     * Get KorisnikId value
     * @return int|null
     */
    public function getKorisnikId()
    {
        return $this->KorisnikId;
    }
    /**
     * Set KorisnikId value
     * @param int $korisnikId
     * @return \StructType\KorisnikOpciDokument
     */
    public function setKorisnikId($korisnikId = null)
    {
        // validation for constraint: int
        if (!is_null($korisnikId) && !(is_int($korisnikId) || ctype_digit($korisnikId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($korisnikId, true), gettype($korisnikId)), __LINE__);
        }
        $this->KorisnikId = $korisnikId;
        return $this;
    }
    /**
     * Get OpciDokument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OpciDokument|null
     */
    public function getOpciDokument()
    {
        return isset($this->OpciDokument) ? $this->OpciDokument : null;
    }
    /**
     * Set OpciDokument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OpciDokument $opciDokument
     * @return \StructType\KorisnikOpciDokument
     */
    public function setOpciDokument(\StructType\OpciDokument $opciDokument = null)
    {
        if (is_null($opciDokument) || (is_array($opciDokument) && empty($opciDokument))) {
            unset($this->OpciDokument);
        } else {
            $this->OpciDokument = $opciDokument;
        }
        return $this;
    }
    /**
     * Get OpciDokumentId value
     * @return int|null
     */
    public function getOpciDokumentId()
    {
        return $this->OpciDokumentId;
    }
    /**
     * Set OpciDokumentId value
     * @param int $opciDokumentId
     * @return \StructType\KorisnikOpciDokument
     */
    public function setOpciDokumentId($opciDokumentId = null)
    {
        // validation for constraint: int
        if (!is_null($opciDokumentId) && !(is_int($opciDokumentId) || ctype_digit($opciDokumentId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($opciDokumentId, true), gettype($opciDokumentId)), __LINE__);
        }
        $this->OpciDokumentId = $opciDokumentId;
        return $this;
    }
    /**
     * Get ValidFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidFrom()
    {
        return isset($this->ValidFrom) ? $this->ValidFrom : null;
    }
    /**
     * Set ValidFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validFrom
     * @return \StructType\KorisnikOpciDokument
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        if (is_null($validFrom) || (is_array($validFrom) && empty($validFrom))) {
            unset($this->ValidFrom);
        } else {
            $this->ValidFrom = $validFrom;
        }
        return $this;
    }
}
