<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPopisDokumenataZaEntitet StructType
 * @subpackage Structs
 */
class GetPopisDokumenataZaEntitet extends AbstractStructBase
{
    /**
     * The entitetID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $entitetID;
    /**
     * The vrstaEntitetaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $vrstaEntitetaID;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityToken;
    /**
     * Constructor method for GetPopisDokumenataZaEntitet
     * @uses GetPopisDokumenataZaEntitet::setEntitetID()
     * @uses GetPopisDokumenataZaEntitet::setVrstaEntitetaID()
     * @uses GetPopisDokumenataZaEntitet::setUsername()
     * @uses GetPopisDokumenataZaEntitet::setSecurityToken()
     * @param int $entitetID
     * @param int $vrstaEntitetaID
     * @param string $username
     * @param string $securityToken
     */
    public function __construct($entitetID = null, $vrstaEntitetaID = null, $username = null, $securityToken = null)
    {
        $this
            ->setEntitetID($entitetID)
            ->setVrstaEntitetaID($vrstaEntitetaID)
            ->setUsername($username)
            ->setSecurityToken($securityToken);
    }
    /**
     * Get entitetID value
     * @return int|null
     */
    public function getEntitetID()
    {
        return $this->entitetID;
    }
    /**
     * Set entitetID value
     * @param int $entitetID
     * @return \StructType\GetPopisDokumenataZaEntitet
     */
    public function setEntitetID($entitetID = null)
    {
        // validation for constraint: int
        if (!is_null($entitetID) && !(is_int($entitetID) || ctype_digit($entitetID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($entitetID, true), gettype($entitetID)), __LINE__);
        }
        $this->entitetID = $entitetID;
        return $this;
    }
    /**
     * Get vrstaEntitetaID value
     * @return int|null
     */
    public function getVrstaEntitetaID()
    {
        return $this->vrstaEntitetaID;
    }
    /**
     * Set vrstaEntitetaID value
     * @param int $vrstaEntitetaID
     * @return \StructType\GetPopisDokumenataZaEntitet
     */
    public function setVrstaEntitetaID($vrstaEntitetaID = null)
    {
        // validation for constraint: int
        if (!is_null($vrstaEntitetaID) && !(is_int($vrstaEntitetaID) || ctype_digit($vrstaEntitetaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vrstaEntitetaID, true), gettype($vrstaEntitetaID)), __LINE__);
        }
        $this->vrstaEntitetaID = $vrstaEntitetaID;
        return $this;
    }
    /**
     * Get username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->username) ? $this->username : null;
    }
    /**
     * Set username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\GetPopisDokumenataZaEntitet
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->username);
        } else {
            $this->username = $username;
        }
        return $this;
    }
    /**
     * Get securityToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityToken()
    {
        return isset($this->securityToken) ? $this->securityToken : null;
    }
    /**
     * Set securityToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityToken
     * @return \StructType\GetPopisDokumenataZaEntitet
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityToken, true), gettype($securityToken)), __LINE__);
        }
        if (is_null($securityToken) || (is_array($securityToken) && empty($securityToken))) {
            unset($this->securityToken);
        } else {
            $this->securityToken = $securityToken;
        }
        return $this;
    }
}
