<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DozvolaZabraneKB StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DozvolaZabraneKB
 * @subpackage Structs
 */
class DozvolaZabraneKB extends AbstractStructBase
{
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumPromjene;
    /**
     * The DozvolaZabrane
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DozvolaZabrane
     */
    public $DozvolaZabrane;
    /**
     * The DozvolaZabraneID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DozvolaZabraneID;
    /**
     * The IDDozvolaZabraneKB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDDozvolaZabraneKB;
    /**
     * The KljucniBrojOtpada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KljucniBrojOtpada
     */
    public $KljucniBrojOtpada;
    /**
     * The KljucniBrojOtpadaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KljucniBrojOtpadaID;
    /**
     * Constructor method for DozvolaZabraneKB
     * @uses DozvolaZabraneKB::setDatumKreiranja()
     * @uses DozvolaZabraneKB::setDatumPromjene()
     * @uses DozvolaZabraneKB::setDozvolaZabrane()
     * @uses DozvolaZabraneKB::setDozvolaZabraneID()
     * @uses DozvolaZabraneKB::setIDDozvolaZabraneKB()
     * @uses DozvolaZabraneKB::setKljucniBrojOtpada()
     * @uses DozvolaZabraneKB::setKljucniBrojOtpadaID()
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param \StructType\DozvolaZabrane $dozvolaZabrane
     * @param int $dozvolaZabraneID
     * @param int $iDDozvolaZabraneKB
     * @param \StructType\KljucniBrojOtpada $kljucniBrojOtpada
     * @param int $kljucniBrojOtpadaID
     */
    public function __construct($datumKreiranja = null, $datumPromjene = null, \StructType\DozvolaZabrane $dozvolaZabrane = null, $dozvolaZabraneID = null, $iDDozvolaZabraneKB = null, \StructType\KljucniBrojOtpada $kljucniBrojOtpada = null, $kljucniBrojOtpadaID = null)
    {
        $this
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setDozvolaZabrane($dozvolaZabrane)
            ->setDozvolaZabraneID($dozvolaZabraneID)
            ->setIDDozvolaZabraneKB($iDDozvolaZabraneKB)
            ->setKljucniBrojOtpada($kljucniBrojOtpada)
            ->setKljucniBrojOtpadaID($kljucniBrojOtpadaID);
    }
    /**
     * Get DatumKreiranja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return isset($this->DatumKreiranja) ? $this->DatumKreiranja : null;
    }
    /**
     * Set DatumKreiranja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumKreiranja
     * @return \StructType\DozvolaZabraneKB
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        if (is_null($datumKreiranja) || (is_array($datumKreiranja) && empty($datumKreiranja))) {
            unset($this->DatumKreiranja);
        } else {
            $this->DatumKreiranja = $datumKreiranja;
        }
        return $this;
    }
    /**
     * Get DatumPromjene value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return isset($this->DatumPromjene) ? $this->DatumPromjene : null;
    }
    /**
     * Set DatumPromjene value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumPromjene
     * @return \StructType\DozvolaZabraneKB
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        if (is_null($datumPromjene) || (is_array($datumPromjene) && empty($datumPromjene))) {
            unset($this->DatumPromjene);
        } else {
            $this->DatumPromjene = $datumPromjene;
        }
        return $this;
    }
    /**
     * Get DozvolaZabrane value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DozvolaZabrane|null
     */
    public function getDozvolaZabrane()
    {
        return isset($this->DozvolaZabrane) ? $this->DozvolaZabrane : null;
    }
    /**
     * Set DozvolaZabrane value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DozvolaZabrane $dozvolaZabrane
     * @return \StructType\DozvolaZabraneKB
     */
    public function setDozvolaZabrane(\StructType\DozvolaZabrane $dozvolaZabrane = null)
    {
        if (is_null($dozvolaZabrane) || (is_array($dozvolaZabrane) && empty($dozvolaZabrane))) {
            unset($this->DozvolaZabrane);
        } else {
            $this->DozvolaZabrane = $dozvolaZabrane;
        }
        return $this;
    }
    /**
     * Get DozvolaZabraneID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDozvolaZabraneID()
    {
        return isset($this->DozvolaZabraneID) ? $this->DozvolaZabraneID : null;
    }
    /**
     * Set DozvolaZabraneID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dozvolaZabraneID
     * @return \StructType\DozvolaZabraneKB
     */
    public function setDozvolaZabraneID($dozvolaZabraneID = null)
    {
        // validation for constraint: int
        if (!is_null($dozvolaZabraneID) && !(is_int($dozvolaZabraneID) || ctype_digit($dozvolaZabraneID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dozvolaZabraneID, true), gettype($dozvolaZabraneID)), __LINE__);
        }
        if (is_null($dozvolaZabraneID) || (is_array($dozvolaZabraneID) && empty($dozvolaZabraneID))) {
            unset($this->DozvolaZabraneID);
        } else {
            $this->DozvolaZabraneID = $dozvolaZabraneID;
        }
        return $this;
    }
    /**
     * Get IDDozvolaZabraneKB value
     * @return int|null
     */
    public function getIDDozvolaZabraneKB()
    {
        return $this->IDDozvolaZabraneKB;
    }
    /**
     * Set IDDozvolaZabraneKB value
     * @param int $iDDozvolaZabraneKB
     * @return \StructType\DozvolaZabraneKB
     */
    public function setIDDozvolaZabraneKB($iDDozvolaZabraneKB = null)
    {
        // validation for constraint: int
        if (!is_null($iDDozvolaZabraneKB) && !(is_int($iDDozvolaZabraneKB) || ctype_digit($iDDozvolaZabraneKB))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDDozvolaZabraneKB, true), gettype($iDDozvolaZabraneKB)), __LINE__);
        }
        $this->IDDozvolaZabraneKB = $iDDozvolaZabraneKB;
        return $this;
    }
    /**
     * Get KljucniBrojOtpada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KljucniBrojOtpada|null
     */
    public function getKljucniBrojOtpada()
    {
        return isset($this->KljucniBrojOtpada) ? $this->KljucniBrojOtpada : null;
    }
    /**
     * Set KljucniBrojOtpada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\KljucniBrojOtpada $kljucniBrojOtpada
     * @return \StructType\DozvolaZabraneKB
     */
    public function setKljucniBrojOtpada(\StructType\KljucniBrojOtpada $kljucniBrojOtpada = null)
    {
        if (is_null($kljucniBrojOtpada) || (is_array($kljucniBrojOtpada) && empty($kljucniBrojOtpada))) {
            unset($this->KljucniBrojOtpada);
        } else {
            $this->KljucniBrojOtpada = $kljucniBrojOtpada;
        }
        return $this;
    }
    /**
     * Get KljucniBrojOtpadaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKljucniBrojOtpadaID()
    {
        return isset($this->KljucniBrojOtpadaID) ? $this->KljucniBrojOtpadaID : null;
    }
    /**
     * Set KljucniBrojOtpadaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $kljucniBrojOtpadaID
     * @return \StructType\DozvolaZabraneKB
     */
    public function setKljucniBrojOtpadaID($kljucniBrojOtpadaID = null)
    {
        // validation for constraint: int
        if (!is_null($kljucniBrojOtpadaID) && !(is_int($kljucniBrojOtpadaID) || ctype_digit($kljucniBrojOtpadaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kljucniBrojOtpadaID, true), gettype($kljucniBrojOtpadaID)), __LINE__);
        }
        if (is_null($kljucniBrojOtpadaID) || (is_array($kljucniBrojOtpadaID) && empty($kljucniBrojOtpadaID))) {
            unset($this->KljucniBrojOtpadaID);
        } else {
            $this->KljucniBrojOtpadaID = $kljucniBrojOtpadaID;
        }
        return $this;
    }
}
