<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kreiraj ServiceType
 * @subpackage Services
 */
class Kreiraj extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named KreirajOnto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KreirajOnto $parameters
     * @return \StructType\KreirajOntoResponse|bool
     */
    public function KreirajOnto(\StructType\KreirajOnto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->KreirajOnto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named KreirajOntoP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KreirajOntoP $parameters
     * @return \StructType\KreirajOntoPResponse|bool
     */
    public function KreirajOntoP(\StructType\KreirajOntoP $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->KreirajOntoP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KreirajOntoPResponse|\StructType\KreirajOntoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
