<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpciDokument StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OpciDokument
 * @subpackage Structs
 */
class OpciDokument extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The KorisnikOpciDokument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKorisnikOpciDokument
     */
    public $KorisnikOpciDokument;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The Tip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tip;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $URL;
    /**
     * Constructor method for OpciDokument
     * @uses OpciDokument::setAktivan()
     * @uses OpciDokument::setID()
     * @uses OpciDokument::setKorisnikOpciDokument()
     * @uses OpciDokument::setNaziv()
     * @uses OpciDokument::setTip()
     * @uses OpciDokument::setURL()
     * @param bool $aktivan
     * @param int $iD
     * @param \ArrayType\ArrayOfKorisnikOpciDokument $korisnikOpciDokument
     * @param string $naziv
     * @param int $tip
     * @param string $uRL
     */
    public function __construct($aktivan = null, $iD = null, \ArrayType\ArrayOfKorisnikOpciDokument $korisnikOpciDokument = null, $naziv = null, $tip = null, $uRL = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setID($iD)
            ->setKorisnikOpciDokument($korisnikOpciDokument)
            ->setNaziv($naziv)
            ->setTip($tip)
            ->setURL($uRL);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\OpciDokument
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\OpciDokument
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get KorisnikOpciDokument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKorisnikOpciDokument|null
     */
    public function getKorisnikOpciDokument()
    {
        return isset($this->KorisnikOpciDokument) ? $this->KorisnikOpciDokument : null;
    }
    /**
     * Set KorisnikOpciDokument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKorisnikOpciDokument $korisnikOpciDokument
     * @return \StructType\OpciDokument
     */
    public function setKorisnikOpciDokument(\ArrayType\ArrayOfKorisnikOpciDokument $korisnikOpciDokument = null)
    {
        if (is_null($korisnikOpciDokument) || (is_array($korisnikOpciDokument) && empty($korisnikOpciDokument))) {
            unset($this->KorisnikOpciDokument);
        } else {
            $this->KorisnikOpciDokument = $korisnikOpciDokument;
        }
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\OpciDokument
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get Tip value
     * @return int|null
     */
    public function getTip()
    {
        return $this->Tip;
    }
    /**
     * Set Tip value
     * @param int $tip
     * @return \StructType\OpciDokument
     */
    public function setTip($tip = null)
    {
        // validation for constraint: int
        if (!is_null($tip) && !(is_int($tip) || ctype_digit($tip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tip, true), gettype($tip)), __LINE__);
        }
        $this->Tip = $tip;
        return $this;
    }
    /**
     * Get URL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getURL()
    {
        return isset($this->URL) ? $this->URL : null;
    }
    /**
     * Set URL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uRL
     * @return \StructType\OpciDokument
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        if (is_null($uRL) || (is_array($uRL) && empty($uRL))) {
            unset($this->URL);
        } else {
            $this->URL = $uRL;
        }
        return $this;
    }
}
