<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LokacijaKorisnikRola StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LokacijaKorisnikRola
 * @subpackage Structs
 */
class LokacijaKorisnikRola extends AbstractStructBase
{
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The Korisnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Korisnik
     */
    public $Korisnik;
    /**
     * The KorisnikID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KorisnikID;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The Lokacija
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Lokacija
     */
    public $Lokacija;
    /**
     * The LokacijaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LokacijaID;
    /**
     * The LokacijaKorisnikID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LokacijaKorisnikID;
    /**
     * The PFOOsoba
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PFOOsoba
     */
    public $PFOOsoba;
    /**
     * The PravnaOsobaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PravnaOsobaID;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * The Rola
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Rola
     */
    public $Rola;
    /**
     * The RolaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RolaID;
    /**
     * The VrijediDo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VrijediDo;
    /**
     * The VrijediOd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VrijediOd;
    /**
     * Constructor method for LokacijaKorisnikRola
     * @uses LokacijaKorisnikRola::setDatumKreiranja()
     * @uses LokacijaKorisnikRola::setDatumPromjene()
     * @uses LokacijaKorisnikRola::setKorisnik()
     * @uses LokacijaKorisnikRola::setKorisnikID()
     * @uses LokacijaKorisnikRola::setKreirao()
     * @uses LokacijaKorisnikRola::setLokacija()
     * @uses LokacijaKorisnikRola::setLokacijaID()
     * @uses LokacijaKorisnikRola::setLokacijaKorisnikID()
     * @uses LokacijaKorisnikRola::setPFOOsoba()
     * @uses LokacijaKorisnikRola::setPravnaOsobaID()
     * @uses LokacijaKorisnikRola::setPromijenio()
     * @uses LokacijaKorisnikRola::setRola()
     * @uses LokacijaKorisnikRola::setRolaID()
     * @uses LokacijaKorisnikRola::setVrijediDo()
     * @uses LokacijaKorisnikRola::setVrijediOd()
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param \StructType\Korisnik $korisnik
     * @param int $korisnikID
     * @param string $kreirao
     * @param \StructType\Lokacija $lokacija
     * @param int $lokacijaID
     * @param int $lokacijaKorisnikID
     * @param \StructType\PFOOsoba $pFOOsoba
     * @param int $pravnaOsobaID
     * @param string $promijenio
     * @param \StructType\Rola $rola
     * @param int $rolaID
     * @param string $vrijediDo
     * @param string $vrijediOd
     */
    public function __construct($datumKreiranja = null, $datumPromjene = null, \StructType\Korisnik $korisnik = null, $korisnikID = null, $kreirao = null, \StructType\Lokacija $lokacija = null, $lokacijaID = null, $lokacijaKorisnikID = null, \StructType\PFOOsoba $pFOOsoba = null, $pravnaOsobaID = null, $promijenio = null, \StructType\Rola $rola = null, $rolaID = null, $vrijediDo = null, $vrijediOd = null)
    {
        $this
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setKorisnik($korisnik)
            ->setKorisnikID($korisnikID)
            ->setKreirao($kreirao)
            ->setLokacija($lokacija)
            ->setLokacijaID($lokacijaID)
            ->setLokacijaKorisnikID($lokacijaKorisnikID)
            ->setPFOOsoba($pFOOsoba)
            ->setPravnaOsobaID($pravnaOsobaID)
            ->setPromijenio($promijenio)
            ->setRola($rola)
            ->setRolaID($rolaID)
            ->setVrijediDo($vrijediDo)
            ->setVrijediOd($vrijediOd);
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get Korisnik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Korisnik|null
     */
    public function getKorisnik()
    {
        return isset($this->Korisnik) ? $this->Korisnik : null;
    }
    /**
     * Set Korisnik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Korisnik $korisnik
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setKorisnik(\StructType\Korisnik $korisnik = null)
    {
        if (is_null($korisnik) || (is_array($korisnik) && empty($korisnik))) {
            unset($this->Korisnik);
        } else {
            $this->Korisnik = $korisnik;
        }
        return $this;
    }
    /**
     * Get KorisnikID value
     * @return int|null
     */
    public function getKorisnikID()
    {
        return $this->KorisnikID;
    }
    /**
     * Set KorisnikID value
     * @param int $korisnikID
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setKorisnikID($korisnikID = null)
    {
        // validation for constraint: int
        if (!is_null($korisnikID) && !(is_int($korisnikID) || ctype_digit($korisnikID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($korisnikID, true), gettype($korisnikID)), __LINE__);
        }
        $this->KorisnikID = $korisnikID;
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get Lokacija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Lokacija|null
     */
    public function getLokacija()
    {
        return isset($this->Lokacija) ? $this->Lokacija : null;
    }
    /**
     * Set Lokacija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Lokacija $lokacija
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setLokacija(\StructType\Lokacija $lokacija = null)
    {
        if (is_null($lokacija) || (is_array($lokacija) && empty($lokacija))) {
            unset($this->Lokacija);
        } else {
            $this->Lokacija = $lokacija;
        }
        return $this;
    }
    /**
     * Get LokacijaID value
     * @return int|null
     */
    public function getLokacijaID()
    {
        return $this->LokacijaID;
    }
    /**
     * Set LokacijaID value
     * @param int $lokacijaID
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setLokacijaID($lokacijaID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaID) && !(is_int($lokacijaID) || ctype_digit($lokacijaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaID, true), gettype($lokacijaID)), __LINE__);
        }
        $this->LokacijaID = $lokacijaID;
        return $this;
    }
    /**
     * Get LokacijaKorisnikID value
     * @return int|null
     */
    public function getLokacijaKorisnikID()
    {
        return $this->LokacijaKorisnikID;
    }
    /**
     * Set LokacijaKorisnikID value
     * @param int $lokacijaKorisnikID
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setLokacijaKorisnikID($lokacijaKorisnikID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaKorisnikID) && !(is_int($lokacijaKorisnikID) || ctype_digit($lokacijaKorisnikID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaKorisnikID, true), gettype($lokacijaKorisnikID)), __LINE__);
        }
        $this->LokacijaKorisnikID = $lokacijaKorisnikID;
        return $this;
    }
    /**
     * Get PFOOsoba value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PFOOsoba|null
     */
    public function getPFOOsoba()
    {
        return isset($this->PFOOsoba) ? $this->PFOOsoba : null;
    }
    /**
     * Set PFOOsoba value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PFOOsoba $pFOOsoba
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setPFOOsoba(\StructType\PFOOsoba $pFOOsoba = null)
    {
        if (is_null($pFOOsoba) || (is_array($pFOOsoba) && empty($pFOOsoba))) {
            unset($this->PFOOsoba);
        } else {
            $this->PFOOsoba = $pFOOsoba;
        }
        return $this;
    }
    /**
     * Get PravnaOsobaID value
     * @return int|null
     */
    public function getPravnaOsobaID()
    {
        return $this->PravnaOsobaID;
    }
    /**
     * Set PravnaOsobaID value
     * @param int $pravnaOsobaID
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setPravnaOsobaID($pravnaOsobaID = null)
    {
        // validation for constraint: int
        if (!is_null($pravnaOsobaID) && !(is_int($pravnaOsobaID) || ctype_digit($pravnaOsobaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pravnaOsobaID, true), gettype($pravnaOsobaID)), __LINE__);
        }
        $this->PravnaOsobaID = $pravnaOsobaID;
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
    /**
     * Get Rola value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Rola|null
     */
    public function getRola()
    {
        return isset($this->Rola) ? $this->Rola : null;
    }
    /**
     * Set Rola value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Rola $rola
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setRola(\StructType\Rola $rola = null)
    {
        if (is_null($rola) || (is_array($rola) && empty($rola))) {
            unset($this->Rola);
        } else {
            $this->Rola = $rola;
        }
        return $this;
    }
    /**
     * Get RolaID value
     * @return int|null
     */
    public function getRolaID()
    {
        return $this->RolaID;
    }
    /**
     * Set RolaID value
     * @param int $rolaID
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setRolaID($rolaID = null)
    {
        // validation for constraint: int
        if (!is_null($rolaID) && !(is_int($rolaID) || ctype_digit($rolaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rolaID, true), gettype($rolaID)), __LINE__);
        }
        $this->RolaID = $rolaID;
        return $this;
    }
    /**
     * Get VrijediDo value
     * @return string|null
     */
    public function getVrijediDo()
    {
        return $this->VrijediDo;
    }
    /**
     * Set VrijediDo value
     * @param string $vrijediDo
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setVrijediDo($vrijediDo = null)
    {
        // validation for constraint: string
        if (!is_null($vrijediDo) && !is_string($vrijediDo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vrijediDo, true), gettype($vrijediDo)), __LINE__);
        }
        $this->VrijediDo = $vrijediDo;
        return $this;
    }
    /**
     * Get VrijediOd value
     * @return string|null
     */
    public function getVrijediOd()
    {
        return $this->VrijediOd;
    }
    /**
     * Set VrijediOd value
     * @param string $vrijediOd
     * @return \StructType\LokacijaKorisnikRola
     */
    public function setVrijediOd($vrijediOd = null)
    {
        // validation for constraint: string
        if (!is_null($vrijediOd) && !is_string($vrijediOd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vrijediOd, true), gettype($vrijediOd)), __LINE__);
        }
        $this->VrijediOd = $vrijediOd;
        return $this;
    }
}
