<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Lokacija StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Lokacija
 * @subpackage Structs
 */
class Lokacija extends BaseResponseDTO
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The KucniBroj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KucniBroj;
    /**
     * The LokacijaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LokacijaID;
    /**
     * The LokacijaIzSUMPa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LokacijaIzSUMPa;
    /**
     * The LokacijaOnemogucena
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LokacijaOnemogucena;
    /**
     * The NaseljaJLSPorijekloOtpada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $NaseljaJLSPorijekloOtpada;
    /**
     * The NaseljeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NaseljeID;
    /**
     * The NazivLokacije
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NazivLokacije;
    /**
     * The OpcinaGradID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OpcinaGradID;
    /**
     * The Opis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Opis;
    /**
     * The PravnaOsoba
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PravnaOsobaObrt
     */
    public $PravnaOsoba;
    /**
     * The Ulica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ulica;
    /**
     * The ZupanijaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ZupanijaID;
    /**
     * The BrojOrganizacijskeJedinice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrojOrganizacijskeJedinice;
    /**
     * The DatumDeaktivacije
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumDeaktivacije;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPrijaveDeaktivacije
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumPrijaveDeaktivacije;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The DeaktivacijaKorisnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeaktivacijaKorisnik;
    /**
     * The DeaktivacijaSustav
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeaktivacijaSustav;
    /**
     * The Dokuments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDokument
     */
    public $Dokuments;
    /**
     * The Dokuments1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDokument
     */
    public $Dokuments1;
    /**
     * The DozvolaZabranes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDozvolaZabrane
     */
    public $DozvolaZabranes;
    /**
     * The Dozvolas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDozvola
     */
    public $Dozvolas;
    /**
     * The EPRTRID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EPRTRID;
    /**
     * The ImaHTRSLokaciju
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ImaHTRSLokaciju;
    /**
     * The ImaKatastarskuAdresu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ImaKatastarskuAdresu;
    /**
     * The ImaUlicuKBR
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ImaUlicuKBR;
    /**
     * The KatastarskaCestica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KatastarskaCestica;
    /**
     * The KatastarskaOpcina
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KatastarskaOpcina;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The LokacijaKorisnikRolas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLokacijaKorisnikRola
     */
    public $LokacijaKorisnikRolas;
    /**
     * The LokacijaROOExports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLokacijaROOExport
     */
    public $LokacijaROOExports;
    /**
     * The LokacijaX
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LokacijaX;
    /**
     * The LokacijaY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LokacijaY;
    /**
     * The MRDLokacijas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMRDLokacija
     */
    public $MRDLokacijas;
    /**
     * The Naselje
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Naselje
     */
    public $Naselje;
    /**
     * The ONTOes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfONTO
     */
    public $ONTOes;
    /**
     * The OdgovornaOsoba
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OdgovornaOsoba;
    /**
     * The OpGrad
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OpGrad
     */
    public $OpGrad;
    /**
     * The OpGradID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OpGradID;
    /**
     * The OznakaOrganizacijskeJedinice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OznakaOrganizacijskeJedinice;
    /**
     * The PFOOsoba
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PFOOsoba
     */
    public $PFOOsoba;
    /**
     * The PFOOsobaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PFOOsobaID;
    /**
     * The PrateciLists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPrateciList
     */
    public $PrateciLists;
    /**
     * The PrateciLists1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPrateciList
     */
    public $PrateciLists1;
    /**
     * The PravnaOsobaLokacijaNaseljes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPravnaOsobaLokacijaNaselje
     */
    public $PravnaOsobaLokacijaNaseljes;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * The RefDozvola
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefDozvola;
    /**
     * The SUMPAktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SUMPAktivan;
    /**
     * The SUMPVrijemeIzmjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SUMPVrijemeIzmjene;
    /**
     * The SUMPVrijemeUpisa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUMPVrijemeUpisa;
    /**
     * The SUMPZadnjiKorisnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SUMPZadnjiKorisnik;
    /**
     * The SjedisteLokacijaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SjedisteLokacijaID;
    /**
     * The SluzbenaLokacija
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SluzbenaLokacija;
    /**
     * The SmijeBitSakrivena
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SmijeBitSakrivena;
    /**
     * The SumpId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SumpId;
    /**
     * The TijekOtpadaPs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTijekOtpadaP
     */
    public $TijekOtpadaPs;
    /**
     * The TijekOtpadaPs1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTijekOtpadaP
     */
    public $TijekOtpadaPs1;
    /**
     * The TijekOtpadas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTijekOtpada
     */
    public $TijekOtpadas;
    /**
     * The UMAudit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfUMAudit
     */
    public $UMAudit;
    /**
     * The UlicaTrg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UlicaTrg
     */
    public $UlicaTrg;
    /**
     * The UlicaTrgId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UlicaTrgId;
    /**
     * The VlastitaOznaka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VlastitaOznaka;
    /**
     * The VrsnaLokacija
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $VrsnaLokacija;
    /**
     * The ZadnjiSustav
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZadnjiSustav;
    /**
     * The ZahtjevTvrtkaLokacijas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfZahtjevTvrtkaLokacija
     */
    public $ZahtjevTvrtkaLokacijas;
    /**
     * The ZgradaKbr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ZgradaKbr
     */
    public $ZgradaKbr;
    /**
     * The ZgradaKbrId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ZgradaKbrId;
    /**
     * The Zupanija
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Zupanija
     */
    public $Zupanija;
    /**
     * The extDozvolas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfextDozvola
     */
    public $extDozvolas;
    /**
     * The extDozvoljeniRDPostupaks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfextDozvoljeniRDPostupak
     */
    public $extDozvoljeniRDPostupaks;
    /**
     * The extOcevidniks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfextOcevidnik
     */
    public $extOcevidniks;
    /**
     * The extPrekogranicniPromets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfextPrekogranicniPromet
     */
    public $extPrekogranicniPromets;
    /**
     * The extPrekogranicniPromets1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfextPrekogranicniPromet
     */
    public $extPrekogranicniPromets1;
    /**
     * Constructor method for Lokacija
     * @uses Lokacija::setAktivan()
     * @uses Lokacija::setKucniBroj()
     * @uses Lokacija::setLokacijaID()
     * @uses Lokacija::setLokacijaIzSUMPa()
     * @uses Lokacija::setLokacijaOnemogucena()
     * @uses Lokacija::setNaseljaJLSPorijekloOtpada()
     * @uses Lokacija::setNaseljeID()
     * @uses Lokacija::setNazivLokacije()
     * @uses Lokacija::setOpcinaGradID()
     * @uses Lokacija::setOpis()
     * @uses Lokacija::setPravnaOsoba()
     * @uses Lokacija::setUlica()
     * @uses Lokacija::setZupanijaID()
     * @uses Lokacija::setBrojOrganizacijskeJedinice()
     * @uses Lokacija::setDatumDeaktivacije()
     * @uses Lokacija::setDatumKreiranja()
     * @uses Lokacija::setDatumPrijaveDeaktivacije()
     * @uses Lokacija::setDatumPromjene()
     * @uses Lokacija::setDeaktivacijaKorisnik()
     * @uses Lokacija::setDeaktivacijaSustav()
     * @uses Lokacija::setDokuments()
     * @uses Lokacija::setDokuments1()
     * @uses Lokacija::setDozvolaZabranes()
     * @uses Lokacija::setDozvolas()
     * @uses Lokacija::setEPRTRID()
     * @uses Lokacija::setImaHTRSLokaciju()
     * @uses Lokacija::setImaKatastarskuAdresu()
     * @uses Lokacija::setImaUlicuKBR()
     * @uses Lokacija::setKatastarskaCestica()
     * @uses Lokacija::setKatastarskaOpcina()
     * @uses Lokacija::setKreirao()
     * @uses Lokacija::setLokacijaKorisnikRolas()
     * @uses Lokacija::setLokacijaROOExports()
     * @uses Lokacija::setLokacijaX()
     * @uses Lokacija::setLokacijaY()
     * @uses Lokacija::setMRDLokacijas()
     * @uses Lokacija::setNaselje()
     * @uses Lokacija::setONTOes()
     * @uses Lokacija::setOdgovornaOsoba()
     * @uses Lokacija::setOpGrad()
     * @uses Lokacija::setOpGradID()
     * @uses Lokacija::setOznakaOrganizacijskeJedinice()
     * @uses Lokacija::setPFOOsoba()
     * @uses Lokacija::setPFOOsobaID()
     * @uses Lokacija::setPrateciLists()
     * @uses Lokacija::setPrateciLists1()
     * @uses Lokacija::setPravnaOsobaLokacijaNaseljes()
     * @uses Lokacija::setPromijenio()
     * @uses Lokacija::setRefDozvola()
     * @uses Lokacija::setSUMPAktivan()
     * @uses Lokacija::setSUMPVrijemeIzmjene()
     * @uses Lokacija::setSUMPVrijemeUpisa()
     * @uses Lokacija::setSUMPZadnjiKorisnik()
     * @uses Lokacija::setSjedisteLokacijaID()
     * @uses Lokacija::setSluzbenaLokacija()
     * @uses Lokacija::setSmijeBitSakrivena()
     * @uses Lokacija::setSumpId()
     * @uses Lokacija::setTijekOtpadaPs()
     * @uses Lokacija::setTijekOtpadaPs1()
     * @uses Lokacija::setTijekOtpadas()
     * @uses Lokacija::setUMAudit()
     * @uses Lokacija::setUlicaTrg()
     * @uses Lokacija::setUlicaTrgId()
     * @uses Lokacija::setVlastitaOznaka()
     * @uses Lokacija::setVrsnaLokacija()
     * @uses Lokacija::setZadnjiSustav()
     * @uses Lokacija::setZahtjevTvrtkaLokacijas()
     * @uses Lokacija::setZgradaKbr()
     * @uses Lokacija::setZgradaKbrId()
     * @uses Lokacija::setZupanija()
     * @uses Lokacija::setExtDozvolas()
     * @uses Lokacija::setExtDozvoljeniRDPostupaks()
     * @uses Lokacija::setExtOcevidniks()
     * @uses Lokacija::setExtPrekogranicniPromets()
     * @uses Lokacija::setExtPrekogranicniPromets1()
     * @param bool $aktivan
     * @param string $kucniBroj
     * @param int $lokacijaID
     * @param bool $lokacijaIzSUMPa
     * @param bool $lokacijaOnemogucena
     * @param \ArrayType\ArrayOfint $naseljaJLSPorijekloOtpada
     * @param int $naseljeID
     * @param string $nazivLokacije
     * @param int $opcinaGradID
     * @param string $opis
     * @param \StructType\PravnaOsobaObrt $pravnaOsoba
     * @param string $ulica
     * @param int $zupanijaID
     * @param string $brojOrganizacijskeJedinice
     * @param string $datumDeaktivacije
     * @param string $datumKreiranja
     * @param string $datumPrijaveDeaktivacije
     * @param string $datumPromjene
     * @param string $deaktivacijaKorisnik
     * @param string $deaktivacijaSustav
     * @param \ArrayType\ArrayOfDokument $dokuments
     * @param \ArrayType\ArrayOfDokument $dokuments1
     * @param \ArrayType\ArrayOfDozvolaZabrane $dozvolaZabranes
     * @param \ArrayType\ArrayOfDozvola $dozvolas
     * @param string $ePRTRID
     * @param bool $imaHTRSLokaciju
     * @param bool $imaKatastarskuAdresu
     * @param bool $imaUlicuKBR
     * @param string $katastarskaCestica
     * @param string $katastarskaOpcina
     * @param string $kreirao
     * @param \ArrayType\ArrayOfLokacijaKorisnikRola $lokacijaKorisnikRolas
     * @param \ArrayType\ArrayOfLokacijaROOExport $lokacijaROOExports
     * @param float $lokacijaX
     * @param float $lokacijaY
     * @param \ArrayType\ArrayOfMRDLokacija $mRDLokacijas
     * @param \StructType\Naselje $naselje
     * @param \ArrayType\ArrayOfONTO $oNTOes
     * @param string $odgovornaOsoba
     * @param \StructType\OpGrad $opGrad
     * @param int $opGradID
     * @param string $oznakaOrganizacijskeJedinice
     * @param \StructType\PFOOsoba $pFOOsoba
     * @param int $pFOOsobaID
     * @param \ArrayType\ArrayOfPrateciList $prateciLists
     * @param \ArrayType\ArrayOfPrateciList $prateciLists1
     * @param \ArrayType\ArrayOfPravnaOsobaLokacijaNaselje $pravnaOsobaLokacijaNaseljes
     * @param string $promijenio
     * @param string $refDozvola
     * @param bool $sUMPAktivan
     * @param string $sUMPVrijemeIzmjene
     * @param string $sUMPVrijemeUpisa
     * @param string $sUMPZadnjiKorisnik
     * @param int $sjedisteLokacijaID
     * @param bool $sluzbenaLokacija
     * @param bool $smijeBitSakrivena
     * @param int $sumpId
     * @param \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs
     * @param \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs1
     * @param \ArrayType\ArrayOfTijekOtpada $tijekOtpadas
     * @param \ArrayType\ArrayOfUMAudit $uMAudit
     * @param \StructType\UlicaTrg $ulicaTrg
     * @param int $ulicaTrgId
     * @param string $vlastitaOznaka
     * @param bool $vrsnaLokacija
     * @param string $zadnjiSustav
     * @param \ArrayType\ArrayOfZahtjevTvrtkaLokacija $zahtjevTvrtkaLokacijas
     * @param \StructType\ZgradaKbr $zgradaKbr
     * @param int $zgradaKbrId
     * @param \StructType\Zupanija $zupanija
     * @param \ArrayType\ArrayOfextDozvola $extDozvolas
     * @param \ArrayType\ArrayOfextDozvoljeniRDPostupak $extDozvoljeniRDPostupaks
     * @param \ArrayType\ArrayOfextOcevidnik $extOcevidniks
     * @param \ArrayType\ArrayOfextPrekogranicniPromet $extPrekogranicniPromets
     * @param \ArrayType\ArrayOfextPrekogranicniPromet $extPrekogranicniPromets1
     */
    public function __construct($aktivan = null, $kucniBroj = null, $lokacijaID = null, $lokacijaIzSUMPa = null, $lokacijaOnemogucena = null, \ArrayType\ArrayOfint $naseljaJLSPorijekloOtpada = null, $naseljeID = null, $nazivLokacije = null, $opcinaGradID = null, $opis = null, \StructType\PravnaOsobaObrt $pravnaOsoba = null, $ulica = null, $zupanijaID = null, $brojOrganizacijskeJedinice = null, $datumDeaktivacije = null, $datumKreiranja = null, $datumPrijaveDeaktivacije = null, $datumPromjene = null, $deaktivacijaKorisnik = null, $deaktivacijaSustav = null, \ArrayType\ArrayOfDokument $dokuments = null, \ArrayType\ArrayOfDokument $dokuments1 = null, \ArrayType\ArrayOfDozvolaZabrane $dozvolaZabranes = null, \ArrayType\ArrayOfDozvola $dozvolas = null, $ePRTRID = null, $imaHTRSLokaciju = null, $imaKatastarskuAdresu = null, $imaUlicuKBR = null, $katastarskaCestica = null, $katastarskaOpcina = null, $kreirao = null, \ArrayType\ArrayOfLokacijaKorisnikRola $lokacijaKorisnikRolas = null, \ArrayType\ArrayOfLokacijaROOExport $lokacijaROOExports = null, $lokacijaX = null, $lokacijaY = null, \ArrayType\ArrayOfMRDLokacija $mRDLokacijas = null, \StructType\Naselje $naselje = null, \ArrayType\ArrayOfONTO $oNTOes = null, $odgovornaOsoba = null, \StructType\OpGrad $opGrad = null, $opGradID = null, $oznakaOrganizacijskeJedinice = null, \StructType\PFOOsoba $pFOOsoba = null, $pFOOsobaID = null, \ArrayType\ArrayOfPrateciList $prateciLists = null, \ArrayType\ArrayOfPrateciList $prateciLists1 = null, \ArrayType\ArrayOfPravnaOsobaLokacijaNaselje $pravnaOsobaLokacijaNaseljes = null, $promijenio = null, $refDozvola = null, $sUMPAktivan = null, $sUMPVrijemeIzmjene = null, $sUMPVrijemeUpisa = null, $sUMPZadnjiKorisnik = null, $sjedisteLokacijaID = null, $sluzbenaLokacija = null, $smijeBitSakrivena = null, $sumpId = null, \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs = null, \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs1 = null, \ArrayType\ArrayOfTijekOtpada $tijekOtpadas = null, \ArrayType\ArrayOfUMAudit $uMAudit = null, \StructType\UlicaTrg $ulicaTrg = null, $ulicaTrgId = null, $vlastitaOznaka = null, $vrsnaLokacija = null, $zadnjiSustav = null, \ArrayType\ArrayOfZahtjevTvrtkaLokacija $zahtjevTvrtkaLokacijas = null, \StructType\ZgradaKbr $zgradaKbr = null, $zgradaKbrId = null, \StructType\Zupanija $zupanija = null, \ArrayType\ArrayOfextDozvola $extDozvolas = null, \ArrayType\ArrayOfextDozvoljeniRDPostupak $extDozvoljeniRDPostupaks = null, \ArrayType\ArrayOfextOcevidnik $extOcevidniks = null, \ArrayType\ArrayOfextPrekogranicniPromet $extPrekogranicniPromets = null, \ArrayType\ArrayOfextPrekogranicniPromet $extPrekogranicniPromets1 = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setKucniBroj($kucniBroj)
            ->setLokacijaID($lokacijaID)
            ->setLokacijaIzSUMPa($lokacijaIzSUMPa)
            ->setLokacijaOnemogucena($lokacijaOnemogucena)
            ->setNaseljaJLSPorijekloOtpada($naseljaJLSPorijekloOtpada)
            ->setNaseljeID($naseljeID)
            ->setNazivLokacije($nazivLokacije)
            ->setOpcinaGradID($opcinaGradID)
            ->setOpis($opis)
            ->setPravnaOsoba($pravnaOsoba)
            ->setUlica($ulica)
            ->setZupanijaID($zupanijaID)
            ->setBrojOrganizacijskeJedinice($brojOrganizacijskeJedinice)
            ->setDatumDeaktivacije($datumDeaktivacije)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPrijaveDeaktivacije($datumPrijaveDeaktivacije)
            ->setDatumPromjene($datumPromjene)
            ->setDeaktivacijaKorisnik($deaktivacijaKorisnik)
            ->setDeaktivacijaSustav($deaktivacijaSustav)
            ->setDokuments($dokuments)
            ->setDokuments1($dokuments1)
            ->setDozvolaZabranes($dozvolaZabranes)
            ->setDozvolas($dozvolas)
            ->setEPRTRID($ePRTRID)
            ->setImaHTRSLokaciju($imaHTRSLokaciju)
            ->setImaKatastarskuAdresu($imaKatastarskuAdresu)
            ->setImaUlicuKBR($imaUlicuKBR)
            ->setKatastarskaCestica($katastarskaCestica)
            ->setKatastarskaOpcina($katastarskaOpcina)
            ->setKreirao($kreirao)
            ->setLokacijaKorisnikRolas($lokacijaKorisnikRolas)
            ->setLokacijaROOExports($lokacijaROOExports)
            ->setLokacijaX($lokacijaX)
            ->setLokacijaY($lokacijaY)
            ->setMRDLokacijas($mRDLokacijas)
            ->setNaselje($naselje)
            ->setONTOes($oNTOes)
            ->setOdgovornaOsoba($odgovornaOsoba)
            ->setOpGrad($opGrad)
            ->setOpGradID($opGradID)
            ->setOznakaOrganizacijskeJedinice($oznakaOrganizacijskeJedinice)
            ->setPFOOsoba($pFOOsoba)
            ->setPFOOsobaID($pFOOsobaID)
            ->setPrateciLists($prateciLists)
            ->setPrateciLists1($prateciLists1)
            ->setPravnaOsobaLokacijaNaseljes($pravnaOsobaLokacijaNaseljes)
            ->setPromijenio($promijenio)
            ->setRefDozvola($refDozvola)
            ->setSUMPAktivan($sUMPAktivan)
            ->setSUMPVrijemeIzmjene($sUMPVrijemeIzmjene)
            ->setSUMPVrijemeUpisa($sUMPVrijemeUpisa)
            ->setSUMPZadnjiKorisnik($sUMPZadnjiKorisnik)
            ->setSjedisteLokacijaID($sjedisteLokacijaID)
            ->setSluzbenaLokacija($sluzbenaLokacija)
            ->setSmijeBitSakrivena($smijeBitSakrivena)
            ->setSumpId($sumpId)
            ->setTijekOtpadaPs($tijekOtpadaPs)
            ->setTijekOtpadaPs1($tijekOtpadaPs1)
            ->setTijekOtpadas($tijekOtpadas)
            ->setUMAudit($uMAudit)
            ->setUlicaTrg($ulicaTrg)
            ->setUlicaTrgId($ulicaTrgId)
            ->setVlastitaOznaka($vlastitaOznaka)
            ->setVrsnaLokacija($vrsnaLokacija)
            ->setZadnjiSustav($zadnjiSustav)
            ->setZahtjevTvrtkaLokacijas($zahtjevTvrtkaLokacijas)
            ->setZgradaKbr($zgradaKbr)
            ->setZgradaKbrId($zgradaKbrId)
            ->setZupanija($zupanija)
            ->setExtDozvolas($extDozvolas)
            ->setExtDozvoljeniRDPostupaks($extDozvoljeniRDPostupaks)
            ->setExtOcevidniks($extOcevidniks)
            ->setExtPrekogranicniPromets($extPrekogranicniPromets)
            ->setExtPrekogranicniPromets1($extPrekogranicniPromets1);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\Lokacija
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get KucniBroj value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKucniBroj()
    {
        return isset($this->KucniBroj) ? $this->KucniBroj : null;
    }
    /**
     * Set KucniBroj value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kucniBroj
     * @return \StructType\Lokacija
     */
    public function setKucniBroj($kucniBroj = null)
    {
        // validation for constraint: string
        if (!is_null($kucniBroj) && !is_string($kucniBroj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kucniBroj, true), gettype($kucniBroj)), __LINE__);
        }
        if (is_null($kucniBroj) || (is_array($kucniBroj) && empty($kucniBroj))) {
            unset($this->KucniBroj);
        } else {
            $this->KucniBroj = $kucniBroj;
        }
        return $this;
    }
    /**
     * Get LokacijaID value
     * @return int|null
     */
    public function getLokacijaID()
    {
        return $this->LokacijaID;
    }
    /**
     * Set LokacijaID value
     * @param int $lokacijaID
     * @return \StructType\Lokacija
     */
    public function setLokacijaID($lokacijaID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaID) && !(is_int($lokacijaID) || ctype_digit($lokacijaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaID, true), gettype($lokacijaID)), __LINE__);
        }
        $this->LokacijaID = $lokacijaID;
        return $this;
    }
    /**
     * Get LokacijaIzSUMPa value
     * @return bool|null
     */
    public function getLokacijaIzSUMPa()
    {
        return $this->LokacijaIzSUMPa;
    }
    /**
     * Set LokacijaIzSUMPa value
     * @param bool $lokacijaIzSUMPa
     * @return \StructType\Lokacija
     */
    public function setLokacijaIzSUMPa($lokacijaIzSUMPa = null)
    {
        // validation for constraint: boolean
        if (!is_null($lokacijaIzSUMPa) && !is_bool($lokacijaIzSUMPa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lokacijaIzSUMPa, true), gettype($lokacijaIzSUMPa)), __LINE__);
        }
        $this->LokacijaIzSUMPa = $lokacijaIzSUMPa;
        return $this;
    }
    /**
     * Get LokacijaOnemogucena value
     * @return bool|null
     */
    public function getLokacijaOnemogucena()
    {
        return $this->LokacijaOnemogucena;
    }
    /**
     * Set LokacijaOnemogucena value
     * @param bool $lokacijaOnemogucena
     * @return \StructType\Lokacija
     */
    public function setLokacijaOnemogucena($lokacijaOnemogucena = null)
    {
        // validation for constraint: boolean
        if (!is_null($lokacijaOnemogucena) && !is_bool($lokacijaOnemogucena)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lokacijaOnemogucena, true), gettype($lokacijaOnemogucena)), __LINE__);
        }
        $this->LokacijaOnemogucena = $lokacijaOnemogucena;
        return $this;
    }
    /**
     * Get NaseljaJLSPorijekloOtpada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getNaseljaJLSPorijekloOtpada()
    {
        return isset($this->NaseljaJLSPorijekloOtpada) ? $this->NaseljaJLSPorijekloOtpada : null;
    }
    /**
     * Set NaseljaJLSPorijekloOtpada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $naseljaJLSPorijekloOtpada
     * @return \StructType\Lokacija
     */
    public function setNaseljaJLSPorijekloOtpada(\ArrayType\ArrayOfint $naseljaJLSPorijekloOtpada = null)
    {
        if (is_null($naseljaJLSPorijekloOtpada) || (is_array($naseljaJLSPorijekloOtpada) && empty($naseljaJLSPorijekloOtpada))) {
            unset($this->NaseljaJLSPorijekloOtpada);
        } else {
            $this->NaseljaJLSPorijekloOtpada = $naseljaJLSPorijekloOtpada;
        }
        return $this;
    }
    /**
     * Get NaseljeID value
     * @return int|null
     */
    public function getNaseljeID()
    {
        return $this->NaseljeID;
    }
    /**
     * Set NaseljeID value
     * @param int $naseljeID
     * @return \StructType\Lokacija
     */
    public function setNaseljeID($naseljeID = null)
    {
        // validation for constraint: int
        if (!is_null($naseljeID) && !(is_int($naseljeID) || ctype_digit($naseljeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($naseljeID, true), gettype($naseljeID)), __LINE__);
        }
        $this->NaseljeID = $naseljeID;
        return $this;
    }
    /**
     * Get NazivLokacije value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNazivLokacije()
    {
        return isset($this->NazivLokacije) ? $this->NazivLokacije : null;
    }
    /**
     * Set NazivLokacije value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nazivLokacije
     * @return \StructType\Lokacija
     */
    public function setNazivLokacije($nazivLokacije = null)
    {
        // validation for constraint: string
        if (!is_null($nazivLokacije) && !is_string($nazivLokacije)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivLokacije, true), gettype($nazivLokacije)), __LINE__);
        }
        if (is_null($nazivLokacije) || (is_array($nazivLokacije) && empty($nazivLokacije))) {
            unset($this->NazivLokacije);
        } else {
            $this->NazivLokacije = $nazivLokacije;
        }
        return $this;
    }
    /**
     * Get OpcinaGradID value
     * @return int|null
     */
    public function getOpcinaGradID()
    {
        return $this->OpcinaGradID;
    }
    /**
     * Set OpcinaGradID value
     * @param int $opcinaGradID
     * @return \StructType\Lokacija
     */
    public function setOpcinaGradID($opcinaGradID = null)
    {
        // validation for constraint: int
        if (!is_null($opcinaGradID) && !(is_int($opcinaGradID) || ctype_digit($opcinaGradID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($opcinaGradID, true), gettype($opcinaGradID)), __LINE__);
        }
        $this->OpcinaGradID = $opcinaGradID;
        return $this;
    }
    /**
     * Get Opis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpis()
    {
        return isset($this->Opis) ? $this->Opis : null;
    }
    /**
     * Set Opis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opis
     * @return \StructType\Lokacija
     */
    public function setOpis($opis = null)
    {
        // validation for constraint: string
        if (!is_null($opis) && !is_string($opis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opis, true), gettype($opis)), __LINE__);
        }
        if (is_null($opis) || (is_array($opis) && empty($opis))) {
            unset($this->Opis);
        } else {
            $this->Opis = $opis;
        }
        return $this;
    }
    /**
     * Get PravnaOsoba value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PravnaOsobaObrt|null
     */
    public function getPravnaOsoba()
    {
        return isset($this->PravnaOsoba) ? $this->PravnaOsoba : null;
    }
    /**
     * Set PravnaOsoba value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PravnaOsobaObrt $pravnaOsoba
     * @return \StructType\Lokacija
     */
    public function setPravnaOsoba(\StructType\PravnaOsobaObrt $pravnaOsoba = null)
    {
        if (is_null($pravnaOsoba) || (is_array($pravnaOsoba) && empty($pravnaOsoba))) {
            unset($this->PravnaOsoba);
        } else {
            $this->PravnaOsoba = $pravnaOsoba;
        }
        return $this;
    }
    /**
     * Get Ulica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUlica()
    {
        return isset($this->Ulica) ? $this->Ulica : null;
    }
    /**
     * Set Ulica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ulica
     * @return \StructType\Lokacija
     */
    public function setUlica($ulica = null)
    {
        // validation for constraint: string
        if (!is_null($ulica) && !is_string($ulica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ulica, true), gettype($ulica)), __LINE__);
        }
        if (is_null($ulica) || (is_array($ulica) && empty($ulica))) {
            unset($this->Ulica);
        } else {
            $this->Ulica = $ulica;
        }
        return $this;
    }
    /**
     * Get ZupanijaID value
     * @return int|null
     */
    public function getZupanijaID()
    {
        return $this->ZupanijaID;
    }
    /**
     * Set ZupanijaID value
     * @param int $zupanijaID
     * @return \StructType\Lokacija
     */
    public function setZupanijaID($zupanijaID = null)
    {
        // validation for constraint: int
        if (!is_null($zupanijaID) && !(is_int($zupanijaID) || ctype_digit($zupanijaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zupanijaID, true), gettype($zupanijaID)), __LINE__);
        }
        $this->ZupanijaID = $zupanijaID;
        return $this;
    }
    /**
     * Get BrojOrganizacijskeJedinice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrojOrganizacijskeJedinice()
    {
        return isset($this->BrojOrganizacijskeJedinice) ? $this->BrojOrganizacijskeJedinice : null;
    }
    /**
     * Set BrojOrganizacijskeJedinice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brojOrganizacijskeJedinice
     * @return \StructType\Lokacija
     */
    public function setBrojOrganizacijskeJedinice($brojOrganizacijskeJedinice = null)
    {
        // validation for constraint: string
        if (!is_null($brojOrganizacijskeJedinice) && !is_string($brojOrganizacijskeJedinice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brojOrganizacijskeJedinice, true), gettype($brojOrganizacijskeJedinice)), __LINE__);
        }
        if (is_null($brojOrganizacijskeJedinice) || (is_array($brojOrganizacijskeJedinice) && empty($brojOrganizacijskeJedinice))) {
            unset($this->BrojOrganizacijskeJedinice);
        } else {
            $this->BrojOrganizacijskeJedinice = $brojOrganizacijskeJedinice;
        }
        return $this;
    }
    /**
     * Get DatumDeaktivacije value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumDeaktivacije()
    {
        return isset($this->DatumDeaktivacije) ? $this->DatumDeaktivacije : null;
    }
    /**
     * Set DatumDeaktivacije value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumDeaktivacije
     * @return \StructType\Lokacija
     */
    public function setDatumDeaktivacije($datumDeaktivacije = null)
    {
        // validation for constraint: string
        if (!is_null($datumDeaktivacije) && !is_string($datumDeaktivacije)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumDeaktivacije, true), gettype($datumDeaktivacije)), __LINE__);
        }
        if (is_null($datumDeaktivacije) || (is_array($datumDeaktivacije) && empty($datumDeaktivacije))) {
            unset($this->DatumDeaktivacije);
        } else {
            $this->DatumDeaktivacije = $datumDeaktivacije;
        }
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\Lokacija
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPrijaveDeaktivacije value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumPrijaveDeaktivacije()
    {
        return isset($this->DatumPrijaveDeaktivacije) ? $this->DatumPrijaveDeaktivacije : null;
    }
    /**
     * Set DatumPrijaveDeaktivacije value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumPrijaveDeaktivacije
     * @return \StructType\Lokacija
     */
    public function setDatumPrijaveDeaktivacije($datumPrijaveDeaktivacije = null)
    {
        // validation for constraint: string
        if (!is_null($datumPrijaveDeaktivacije) && !is_string($datumPrijaveDeaktivacije)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPrijaveDeaktivacije, true), gettype($datumPrijaveDeaktivacije)), __LINE__);
        }
        if (is_null($datumPrijaveDeaktivacije) || (is_array($datumPrijaveDeaktivacije) && empty($datumPrijaveDeaktivacije))) {
            unset($this->DatumPrijaveDeaktivacije);
        } else {
            $this->DatumPrijaveDeaktivacije = $datumPrijaveDeaktivacije;
        }
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\Lokacija
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get DeaktivacijaKorisnik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeaktivacijaKorisnik()
    {
        return isset($this->DeaktivacijaKorisnik) ? $this->DeaktivacijaKorisnik : null;
    }
    /**
     * Set DeaktivacijaKorisnik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deaktivacijaKorisnik
     * @return \StructType\Lokacija
     */
    public function setDeaktivacijaKorisnik($deaktivacijaKorisnik = null)
    {
        // validation for constraint: string
        if (!is_null($deaktivacijaKorisnik) && !is_string($deaktivacijaKorisnik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deaktivacijaKorisnik, true), gettype($deaktivacijaKorisnik)), __LINE__);
        }
        if (is_null($deaktivacijaKorisnik) || (is_array($deaktivacijaKorisnik) && empty($deaktivacijaKorisnik))) {
            unset($this->DeaktivacijaKorisnik);
        } else {
            $this->DeaktivacijaKorisnik = $deaktivacijaKorisnik;
        }
        return $this;
    }
    /**
     * Get DeaktivacijaSustav value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeaktivacijaSustav()
    {
        return isset($this->DeaktivacijaSustav) ? $this->DeaktivacijaSustav : null;
    }
    /**
     * Set DeaktivacijaSustav value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deaktivacijaSustav
     * @return \StructType\Lokacija
     */
    public function setDeaktivacijaSustav($deaktivacijaSustav = null)
    {
        // validation for constraint: string
        if (!is_null($deaktivacijaSustav) && !is_string($deaktivacijaSustav)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deaktivacijaSustav, true), gettype($deaktivacijaSustav)), __LINE__);
        }
        if (is_null($deaktivacijaSustav) || (is_array($deaktivacijaSustav) && empty($deaktivacijaSustav))) {
            unset($this->DeaktivacijaSustav);
        } else {
            $this->DeaktivacijaSustav = $deaktivacijaSustav;
        }
        return $this;
    }
    /**
     * Get Dokuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDokument|null
     */
    public function getDokuments()
    {
        return isset($this->Dokuments) ? $this->Dokuments : null;
    }
    /**
     * Set Dokuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDokument $dokuments
     * @return \StructType\Lokacija
     */
    public function setDokuments(\ArrayType\ArrayOfDokument $dokuments = null)
    {
        if (is_null($dokuments) || (is_array($dokuments) && empty($dokuments))) {
            unset($this->Dokuments);
        } else {
            $this->Dokuments = $dokuments;
        }
        return $this;
    }
    /**
     * Get Dokuments1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDokument|null
     */
    public function getDokuments1()
    {
        return isset($this->Dokuments1) ? $this->Dokuments1 : null;
    }
    /**
     * Set Dokuments1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDokument $dokuments1
     * @return \StructType\Lokacija
     */
    public function setDokuments1(\ArrayType\ArrayOfDokument $dokuments1 = null)
    {
        if (is_null($dokuments1) || (is_array($dokuments1) && empty($dokuments1))) {
            unset($this->Dokuments1);
        } else {
            $this->Dokuments1 = $dokuments1;
        }
        return $this;
    }
    /**
     * Get DozvolaZabranes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDozvolaZabrane|null
     */
    public function getDozvolaZabranes()
    {
        return isset($this->DozvolaZabranes) ? $this->DozvolaZabranes : null;
    }
    /**
     * Set DozvolaZabranes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDozvolaZabrane $dozvolaZabranes
     * @return \StructType\Lokacija
     */
    public function setDozvolaZabranes(\ArrayType\ArrayOfDozvolaZabrane $dozvolaZabranes = null)
    {
        if (is_null($dozvolaZabranes) || (is_array($dozvolaZabranes) && empty($dozvolaZabranes))) {
            unset($this->DozvolaZabranes);
        } else {
            $this->DozvolaZabranes = $dozvolaZabranes;
        }
        return $this;
    }
    /**
     * Get Dozvolas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDozvola|null
     */
    public function getDozvolas()
    {
        return isset($this->Dozvolas) ? $this->Dozvolas : null;
    }
    /**
     * Set Dozvolas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDozvola $dozvolas
     * @return \StructType\Lokacija
     */
    public function setDozvolas(\ArrayType\ArrayOfDozvola $dozvolas = null)
    {
        if (is_null($dozvolas) || (is_array($dozvolas) && empty($dozvolas))) {
            unset($this->Dozvolas);
        } else {
            $this->Dozvolas = $dozvolas;
        }
        return $this;
    }
    /**
     * Get EPRTRID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEPRTRID()
    {
        return isset($this->EPRTRID) ? $this->EPRTRID : null;
    }
    /**
     * Set EPRTRID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ePRTRID
     * @return \StructType\Lokacija
     */
    public function setEPRTRID($ePRTRID = null)
    {
        // validation for constraint: string
        if (!is_null($ePRTRID) && !is_string($ePRTRID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ePRTRID, true), gettype($ePRTRID)), __LINE__);
        }
        if (is_null($ePRTRID) || (is_array($ePRTRID) && empty($ePRTRID))) {
            unset($this->EPRTRID);
        } else {
            $this->EPRTRID = $ePRTRID;
        }
        return $this;
    }
    /**
     * Get ImaHTRSLokaciju value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getImaHTRSLokaciju()
    {
        return isset($this->ImaHTRSLokaciju) ? $this->ImaHTRSLokaciju : null;
    }
    /**
     * Set ImaHTRSLokaciju value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $imaHTRSLokaciju
     * @return \StructType\Lokacija
     */
    public function setImaHTRSLokaciju($imaHTRSLokaciju = null)
    {
        // validation for constraint: boolean
        if (!is_null($imaHTRSLokaciju) && !is_bool($imaHTRSLokaciju)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($imaHTRSLokaciju, true), gettype($imaHTRSLokaciju)), __LINE__);
        }
        if (is_null($imaHTRSLokaciju) || (is_array($imaHTRSLokaciju) && empty($imaHTRSLokaciju))) {
            unset($this->ImaHTRSLokaciju);
        } else {
            $this->ImaHTRSLokaciju = $imaHTRSLokaciju;
        }
        return $this;
    }
    /**
     * Get ImaKatastarskuAdresu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getImaKatastarskuAdresu()
    {
        return isset($this->ImaKatastarskuAdresu) ? $this->ImaKatastarskuAdresu : null;
    }
    /**
     * Set ImaKatastarskuAdresu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $imaKatastarskuAdresu
     * @return \StructType\Lokacija
     */
    public function setImaKatastarskuAdresu($imaKatastarskuAdresu = null)
    {
        // validation for constraint: boolean
        if (!is_null($imaKatastarskuAdresu) && !is_bool($imaKatastarskuAdresu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($imaKatastarskuAdresu, true), gettype($imaKatastarskuAdresu)), __LINE__);
        }
        if (is_null($imaKatastarskuAdresu) || (is_array($imaKatastarskuAdresu) && empty($imaKatastarskuAdresu))) {
            unset($this->ImaKatastarskuAdresu);
        } else {
            $this->ImaKatastarskuAdresu = $imaKatastarskuAdresu;
        }
        return $this;
    }
    /**
     * Get ImaUlicuKBR value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getImaUlicuKBR()
    {
        return isset($this->ImaUlicuKBR) ? $this->ImaUlicuKBR : null;
    }
    /**
     * Set ImaUlicuKBR value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $imaUlicuKBR
     * @return \StructType\Lokacija
     */
    public function setImaUlicuKBR($imaUlicuKBR = null)
    {
        // validation for constraint: boolean
        if (!is_null($imaUlicuKBR) && !is_bool($imaUlicuKBR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($imaUlicuKBR, true), gettype($imaUlicuKBR)), __LINE__);
        }
        if (is_null($imaUlicuKBR) || (is_array($imaUlicuKBR) && empty($imaUlicuKBR))) {
            unset($this->ImaUlicuKBR);
        } else {
            $this->ImaUlicuKBR = $imaUlicuKBR;
        }
        return $this;
    }
    /**
     * Get KatastarskaCestica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKatastarskaCestica()
    {
        return isset($this->KatastarskaCestica) ? $this->KatastarskaCestica : null;
    }
    /**
     * Set KatastarskaCestica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $katastarskaCestica
     * @return \StructType\Lokacija
     */
    public function setKatastarskaCestica($katastarskaCestica = null)
    {
        // validation for constraint: string
        if (!is_null($katastarskaCestica) && !is_string($katastarskaCestica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($katastarskaCestica, true), gettype($katastarskaCestica)), __LINE__);
        }
        if (is_null($katastarskaCestica) || (is_array($katastarskaCestica) && empty($katastarskaCestica))) {
            unset($this->KatastarskaCestica);
        } else {
            $this->KatastarskaCestica = $katastarskaCestica;
        }
        return $this;
    }
    /**
     * Get KatastarskaOpcina value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKatastarskaOpcina()
    {
        return isset($this->KatastarskaOpcina) ? $this->KatastarskaOpcina : null;
    }
    /**
     * Set KatastarskaOpcina value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $katastarskaOpcina
     * @return \StructType\Lokacija
     */
    public function setKatastarskaOpcina($katastarskaOpcina = null)
    {
        // validation for constraint: string
        if (!is_null($katastarskaOpcina) && !is_string($katastarskaOpcina)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($katastarskaOpcina, true), gettype($katastarskaOpcina)), __LINE__);
        }
        if (is_null($katastarskaOpcina) || (is_array($katastarskaOpcina) && empty($katastarskaOpcina))) {
            unset($this->KatastarskaOpcina);
        } else {
            $this->KatastarskaOpcina = $katastarskaOpcina;
        }
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\Lokacija
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get LokacijaKorisnikRolas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLokacijaKorisnikRola|null
     */
    public function getLokacijaKorisnikRolas()
    {
        return isset($this->LokacijaKorisnikRolas) ? $this->LokacijaKorisnikRolas : null;
    }
    /**
     * Set LokacijaKorisnikRolas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLokacijaKorisnikRola $lokacijaKorisnikRolas
     * @return \StructType\Lokacija
     */
    public function setLokacijaKorisnikRolas(\ArrayType\ArrayOfLokacijaKorisnikRola $lokacijaKorisnikRolas = null)
    {
        if (is_null($lokacijaKorisnikRolas) || (is_array($lokacijaKorisnikRolas) && empty($lokacijaKorisnikRolas))) {
            unset($this->LokacijaKorisnikRolas);
        } else {
            $this->LokacijaKorisnikRolas = $lokacijaKorisnikRolas;
        }
        return $this;
    }
    /**
     * Get LokacijaROOExports value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLokacijaROOExport|null
     */
    public function getLokacijaROOExports()
    {
        return isset($this->LokacijaROOExports) ? $this->LokacijaROOExports : null;
    }
    /**
     * Set LokacijaROOExports value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLokacijaROOExport $lokacijaROOExports
     * @return \StructType\Lokacija
     */
    public function setLokacijaROOExports(\ArrayType\ArrayOfLokacijaROOExport $lokacijaROOExports = null)
    {
        if (is_null($lokacijaROOExports) || (is_array($lokacijaROOExports) && empty($lokacijaROOExports))) {
            unset($this->LokacijaROOExports);
        } else {
            $this->LokacijaROOExports = $lokacijaROOExports;
        }
        return $this;
    }
    /**
     * Get LokacijaX value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLokacijaX()
    {
        return isset($this->LokacijaX) ? $this->LokacijaX : null;
    }
    /**
     * Set LokacijaX value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $lokacijaX
     * @return \StructType\Lokacija
     */
    public function setLokacijaX($lokacijaX = null)
    {
        // validation for constraint: float
        if (!is_null($lokacijaX) && !(is_float($lokacijaX) || is_numeric($lokacijaX))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lokacijaX, true), gettype($lokacijaX)), __LINE__);
        }
        if (is_null($lokacijaX) || (is_array($lokacijaX) && empty($lokacijaX))) {
            unset($this->LokacijaX);
        } else {
            $this->LokacijaX = $lokacijaX;
        }
        return $this;
    }
    /**
     * Get LokacijaY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLokacijaY()
    {
        return isset($this->LokacijaY) ? $this->LokacijaY : null;
    }
    /**
     * Set LokacijaY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $lokacijaY
     * @return \StructType\Lokacija
     */
    public function setLokacijaY($lokacijaY = null)
    {
        // validation for constraint: float
        if (!is_null($lokacijaY) && !(is_float($lokacijaY) || is_numeric($lokacijaY))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lokacijaY, true), gettype($lokacijaY)), __LINE__);
        }
        if (is_null($lokacijaY) || (is_array($lokacijaY) && empty($lokacijaY))) {
            unset($this->LokacijaY);
        } else {
            $this->LokacijaY = $lokacijaY;
        }
        return $this;
    }
    /**
     * Get MRDLokacijas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMRDLokacija|null
     */
    public function getMRDLokacijas()
    {
        return isset($this->MRDLokacijas) ? $this->MRDLokacijas : null;
    }
    /**
     * Set MRDLokacijas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMRDLokacija $mRDLokacijas
     * @return \StructType\Lokacija
     */
    public function setMRDLokacijas(\ArrayType\ArrayOfMRDLokacija $mRDLokacijas = null)
    {
        if (is_null($mRDLokacijas) || (is_array($mRDLokacijas) && empty($mRDLokacijas))) {
            unset($this->MRDLokacijas);
        } else {
            $this->MRDLokacijas = $mRDLokacijas;
        }
        return $this;
    }
    /**
     * Get Naselje value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Naselje|null
     */
    public function getNaselje()
    {
        return isset($this->Naselje) ? $this->Naselje : null;
    }
    /**
     * Set Naselje value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Naselje $naselje
     * @return \StructType\Lokacija
     */
    public function setNaselje(\StructType\Naselje $naselje = null)
    {
        if (is_null($naselje) || (is_array($naselje) && empty($naselje))) {
            unset($this->Naselje);
        } else {
            $this->Naselje = $naselje;
        }
        return $this;
    }
    /**
     * Get ONTOes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfONTO|null
     */
    public function getONTOes()
    {
        return isset($this->ONTOes) ? $this->ONTOes : null;
    }
    /**
     * Set ONTOes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfONTO $oNTOes
     * @return \StructType\Lokacija
     */
    public function setONTOes(\ArrayType\ArrayOfONTO $oNTOes = null)
    {
        if (is_null($oNTOes) || (is_array($oNTOes) && empty($oNTOes))) {
            unset($this->ONTOes);
        } else {
            $this->ONTOes = $oNTOes;
        }
        return $this;
    }
    /**
     * Get OdgovornaOsoba value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOdgovornaOsoba()
    {
        return isset($this->OdgovornaOsoba) ? $this->OdgovornaOsoba : null;
    }
    /**
     * Set OdgovornaOsoba value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $odgovornaOsoba
     * @return \StructType\Lokacija
     */
    public function setOdgovornaOsoba($odgovornaOsoba = null)
    {
        // validation for constraint: string
        if (!is_null($odgovornaOsoba) && !is_string($odgovornaOsoba)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($odgovornaOsoba, true), gettype($odgovornaOsoba)), __LINE__);
        }
        if (is_null($odgovornaOsoba) || (is_array($odgovornaOsoba) && empty($odgovornaOsoba))) {
            unset($this->OdgovornaOsoba);
        } else {
            $this->OdgovornaOsoba = $odgovornaOsoba;
        }
        return $this;
    }
    /**
     * Get OpGrad value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OpGrad|null
     */
    public function getOpGrad()
    {
        return isset($this->OpGrad) ? $this->OpGrad : null;
    }
    /**
     * Set OpGrad value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OpGrad $opGrad
     * @return \StructType\Lokacija
     */
    public function setOpGrad(\StructType\OpGrad $opGrad = null)
    {
        if (is_null($opGrad) || (is_array($opGrad) && empty($opGrad))) {
            unset($this->OpGrad);
        } else {
            $this->OpGrad = $opGrad;
        }
        return $this;
    }
    /**
     * Get OpGradID value
     * @return int|null
     */
    public function getOpGradID()
    {
        return $this->OpGradID;
    }
    /**
     * Set OpGradID value
     * @param int $opGradID
     * @return \StructType\Lokacija
     */
    public function setOpGradID($opGradID = null)
    {
        // validation for constraint: int
        if (!is_null($opGradID) && !(is_int($opGradID) || ctype_digit($opGradID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($opGradID, true), gettype($opGradID)), __LINE__);
        }
        $this->OpGradID = $opGradID;
        return $this;
    }
    /**
     * Get OznakaOrganizacijskeJedinice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOznakaOrganizacijskeJedinice()
    {
        return isset($this->OznakaOrganizacijskeJedinice) ? $this->OznakaOrganizacijskeJedinice : null;
    }
    /**
     * Set OznakaOrganizacijskeJedinice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oznakaOrganizacijskeJedinice
     * @return \StructType\Lokacija
     */
    public function setOznakaOrganizacijskeJedinice($oznakaOrganizacijskeJedinice = null)
    {
        // validation for constraint: string
        if (!is_null($oznakaOrganizacijskeJedinice) && !is_string($oznakaOrganizacijskeJedinice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oznakaOrganizacijskeJedinice, true), gettype($oznakaOrganizacijskeJedinice)), __LINE__);
        }
        if (is_null($oznakaOrganizacijskeJedinice) || (is_array($oznakaOrganizacijskeJedinice) && empty($oznakaOrganizacijskeJedinice))) {
            unset($this->OznakaOrganizacijskeJedinice);
        } else {
            $this->OznakaOrganizacijskeJedinice = $oznakaOrganizacijskeJedinice;
        }
        return $this;
    }
    /**
     * Get PFOOsoba value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PFOOsoba|null
     */
    public function getPFOOsoba()
    {
        return isset($this->PFOOsoba) ? $this->PFOOsoba : null;
    }
    /**
     * Set PFOOsoba value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PFOOsoba $pFOOsoba
     * @return \StructType\Lokacija
     */
    public function setPFOOsoba(\StructType\PFOOsoba $pFOOsoba = null)
    {
        if (is_null($pFOOsoba) || (is_array($pFOOsoba) && empty($pFOOsoba))) {
            unset($this->PFOOsoba);
        } else {
            $this->PFOOsoba = $pFOOsoba;
        }
        return $this;
    }
    /**
     * Get PFOOsobaID value
     * @return int|null
     */
    public function getPFOOsobaID()
    {
        return $this->PFOOsobaID;
    }
    /**
     * Set PFOOsobaID value
     * @param int $pFOOsobaID
     * @return \StructType\Lokacija
     */
    public function setPFOOsobaID($pFOOsobaID = null)
    {
        // validation for constraint: int
        if (!is_null($pFOOsobaID) && !(is_int($pFOOsobaID) || ctype_digit($pFOOsobaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pFOOsobaID, true), gettype($pFOOsobaID)), __LINE__);
        }
        $this->PFOOsobaID = $pFOOsobaID;
        return $this;
    }
    /**
     * Get PrateciLists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPrateciList|null
     */
    public function getPrateciLists()
    {
        return isset($this->PrateciLists) ? $this->PrateciLists : null;
    }
    /**
     * Set PrateciLists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPrateciList $prateciLists
     * @return \StructType\Lokacija
     */
    public function setPrateciLists(\ArrayType\ArrayOfPrateciList $prateciLists = null)
    {
        if (is_null($prateciLists) || (is_array($prateciLists) && empty($prateciLists))) {
            unset($this->PrateciLists);
        } else {
            $this->PrateciLists = $prateciLists;
        }
        return $this;
    }
    /**
     * Get PrateciLists1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPrateciList|null
     */
    public function getPrateciLists1()
    {
        return isset($this->PrateciLists1) ? $this->PrateciLists1 : null;
    }
    /**
     * Set PrateciLists1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPrateciList $prateciLists1
     * @return \StructType\Lokacija
     */
    public function setPrateciLists1(\ArrayType\ArrayOfPrateciList $prateciLists1 = null)
    {
        if (is_null($prateciLists1) || (is_array($prateciLists1) && empty($prateciLists1))) {
            unset($this->PrateciLists1);
        } else {
            $this->PrateciLists1 = $prateciLists1;
        }
        return $this;
    }
    /**
     * Get PravnaOsobaLokacijaNaseljes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPravnaOsobaLokacijaNaselje|null
     */
    public function getPravnaOsobaLokacijaNaseljes()
    {
        return isset($this->PravnaOsobaLokacijaNaseljes) ? $this->PravnaOsobaLokacijaNaseljes : null;
    }
    /**
     * Set PravnaOsobaLokacijaNaseljes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPravnaOsobaLokacijaNaselje $pravnaOsobaLokacijaNaseljes
     * @return \StructType\Lokacija
     */
    public function setPravnaOsobaLokacijaNaseljes(\ArrayType\ArrayOfPravnaOsobaLokacijaNaselje $pravnaOsobaLokacijaNaseljes = null)
    {
        if (is_null($pravnaOsobaLokacijaNaseljes) || (is_array($pravnaOsobaLokacijaNaseljes) && empty($pravnaOsobaLokacijaNaseljes))) {
            unset($this->PravnaOsobaLokacijaNaseljes);
        } else {
            $this->PravnaOsobaLokacijaNaseljes = $pravnaOsobaLokacijaNaseljes;
        }
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\Lokacija
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
    /**
     * Get RefDozvola value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefDozvola()
    {
        return isset($this->RefDozvola) ? $this->RefDozvola : null;
    }
    /**
     * Set RefDozvola value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refDozvola
     * @return \StructType\Lokacija
     */
    public function setRefDozvola($refDozvola = null)
    {
        // validation for constraint: string
        if (!is_null($refDozvola) && !is_string($refDozvola)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refDozvola, true), gettype($refDozvola)), __LINE__);
        }
        if (is_null($refDozvola) || (is_array($refDozvola) && empty($refDozvola))) {
            unset($this->RefDozvola);
        } else {
            $this->RefDozvola = $refDozvola;
        }
        return $this;
    }
    /**
     * Get SUMPAktivan value
     * @return bool|null
     */
    public function getSUMPAktivan()
    {
        return $this->SUMPAktivan;
    }
    /**
     * Set SUMPAktivan value
     * @param bool $sUMPAktivan
     * @return \StructType\Lokacija
     */
    public function setSUMPAktivan($sUMPAktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($sUMPAktivan) && !is_bool($sUMPAktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sUMPAktivan, true), gettype($sUMPAktivan)), __LINE__);
        }
        $this->SUMPAktivan = $sUMPAktivan;
        return $this;
    }
    /**
     * Get SUMPVrijemeIzmjene value
     * @return string|null
     */
    public function getSUMPVrijemeIzmjene()
    {
        return $this->SUMPVrijemeIzmjene;
    }
    /**
     * Set SUMPVrijemeIzmjene value
     * @param string $sUMPVrijemeIzmjene
     * @return \StructType\Lokacija
     */
    public function setSUMPVrijemeIzmjene($sUMPVrijemeIzmjene = null)
    {
        // validation for constraint: string
        if (!is_null($sUMPVrijemeIzmjene) && !is_string($sUMPVrijemeIzmjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUMPVrijemeIzmjene, true), gettype($sUMPVrijemeIzmjene)), __LINE__);
        }
        $this->SUMPVrijemeIzmjene = $sUMPVrijemeIzmjene;
        return $this;
    }
    /**
     * Get SUMPVrijemeUpisa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUMPVrijemeUpisa()
    {
        return isset($this->SUMPVrijemeUpisa) ? $this->SUMPVrijemeUpisa : null;
    }
    /**
     * Set SUMPVrijemeUpisa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUMPVrijemeUpisa
     * @return \StructType\Lokacija
     */
    public function setSUMPVrijemeUpisa($sUMPVrijemeUpisa = null)
    {
        // validation for constraint: string
        if (!is_null($sUMPVrijemeUpisa) && !is_string($sUMPVrijemeUpisa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUMPVrijemeUpisa, true), gettype($sUMPVrijemeUpisa)), __LINE__);
        }
        if (is_null($sUMPVrijemeUpisa) || (is_array($sUMPVrijemeUpisa) && empty($sUMPVrijemeUpisa))) {
            unset($this->SUMPVrijemeUpisa);
        } else {
            $this->SUMPVrijemeUpisa = $sUMPVrijemeUpisa;
        }
        return $this;
    }
    /**
     * Get SUMPZadnjiKorisnik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSUMPZadnjiKorisnik()
    {
        return isset($this->SUMPZadnjiKorisnik) ? $this->SUMPZadnjiKorisnik : null;
    }
    /**
     * Set SUMPZadnjiKorisnik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sUMPZadnjiKorisnik
     * @return \StructType\Lokacija
     */
    public function setSUMPZadnjiKorisnik($sUMPZadnjiKorisnik = null)
    {
        // validation for constraint: string
        if (!is_null($sUMPZadnjiKorisnik) && !is_string($sUMPZadnjiKorisnik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sUMPZadnjiKorisnik, true), gettype($sUMPZadnjiKorisnik)), __LINE__);
        }
        if (is_null($sUMPZadnjiKorisnik) || (is_array($sUMPZadnjiKorisnik) && empty($sUMPZadnjiKorisnik))) {
            unset($this->SUMPZadnjiKorisnik);
        } else {
            $this->SUMPZadnjiKorisnik = $sUMPZadnjiKorisnik;
        }
        return $this;
    }
    /**
     * Get SjedisteLokacijaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSjedisteLokacijaID()
    {
        return isset($this->SjedisteLokacijaID) ? $this->SjedisteLokacijaID : null;
    }
    /**
     * Set SjedisteLokacijaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sjedisteLokacijaID
     * @return \StructType\Lokacija
     */
    public function setSjedisteLokacijaID($sjedisteLokacijaID = null)
    {
        // validation for constraint: int
        if (!is_null($sjedisteLokacijaID) && !(is_int($sjedisteLokacijaID) || ctype_digit($sjedisteLokacijaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sjedisteLokacijaID, true), gettype($sjedisteLokacijaID)), __LINE__);
        }
        if (is_null($sjedisteLokacijaID) || (is_array($sjedisteLokacijaID) && empty($sjedisteLokacijaID))) {
            unset($this->SjedisteLokacijaID);
        } else {
            $this->SjedisteLokacijaID = $sjedisteLokacijaID;
        }
        return $this;
    }
    /**
     * Get SluzbenaLokacija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSluzbenaLokacija()
    {
        return isset($this->SluzbenaLokacija) ? $this->SluzbenaLokacija : null;
    }
    /**
     * Set SluzbenaLokacija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sluzbenaLokacija
     * @return \StructType\Lokacija
     */
    public function setSluzbenaLokacija($sluzbenaLokacija = null)
    {
        // validation for constraint: boolean
        if (!is_null($sluzbenaLokacija) && !is_bool($sluzbenaLokacija)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sluzbenaLokacija, true), gettype($sluzbenaLokacija)), __LINE__);
        }
        if (is_null($sluzbenaLokacija) || (is_array($sluzbenaLokacija) && empty($sluzbenaLokacija))) {
            unset($this->SluzbenaLokacija);
        } else {
            $this->SluzbenaLokacija = $sluzbenaLokacija;
        }
        return $this;
    }
    /**
     * Get SmijeBitSakrivena value
     * @return bool|null
     */
    public function getSmijeBitSakrivena()
    {
        return $this->SmijeBitSakrivena;
    }
    /**
     * Set SmijeBitSakrivena value
     * @param bool $smijeBitSakrivena
     * @return \StructType\Lokacija
     */
    public function setSmijeBitSakrivena($smijeBitSakrivena = null)
    {
        // validation for constraint: boolean
        if (!is_null($smijeBitSakrivena) && !is_bool($smijeBitSakrivena)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($smijeBitSakrivena, true), gettype($smijeBitSakrivena)), __LINE__);
        }
        $this->SmijeBitSakrivena = $smijeBitSakrivena;
        return $this;
    }
    /**
     * Get SumpId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSumpId()
    {
        return isset($this->SumpId) ? $this->SumpId : null;
    }
    /**
     * Set SumpId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sumpId
     * @return \StructType\Lokacija
     */
    public function setSumpId($sumpId = null)
    {
        // validation for constraint: int
        if (!is_null($sumpId) && !(is_int($sumpId) || ctype_digit($sumpId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sumpId, true), gettype($sumpId)), __LINE__);
        }
        if (is_null($sumpId) || (is_array($sumpId) && empty($sumpId))) {
            unset($this->SumpId);
        } else {
            $this->SumpId = $sumpId;
        }
        return $this;
    }
    /**
     * Get TijekOtpadaPs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTijekOtpadaP|null
     */
    public function getTijekOtpadaPs()
    {
        return isset($this->TijekOtpadaPs) ? $this->TijekOtpadaPs : null;
    }
    /**
     * Set TijekOtpadaPs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs
     * @return \StructType\Lokacija
     */
    public function setTijekOtpadaPs(\ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs = null)
    {
        if (is_null($tijekOtpadaPs) || (is_array($tijekOtpadaPs) && empty($tijekOtpadaPs))) {
            unset($this->TijekOtpadaPs);
        } else {
            $this->TijekOtpadaPs = $tijekOtpadaPs;
        }
        return $this;
    }
    /**
     * Get TijekOtpadaPs1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTijekOtpadaP|null
     */
    public function getTijekOtpadaPs1()
    {
        return isset($this->TijekOtpadaPs1) ? $this->TijekOtpadaPs1 : null;
    }
    /**
     * Set TijekOtpadaPs1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs1
     * @return \StructType\Lokacija
     */
    public function setTijekOtpadaPs1(\ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs1 = null)
    {
        if (is_null($tijekOtpadaPs1) || (is_array($tijekOtpadaPs1) && empty($tijekOtpadaPs1))) {
            unset($this->TijekOtpadaPs1);
        } else {
            $this->TijekOtpadaPs1 = $tijekOtpadaPs1;
        }
        return $this;
    }
    /**
     * Get TijekOtpadas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTijekOtpada|null
     */
    public function getTijekOtpadas()
    {
        return isset($this->TijekOtpadas) ? $this->TijekOtpadas : null;
    }
    /**
     * Set TijekOtpadas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTijekOtpada $tijekOtpadas
     * @return \StructType\Lokacija
     */
    public function setTijekOtpadas(\ArrayType\ArrayOfTijekOtpada $tijekOtpadas = null)
    {
        if (is_null($tijekOtpadas) || (is_array($tijekOtpadas) && empty($tijekOtpadas))) {
            unset($this->TijekOtpadas);
        } else {
            $this->TijekOtpadas = $tijekOtpadas;
        }
        return $this;
    }
    /**
     * Get UMAudit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfUMAudit|null
     */
    public function getUMAudit()
    {
        return isset($this->UMAudit) ? $this->UMAudit : null;
    }
    /**
     * Set UMAudit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfUMAudit $uMAudit
     * @return \StructType\Lokacija
     */
    public function setUMAudit(\ArrayType\ArrayOfUMAudit $uMAudit = null)
    {
        if (is_null($uMAudit) || (is_array($uMAudit) && empty($uMAudit))) {
            unset($this->UMAudit);
        } else {
            $this->UMAudit = $uMAudit;
        }
        return $this;
    }
    /**
     * Get UlicaTrg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UlicaTrg|null
     */
    public function getUlicaTrg()
    {
        return isset($this->UlicaTrg) ? $this->UlicaTrg : null;
    }
    /**
     * Set UlicaTrg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\UlicaTrg $ulicaTrg
     * @return \StructType\Lokacija
     */
    public function setUlicaTrg(\StructType\UlicaTrg $ulicaTrg = null)
    {
        if (is_null($ulicaTrg) || (is_array($ulicaTrg) && empty($ulicaTrg))) {
            unset($this->UlicaTrg);
        } else {
            $this->UlicaTrg = $ulicaTrg;
        }
        return $this;
    }
    /**
     * Get UlicaTrgId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUlicaTrgId()
    {
        return isset($this->UlicaTrgId) ? $this->UlicaTrgId : null;
    }
    /**
     * Set UlicaTrgId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ulicaTrgId
     * @return \StructType\Lokacija
     */
    public function setUlicaTrgId($ulicaTrgId = null)
    {
        // validation for constraint: int
        if (!is_null($ulicaTrgId) && !(is_int($ulicaTrgId) || ctype_digit($ulicaTrgId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ulicaTrgId, true), gettype($ulicaTrgId)), __LINE__);
        }
        if (is_null($ulicaTrgId) || (is_array($ulicaTrgId) && empty($ulicaTrgId))) {
            unset($this->UlicaTrgId);
        } else {
            $this->UlicaTrgId = $ulicaTrgId;
        }
        return $this;
    }
    /**
     * Get VlastitaOznaka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVlastitaOznaka()
    {
        return isset($this->VlastitaOznaka) ? $this->VlastitaOznaka : null;
    }
    /**
     * Set VlastitaOznaka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vlastitaOznaka
     * @return \StructType\Lokacija
     */
    public function setVlastitaOznaka($vlastitaOznaka = null)
    {
        // validation for constraint: string
        if (!is_null($vlastitaOznaka) && !is_string($vlastitaOznaka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vlastitaOznaka, true), gettype($vlastitaOznaka)), __LINE__);
        }
        if (is_null($vlastitaOznaka) || (is_array($vlastitaOznaka) && empty($vlastitaOznaka))) {
            unset($this->VlastitaOznaka);
        } else {
            $this->VlastitaOznaka = $vlastitaOznaka;
        }
        return $this;
    }
    /**
     * Get VrsnaLokacija value
     * @return bool|null
     */
    public function getVrsnaLokacija()
    {
        return $this->VrsnaLokacija;
    }
    /**
     * Set VrsnaLokacija value
     * @param bool $vrsnaLokacija
     * @return \StructType\Lokacija
     */
    public function setVrsnaLokacija($vrsnaLokacija = null)
    {
        // validation for constraint: boolean
        if (!is_null($vrsnaLokacija) && !is_bool($vrsnaLokacija)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vrsnaLokacija, true), gettype($vrsnaLokacija)), __LINE__);
        }
        $this->VrsnaLokacija = $vrsnaLokacija;
        return $this;
    }
    /**
     * Get ZadnjiSustav value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZadnjiSustav()
    {
        return isset($this->ZadnjiSustav) ? $this->ZadnjiSustav : null;
    }
    /**
     * Set ZadnjiSustav value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zadnjiSustav
     * @return \StructType\Lokacija
     */
    public function setZadnjiSustav($zadnjiSustav = null)
    {
        // validation for constraint: string
        if (!is_null($zadnjiSustav) && !is_string($zadnjiSustav)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zadnjiSustav, true), gettype($zadnjiSustav)), __LINE__);
        }
        if (is_null($zadnjiSustav) || (is_array($zadnjiSustav) && empty($zadnjiSustav))) {
            unset($this->ZadnjiSustav);
        } else {
            $this->ZadnjiSustav = $zadnjiSustav;
        }
        return $this;
    }
    /**
     * Get ZahtjevTvrtkaLokacijas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfZahtjevTvrtkaLokacija|null
     */
    public function getZahtjevTvrtkaLokacijas()
    {
        return isset($this->ZahtjevTvrtkaLokacijas) ? $this->ZahtjevTvrtkaLokacijas : null;
    }
    /**
     * Set ZahtjevTvrtkaLokacijas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfZahtjevTvrtkaLokacija $zahtjevTvrtkaLokacijas
     * @return \StructType\Lokacija
     */
    public function setZahtjevTvrtkaLokacijas(\ArrayType\ArrayOfZahtjevTvrtkaLokacija $zahtjevTvrtkaLokacijas = null)
    {
        if (is_null($zahtjevTvrtkaLokacijas) || (is_array($zahtjevTvrtkaLokacijas) && empty($zahtjevTvrtkaLokacijas))) {
            unset($this->ZahtjevTvrtkaLokacijas);
        } else {
            $this->ZahtjevTvrtkaLokacijas = $zahtjevTvrtkaLokacijas;
        }
        return $this;
    }
    /**
     * Get ZgradaKbr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ZgradaKbr|null
     */
    public function getZgradaKbr()
    {
        return isset($this->ZgradaKbr) ? $this->ZgradaKbr : null;
    }
    /**
     * Set ZgradaKbr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ZgradaKbr $zgradaKbr
     * @return \StructType\Lokacija
     */
    public function setZgradaKbr(\StructType\ZgradaKbr $zgradaKbr = null)
    {
        if (is_null($zgradaKbr) || (is_array($zgradaKbr) && empty($zgradaKbr))) {
            unset($this->ZgradaKbr);
        } else {
            $this->ZgradaKbr = $zgradaKbr;
        }
        return $this;
    }
    /**
     * Get ZgradaKbrId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getZgradaKbrId()
    {
        return isset($this->ZgradaKbrId) ? $this->ZgradaKbrId : null;
    }
    /**
     * Set ZgradaKbrId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $zgradaKbrId
     * @return \StructType\Lokacija
     */
    public function setZgradaKbrId($zgradaKbrId = null)
    {
        // validation for constraint: int
        if (!is_null($zgradaKbrId) && !(is_int($zgradaKbrId) || ctype_digit($zgradaKbrId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zgradaKbrId, true), gettype($zgradaKbrId)), __LINE__);
        }
        if (is_null($zgradaKbrId) || (is_array($zgradaKbrId) && empty($zgradaKbrId))) {
            unset($this->ZgradaKbrId);
        } else {
            $this->ZgradaKbrId = $zgradaKbrId;
        }
        return $this;
    }
    /**
     * Get Zupanija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Zupanija|null
     */
    public function getZupanija()
    {
        return isset($this->Zupanija) ? $this->Zupanija : null;
    }
    /**
     * Set Zupanija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Zupanija $zupanija
     * @return \StructType\Lokacija
     */
    public function setZupanija(\StructType\Zupanija $zupanija = null)
    {
        if (is_null($zupanija) || (is_array($zupanija) && empty($zupanija))) {
            unset($this->Zupanija);
        } else {
            $this->Zupanija = $zupanija;
        }
        return $this;
    }
    /**
     * Get extDozvolas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfextDozvola|null
     */
    public function getExtDozvolas()
    {
        return isset($this->extDozvolas) ? $this->extDozvolas : null;
    }
    /**
     * Set extDozvolas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfextDozvola $extDozvolas
     * @return \StructType\Lokacija
     */
    public function setExtDozvolas(\ArrayType\ArrayOfextDozvola $extDozvolas = null)
    {
        if (is_null($extDozvolas) || (is_array($extDozvolas) && empty($extDozvolas))) {
            unset($this->extDozvolas);
        } else {
            $this->extDozvolas = $extDozvolas;
        }
        return $this;
    }
    /**
     * Get extDozvoljeniRDPostupaks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfextDozvoljeniRDPostupak|null
     */
    public function getExtDozvoljeniRDPostupaks()
    {
        return isset($this->extDozvoljeniRDPostupaks) ? $this->extDozvoljeniRDPostupaks : null;
    }
    /**
     * Set extDozvoljeniRDPostupaks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfextDozvoljeniRDPostupak $extDozvoljeniRDPostupaks
     * @return \StructType\Lokacija
     */
    public function setExtDozvoljeniRDPostupaks(\ArrayType\ArrayOfextDozvoljeniRDPostupak $extDozvoljeniRDPostupaks = null)
    {
        if (is_null($extDozvoljeniRDPostupaks) || (is_array($extDozvoljeniRDPostupaks) && empty($extDozvoljeniRDPostupaks))) {
            unset($this->extDozvoljeniRDPostupaks);
        } else {
            $this->extDozvoljeniRDPostupaks = $extDozvoljeniRDPostupaks;
        }
        return $this;
    }
    /**
     * Get extOcevidniks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfextOcevidnik|null
     */
    public function getExtOcevidniks()
    {
        return isset($this->extOcevidniks) ? $this->extOcevidniks : null;
    }
    /**
     * Set extOcevidniks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfextOcevidnik $extOcevidniks
     * @return \StructType\Lokacija
     */
    public function setExtOcevidniks(\ArrayType\ArrayOfextOcevidnik $extOcevidniks = null)
    {
        if (is_null($extOcevidniks) || (is_array($extOcevidniks) && empty($extOcevidniks))) {
            unset($this->extOcevidniks);
        } else {
            $this->extOcevidniks = $extOcevidniks;
        }
        return $this;
    }
    /**
     * Get extPrekogranicniPromets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfextPrekogranicniPromet|null
     */
    public function getExtPrekogranicniPromets()
    {
        return isset($this->extPrekogranicniPromets) ? $this->extPrekogranicniPromets : null;
    }
    /**
     * Set extPrekogranicniPromets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfextPrekogranicniPromet $extPrekogranicniPromets
     * @return \StructType\Lokacija
     */
    public function setExtPrekogranicniPromets(\ArrayType\ArrayOfextPrekogranicniPromet $extPrekogranicniPromets = null)
    {
        if (is_null($extPrekogranicniPromets) || (is_array($extPrekogranicniPromets) && empty($extPrekogranicniPromets))) {
            unset($this->extPrekogranicniPromets);
        } else {
            $this->extPrekogranicniPromets = $extPrekogranicniPromets;
        }
        return $this;
    }
    /**
     * Get extPrekogranicniPromets1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfextPrekogranicniPromet|null
     */
    public function getExtPrekogranicniPromets1()
    {
        return isset($this->extPrekogranicniPromets1) ? $this->extPrekogranicniPromets1 : null;
    }
    /**
     * Set extPrekogranicniPromets1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfextPrekogranicniPromet $extPrekogranicniPromets1
     * @return \StructType\Lokacija
     */
    public function setExtPrekogranicniPromets1(\ArrayType\ArrayOfextPrekogranicniPromet $extPrekogranicniPromets1 = null)
    {
        if (is_null($extPrekogranicniPromets1) || (is_array($extPrekogranicniPromets1) && empty($extPrekogranicniPromets1))) {
            unset($this->extPrekogranicniPromets1);
        } else {
            $this->extPrekogranicniPromets1 = $extPrekogranicniPromets1;
        }
        return $this;
    }
}
