<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLokacija_v2 StructType
 * @subpackage Structs
 */
class GetLokacija_v2 extends AbstractStructBase
{
    /**
     * The username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityToken;
    /**
     * The lokacijaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lokacijaID;
    /**
     * The lokacijaProdavateljaOtpada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $lokacijaProdavateljaOtpada;
    /**
     * Constructor method for GetLokacija_v2
     * @uses GetLokacija_v2::setUsername()
     * @uses GetLokacija_v2::setSecurityToken()
     * @uses GetLokacija_v2::setLokacijaID()
     * @uses GetLokacija_v2::setLokacijaProdavateljaOtpada()
     * @param string $username
     * @param string $securityToken
     * @param int $lokacijaID
     * @param bool $lokacijaProdavateljaOtpada
     */
    public function __construct($username = null, $securityToken = null, $lokacijaID = null, $lokacijaProdavateljaOtpada = null)
    {
        $this
            ->setUsername($username)
            ->setSecurityToken($securityToken)
            ->setLokacijaID($lokacijaID)
            ->setLokacijaProdavateljaOtpada($lokacijaProdavateljaOtpada);
    }
    /**
     * Get username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->username) ? $this->username : null;
    }
    /**
     * Set username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\GetLokacija_v2
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->username);
        } else {
            $this->username = $username;
        }
        return $this;
    }
    /**
     * Get securityToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityToken()
    {
        return isset($this->securityToken) ? $this->securityToken : null;
    }
    /**
     * Set securityToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityToken
     * @return \StructType\GetLokacija_v2
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityToken, true), gettype($securityToken)), __LINE__);
        }
        if (is_null($securityToken) || (is_array($securityToken) && empty($securityToken))) {
            unset($this->securityToken);
        } else {
            $this->securityToken = $securityToken;
        }
        return $this;
    }
    /**
     * Get lokacijaID value
     * @return int|null
     */
    public function getLokacijaID()
    {
        return $this->lokacijaID;
    }
    /**
     * Set lokacijaID value
     * @param int $lokacijaID
     * @return \StructType\GetLokacija_v2
     */
    public function setLokacijaID($lokacijaID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaID) && !(is_int($lokacijaID) || ctype_digit($lokacijaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaID, true), gettype($lokacijaID)), __LINE__);
        }
        $this->lokacijaID = $lokacijaID;
        return $this;
    }
    /**
     * Get lokacijaProdavateljaOtpada value
     * @return bool|null
     */
    public function getLokacijaProdavateljaOtpada()
    {
        return $this->lokacijaProdavateljaOtpada;
    }
    /**
     * Set lokacijaProdavateljaOtpada value
     * @param bool $lokacijaProdavateljaOtpada
     * @return \StructType\GetLokacija_v2
     */
    public function setLokacijaProdavateljaOtpada($lokacijaProdavateljaOtpada = null)
    {
        // validation for constraint: boolean
        if (!is_null($lokacijaProdavateljaOtpada) && !is_bool($lokacijaProdavateljaOtpada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lokacijaProdavateljaOtpada, true), gettype($lokacijaProdavateljaOtpada)), __LINE__);
        }
        $this->lokacijaProdavateljaOtpada = $lokacijaProdavateljaOtpada;
        return $this;
    }
}
