<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DokumentKategorijaDokumenta StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DokumentKategorijaDokumenta
 * @subpackage Structs
 */
class DokumentKategorijaDokumenta extends AbstractStructBase
{
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The Dokument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Dokument
     */
    public $Dokument;
    /**
     * The DokumentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DokumentID;
    /**
     * The DokumentKategorijaDokumentaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DokumentKategorijaDokumentaID;
    /**
     * The KategorijaDokumenta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KategorijaDokumenta
     */
    public $KategorijaDokumenta;
    /**
     * The KategorijaDokumentaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KategorijaDokumentaID;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * Constructor method for DokumentKategorijaDokumenta
     * @uses DokumentKategorijaDokumenta::setDatumKreiranja()
     * @uses DokumentKategorijaDokumenta::setDatumPromjene()
     * @uses DokumentKategorijaDokumenta::setDokument()
     * @uses DokumentKategorijaDokumenta::setDokumentID()
     * @uses DokumentKategorijaDokumenta::setDokumentKategorijaDokumentaID()
     * @uses DokumentKategorijaDokumenta::setKategorijaDokumenta()
     * @uses DokumentKategorijaDokumenta::setKategorijaDokumentaID()
     * @uses DokumentKategorijaDokumenta::setKreirao()
     * @uses DokumentKategorijaDokumenta::setPromijenio()
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param \StructType\Dokument $dokument
     * @param int $dokumentID
     * @param int $dokumentKategorijaDokumentaID
     * @param \StructType\KategorijaDokumenta $kategorijaDokumenta
     * @param int $kategorijaDokumentaID
     * @param string $kreirao
     * @param string $promijenio
     */
    public function __construct($datumKreiranja = null, $datumPromjene = null, \StructType\Dokument $dokument = null, $dokumentID = null, $dokumentKategorijaDokumentaID = null, \StructType\KategorijaDokumenta $kategorijaDokumenta = null, $kategorijaDokumentaID = null, $kreirao = null, $promijenio = null)
    {
        $this
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setDokument($dokument)
            ->setDokumentID($dokumentID)
            ->setDokumentKategorijaDokumentaID($dokumentKategorijaDokumentaID)
            ->setKategorijaDokumenta($kategorijaDokumenta)
            ->setKategorijaDokumentaID($kategorijaDokumentaID)
            ->setKreirao($kreirao)
            ->setPromijenio($promijenio);
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\DokumentKategorijaDokumenta
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\DokumentKategorijaDokumenta
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get Dokument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Dokument|null
     */
    public function getDokument()
    {
        return isset($this->Dokument) ? $this->Dokument : null;
    }
    /**
     * Set Dokument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Dokument $dokument
     * @return \StructType\DokumentKategorijaDokumenta
     */
    public function setDokument(\StructType\Dokument $dokument = null)
    {
        if (is_null($dokument) || (is_array($dokument) && empty($dokument))) {
            unset($this->Dokument);
        } else {
            $this->Dokument = $dokument;
        }
        return $this;
    }
    /**
     * Get DokumentID value
     * @return int|null
     */
    public function getDokumentID()
    {
        return $this->DokumentID;
    }
    /**
     * Set DokumentID value
     * @param int $dokumentID
     * @return \StructType\DokumentKategorijaDokumenta
     */
    public function setDokumentID($dokumentID = null)
    {
        // validation for constraint: int
        if (!is_null($dokumentID) && !(is_int($dokumentID) || ctype_digit($dokumentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dokumentID, true), gettype($dokumentID)), __LINE__);
        }
        $this->DokumentID = $dokumentID;
        return $this;
    }
    /**
     * Get DokumentKategorijaDokumentaID value
     * @return int|null
     */
    public function getDokumentKategorijaDokumentaID()
    {
        return $this->DokumentKategorijaDokumentaID;
    }
    /**
     * Set DokumentKategorijaDokumentaID value
     * @param int $dokumentKategorijaDokumentaID
     * @return \StructType\DokumentKategorijaDokumenta
     */
    public function setDokumentKategorijaDokumentaID($dokumentKategorijaDokumentaID = null)
    {
        // validation for constraint: int
        if (!is_null($dokumentKategorijaDokumentaID) && !(is_int($dokumentKategorijaDokumentaID) || ctype_digit($dokumentKategorijaDokumentaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dokumentKategorijaDokumentaID, true), gettype($dokumentKategorijaDokumentaID)), __LINE__);
        }
        $this->DokumentKategorijaDokumentaID = $dokumentKategorijaDokumentaID;
        return $this;
    }
    /**
     * Get KategorijaDokumenta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KategorijaDokumenta|null
     */
    public function getKategorijaDokumenta()
    {
        return isset($this->KategorijaDokumenta) ? $this->KategorijaDokumenta : null;
    }
    /**
     * Set KategorijaDokumenta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\KategorijaDokumenta $kategorijaDokumenta
     * @return \StructType\DokumentKategorijaDokumenta
     */
    public function setKategorijaDokumenta(\StructType\KategorijaDokumenta $kategorijaDokumenta = null)
    {
        if (is_null($kategorijaDokumenta) || (is_array($kategorijaDokumenta) && empty($kategorijaDokumenta))) {
            unset($this->KategorijaDokumenta);
        } else {
            $this->KategorijaDokumenta = $kategorijaDokumenta;
        }
        return $this;
    }
    /**
     * Get KategorijaDokumentaID value
     * @return int|null
     */
    public function getKategorijaDokumentaID()
    {
        return $this->KategorijaDokumentaID;
    }
    /**
     * Set KategorijaDokumentaID value
     * @param int $kategorijaDokumentaID
     * @return \StructType\DokumentKategorijaDokumenta
     */
    public function setKategorijaDokumentaID($kategorijaDokumentaID = null)
    {
        // validation for constraint: int
        if (!is_null($kategorijaDokumentaID) && !(is_int($kategorijaDokumentaID) || ctype_digit($kategorijaDokumentaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kategorijaDokumentaID, true), gettype($kategorijaDokumentaID)), __LINE__);
        }
        $this->KategorijaDokumentaID = $kategorijaDokumentaID;
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\DokumentKategorijaDokumenta
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\DokumentKategorijaDokumenta
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
}
