<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Storniraj ServiceType
 * @subpackage Services
 */
class Storniraj extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named StornirajPLO
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StornirajPLO $parameters
     * @return \StructType\StornirajPLOResponse|bool
     */
    public function StornirajPLO(\StructType\StornirajPLO $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StornirajPLO($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StornirajTijekOtpada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StornirajTijekOtpada $parameters
     * @return \StructType\StornirajTijekOtpadaResponse|bool
     */
    public function StornirajTijekOtpada(\StructType\StornirajTijekOtpada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StornirajTijekOtpada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named StornirajTijekOtpadaP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\StornirajTijekOtpadaP $parameters
     * @return \StructType\StornirajTijekOtpadaPResponse|bool
     */
    public function StornirajTijekOtpadaP(\StructType\StornirajTijekOtpadaP $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->StornirajTijekOtpadaP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\StornirajPLOResponse|\StructType\StornirajTijekOtpadaPResponse|\StructType\StornirajTijekOtpadaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
