<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPLOResponse ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPLOResponse
 * @subpackage Arrays
 */
class ArrayOfPLOResponse extends AbstractStructArrayBase
{
    /**
     * The PLOResponse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PLOResponse[]
     */
    public $PLOResponse;
    /**
     * Constructor method for ArrayOfPLOResponse
     * @uses ArrayOfPLOResponse::setPLOResponse()
     * @param \StructType\PLOResponse[] $pLOResponse
     */
    public function __construct(array $pLOResponse = array())
    {
        $this
            ->setPLOResponse($pLOResponse);
    }
    /**
     * Get PLOResponse value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PLOResponse[]|null
     */
    public function getPLOResponse()
    {
        return isset($this->PLOResponse) ? $this->PLOResponse : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPLOResponse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPLOResponse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePLOResponseForArrayConstraintsFromSetPLOResponse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPLOResponsePLOResponseItem) {
            // validation for constraint: itemType
            if (!$arrayOfPLOResponsePLOResponseItem instanceof \StructType\PLOResponse) {
                $invalidValues[] = is_object($arrayOfPLOResponsePLOResponseItem) ? get_class($arrayOfPLOResponsePLOResponseItem) : sprintf('%s(%s)', gettype($arrayOfPLOResponsePLOResponseItem), var_export($arrayOfPLOResponsePLOResponseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PLOResponse property can only contain items of type \StructType\PLOResponse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PLOResponse value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PLOResponse[] $pLOResponse
     * @return \ArrayType\ArrayOfPLOResponse
     */
    public function setPLOResponse(array $pLOResponse = array())
    {
        // validation for constraint: array
        if ('' !== ($pLOResponseArrayErrorMessage = self::validatePLOResponseForArrayConstraintsFromSetPLOResponse($pLOResponse))) {
            throw new \InvalidArgumentException($pLOResponseArrayErrorMessage, __LINE__);
        }
        if (is_null($pLOResponse) || (is_array($pLOResponse) && empty($pLOResponse))) {
            unset($this->PLOResponse);
        } else {
            $this->PLOResponse = $pLOResponse;
        }
        return $this;
    }
    /**
     * Add item to PLOResponse value
     * @throws \InvalidArgumentException
     * @param \StructType\PLOResponse $item
     * @return \ArrayType\ArrayOfPLOResponse
     */
    public function addToPLOResponse(\StructType\PLOResponse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PLOResponse) {
            throw new \InvalidArgumentException(sprintf('The PLOResponse property can only contain items of type \StructType\PLOResponse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PLOResponse[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PLOResponse|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PLOResponse|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PLOResponse|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PLOResponse|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PLOResponse|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PLOResponse
     */
    public function getAttributeName()
    {
        return 'PLOResponse';
    }
}
