<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMRD ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMRD
 * @subpackage Arrays
 */
class ArrayOfMRD extends AbstractStructArrayBase
{
    /**
     * The MRD
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MRD[]
     */
    public $MRD;
    /**
     * Constructor method for ArrayOfMRD
     * @uses ArrayOfMRD::setMRD()
     * @param \StructType\MRD[] $mRD
     */
    public function __construct(array $mRD = array())
    {
        $this
            ->setMRD($mRD);
    }
    /**
     * Get MRD value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MRD[]|null
     */
    public function getMRD()
    {
        return isset($this->MRD) ? $this->MRD : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMRD method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMRD method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMRDForArrayConstraintsFromSetMRD(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfMRDMRDItem) {
            // validation for constraint: itemType
            if (!$arrayOfMRDMRDItem instanceof \StructType\MRD) {
                $invalidValues[] = is_object($arrayOfMRDMRDItem) ? get_class($arrayOfMRDMRDItem) : sprintf('%s(%s)', gettype($arrayOfMRDMRDItem), var_export($arrayOfMRDMRDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MRD property can only contain items of type \StructType\MRD, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MRD value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MRD[] $mRD
     * @return \ArrayType\ArrayOfMRD
     */
    public function setMRD(array $mRD = array())
    {
        // validation for constraint: array
        if ('' !== ($mRDArrayErrorMessage = self::validateMRDForArrayConstraintsFromSetMRD($mRD))) {
            throw new \InvalidArgumentException($mRDArrayErrorMessage, __LINE__);
        }
        if (is_null($mRD) || (is_array($mRD) && empty($mRD))) {
            unset($this->MRD);
        } else {
            $this->MRD = $mRD;
        }
        return $this;
    }
    /**
     * Add item to MRD value
     * @throws \InvalidArgumentException
     * @param \StructType\MRD $item
     * @return \ArrayType\ArrayOfMRD
     */
    public function addToMRD(\StructType\MRD $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MRD) {
            throw new \InvalidArgumentException(sprintf('The MRD property can only contain items of type \StructType\MRD, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MRD[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MRD|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MRD|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MRD|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MRD|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MRD|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MRD
     */
    public function getAttributeName()
    {
        return 'MRD';
    }
}
