<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Rola StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Rola
 * @subpackage Structs
 */
class Rola extends AbstractStructBase
{
    /**
     * The DozvolaRolaOIB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDozvolaRolaOIB
     */
    public $DozvolaRolaOIB;
    /**
     * The LokacijaKorisnikRolas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLokacijaKorisnikRola
     */
    public $LokacijaKorisnikRolas;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The RolaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RolaID;
    /**
     * The Zahtjev_Rola
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfZahtjev_Rola
     */
    public $Zahtjev_Rola;
    /**
     * Constructor method for Rola
     * @uses Rola::setDozvolaRolaOIB()
     * @uses Rola::setLokacijaKorisnikRolas()
     * @uses Rola::setNaziv()
     * @uses Rola::setRolaID()
     * @uses Rola::setZahtjev_Rola()
     * @param \ArrayType\ArrayOfDozvolaRolaOIB $dozvolaRolaOIB
     * @param \ArrayType\ArrayOfLokacijaKorisnikRola $lokacijaKorisnikRolas
     * @param string $naziv
     * @param int $rolaID
     * @param \ArrayType\ArrayOfZahtjev_Rola $zahtjev_Rola
     */
    public function __construct(\ArrayType\ArrayOfDozvolaRolaOIB $dozvolaRolaOIB = null, \ArrayType\ArrayOfLokacijaKorisnikRola $lokacijaKorisnikRolas = null, $naziv = null, $rolaID = null, \ArrayType\ArrayOfZahtjev_Rola $zahtjev_Rola = null)
    {
        $this
            ->setDozvolaRolaOIB($dozvolaRolaOIB)
            ->setLokacijaKorisnikRolas($lokacijaKorisnikRolas)
            ->setNaziv($naziv)
            ->setRolaID($rolaID)
            ->setZahtjev_Rola($zahtjev_Rola);
    }
    /**
     * Get DozvolaRolaOIB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDozvolaRolaOIB|null
     */
    public function getDozvolaRolaOIB()
    {
        return isset($this->DozvolaRolaOIB) ? $this->DozvolaRolaOIB : null;
    }
    /**
     * Set DozvolaRolaOIB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDozvolaRolaOIB $dozvolaRolaOIB
     * @return \StructType\Rola
     */
    public function setDozvolaRolaOIB(\ArrayType\ArrayOfDozvolaRolaOIB $dozvolaRolaOIB = null)
    {
        if (is_null($dozvolaRolaOIB) || (is_array($dozvolaRolaOIB) && empty($dozvolaRolaOIB))) {
            unset($this->DozvolaRolaOIB);
        } else {
            $this->DozvolaRolaOIB = $dozvolaRolaOIB;
        }
        return $this;
    }
    /**
     * Get LokacijaKorisnikRolas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLokacijaKorisnikRola|null
     */
    public function getLokacijaKorisnikRolas()
    {
        return isset($this->LokacijaKorisnikRolas) ? $this->LokacijaKorisnikRolas : null;
    }
    /**
     * Set LokacijaKorisnikRolas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLokacijaKorisnikRola $lokacijaKorisnikRolas
     * @return \StructType\Rola
     */
    public function setLokacijaKorisnikRolas(\ArrayType\ArrayOfLokacijaKorisnikRola $lokacijaKorisnikRolas = null)
    {
        if (is_null($lokacijaKorisnikRolas) || (is_array($lokacijaKorisnikRolas) && empty($lokacijaKorisnikRolas))) {
            unset($this->LokacijaKorisnikRolas);
        } else {
            $this->LokacijaKorisnikRolas = $lokacijaKorisnikRolas;
        }
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\Rola
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get RolaID value
     * @return int|null
     */
    public function getRolaID()
    {
        return $this->RolaID;
    }
    /**
     * Set RolaID value
     * @param int $rolaID
     * @return \StructType\Rola
     */
    public function setRolaID($rolaID = null)
    {
        // validation for constraint: int
        if (!is_null($rolaID) && !(is_int($rolaID) || ctype_digit($rolaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rolaID, true), gettype($rolaID)), __LINE__);
        }
        $this->RolaID = $rolaID;
        return $this;
    }
    /**
     * Get Zahtjev_Rola value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfZahtjev_Rola|null
     */
    public function getZahtjev_Rola()
    {
        return isset($this->Zahtjev_Rola) ? $this->Zahtjev_Rola : null;
    }
    /**
     * Set Zahtjev_Rola value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfZahtjev_Rola $zahtjev_Rola
     * @return \StructType\Rola
     */
    public function setZahtjev_Rola(\ArrayType\ArrayOfZahtjev_Rola $zahtjev_Rola = null)
    {
        if (is_null($zahtjev_Rola) || (is_array($zahtjev_Rola) && empty($zahtjev_Rola))) {
            unset($this->Zahtjev_Rola);
        } else {
            $this->Zahtjev_Rola = $zahtjev_Rola;
        }
        return $this;
    }
}
