<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ROOExport StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ROOExport
 * @subpackage Structs
 */
class ROOExport extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Aktivan;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The LokacijaROOExports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLokacijaROOExport
     */
    public $LokacijaROOExports;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The OznakaNacinaROOExports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOznakaNacinaROOExport
     */
    public $OznakaNacinaROOExports;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * The ROOExportID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ROOExportID;
    /**
     * The ROOExportVrstaDjelatnostiZaROOs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfROOExportVrstaDjelatnostiZaROO
     */
    public $ROOExportVrstaDjelatnostiZaROOs;
    /**
     * The VrstaOznakePosiljkeROOExports
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfVrstaOznakePosiljkeROOExport
     */
    public $VrstaOznakePosiljkeROOExports;
    /**
     * Constructor method for ROOExport
     * @uses ROOExport::setAktivan()
     * @uses ROOExport::setDatumKreiranja()
     * @uses ROOExport::setDatumPromjene()
     * @uses ROOExport::setKreirao()
     * @uses ROOExport::setLokacijaROOExports()
     * @uses ROOExport::setNaziv()
     * @uses ROOExport::setOznakaNacinaROOExports()
     * @uses ROOExport::setPromijenio()
     * @uses ROOExport::setROOExportID()
     * @uses ROOExport::setROOExportVrstaDjelatnostiZaROOs()
     * @uses ROOExport::setVrstaOznakePosiljkeROOExports()
     * @param bool $aktivan
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param string $kreirao
     * @param \ArrayType\ArrayOfLokacijaROOExport $lokacijaROOExports
     * @param string $naziv
     * @param \ArrayType\ArrayOfOznakaNacinaROOExport $oznakaNacinaROOExports
     * @param string $promijenio
     * @param int $rOOExportID
     * @param \ArrayType\ArrayOfROOExportVrstaDjelatnostiZaROO $rOOExportVrstaDjelatnostiZaROOs
     * @param \ArrayType\ArrayOfVrstaOznakePosiljkeROOExport $vrstaOznakePosiljkeROOExports
     */
    public function __construct($aktivan = null, $datumKreiranja = null, $datumPromjene = null, $kreirao = null, \ArrayType\ArrayOfLokacijaROOExport $lokacijaROOExports = null, $naziv = null, \ArrayType\ArrayOfOznakaNacinaROOExport $oznakaNacinaROOExports = null, $promijenio = null, $rOOExportID = null, \ArrayType\ArrayOfROOExportVrstaDjelatnostiZaROO $rOOExportVrstaDjelatnostiZaROOs = null, \ArrayType\ArrayOfVrstaOznakePosiljkeROOExport $vrstaOznakePosiljkeROOExports = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setKreirao($kreirao)
            ->setLokacijaROOExports($lokacijaROOExports)
            ->setNaziv($naziv)
            ->setOznakaNacinaROOExports($oznakaNacinaROOExports)
            ->setPromijenio($promijenio)
            ->setROOExportID($rOOExportID)
            ->setROOExportVrstaDjelatnostiZaROOs($rOOExportVrstaDjelatnostiZaROOs)
            ->setVrstaOznakePosiljkeROOExports($vrstaOznakePosiljkeROOExports);
    }
    /**
     * Get Aktivan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAktivan()
    {
        return isset($this->Aktivan) ? $this->Aktivan : null;
    }
    /**
     * Set Aktivan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $aktivan
     * @return \StructType\ROOExport
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        if (is_null($aktivan) || (is_array($aktivan) && empty($aktivan))) {
            unset($this->Aktivan);
        } else {
            $this->Aktivan = $aktivan;
        }
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\ROOExport
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\ROOExport
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\ROOExport
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get LokacijaROOExports value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLokacijaROOExport|null
     */
    public function getLokacijaROOExports()
    {
        return isset($this->LokacijaROOExports) ? $this->LokacijaROOExports : null;
    }
    /**
     * Set LokacijaROOExports value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLokacijaROOExport $lokacijaROOExports
     * @return \StructType\ROOExport
     */
    public function setLokacijaROOExports(\ArrayType\ArrayOfLokacijaROOExport $lokacijaROOExports = null)
    {
        if (is_null($lokacijaROOExports) || (is_array($lokacijaROOExports) && empty($lokacijaROOExports))) {
            unset($this->LokacijaROOExports);
        } else {
            $this->LokacijaROOExports = $lokacijaROOExports;
        }
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\ROOExport
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get OznakaNacinaROOExports value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOznakaNacinaROOExport|null
     */
    public function getOznakaNacinaROOExports()
    {
        return isset($this->OznakaNacinaROOExports) ? $this->OznakaNacinaROOExports : null;
    }
    /**
     * Set OznakaNacinaROOExports value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOznakaNacinaROOExport $oznakaNacinaROOExports
     * @return \StructType\ROOExport
     */
    public function setOznakaNacinaROOExports(\ArrayType\ArrayOfOznakaNacinaROOExport $oznakaNacinaROOExports = null)
    {
        if (is_null($oznakaNacinaROOExports) || (is_array($oznakaNacinaROOExports) && empty($oznakaNacinaROOExports))) {
            unset($this->OznakaNacinaROOExports);
        } else {
            $this->OznakaNacinaROOExports = $oznakaNacinaROOExports;
        }
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\ROOExport
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
    /**
     * Get ROOExportID value
     * @return int|null
     */
    public function getROOExportID()
    {
        return $this->ROOExportID;
    }
    /**
     * Set ROOExportID value
     * @param int $rOOExportID
     * @return \StructType\ROOExport
     */
    public function setROOExportID($rOOExportID = null)
    {
        // validation for constraint: int
        if (!is_null($rOOExportID) && !(is_int($rOOExportID) || ctype_digit($rOOExportID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rOOExportID, true), gettype($rOOExportID)), __LINE__);
        }
        $this->ROOExportID = $rOOExportID;
        return $this;
    }
    /**
     * Get ROOExportVrstaDjelatnostiZaROOs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfROOExportVrstaDjelatnostiZaROO|null
     */
    public function getROOExportVrstaDjelatnostiZaROOs()
    {
        return isset($this->ROOExportVrstaDjelatnostiZaROOs) ? $this->ROOExportVrstaDjelatnostiZaROOs : null;
    }
    /**
     * Set ROOExportVrstaDjelatnostiZaROOs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfROOExportVrstaDjelatnostiZaROO $rOOExportVrstaDjelatnostiZaROOs
     * @return \StructType\ROOExport
     */
    public function setROOExportVrstaDjelatnostiZaROOs(\ArrayType\ArrayOfROOExportVrstaDjelatnostiZaROO $rOOExportVrstaDjelatnostiZaROOs = null)
    {
        if (is_null($rOOExportVrstaDjelatnostiZaROOs) || (is_array($rOOExportVrstaDjelatnostiZaROOs) && empty($rOOExportVrstaDjelatnostiZaROOs))) {
            unset($this->ROOExportVrstaDjelatnostiZaROOs);
        } else {
            $this->ROOExportVrstaDjelatnostiZaROOs = $rOOExportVrstaDjelatnostiZaROOs;
        }
        return $this;
    }
    /**
     * Get VrstaOznakePosiljkeROOExports value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfVrstaOznakePosiljkeROOExport|null
     */
    public function getVrstaOznakePosiljkeROOExports()
    {
        return isset($this->VrstaOznakePosiljkeROOExports) ? $this->VrstaOznakePosiljkeROOExports : null;
    }
    /**
     * Set VrstaOznakePosiljkeROOExports value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfVrstaOznakePosiljkeROOExport $vrstaOznakePosiljkeROOExports
     * @return \StructType\ROOExport
     */
    public function setVrstaOznakePosiljkeROOExports(\ArrayType\ArrayOfVrstaOznakePosiljkeROOExport $vrstaOznakePosiljkeROOExports = null)
    {
        if (is_null($vrstaOznakePosiljkeROOExports) || (is_array($vrstaOznakePosiljkeROOExports) && empty($vrstaOznakePosiljkeROOExports))) {
            unset($this->VrstaOznakePosiljkeROOExports);
        } else {
            $this->VrstaOznakePosiljkeROOExports = $vrstaOznakePosiljkeROOExports;
        }
        return $this;
    }
}
