<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MRD StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MRD
 * @subpackage Structs
 */
class MRD extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The MRDLokacijas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfMRDLokacija
     */
    public $MRDLokacijas;
    /**
     * The OznakaMRD
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OznakaMRD;
    /**
     * The PFOOsoba
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PFOOsoba
     */
    public $PFOOsoba;
    /**
     * The PFOOsobaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PFOOsobaId;
    /**
     * The PrateciLists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPrateciList
     */
    public $PrateciLists;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * The TijekOtpadaPs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTijekOtpadaP
     */
    public $TijekOtpadaPs;
    /**
     * The TijekOtpadas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTijekOtpada
     */
    public $TijekOtpadas;
    /**
     * Constructor method for MRD
     * @uses MRD::setAktivan()
     * @uses MRD::setDatumKreiranja()
     * @uses MRD::setDatumPromjene()
     * @uses MRD::setId()
     * @uses MRD::setKreirao()
     * @uses MRD::setMRDLokacijas()
     * @uses MRD::setOznakaMRD()
     * @uses MRD::setPFOOsoba()
     * @uses MRD::setPFOOsobaId()
     * @uses MRD::setPrateciLists()
     * @uses MRD::setPromijenio()
     * @uses MRD::setTijekOtpadaPs()
     * @uses MRD::setTijekOtpadas()
     * @param bool $aktivan
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param int $id
     * @param string $kreirao
     * @param \ArrayType\ArrayOfMRDLokacija $mRDLokacijas
     * @param string $oznakaMRD
     * @param \StructType\PFOOsoba $pFOOsoba
     * @param int $pFOOsobaId
     * @param \ArrayType\ArrayOfPrateciList $prateciLists
     * @param string $promijenio
     * @param \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs
     * @param \ArrayType\ArrayOfTijekOtpada $tijekOtpadas
     */
    public function __construct($aktivan = null, $datumKreiranja = null, $datumPromjene = null, $id = null, $kreirao = null, \ArrayType\ArrayOfMRDLokacija $mRDLokacijas = null, $oznakaMRD = null, \StructType\PFOOsoba $pFOOsoba = null, $pFOOsobaId = null, \ArrayType\ArrayOfPrateciList $prateciLists = null, $promijenio = null, \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs = null, \ArrayType\ArrayOfTijekOtpada $tijekOtpadas = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setId($id)
            ->setKreirao($kreirao)
            ->setMRDLokacijas($mRDLokacijas)
            ->setOznakaMRD($oznakaMRD)
            ->setPFOOsoba($pFOOsoba)
            ->setPFOOsobaId($pFOOsobaId)
            ->setPrateciLists($prateciLists)
            ->setPromijenio($promijenio)
            ->setTijekOtpadaPs($tijekOtpadaPs)
            ->setTijekOtpadas($tijekOtpadas);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\MRD
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\MRD
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\MRD
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\MRD
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\MRD
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get MRDLokacijas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfMRDLokacija|null
     */
    public function getMRDLokacijas()
    {
        return isset($this->MRDLokacijas) ? $this->MRDLokacijas : null;
    }
    /**
     * Set MRDLokacijas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfMRDLokacija $mRDLokacijas
     * @return \StructType\MRD
     */
    public function setMRDLokacijas(\ArrayType\ArrayOfMRDLokacija $mRDLokacijas = null)
    {
        if (is_null($mRDLokacijas) || (is_array($mRDLokacijas) && empty($mRDLokacijas))) {
            unset($this->MRDLokacijas);
        } else {
            $this->MRDLokacijas = $mRDLokacijas;
        }
        return $this;
    }
    /**
     * Get OznakaMRD value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOznakaMRD()
    {
        return isset($this->OznakaMRD) ? $this->OznakaMRD : null;
    }
    /**
     * Set OznakaMRD value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oznakaMRD
     * @return \StructType\MRD
     */
    public function setOznakaMRD($oznakaMRD = null)
    {
        // validation for constraint: string
        if (!is_null($oznakaMRD) && !is_string($oznakaMRD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oznakaMRD, true), gettype($oznakaMRD)), __LINE__);
        }
        if (is_null($oznakaMRD) || (is_array($oznakaMRD) && empty($oznakaMRD))) {
            unset($this->OznakaMRD);
        } else {
            $this->OznakaMRD = $oznakaMRD;
        }
        return $this;
    }
    /**
     * Get PFOOsoba value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PFOOsoba|null
     */
    public function getPFOOsoba()
    {
        return isset($this->PFOOsoba) ? $this->PFOOsoba : null;
    }
    /**
     * Set PFOOsoba value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PFOOsoba $pFOOsoba
     * @return \StructType\MRD
     */
    public function setPFOOsoba(\StructType\PFOOsoba $pFOOsoba = null)
    {
        if (is_null($pFOOsoba) || (is_array($pFOOsoba) && empty($pFOOsoba))) {
            unset($this->PFOOsoba);
        } else {
            $this->PFOOsoba = $pFOOsoba;
        }
        return $this;
    }
    /**
     * Get PFOOsobaId value
     * @return int|null
     */
    public function getPFOOsobaId()
    {
        return $this->PFOOsobaId;
    }
    /**
     * Set PFOOsobaId value
     * @param int $pFOOsobaId
     * @return \StructType\MRD
     */
    public function setPFOOsobaId($pFOOsobaId = null)
    {
        // validation for constraint: int
        if (!is_null($pFOOsobaId) && !(is_int($pFOOsobaId) || ctype_digit($pFOOsobaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pFOOsobaId, true), gettype($pFOOsobaId)), __LINE__);
        }
        $this->PFOOsobaId = $pFOOsobaId;
        return $this;
    }
    /**
     * Get PrateciLists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPrateciList|null
     */
    public function getPrateciLists()
    {
        return isset($this->PrateciLists) ? $this->PrateciLists : null;
    }
    /**
     * Set PrateciLists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPrateciList $prateciLists
     * @return \StructType\MRD
     */
    public function setPrateciLists(\ArrayType\ArrayOfPrateciList $prateciLists = null)
    {
        if (is_null($prateciLists) || (is_array($prateciLists) && empty($prateciLists))) {
            unset($this->PrateciLists);
        } else {
            $this->PrateciLists = $prateciLists;
        }
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\MRD
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
    /**
     * Get TijekOtpadaPs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTijekOtpadaP|null
     */
    public function getTijekOtpadaPs()
    {
        return isset($this->TijekOtpadaPs) ? $this->TijekOtpadaPs : null;
    }
    /**
     * Set TijekOtpadaPs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs
     * @return \StructType\MRD
     */
    public function setTijekOtpadaPs(\ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs = null)
    {
        if (is_null($tijekOtpadaPs) || (is_array($tijekOtpadaPs) && empty($tijekOtpadaPs))) {
            unset($this->TijekOtpadaPs);
        } else {
            $this->TijekOtpadaPs = $tijekOtpadaPs;
        }
        return $this;
    }
    /**
     * Get TijekOtpadas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTijekOtpada|null
     */
    public function getTijekOtpadas()
    {
        return isset($this->TijekOtpadas) ? $this->TijekOtpadas : null;
    }
    /**
     * Set TijekOtpadas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTijekOtpada $tijekOtpadas
     * @return \StructType\MRD
     */
    public function setTijekOtpadas(\ArrayType\ArrayOfTijekOtpada $tijekOtpadas = null)
    {
        if (is_null($tijekOtpadas) || (is_array($tijekOtpadas) && empty($tijekOtpadas))) {
            unset($this->TijekOtpadas);
        } else {
            $this->TijekOtpadas = $tijekOtpadas;
        }
        return $this;
    }
}
