<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Zatvori ServiceType
 * @subpackage Services
 */
class Zatvori extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ZatvoriOnto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZatvoriOnto $parameters
     * @return \StructType\ZatvoriOntoResponse|bool
     */
    public function ZatvoriOnto(\StructType\ZatvoriOnto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ZatvoriOnto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ZatvoriOntoCollection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZatvoriOntoCollection $parameters
     * @return \StructType\ZatvoriOntoCollectionResponse|bool
     */
    public function ZatvoriOntoCollection(\StructType\ZatvoriOntoCollection $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ZatvoriOntoCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ZatvoriOntoP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZatvoriOntoP $parameters
     * @return \StructType\ZatvoriOntoPResponse|bool
     */
    public function ZatvoriOntoP(\StructType\ZatvoriOntoP $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ZatvoriOntoP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ZatvoriOntoPCollection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZatvoriOntoPCollection $parameters
     * @return \StructType\ZatvoriOntoPCollectionResponse|bool
     */
    public function ZatvoriOntoPCollection(\StructType\ZatvoriOntoPCollection $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ZatvoriOntoPCollection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ZatvoriOntoCollectionResponse|\StructType\ZatvoriOntoPCollectionResponse|\StructType\ZatvoriOntoPResponse|\StructType\ZatvoriOntoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
