<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetCustomIDPredavatelja
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomIDPredavatelja $parameters
     * @return \StructType\SetCustomIDPredavateljaResponse|bool
     */
    public function SetCustomIDPredavatelja(\StructType\SetCustomIDPredavatelja $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCustomIDPredavatelja($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCustomIDPrijevoznika
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomIDPrijevoznika $parameters
     * @return \StructType\SetCustomIDPrijevoznikaResponse|bool
     */
    public function SetCustomIDPrijevoznika(\StructType\SetCustomIDPrijevoznika $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCustomIDPrijevoznika($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SetCustomIDPreuzimatelja
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SetCustomIDPreuzimatelja $parameters
     * @return \StructType\SetCustomIDPreuzimateljaResponse|bool
     */
    public function SetCustomIDPreuzimatelja(\StructType\SetCustomIDPreuzimatelja $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetCustomIDPreuzimatelja($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SetCustomIDPredavateljaResponse|\StructType\SetCustomIDPreuzimateljaResponse|\StructType\SetCustomIDPrijevoznikaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
