<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SUMPSadrziOIB StructType
 * @subpackage Structs
 */
class SUMPSadrziOIB extends AbstractStructBase
{
    /**
     * The OIB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OIB;
    /**
     * Constructor method for SUMPSadrziOIB
     * @uses SUMPSadrziOIB::setOIB()
     * @param string $oIB
     */
    public function __construct($oIB = null)
    {
        $this
            ->setOIB($oIB);
    }
    /**
     * Get OIB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOIB()
    {
        return isset($this->OIB) ? $this->OIB : null;
    }
    /**
     * Set OIB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oIB
     * @return \StructType\SUMPSadrziOIB
     */
    public function setOIB($oIB = null)
    {
        // validation for constraint: string
        if (!is_null($oIB) && !is_string($oIB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oIB, true), gettype($oIB)), __LINE__);
        }
        if (is_null($oIB) || (is_array($oIB) && empty($oIB))) {
            unset($this->OIB);
        } else {
            $this->OIB = $oIB;
        }
        return $this;
    }
}
