<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PretraziOntoCount StructType
 * @subpackage Structs
 */
class PretraziOntoCount extends AbstractStructBase
{
    /**
     * The ontoPretragaInput
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OntoPretragaInput
     */
    public $ontoPretragaInput;
    /**
     * The lokacijaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $lokacijaID;
    /**
     * The username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $username;
    /**
     * The securityToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $securityToken;
    /**
     * Constructor method for PretraziOntoCount
     * @uses PretraziOntoCount::setOntoPretragaInput()
     * @uses PretraziOntoCount::setLokacijaID()
     * @uses PretraziOntoCount::setUsername()
     * @uses PretraziOntoCount::setSecurityToken()
     * @param \StructType\OntoPretragaInput $ontoPretragaInput
     * @param int $lokacijaID
     * @param string $username
     * @param string $securityToken
     */
    public function __construct(\StructType\OntoPretragaInput $ontoPretragaInput = null, $lokacijaID = null, $username = null, $securityToken = null)
    {
        $this
            ->setOntoPretragaInput($ontoPretragaInput)
            ->setLokacijaID($lokacijaID)
            ->setUsername($username)
            ->setSecurityToken($securityToken);
    }
    /**
     * Get ontoPretragaInput value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OntoPretragaInput|null
     */
    public function getOntoPretragaInput()
    {
        return isset($this->ontoPretragaInput) ? $this->ontoPretragaInput : null;
    }
    /**
     * Set ontoPretragaInput value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OntoPretragaInput $ontoPretragaInput
     * @return \StructType\PretraziOntoCount
     */
    public function setOntoPretragaInput(\StructType\OntoPretragaInput $ontoPretragaInput = null)
    {
        if (is_null($ontoPretragaInput) || (is_array($ontoPretragaInput) && empty($ontoPretragaInput))) {
            unset($this->ontoPretragaInput);
        } else {
            $this->ontoPretragaInput = $ontoPretragaInput;
        }
        return $this;
    }
    /**
     * Get lokacijaID value
     * @return int|null
     */
    public function getLokacijaID()
    {
        return $this->lokacijaID;
    }
    /**
     * Set lokacijaID value
     * @param int $lokacijaID
     * @return \StructType\PretraziOntoCount
     */
    public function setLokacijaID($lokacijaID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaID) && !(is_int($lokacijaID) || ctype_digit($lokacijaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaID, true), gettype($lokacijaID)), __LINE__);
        }
        $this->lokacijaID = $lokacijaID;
        return $this;
    }
    /**
     * Get username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->username) ? $this->username : null;
    }
    /**
     * Set username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\PretraziOntoCount
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->username);
        } else {
            $this->username = $username;
        }
        return $this;
    }
    /**
     * Get securityToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityToken()
    {
        return isset($this->securityToken) ? $this->securityToken : null;
    }
    /**
     * Set securityToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityToken
     * @return \StructType\PretraziOntoCount
     */
    public function setSecurityToken($securityToken = null)
    {
        // validation for constraint: string
        if (!is_null($securityToken) && !is_string($securityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityToken, true), gettype($securityToken)), __LINE__);
        }
        if (is_null($securityToken) || (is_array($securityToken) && empty($securityToken))) {
            unset($this->securityToken);
        } else {
            $this->securityToken = $securityToken;
        }
        return $this;
    }
}
