<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PLPravilnik StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PLPravilnik
 * @subpackage Structs
 */
class PLPravilnik extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumPromjene;
    /**
     * The Korisnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Korisnik
     */
    public $Korisnik;
    /**
     * The KorisnikId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KorisnikId;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The Opis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Opis;
    /**
     * The PLPravilnikID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PLPravilnikID;
    /**
     * The PrateciLists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPrateciList
     */
    public $PrateciLists;
    /**
     * Constructor method for PLPravilnik
     * @uses PLPravilnik::setAktivan()
     * @uses PLPravilnik::setDatumKreiranja()
     * @uses PLPravilnik::setDatumPromjene()
     * @uses PLPravilnik::setKorisnik()
     * @uses PLPravilnik::setKorisnikId()
     * @uses PLPravilnik::setNaziv()
     * @uses PLPravilnik::setOpis()
     * @uses PLPravilnik::setPLPravilnikID()
     * @uses PLPravilnik::setPrateciLists()
     * @param bool $aktivan
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param \StructType\Korisnik $korisnik
     * @param int $korisnikId
     * @param string $naziv
     * @param string $opis
     * @param int $pLPravilnikID
     * @param \ArrayType\ArrayOfPrateciList $prateciLists
     */
    public function __construct($aktivan = null, $datumKreiranja = null, $datumPromjene = null, \StructType\Korisnik $korisnik = null, $korisnikId = null, $naziv = null, $opis = null, $pLPravilnikID = null, \ArrayType\ArrayOfPrateciList $prateciLists = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setKorisnik($korisnik)
            ->setKorisnikId($korisnikId)
            ->setNaziv($naziv)
            ->setOpis($opis)
            ->setPLPravilnikID($pLPravilnikID)
            ->setPrateciLists($prateciLists);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\PLPravilnik
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\PLPravilnik
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return isset($this->DatumPromjene) ? $this->DatumPromjene : null;
    }
    /**
     * Set DatumPromjene value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumPromjene
     * @return \StructType\PLPravilnik
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        if (is_null($datumPromjene) || (is_array($datumPromjene) && empty($datumPromjene))) {
            unset($this->DatumPromjene);
        } else {
            $this->DatumPromjene = $datumPromjene;
        }
        return $this;
    }
    /**
     * Get Korisnik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Korisnik|null
     */
    public function getKorisnik()
    {
        return isset($this->Korisnik) ? $this->Korisnik : null;
    }
    /**
     * Set Korisnik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Korisnik $korisnik
     * @return \StructType\PLPravilnik
     */
    public function setKorisnik(\StructType\Korisnik $korisnik = null)
    {
        if (is_null($korisnik) || (is_array($korisnik) && empty($korisnik))) {
            unset($this->Korisnik);
        } else {
            $this->Korisnik = $korisnik;
        }
        return $this;
    }
    /**
     * Get KorisnikId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKorisnikId()
    {
        return isset($this->KorisnikId) ? $this->KorisnikId : null;
    }
    /**
     * Set KorisnikId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $korisnikId
     * @return \StructType\PLPravilnik
     */
    public function setKorisnikId($korisnikId = null)
    {
        // validation for constraint: int
        if (!is_null($korisnikId) && !(is_int($korisnikId) || ctype_digit($korisnikId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($korisnikId, true), gettype($korisnikId)), __LINE__);
        }
        if (is_null($korisnikId) || (is_array($korisnikId) && empty($korisnikId))) {
            unset($this->KorisnikId);
        } else {
            $this->KorisnikId = $korisnikId;
        }
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\PLPravilnik
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get Opis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpis()
    {
        return isset($this->Opis) ? $this->Opis : null;
    }
    /**
     * Set Opis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opis
     * @return \StructType\PLPravilnik
     */
    public function setOpis($opis = null)
    {
        // validation for constraint: string
        if (!is_null($opis) && !is_string($opis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opis, true), gettype($opis)), __LINE__);
        }
        if (is_null($opis) || (is_array($opis) && empty($opis))) {
            unset($this->Opis);
        } else {
            $this->Opis = $opis;
        }
        return $this;
    }
    /**
     * Get PLPravilnikID value
     * @return int|null
     */
    public function getPLPravilnikID()
    {
        return $this->PLPravilnikID;
    }
    /**
     * Set PLPravilnikID value
     * @param int $pLPravilnikID
     * @return \StructType\PLPravilnik
     */
    public function setPLPravilnikID($pLPravilnikID = null)
    {
        // validation for constraint: int
        if (!is_null($pLPravilnikID) && !(is_int($pLPravilnikID) || ctype_digit($pLPravilnikID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pLPravilnikID, true), gettype($pLPravilnikID)), __LINE__);
        }
        $this->PLPravilnikID = $pLPravilnikID;
        return $this;
    }
    /**
     * Get PrateciLists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPrateciList|null
     */
    public function getPrateciLists()
    {
        return isset($this->PrateciLists) ? $this->PrateciLists : null;
    }
    /**
     * Set PrateciLists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPrateciList $prateciLists
     * @return \StructType\PLPravilnik
     */
    public function setPrateciLists(\ArrayType\ArrayOfPrateciList $prateciLists = null)
    {
        if (is_null($prateciLists) || (is_array($prateciLists) && empty($prateciLists))) {
            unset($this->PrateciLists);
        } else {
            $this->PrateciLists = $prateciLists;
        }
        return $this;
    }
}
