<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OznakaPosiljke StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OznakaPosiljke
 * @subpackage Structs
 */
class OznakaPosiljke extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The DopustenaDodatnaOznaka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DopustenaDodatnaOznaka;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The NazivSifre
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NazivSifre;
    /**
     * The OznakaPosiljkeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OznakaPosiljkeID;
    /**
     * The Sifra
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sifra;
    /**
     * The Tip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Tip;
    /**
     * Constructor method for OznakaPosiljke
     * @uses OznakaPosiljke::setAktivan()
     * @uses OznakaPosiljke::setDopustenaDodatnaOznaka()
     * @uses OznakaPosiljke::setNaziv()
     * @uses OznakaPosiljke::setNazivSifre()
     * @uses OznakaPosiljke::setOznakaPosiljkeID()
     * @uses OznakaPosiljke::setSifra()
     * @uses OznakaPosiljke::setTip()
     * @param bool $aktivan
     * @param bool $dopustenaDodatnaOznaka
     * @param string $naziv
     * @param string $nazivSifre
     * @param int $oznakaPosiljkeID
     * @param string $sifra
     * @param int $tip
     */
    public function __construct($aktivan = null, $dopustenaDodatnaOznaka = null, $naziv = null, $nazivSifre = null, $oznakaPosiljkeID = null, $sifra = null, $tip = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setDopustenaDodatnaOznaka($dopustenaDodatnaOznaka)
            ->setNaziv($naziv)
            ->setNazivSifre($nazivSifre)
            ->setOznakaPosiljkeID($oznakaPosiljkeID)
            ->setSifra($sifra)
            ->setTip($tip);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\OznakaPosiljke
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get DopustenaDodatnaOznaka value
     * @return bool|null
     */
    public function getDopustenaDodatnaOznaka()
    {
        return $this->DopustenaDodatnaOznaka;
    }
    /**
     * Set DopustenaDodatnaOznaka value
     * @param bool $dopustenaDodatnaOznaka
     * @return \StructType\OznakaPosiljke
     */
    public function setDopustenaDodatnaOznaka($dopustenaDodatnaOznaka = null)
    {
        // validation for constraint: boolean
        if (!is_null($dopustenaDodatnaOznaka) && !is_bool($dopustenaDodatnaOznaka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dopustenaDodatnaOznaka, true), gettype($dopustenaDodatnaOznaka)), __LINE__);
        }
        $this->DopustenaDodatnaOznaka = $dopustenaDodatnaOznaka;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\OznakaPosiljke
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get NazivSifre value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNazivSifre()
    {
        return isset($this->NazivSifre) ? $this->NazivSifre : null;
    }
    /**
     * Set NazivSifre value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nazivSifre
     * @return \StructType\OznakaPosiljke
     */
    public function setNazivSifre($nazivSifre = null)
    {
        // validation for constraint: string
        if (!is_null($nazivSifre) && !is_string($nazivSifre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivSifre, true), gettype($nazivSifre)), __LINE__);
        }
        if (is_null($nazivSifre) || (is_array($nazivSifre) && empty($nazivSifre))) {
            unset($this->NazivSifre);
        } else {
            $this->NazivSifre = $nazivSifre;
        }
        return $this;
    }
    /**
     * Get OznakaPosiljkeID value
     * @return int|null
     */
    public function getOznakaPosiljkeID()
    {
        return $this->OznakaPosiljkeID;
    }
    /**
     * Set OznakaPosiljkeID value
     * @param int $oznakaPosiljkeID
     * @return \StructType\OznakaPosiljke
     */
    public function setOznakaPosiljkeID($oznakaPosiljkeID = null)
    {
        // validation for constraint: int
        if (!is_null($oznakaPosiljkeID) && !(is_int($oznakaPosiljkeID) || ctype_digit($oznakaPosiljkeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oznakaPosiljkeID, true), gettype($oznakaPosiljkeID)), __LINE__);
        }
        $this->OznakaPosiljkeID = $oznakaPosiljkeID;
        return $this;
    }
    /**
     * Get Sifra value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSifra()
    {
        return isset($this->Sifra) ? $this->Sifra : null;
    }
    /**
     * Set Sifra value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sifra
     * @return \StructType\OznakaPosiljke
     */
    public function setSifra($sifra = null)
    {
        // validation for constraint: string
        if (!is_null($sifra) && !is_string($sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifra, true), gettype($sifra)), __LINE__);
        }
        if (is_null($sifra) || (is_array($sifra) && empty($sifra))) {
            unset($this->Sifra);
        } else {
            $this->Sifra = $sifra;
        }
        return $this;
    }
    /**
     * Get Tip value
     * @return int|null
     */
    public function getTip()
    {
        return $this->Tip;
    }
    /**
     * Set Tip value
     * @param int $tip
     * @return \StructType\OznakaPosiljke
     */
    public function setTip($tip = null)
    {
        // validation for constraint: int
        if (!is_null($tip) && !(is_int($tip) || ctype_digit($tip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tip, true), gettype($tip)), __LINE__);
        }
        $this->Tip = $tip;
        return $this;
    }
}
