<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MRDOznaka StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MRDOznaka
 * @subpackage Structs
 */
class MRDOznaka extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The LokacijaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LokacijaId;
    /**
     * The Oznaka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Oznaka;
    /**
     * Constructor method for MRDOznaka
     * @uses MRDOznaka::setAktivan()
     * @uses MRDOznaka::setId()
     * @uses MRDOznaka::setLokacijaId()
     * @uses MRDOznaka::setOznaka()
     * @param bool $aktivan
     * @param int $id
     * @param int $lokacijaId
     * @param string $oznaka
     */
    public function __construct($aktivan = null, $id = null, $lokacijaId = null, $oznaka = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setId($id)
            ->setLokacijaId($lokacijaId)
            ->setOznaka($oznaka);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\MRDOznaka
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\MRDOznaka
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get LokacijaId value
     * @return int|null
     */
    public function getLokacijaId()
    {
        return $this->LokacijaId;
    }
    /**
     * Set LokacijaId value
     * @param int $lokacijaId
     * @return \StructType\MRDOznaka
     */
    public function setLokacijaId($lokacijaId = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaId) && !(is_int($lokacijaId) || ctype_digit($lokacijaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaId, true), gettype($lokacijaId)), __LINE__);
        }
        $this->LokacijaId = $lokacijaId;
        return $this;
    }
    /**
     * Get Oznaka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOznaka()
    {
        return isset($this->Oznaka) ? $this->Oznaka : null;
    }
    /**
     * Set Oznaka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oznaka
     * @return \StructType\MRDOznaka
     */
    public function setOznaka($oznaka = null)
    {
        // validation for constraint: string
        if (!is_null($oznaka) && !is_string($oznaka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oznaka, true), gettype($oznaka)), __LINE__);
        }
        if (is_null($oznaka) || (is_array($oznaka) && empty($oznaka))) {
            unset($this->Oznaka);
        } else {
            $this->Oznaka = $oznaka;
        }
        return $this;
    }
}
