<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuditAkcija StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AuditAkcija
 * @subpackage Structs
 */
class AuditAkcija extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The UMAudit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfUMAudit
     */
    public $UMAudit;
    /**
     * The Visible
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Visible;
    /**
     * Constructor method for AuditAkcija
     * @uses AuditAkcija::setId()
     * @uses AuditAkcija::setNaziv()
     * @uses AuditAkcija::setUMAudit()
     * @uses AuditAkcija::setVisible()
     * @param int $id
     * @param string $naziv
     * @param \ArrayType\ArrayOfUMAudit $uMAudit
     * @param bool $visible
     */
    public function __construct($id = null, $naziv = null, \ArrayType\ArrayOfUMAudit $uMAudit = null, $visible = null)
    {
        $this
            ->setId($id)
            ->setNaziv($naziv)
            ->setUMAudit($uMAudit)
            ->setVisible($visible);
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\AuditAkcija
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\AuditAkcija
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get UMAudit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfUMAudit|null
     */
    public function getUMAudit()
    {
        return isset($this->UMAudit) ? $this->UMAudit : null;
    }
    /**
     * Set UMAudit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfUMAudit $uMAudit
     * @return \StructType\AuditAkcija
     */
    public function setUMAudit(\ArrayType\ArrayOfUMAudit $uMAudit = null)
    {
        if (is_null($uMAudit) || (is_array($uMAudit) && empty($uMAudit))) {
            unset($this->UMAudit);
        } else {
            $this->UMAudit = $uMAudit;
        }
        return $this;
    }
    /**
     * Get Visible value
     * @return bool|null
     */
    public function getVisible()
    {
        return $this->Visible;
    }
    /**
     * Set Visible value
     * @param bool $visible
     * @return \StructType\AuditAkcija
     */
    public function setVisible($visible = null)
    {
        // validation for constraint: boolean
        if (!is_null($visible) && !is_bool($visible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visible, true), gettype($visible)), __LINE__);
        }
        $this->Visible = $visible;
        return $this;
    }
}
