<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPrivitak ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPrivitak
 * @subpackage Arrays
 */
class ArrayOfPrivitak extends AbstractStructArrayBase
{
    /**
     * The Privitak
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Privitak[]
     */
    public $Privitak;
    /**
     * Constructor method for ArrayOfPrivitak
     * @uses ArrayOfPrivitak::setPrivitak()
     * @param \StructType\Privitak[] $privitak
     */
    public function __construct(array $privitak = array())
    {
        $this
            ->setPrivitak($privitak);
    }
    /**
     * Get Privitak value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Privitak[]|null
     */
    public function getPrivitak()
    {
        return isset($this->Privitak) ? $this->Privitak : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPrivitak method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrivitak method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePrivitakForArrayConstraintsFromSetPrivitak(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPrivitakPrivitakItem) {
            // validation for constraint: itemType
            if (!$arrayOfPrivitakPrivitakItem instanceof \StructType\Privitak) {
                $invalidValues[] = is_object($arrayOfPrivitakPrivitakItem) ? get_class($arrayOfPrivitakPrivitakItem) : sprintf('%s(%s)', gettype($arrayOfPrivitakPrivitakItem), var_export($arrayOfPrivitakPrivitakItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Privitak property can only contain items of type \StructType\Privitak, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Privitak value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Privitak[] $privitak
     * @return \ArrayType\ArrayOfPrivitak
     */
    public function setPrivitak(array $privitak = array())
    {
        // validation for constraint: array
        if ('' !== ($privitakArrayErrorMessage = self::validatePrivitakForArrayConstraintsFromSetPrivitak($privitak))) {
            throw new \InvalidArgumentException($privitakArrayErrorMessage, __LINE__);
        }
        if (is_null($privitak) || (is_array($privitak) && empty($privitak))) {
            unset($this->Privitak);
        } else {
            $this->Privitak = $privitak;
        }
        return $this;
    }
    /**
     * Add item to Privitak value
     * @throws \InvalidArgumentException
     * @param \StructType\Privitak $item
     * @return \ArrayType\ArrayOfPrivitak
     */
    public function addToPrivitak(\StructType\Privitak $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Privitak) {
            throw new \InvalidArgumentException(sprintf('The Privitak property can only contain items of type \StructType\Privitak, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Privitak[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Privitak|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Privitak|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Privitak|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Privitak|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Privitak|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Privitak
     */
    public function getAttributeName()
    {
        return 'Privitak';
    }
}
