<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNKD ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfNKD
 * @subpackage Arrays
 */
class ArrayOfNKD extends AbstractStructArrayBase
{
    /**
     * The NKD
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NKD[]
     */
    public $NKD;
    /**
     * Constructor method for ArrayOfNKD
     * @uses ArrayOfNKD::setNKD()
     * @param \StructType\NKD[] $nKD
     */
    public function __construct(array $nKD = array())
    {
        $this
            ->setNKD($nKD);
    }
    /**
     * Get NKD value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NKD[]|null
     */
    public function getNKD()
    {
        return isset($this->NKD) ? $this->NKD : null;
    }
    /**
     * This method is responsible for validating the values passed to the setNKD method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNKD method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNKDForArrayConstraintsFromSetNKD(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfNKDNKDItem) {
            // validation for constraint: itemType
            if (!$arrayOfNKDNKDItem instanceof \StructType\NKD) {
                $invalidValues[] = is_object($arrayOfNKDNKDItem) ? get_class($arrayOfNKDNKDItem) : sprintf('%s(%s)', gettype($arrayOfNKDNKDItem), var_export($arrayOfNKDNKDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NKD property can only contain items of type \StructType\NKD, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NKD value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\NKD[] $nKD
     * @return \ArrayType\ArrayOfNKD
     */
    public function setNKD(array $nKD = array())
    {
        // validation for constraint: array
        if ('' !== ($nKDArrayErrorMessage = self::validateNKDForArrayConstraintsFromSetNKD($nKD))) {
            throw new \InvalidArgumentException($nKDArrayErrorMessage, __LINE__);
        }
        if (is_null($nKD) || (is_array($nKD) && empty($nKD))) {
            unset($this->NKD);
        } else {
            $this->NKD = $nKD;
        }
        return $this;
    }
    /**
     * Add item to NKD value
     * @throws \InvalidArgumentException
     * @param \StructType\NKD $item
     * @return \ArrayType\ArrayOfNKD
     */
    public function addToNKD(\StructType\NKD $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NKD) {
            throw new \InvalidArgumentException(sprintf('The NKD property can only contain items of type \StructType\NKD, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NKD[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\NKD|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\NKD|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\NKD|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\NKD|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\NKD|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string NKD
     */
    public function getAttributeName()
    {
        return 'NKD';
    }
}
