<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLokacija ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLokacija
 * @subpackage Arrays
 */
class ArrayOfLokacija extends AbstractStructArrayBase
{
    /**
     * The Lokacija
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Lokacija[]
     */
    public $Lokacija;
    /**
     * Constructor method for ArrayOfLokacija
     * @uses ArrayOfLokacija::setLokacija()
     * @param \StructType\Lokacija[] $lokacija
     */
    public function __construct(array $lokacija = array())
    {
        $this
            ->setLokacija($lokacija);
    }
    /**
     * Get Lokacija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Lokacija[]|null
     */
    public function getLokacija()
    {
        return isset($this->Lokacija) ? $this->Lokacija : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLokacija method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLokacija method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLokacijaForArrayConstraintsFromSetLokacija(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLokacijaLokacijaItem) {
            // validation for constraint: itemType
            if (!$arrayOfLokacijaLokacijaItem instanceof \StructType\Lokacija) {
                $invalidValues[] = is_object($arrayOfLokacijaLokacijaItem) ? get_class($arrayOfLokacijaLokacijaItem) : sprintf('%s(%s)', gettype($arrayOfLokacijaLokacijaItem), var_export($arrayOfLokacijaLokacijaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Lokacija property can only contain items of type \StructType\Lokacija, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Lokacija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Lokacija[] $lokacija
     * @return \ArrayType\ArrayOfLokacija
     */
    public function setLokacija(array $lokacija = array())
    {
        // validation for constraint: array
        if ('' !== ($lokacijaArrayErrorMessage = self::validateLokacijaForArrayConstraintsFromSetLokacija($lokacija))) {
            throw new \InvalidArgumentException($lokacijaArrayErrorMessage, __LINE__);
        }
        if (is_null($lokacija) || (is_array($lokacija) && empty($lokacija))) {
            unset($this->Lokacija);
        } else {
            $this->Lokacija = $lokacija;
        }
        return $this;
    }
    /**
     * Add item to Lokacija value
     * @throws \InvalidArgumentException
     * @param \StructType\Lokacija $item
     * @return \ArrayType\ArrayOfLokacija
     */
    public function addToLokacija(\StructType\Lokacija $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Lokacija) {
            throw new \InvalidArgumentException(sprintf('The Lokacija property can only contain items of type \StructType\Lokacija, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Lokacija[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Lokacija|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Lokacija|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Lokacija|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Lokacija|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Lokacija|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Lokacija
     */
    public function getAttributeName()
    {
        return 'Lokacija';
    }
}
