<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Zahtjev StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Zahtjev
 * @subpackage Structs
 */
class Zahtjev extends AbstractStructBase
{
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Ime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ime;
    /**
     * The IsPosrednik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPosrednik;
    /**
     * The Komentar
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Komentar;
    /**
     * The Korisnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Korisnik
     */
    public $Korisnik;
    /**
     * The KorisnikId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KorisnikId;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The MBO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MBO;
    /**
     * The NazivTvrtke
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NazivTvrtke;
    /**
     * The OIB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OIB;
    /**
     * The PFOOsoba
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PFOOsoba
     */
    public $PFOOsoba;
    /**
     * The PFOOsobaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PFOOsobaId;
    /**
     * The Prezime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Prezime;
    /**
     * The Prilog
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPrilog
     */
    public $Prilog;
    /**
     * The Sifra
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Sifra;
    /**
     * The Telefon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Telefon;
    /**
     * The TipTvrtke
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TipTvrtke;
    /**
     * The TipZahtjeva
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TipZahtjeva
     */
    public $TipZahtjeva;
    /**
     * The TipZahtjevaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TipZahtjevaId;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The VrijemeKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VrijemeKreiranja;
    /**
     * The ZahtjevStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ZahtjevStatus;
    /**
     * The ZahtjevTvrtkaLokacija
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfZahtjevTvrtkaLokacija
     */
    public $ZahtjevTvrtkaLokacija;
    /**
     * The Zahtjev_Rola
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfZahtjev_Rola
     */
    public $Zahtjev_Rola;
    /**
     * Constructor method for Zahtjev
     * @uses Zahtjev::setEmail()
     * @uses Zahtjev::setID()
     * @uses Zahtjev::setIme()
     * @uses Zahtjev::setIsPosrednik()
     * @uses Zahtjev::setKomentar()
     * @uses Zahtjev::setKorisnik()
     * @uses Zahtjev::setKorisnikId()
     * @uses Zahtjev::setKreirao()
     * @uses Zahtjev::setMBO()
     * @uses Zahtjev::setNazivTvrtke()
     * @uses Zahtjev::setOIB()
     * @uses Zahtjev::setPFOOsoba()
     * @uses Zahtjev::setPFOOsobaId()
     * @uses Zahtjev::setPrezime()
     * @uses Zahtjev::setPrilog()
     * @uses Zahtjev::setSifra()
     * @uses Zahtjev::setTelefon()
     * @uses Zahtjev::setTipTvrtke()
     * @uses Zahtjev::setTipZahtjeva()
     * @uses Zahtjev::setTipZahtjevaId()
     * @uses Zahtjev::setUserName()
     * @uses Zahtjev::setVrijemeKreiranja()
     * @uses Zahtjev::setZahtjevStatus()
     * @uses Zahtjev::setZahtjevTvrtkaLokacija()
     * @uses Zahtjev::setZahtjev_Rola()
     * @param string $email
     * @param int $iD
     * @param string $ime
     * @param bool $isPosrednik
     * @param string $komentar
     * @param \StructType\Korisnik $korisnik
     * @param int $korisnikId
     * @param string $kreirao
     * @param string $mBO
     * @param string $nazivTvrtke
     * @param string $oIB
     * @param \StructType\PFOOsoba $pFOOsoba
     * @param int $pFOOsobaId
     * @param string $prezime
     * @param \ArrayType\ArrayOfPrilog $prilog
     * @param string $sifra
     * @param string $telefon
     * @param int $tipTvrtke
     * @param \StructType\TipZahtjeva $tipZahtjeva
     * @param int $tipZahtjevaId
     * @param string $userName
     * @param string $vrijemeKreiranja
     * @param int $zahtjevStatus
     * @param \ArrayType\ArrayOfZahtjevTvrtkaLokacija $zahtjevTvrtkaLokacija
     * @param \ArrayType\ArrayOfZahtjev_Rola $zahtjev_Rola
     */
    public function __construct($email = null, $iD = null, $ime = null, $isPosrednik = null, $komentar = null, \StructType\Korisnik $korisnik = null, $korisnikId = null, $kreirao = null, $mBO = null, $nazivTvrtke = null, $oIB = null, \StructType\PFOOsoba $pFOOsoba = null, $pFOOsobaId = null, $prezime = null, \ArrayType\ArrayOfPrilog $prilog = null, $sifra = null, $telefon = null, $tipTvrtke = null, \StructType\TipZahtjeva $tipZahtjeva = null, $tipZahtjevaId = null, $userName = null, $vrijemeKreiranja = null, $zahtjevStatus = null, \ArrayType\ArrayOfZahtjevTvrtkaLokacija $zahtjevTvrtkaLokacija = null, \ArrayType\ArrayOfZahtjev_Rola $zahtjev_Rola = null)
    {
        $this
            ->setEmail($email)
            ->setID($iD)
            ->setIme($ime)
            ->setIsPosrednik($isPosrednik)
            ->setKomentar($komentar)
            ->setKorisnik($korisnik)
            ->setKorisnikId($korisnikId)
            ->setKreirao($kreirao)
            ->setMBO($mBO)
            ->setNazivTvrtke($nazivTvrtke)
            ->setOIB($oIB)
            ->setPFOOsoba($pFOOsoba)
            ->setPFOOsobaId($pFOOsobaId)
            ->setPrezime($prezime)
            ->setPrilog($prilog)
            ->setSifra($sifra)
            ->setTelefon($telefon)
            ->setTipTvrtke($tipTvrtke)
            ->setTipZahtjeva($tipZahtjeva)
            ->setTipZahtjevaId($tipZahtjevaId)
            ->setUserName($userName)
            ->setVrijemeKreiranja($vrijemeKreiranja)
            ->setZahtjevStatus($zahtjevStatus)
            ->setZahtjevTvrtkaLokacija($zahtjevTvrtkaLokacija)
            ->setZahtjev_Rola($zahtjev_Rola);
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\Zahtjev
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\Zahtjev
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Ime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIme()
    {
        return isset($this->Ime) ? $this->Ime : null;
    }
    /**
     * Set Ime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ime
     * @return \StructType\Zahtjev
     */
    public function setIme($ime = null)
    {
        // validation for constraint: string
        if (!is_null($ime) && !is_string($ime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ime, true), gettype($ime)), __LINE__);
        }
        if (is_null($ime) || (is_array($ime) && empty($ime))) {
            unset($this->Ime);
        } else {
            $this->Ime = $ime;
        }
        return $this;
    }
    /**
     * Get IsPosrednik value
     * @return bool|null
     */
    public function getIsPosrednik()
    {
        return $this->IsPosrednik;
    }
    /**
     * Set IsPosrednik value
     * @param bool $isPosrednik
     * @return \StructType\Zahtjev
     */
    public function setIsPosrednik($isPosrednik = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPosrednik) && !is_bool($isPosrednik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPosrednik, true), gettype($isPosrednik)), __LINE__);
        }
        $this->IsPosrednik = $isPosrednik;
        return $this;
    }
    /**
     * Get Komentar value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKomentar()
    {
        return isset($this->Komentar) ? $this->Komentar : null;
    }
    /**
     * Set Komentar value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $komentar
     * @return \StructType\Zahtjev
     */
    public function setKomentar($komentar = null)
    {
        // validation for constraint: string
        if (!is_null($komentar) && !is_string($komentar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($komentar, true), gettype($komentar)), __LINE__);
        }
        if (is_null($komentar) || (is_array($komentar) && empty($komentar))) {
            unset($this->Komentar);
        } else {
            $this->Komentar = $komentar;
        }
        return $this;
    }
    /**
     * Get Korisnik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Korisnik|null
     */
    public function getKorisnik()
    {
        return isset($this->Korisnik) ? $this->Korisnik : null;
    }
    /**
     * Set Korisnik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Korisnik $korisnik
     * @return \StructType\Zahtjev
     */
    public function setKorisnik(\StructType\Korisnik $korisnik = null)
    {
        if (is_null($korisnik) || (is_array($korisnik) && empty($korisnik))) {
            unset($this->Korisnik);
        } else {
            $this->Korisnik = $korisnik;
        }
        return $this;
    }
    /**
     * Get KorisnikId value
     * @return int|null
     */
    public function getKorisnikId()
    {
        return $this->KorisnikId;
    }
    /**
     * Set KorisnikId value
     * @param int $korisnikId
     * @return \StructType\Zahtjev
     */
    public function setKorisnikId($korisnikId = null)
    {
        // validation for constraint: int
        if (!is_null($korisnikId) && !(is_int($korisnikId) || ctype_digit($korisnikId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($korisnikId, true), gettype($korisnikId)), __LINE__);
        }
        $this->KorisnikId = $korisnikId;
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\Zahtjev
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get MBO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMBO()
    {
        return isset($this->MBO) ? $this->MBO : null;
    }
    /**
     * Set MBO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mBO
     * @return \StructType\Zahtjev
     */
    public function setMBO($mBO = null)
    {
        // validation for constraint: string
        if (!is_null($mBO) && !is_string($mBO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mBO, true), gettype($mBO)), __LINE__);
        }
        if (is_null($mBO) || (is_array($mBO) && empty($mBO))) {
            unset($this->MBO);
        } else {
            $this->MBO = $mBO;
        }
        return $this;
    }
    /**
     * Get NazivTvrtke value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNazivTvrtke()
    {
        return isset($this->NazivTvrtke) ? $this->NazivTvrtke : null;
    }
    /**
     * Set NazivTvrtke value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nazivTvrtke
     * @return \StructType\Zahtjev
     */
    public function setNazivTvrtke($nazivTvrtke = null)
    {
        // validation for constraint: string
        if (!is_null($nazivTvrtke) && !is_string($nazivTvrtke)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivTvrtke, true), gettype($nazivTvrtke)), __LINE__);
        }
        if (is_null($nazivTvrtke) || (is_array($nazivTvrtke) && empty($nazivTvrtke))) {
            unset($this->NazivTvrtke);
        } else {
            $this->NazivTvrtke = $nazivTvrtke;
        }
        return $this;
    }
    /**
     * Get OIB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOIB()
    {
        return isset($this->OIB) ? $this->OIB : null;
    }
    /**
     * Set OIB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oIB
     * @return \StructType\Zahtjev
     */
    public function setOIB($oIB = null)
    {
        // validation for constraint: string
        if (!is_null($oIB) && !is_string($oIB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oIB, true), gettype($oIB)), __LINE__);
        }
        if (is_null($oIB) || (is_array($oIB) && empty($oIB))) {
            unset($this->OIB);
        } else {
            $this->OIB = $oIB;
        }
        return $this;
    }
    /**
     * Get PFOOsoba value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PFOOsoba|null
     */
    public function getPFOOsoba()
    {
        return isset($this->PFOOsoba) ? $this->PFOOsoba : null;
    }
    /**
     * Set PFOOsoba value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PFOOsoba $pFOOsoba
     * @return \StructType\Zahtjev
     */
    public function setPFOOsoba(\StructType\PFOOsoba $pFOOsoba = null)
    {
        if (is_null($pFOOsoba) || (is_array($pFOOsoba) && empty($pFOOsoba))) {
            unset($this->PFOOsoba);
        } else {
            $this->PFOOsoba = $pFOOsoba;
        }
        return $this;
    }
    /**
     * Get PFOOsobaId value
     * @return int|null
     */
    public function getPFOOsobaId()
    {
        return $this->PFOOsobaId;
    }
    /**
     * Set PFOOsobaId value
     * @param int $pFOOsobaId
     * @return \StructType\Zahtjev
     */
    public function setPFOOsobaId($pFOOsobaId = null)
    {
        // validation for constraint: int
        if (!is_null($pFOOsobaId) && !(is_int($pFOOsobaId) || ctype_digit($pFOOsobaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pFOOsobaId, true), gettype($pFOOsobaId)), __LINE__);
        }
        $this->PFOOsobaId = $pFOOsobaId;
        return $this;
    }
    /**
     * Get Prezime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrezime()
    {
        return isset($this->Prezime) ? $this->Prezime : null;
    }
    /**
     * Set Prezime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prezime
     * @return \StructType\Zahtjev
     */
    public function setPrezime($prezime = null)
    {
        // validation for constraint: string
        if (!is_null($prezime) && !is_string($prezime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prezime, true), gettype($prezime)), __LINE__);
        }
        if (is_null($prezime) || (is_array($prezime) && empty($prezime))) {
            unset($this->Prezime);
        } else {
            $this->Prezime = $prezime;
        }
        return $this;
    }
    /**
     * Get Prilog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPrilog|null
     */
    public function getPrilog()
    {
        return isset($this->Prilog) ? $this->Prilog : null;
    }
    /**
     * Set Prilog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPrilog $prilog
     * @return \StructType\Zahtjev
     */
    public function setPrilog(\ArrayType\ArrayOfPrilog $prilog = null)
    {
        if (is_null($prilog) || (is_array($prilog) && empty($prilog))) {
            unset($this->Prilog);
        } else {
            $this->Prilog = $prilog;
        }
        return $this;
    }
    /**
     * Get Sifra value
     * @return string|null
     */
    public function getSifra()
    {
        return $this->Sifra;
    }
    /**
     * Set Sifra value
     * @param string $sifra
     * @return \StructType\Zahtjev
     */
    public function setSifra($sifra = null)
    {
        // validation for constraint: string
        if (!is_null($sifra) && !is_string($sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sifra, true), gettype($sifra)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sifra) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sifra)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sifra, true)), __LINE__);
        }
        $this->Sifra = $sifra;
        return $this;
    }
    /**
     * Get Telefon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefon()
    {
        return isset($this->Telefon) ? $this->Telefon : null;
    }
    /**
     * Set Telefon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefon
     * @return \StructType\Zahtjev
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        if (is_null($telefon) || (is_array($telefon) && empty($telefon))) {
            unset($this->Telefon);
        } else {
            $this->Telefon = $telefon;
        }
        return $this;
    }
    /**
     * Get TipTvrtke value
     * @return int|null
     */
    public function getTipTvrtke()
    {
        return $this->TipTvrtke;
    }
    /**
     * Set TipTvrtke value
     * @param int $tipTvrtke
     * @return \StructType\Zahtjev
     */
    public function setTipTvrtke($tipTvrtke = null)
    {
        // validation for constraint: int
        if (!is_null($tipTvrtke) && !(is_int($tipTvrtke) || ctype_digit($tipTvrtke))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipTvrtke, true), gettype($tipTvrtke)), __LINE__);
        }
        $this->TipTvrtke = $tipTvrtke;
        return $this;
    }
    /**
     * Get TipZahtjeva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TipZahtjeva|null
     */
    public function getTipZahtjeva()
    {
        return isset($this->TipZahtjeva) ? $this->TipZahtjeva : null;
    }
    /**
     * Set TipZahtjeva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TipZahtjeva $tipZahtjeva
     * @return \StructType\Zahtjev
     */
    public function setTipZahtjeva(\StructType\TipZahtjeva $tipZahtjeva = null)
    {
        if (is_null($tipZahtjeva) || (is_array($tipZahtjeva) && empty($tipZahtjeva))) {
            unset($this->TipZahtjeva);
        } else {
            $this->TipZahtjeva = $tipZahtjeva;
        }
        return $this;
    }
    /**
     * Get TipZahtjevaId value
     * @return int|null
     */
    public function getTipZahtjevaId()
    {
        return $this->TipZahtjevaId;
    }
    /**
     * Set TipZahtjevaId value
     * @param int $tipZahtjevaId
     * @return \StructType\Zahtjev
     */
    public function setTipZahtjevaId($tipZahtjevaId = null)
    {
        // validation for constraint: int
        if (!is_null($tipZahtjevaId) && !(is_int($tipZahtjevaId) || ctype_digit($tipZahtjevaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipZahtjevaId, true), gettype($tipZahtjevaId)), __LINE__);
        }
        $this->TipZahtjevaId = $tipZahtjevaId;
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \StructType\Zahtjev
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get VrijemeKreiranja value
     * @return string|null
     */
    public function getVrijemeKreiranja()
    {
        return $this->VrijemeKreiranja;
    }
    /**
     * Set VrijemeKreiranja value
     * @param string $vrijemeKreiranja
     * @return \StructType\Zahtjev
     */
    public function setVrijemeKreiranja($vrijemeKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($vrijemeKreiranja) && !is_string($vrijemeKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vrijemeKreiranja, true), gettype($vrijemeKreiranja)), __LINE__);
        }
        $this->VrijemeKreiranja = $vrijemeKreiranja;
        return $this;
    }
    /**
     * Get ZahtjevStatus value
     * @return int|null
     */
    public function getZahtjevStatus()
    {
        return $this->ZahtjevStatus;
    }
    /**
     * Set ZahtjevStatus value
     * @param int $zahtjevStatus
     * @return \StructType\Zahtjev
     */
    public function setZahtjevStatus($zahtjevStatus = null)
    {
        // validation for constraint: int
        if (!is_null($zahtjevStatus) && !(is_int($zahtjevStatus) || ctype_digit($zahtjevStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zahtjevStatus, true), gettype($zahtjevStatus)), __LINE__);
        }
        $this->ZahtjevStatus = $zahtjevStatus;
        return $this;
    }
    /**
     * Get ZahtjevTvrtkaLokacija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfZahtjevTvrtkaLokacija|null
     */
    public function getZahtjevTvrtkaLokacija()
    {
        return isset($this->ZahtjevTvrtkaLokacija) ? $this->ZahtjevTvrtkaLokacija : null;
    }
    /**
     * Set ZahtjevTvrtkaLokacija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfZahtjevTvrtkaLokacija $zahtjevTvrtkaLokacija
     * @return \StructType\Zahtjev
     */
    public function setZahtjevTvrtkaLokacija(\ArrayType\ArrayOfZahtjevTvrtkaLokacija $zahtjevTvrtkaLokacija = null)
    {
        if (is_null($zahtjevTvrtkaLokacija) || (is_array($zahtjevTvrtkaLokacija) && empty($zahtjevTvrtkaLokacija))) {
            unset($this->ZahtjevTvrtkaLokacija);
        } else {
            $this->ZahtjevTvrtkaLokacija = $zahtjevTvrtkaLokacija;
        }
        return $this;
    }
    /**
     * Get Zahtjev_Rola value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfZahtjev_Rola|null
     */
    public function getZahtjev_Rola()
    {
        return isset($this->Zahtjev_Rola) ? $this->Zahtjev_Rola : null;
    }
    /**
     * Set Zahtjev_Rola value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfZahtjev_Rola $zahtjev_Rola
     * @return \StructType\Zahtjev
     */
    public function setZahtjev_Rola(\ArrayType\ArrayOfZahtjev_Rola $zahtjev_Rola = null)
    {
        if (is_null($zahtjev_Rola) || (is_array($zahtjev_Rola) && empty($zahtjev_Rola))) {
            unset($this->Zahtjev_Rola);
        } else {
            $this->Zahtjev_Rola = $zahtjev_Rola;
        }
        return $this;
    }
}
