<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UMAudit StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UMAudit
 * @subpackage Structs
 */
class UMAudit extends AbstractStructBase
{
    /**
     * The AkcijaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AkcijaId;
    /**
     * The AkcijaNaziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AkcijaNaziv;
    /**
     * The AuditAkcija
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuditAkcija
     */
    public $AuditAkcija;
    /**
     * The AuditStanje
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuditStanje
     */
    public $AuditStanje;
    /**
     * The AuditStanje1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuditStanje
     */
    public $AuditStanje1;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Ime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ime;
    /**
     * The InicijatorAkcijeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InicijatorAkcijeId;
    /**
     * The InicijatorEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InicijatorEmail;
    /**
     * The InicijatorIme
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InicijatorIme;
    /**
     * The InicijatorPrezime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InicijatorPrezime;
    /**
     * The InicijatorUsername
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InicijatorUsername;
    /**
     * The Korisnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Korisnik
     */
    public $Korisnik;
    /**
     * The Korisnik1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Korisnik
     */
    public $Korisnik1;
    /**
     * The KorisnikId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KorisnikId;
    /**
     * The Lokacija
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Lokacija
     */
    public $Lokacija;
    /**
     * The LokacijaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LokacijaId;
    /**
     * The NovoStanjeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NovoStanjeId;
    /**
     * The PFOOsoba
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PFOOsoba
     */
    public $PFOOsoba;
    /**
     * The PFOOsobaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PFOOsobaId;
    /**
     * The PFOOsobaMB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PFOOsobaMB;
    /**
     * The PFOOsobaNaziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PFOOsobaNaziv;
    /**
     * The PFOOsobaOIB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PFOOsobaOIB;
    /**
     * The PFOOsobaTipId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PFOOsobaTipId;
    /**
     * The Poruka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Poruka;
    /**
     * The PrethodnoStanjeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrethodnoStanjeId;
    /**
     * The Prezime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Prezime;
    /**
     * The Prilog
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPrilog
     */
    public $Prilog;
    /**
     * The Username
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Username;
    /**
     * The VrijemeKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VrijemeKreiranja;
    /**
     * The ZahtjevId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ZahtjevId;
    /**
     * Constructor method for UMAudit
     * @uses UMAudit::setAkcijaId()
     * @uses UMAudit::setAkcijaNaziv()
     * @uses UMAudit::setAuditAkcija()
     * @uses UMAudit::setAuditStanje()
     * @uses UMAudit::setAuditStanje1()
     * @uses UMAudit::setEmail()
     * @uses UMAudit::setID()
     * @uses UMAudit::setIme()
     * @uses UMAudit::setInicijatorAkcijeId()
     * @uses UMAudit::setInicijatorEmail()
     * @uses UMAudit::setInicijatorIme()
     * @uses UMAudit::setInicijatorPrezime()
     * @uses UMAudit::setInicijatorUsername()
     * @uses UMAudit::setKorisnik()
     * @uses UMAudit::setKorisnik1()
     * @uses UMAudit::setKorisnikId()
     * @uses UMAudit::setLokacija()
     * @uses UMAudit::setLokacijaId()
     * @uses UMAudit::setNovoStanjeId()
     * @uses UMAudit::setPFOOsoba()
     * @uses UMAudit::setPFOOsobaId()
     * @uses UMAudit::setPFOOsobaMB()
     * @uses UMAudit::setPFOOsobaNaziv()
     * @uses UMAudit::setPFOOsobaOIB()
     * @uses UMAudit::setPFOOsobaTipId()
     * @uses UMAudit::setPoruka()
     * @uses UMAudit::setPrethodnoStanjeId()
     * @uses UMAudit::setPrezime()
     * @uses UMAudit::setPrilog()
     * @uses UMAudit::setUsername()
     * @uses UMAudit::setVrijemeKreiranja()
     * @uses UMAudit::setZahtjevId()
     * @param int $akcijaId
     * @param string $akcijaNaziv
     * @param \StructType\AuditAkcija $auditAkcija
     * @param \StructType\AuditStanje $auditStanje
     * @param \StructType\AuditStanje $auditStanje1
     * @param string $email
     * @param int $iD
     * @param string $ime
     * @param int $inicijatorAkcijeId
     * @param string $inicijatorEmail
     * @param string $inicijatorIme
     * @param string $inicijatorPrezime
     * @param string $inicijatorUsername
     * @param \StructType\Korisnik $korisnik
     * @param \StructType\Korisnik $korisnik1
     * @param int $korisnikId
     * @param \StructType\Lokacija $lokacija
     * @param int $lokacijaId
     * @param int $novoStanjeId
     * @param \StructType\PFOOsoba $pFOOsoba
     * @param int $pFOOsobaId
     * @param string $pFOOsobaMB
     * @param string $pFOOsobaNaziv
     * @param string $pFOOsobaOIB
     * @param int $pFOOsobaTipId
     * @param string $poruka
     * @param int $prethodnoStanjeId
     * @param string $prezime
     * @param \ArrayType\ArrayOfPrilog $prilog
     * @param string $username
     * @param string $vrijemeKreiranja
     * @param int $zahtjevId
     */
    public function __construct($akcijaId = null, $akcijaNaziv = null, \StructType\AuditAkcija $auditAkcija = null, \StructType\AuditStanje $auditStanje = null, \StructType\AuditStanje $auditStanje1 = null, $email = null, $iD = null, $ime = null, $inicijatorAkcijeId = null, $inicijatorEmail = null, $inicijatorIme = null, $inicijatorPrezime = null, $inicijatorUsername = null, \StructType\Korisnik $korisnik = null, \StructType\Korisnik $korisnik1 = null, $korisnikId = null, \StructType\Lokacija $lokacija = null, $lokacijaId = null, $novoStanjeId = null, \StructType\PFOOsoba $pFOOsoba = null, $pFOOsobaId = null, $pFOOsobaMB = null, $pFOOsobaNaziv = null, $pFOOsobaOIB = null, $pFOOsobaTipId = null, $poruka = null, $prethodnoStanjeId = null, $prezime = null, \ArrayType\ArrayOfPrilog $prilog = null, $username = null, $vrijemeKreiranja = null, $zahtjevId = null)
    {
        $this
            ->setAkcijaId($akcijaId)
            ->setAkcijaNaziv($akcijaNaziv)
            ->setAuditAkcija($auditAkcija)
            ->setAuditStanje($auditStanje)
            ->setAuditStanje1($auditStanje1)
            ->setEmail($email)
            ->setID($iD)
            ->setIme($ime)
            ->setInicijatorAkcijeId($inicijatorAkcijeId)
            ->setInicijatorEmail($inicijatorEmail)
            ->setInicijatorIme($inicijatorIme)
            ->setInicijatorPrezime($inicijatorPrezime)
            ->setInicijatorUsername($inicijatorUsername)
            ->setKorisnik($korisnik)
            ->setKorisnik1($korisnik1)
            ->setKorisnikId($korisnikId)
            ->setLokacija($lokacija)
            ->setLokacijaId($lokacijaId)
            ->setNovoStanjeId($novoStanjeId)
            ->setPFOOsoba($pFOOsoba)
            ->setPFOOsobaId($pFOOsobaId)
            ->setPFOOsobaMB($pFOOsobaMB)
            ->setPFOOsobaNaziv($pFOOsobaNaziv)
            ->setPFOOsobaOIB($pFOOsobaOIB)
            ->setPFOOsobaTipId($pFOOsobaTipId)
            ->setPoruka($poruka)
            ->setPrethodnoStanjeId($prethodnoStanjeId)
            ->setPrezime($prezime)
            ->setPrilog($prilog)
            ->setUsername($username)
            ->setVrijemeKreiranja($vrijemeKreiranja)
            ->setZahtjevId($zahtjevId);
    }
    /**
     * Get AkcijaId value
     * @return int|null
     */
    public function getAkcijaId()
    {
        return $this->AkcijaId;
    }
    /**
     * Set AkcijaId value
     * @param int $akcijaId
     * @return \StructType\UMAudit
     */
    public function setAkcijaId($akcijaId = null)
    {
        // validation for constraint: int
        if (!is_null($akcijaId) && !(is_int($akcijaId) || ctype_digit($akcijaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($akcijaId, true), gettype($akcijaId)), __LINE__);
        }
        $this->AkcijaId = $akcijaId;
        return $this;
    }
    /**
     * Get AkcijaNaziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAkcijaNaziv()
    {
        return isset($this->AkcijaNaziv) ? $this->AkcijaNaziv : null;
    }
    /**
     * Set AkcijaNaziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $akcijaNaziv
     * @return \StructType\UMAudit
     */
    public function setAkcijaNaziv($akcijaNaziv = null)
    {
        // validation for constraint: string
        if (!is_null($akcijaNaziv) && !is_string($akcijaNaziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($akcijaNaziv, true), gettype($akcijaNaziv)), __LINE__);
        }
        if (is_null($akcijaNaziv) || (is_array($akcijaNaziv) && empty($akcijaNaziv))) {
            unset($this->AkcijaNaziv);
        } else {
            $this->AkcijaNaziv = $akcijaNaziv;
        }
        return $this;
    }
    /**
     * Get AuditAkcija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuditAkcija|null
     */
    public function getAuditAkcija()
    {
        return isset($this->AuditAkcija) ? $this->AuditAkcija : null;
    }
    /**
     * Set AuditAkcija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuditAkcija $auditAkcija
     * @return \StructType\UMAudit
     */
    public function setAuditAkcija(\StructType\AuditAkcija $auditAkcija = null)
    {
        if (is_null($auditAkcija) || (is_array($auditAkcija) && empty($auditAkcija))) {
            unset($this->AuditAkcija);
        } else {
            $this->AuditAkcija = $auditAkcija;
        }
        return $this;
    }
    /**
     * Get AuditStanje value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuditStanje|null
     */
    public function getAuditStanje()
    {
        return isset($this->AuditStanje) ? $this->AuditStanje : null;
    }
    /**
     * Set AuditStanje value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuditStanje $auditStanje
     * @return \StructType\UMAudit
     */
    public function setAuditStanje(\StructType\AuditStanje $auditStanje = null)
    {
        if (is_null($auditStanje) || (is_array($auditStanje) && empty($auditStanje))) {
            unset($this->AuditStanje);
        } else {
            $this->AuditStanje = $auditStanje;
        }
        return $this;
    }
    /**
     * Get AuditStanje1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuditStanje|null
     */
    public function getAuditStanje1()
    {
        return isset($this->AuditStanje1) ? $this->AuditStanje1 : null;
    }
    /**
     * Set AuditStanje1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuditStanje $auditStanje1
     * @return \StructType\UMAudit
     */
    public function setAuditStanje1(\StructType\AuditStanje $auditStanje1 = null)
    {
        if (is_null($auditStanje1) || (is_array($auditStanje1) && empty($auditStanje1))) {
            unset($this->AuditStanje1);
        } else {
            $this->AuditStanje1 = $auditStanje1;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \StructType\UMAudit
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\UMAudit
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Ime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIme()
    {
        return isset($this->Ime) ? $this->Ime : null;
    }
    /**
     * Set Ime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ime
     * @return \StructType\UMAudit
     */
    public function setIme($ime = null)
    {
        // validation for constraint: string
        if (!is_null($ime) && !is_string($ime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ime, true), gettype($ime)), __LINE__);
        }
        if (is_null($ime) || (is_array($ime) && empty($ime))) {
            unset($this->Ime);
        } else {
            $this->Ime = $ime;
        }
        return $this;
    }
    /**
     * Get InicijatorAkcijeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInicijatorAkcijeId()
    {
        return isset($this->InicijatorAkcijeId) ? $this->InicijatorAkcijeId : null;
    }
    /**
     * Set InicijatorAkcijeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $inicijatorAkcijeId
     * @return \StructType\UMAudit
     */
    public function setInicijatorAkcijeId($inicijatorAkcijeId = null)
    {
        // validation for constraint: int
        if (!is_null($inicijatorAkcijeId) && !(is_int($inicijatorAkcijeId) || ctype_digit($inicijatorAkcijeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inicijatorAkcijeId, true), gettype($inicijatorAkcijeId)), __LINE__);
        }
        if (is_null($inicijatorAkcijeId) || (is_array($inicijatorAkcijeId) && empty($inicijatorAkcijeId))) {
            unset($this->InicijatorAkcijeId);
        } else {
            $this->InicijatorAkcijeId = $inicijatorAkcijeId;
        }
        return $this;
    }
    /**
     * Get InicijatorEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInicijatorEmail()
    {
        return isset($this->InicijatorEmail) ? $this->InicijatorEmail : null;
    }
    /**
     * Set InicijatorEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inicijatorEmail
     * @return \StructType\UMAudit
     */
    public function setInicijatorEmail($inicijatorEmail = null)
    {
        // validation for constraint: string
        if (!is_null($inicijatorEmail) && !is_string($inicijatorEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inicijatorEmail, true), gettype($inicijatorEmail)), __LINE__);
        }
        if (is_null($inicijatorEmail) || (is_array($inicijatorEmail) && empty($inicijatorEmail))) {
            unset($this->InicijatorEmail);
        } else {
            $this->InicijatorEmail = $inicijatorEmail;
        }
        return $this;
    }
    /**
     * Get InicijatorIme value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInicijatorIme()
    {
        return isset($this->InicijatorIme) ? $this->InicijatorIme : null;
    }
    /**
     * Set InicijatorIme value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inicijatorIme
     * @return \StructType\UMAudit
     */
    public function setInicijatorIme($inicijatorIme = null)
    {
        // validation for constraint: string
        if (!is_null($inicijatorIme) && !is_string($inicijatorIme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inicijatorIme, true), gettype($inicijatorIme)), __LINE__);
        }
        if (is_null($inicijatorIme) || (is_array($inicijatorIme) && empty($inicijatorIme))) {
            unset($this->InicijatorIme);
        } else {
            $this->InicijatorIme = $inicijatorIme;
        }
        return $this;
    }
    /**
     * Get InicijatorPrezime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInicijatorPrezime()
    {
        return isset($this->InicijatorPrezime) ? $this->InicijatorPrezime : null;
    }
    /**
     * Set InicijatorPrezime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inicijatorPrezime
     * @return \StructType\UMAudit
     */
    public function setInicijatorPrezime($inicijatorPrezime = null)
    {
        // validation for constraint: string
        if (!is_null($inicijatorPrezime) && !is_string($inicijatorPrezime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inicijatorPrezime, true), gettype($inicijatorPrezime)), __LINE__);
        }
        if (is_null($inicijatorPrezime) || (is_array($inicijatorPrezime) && empty($inicijatorPrezime))) {
            unset($this->InicijatorPrezime);
        } else {
            $this->InicijatorPrezime = $inicijatorPrezime;
        }
        return $this;
    }
    /**
     * Get InicijatorUsername value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInicijatorUsername()
    {
        return isset($this->InicijatorUsername) ? $this->InicijatorUsername : null;
    }
    /**
     * Set InicijatorUsername value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inicijatorUsername
     * @return \StructType\UMAudit
     */
    public function setInicijatorUsername($inicijatorUsername = null)
    {
        // validation for constraint: string
        if (!is_null($inicijatorUsername) && !is_string($inicijatorUsername)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inicijatorUsername, true), gettype($inicijatorUsername)), __LINE__);
        }
        if (is_null($inicijatorUsername) || (is_array($inicijatorUsername) && empty($inicijatorUsername))) {
            unset($this->InicijatorUsername);
        } else {
            $this->InicijatorUsername = $inicijatorUsername;
        }
        return $this;
    }
    /**
     * Get Korisnik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Korisnik|null
     */
    public function getKorisnik()
    {
        return isset($this->Korisnik) ? $this->Korisnik : null;
    }
    /**
     * Set Korisnik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Korisnik $korisnik
     * @return \StructType\UMAudit
     */
    public function setKorisnik(\StructType\Korisnik $korisnik = null)
    {
        if (is_null($korisnik) || (is_array($korisnik) && empty($korisnik))) {
            unset($this->Korisnik);
        } else {
            $this->Korisnik = $korisnik;
        }
        return $this;
    }
    /**
     * Get Korisnik1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Korisnik|null
     */
    public function getKorisnik1()
    {
        return isset($this->Korisnik1) ? $this->Korisnik1 : null;
    }
    /**
     * Set Korisnik1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Korisnik $korisnik1
     * @return \StructType\UMAudit
     */
    public function setKorisnik1(\StructType\Korisnik $korisnik1 = null)
    {
        if (is_null($korisnik1) || (is_array($korisnik1) && empty($korisnik1))) {
            unset($this->Korisnik1);
        } else {
            $this->Korisnik1 = $korisnik1;
        }
        return $this;
    }
    /**
     * Get KorisnikId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKorisnikId()
    {
        return isset($this->KorisnikId) ? $this->KorisnikId : null;
    }
    /**
     * Set KorisnikId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $korisnikId
     * @return \StructType\UMAudit
     */
    public function setKorisnikId($korisnikId = null)
    {
        // validation for constraint: int
        if (!is_null($korisnikId) && !(is_int($korisnikId) || ctype_digit($korisnikId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($korisnikId, true), gettype($korisnikId)), __LINE__);
        }
        if (is_null($korisnikId) || (is_array($korisnikId) && empty($korisnikId))) {
            unset($this->KorisnikId);
        } else {
            $this->KorisnikId = $korisnikId;
        }
        return $this;
    }
    /**
     * Get Lokacija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Lokacija|null
     */
    public function getLokacija()
    {
        return isset($this->Lokacija) ? $this->Lokacija : null;
    }
    /**
     * Set Lokacija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Lokacija $lokacija
     * @return \StructType\UMAudit
     */
    public function setLokacija(\StructType\Lokacija $lokacija = null)
    {
        if (is_null($lokacija) || (is_array($lokacija) && empty($lokacija))) {
            unset($this->Lokacija);
        } else {
            $this->Lokacija = $lokacija;
        }
        return $this;
    }
    /**
     * Get LokacijaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLokacijaId()
    {
        return isset($this->LokacijaId) ? $this->LokacijaId : null;
    }
    /**
     * Set LokacijaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lokacijaId
     * @return \StructType\UMAudit
     */
    public function setLokacijaId($lokacijaId = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaId) && !(is_int($lokacijaId) || ctype_digit($lokacijaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaId, true), gettype($lokacijaId)), __LINE__);
        }
        if (is_null($lokacijaId) || (is_array($lokacijaId) && empty($lokacijaId))) {
            unset($this->LokacijaId);
        } else {
            $this->LokacijaId = $lokacijaId;
        }
        return $this;
    }
    /**
     * Get NovoStanjeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNovoStanjeId()
    {
        return isset($this->NovoStanjeId) ? $this->NovoStanjeId : null;
    }
    /**
     * Set NovoStanjeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $novoStanjeId
     * @return \StructType\UMAudit
     */
    public function setNovoStanjeId($novoStanjeId = null)
    {
        // validation for constraint: int
        if (!is_null($novoStanjeId) && !(is_int($novoStanjeId) || ctype_digit($novoStanjeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($novoStanjeId, true), gettype($novoStanjeId)), __LINE__);
        }
        if (is_null($novoStanjeId) || (is_array($novoStanjeId) && empty($novoStanjeId))) {
            unset($this->NovoStanjeId);
        } else {
            $this->NovoStanjeId = $novoStanjeId;
        }
        return $this;
    }
    /**
     * Get PFOOsoba value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PFOOsoba|null
     */
    public function getPFOOsoba()
    {
        return isset($this->PFOOsoba) ? $this->PFOOsoba : null;
    }
    /**
     * Set PFOOsoba value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PFOOsoba $pFOOsoba
     * @return \StructType\UMAudit
     */
    public function setPFOOsoba(\StructType\PFOOsoba $pFOOsoba = null)
    {
        if (is_null($pFOOsoba) || (is_array($pFOOsoba) && empty($pFOOsoba))) {
            unset($this->PFOOsoba);
        } else {
            $this->PFOOsoba = $pFOOsoba;
        }
        return $this;
    }
    /**
     * Get PFOOsobaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPFOOsobaId()
    {
        return isset($this->PFOOsobaId) ? $this->PFOOsobaId : null;
    }
    /**
     * Set PFOOsobaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pFOOsobaId
     * @return \StructType\UMAudit
     */
    public function setPFOOsobaId($pFOOsobaId = null)
    {
        // validation for constraint: int
        if (!is_null($pFOOsobaId) && !(is_int($pFOOsobaId) || ctype_digit($pFOOsobaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pFOOsobaId, true), gettype($pFOOsobaId)), __LINE__);
        }
        if (is_null($pFOOsobaId) || (is_array($pFOOsobaId) && empty($pFOOsobaId))) {
            unset($this->PFOOsobaId);
        } else {
            $this->PFOOsobaId = $pFOOsobaId;
        }
        return $this;
    }
    /**
     * Get PFOOsobaMB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPFOOsobaMB()
    {
        return isset($this->PFOOsobaMB) ? $this->PFOOsobaMB : null;
    }
    /**
     * Set PFOOsobaMB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pFOOsobaMB
     * @return \StructType\UMAudit
     */
    public function setPFOOsobaMB($pFOOsobaMB = null)
    {
        // validation for constraint: string
        if (!is_null($pFOOsobaMB) && !is_string($pFOOsobaMB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pFOOsobaMB, true), gettype($pFOOsobaMB)), __LINE__);
        }
        if (is_null($pFOOsobaMB) || (is_array($pFOOsobaMB) && empty($pFOOsobaMB))) {
            unset($this->PFOOsobaMB);
        } else {
            $this->PFOOsobaMB = $pFOOsobaMB;
        }
        return $this;
    }
    /**
     * Get PFOOsobaNaziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPFOOsobaNaziv()
    {
        return isset($this->PFOOsobaNaziv) ? $this->PFOOsobaNaziv : null;
    }
    /**
     * Set PFOOsobaNaziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pFOOsobaNaziv
     * @return \StructType\UMAudit
     */
    public function setPFOOsobaNaziv($pFOOsobaNaziv = null)
    {
        // validation for constraint: string
        if (!is_null($pFOOsobaNaziv) && !is_string($pFOOsobaNaziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pFOOsobaNaziv, true), gettype($pFOOsobaNaziv)), __LINE__);
        }
        if (is_null($pFOOsobaNaziv) || (is_array($pFOOsobaNaziv) && empty($pFOOsobaNaziv))) {
            unset($this->PFOOsobaNaziv);
        } else {
            $this->PFOOsobaNaziv = $pFOOsobaNaziv;
        }
        return $this;
    }
    /**
     * Get PFOOsobaOIB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPFOOsobaOIB()
    {
        return isset($this->PFOOsobaOIB) ? $this->PFOOsobaOIB : null;
    }
    /**
     * Set PFOOsobaOIB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pFOOsobaOIB
     * @return \StructType\UMAudit
     */
    public function setPFOOsobaOIB($pFOOsobaOIB = null)
    {
        // validation for constraint: string
        if (!is_null($pFOOsobaOIB) && !is_string($pFOOsobaOIB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pFOOsobaOIB, true), gettype($pFOOsobaOIB)), __LINE__);
        }
        if (is_null($pFOOsobaOIB) || (is_array($pFOOsobaOIB) && empty($pFOOsobaOIB))) {
            unset($this->PFOOsobaOIB);
        } else {
            $this->PFOOsobaOIB = $pFOOsobaOIB;
        }
        return $this;
    }
    /**
     * Get PFOOsobaTipId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPFOOsobaTipId()
    {
        return isset($this->PFOOsobaTipId) ? $this->PFOOsobaTipId : null;
    }
    /**
     * Set PFOOsobaTipId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pFOOsobaTipId
     * @return \StructType\UMAudit
     */
    public function setPFOOsobaTipId($pFOOsobaTipId = null)
    {
        // validation for constraint: int
        if (!is_null($pFOOsobaTipId) && !(is_int($pFOOsobaTipId) || ctype_digit($pFOOsobaTipId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pFOOsobaTipId, true), gettype($pFOOsobaTipId)), __LINE__);
        }
        if (is_null($pFOOsobaTipId) || (is_array($pFOOsobaTipId) && empty($pFOOsobaTipId))) {
            unset($this->PFOOsobaTipId);
        } else {
            $this->PFOOsobaTipId = $pFOOsobaTipId;
        }
        return $this;
    }
    /**
     * Get Poruka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPoruka()
    {
        return isset($this->Poruka) ? $this->Poruka : null;
    }
    /**
     * Set Poruka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $poruka
     * @return \StructType\UMAudit
     */
    public function setPoruka($poruka = null)
    {
        // validation for constraint: string
        if (!is_null($poruka) && !is_string($poruka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poruka, true), gettype($poruka)), __LINE__);
        }
        if (is_null($poruka) || (is_array($poruka) && empty($poruka))) {
            unset($this->Poruka);
        } else {
            $this->Poruka = $poruka;
        }
        return $this;
    }
    /**
     * Get PrethodnoStanjeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrethodnoStanjeId()
    {
        return isset($this->PrethodnoStanjeId) ? $this->PrethodnoStanjeId : null;
    }
    /**
     * Set PrethodnoStanjeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prethodnoStanjeId
     * @return \StructType\UMAudit
     */
    public function setPrethodnoStanjeId($prethodnoStanjeId = null)
    {
        // validation for constraint: int
        if (!is_null($prethodnoStanjeId) && !(is_int($prethodnoStanjeId) || ctype_digit($prethodnoStanjeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prethodnoStanjeId, true), gettype($prethodnoStanjeId)), __LINE__);
        }
        if (is_null($prethodnoStanjeId) || (is_array($prethodnoStanjeId) && empty($prethodnoStanjeId))) {
            unset($this->PrethodnoStanjeId);
        } else {
            $this->PrethodnoStanjeId = $prethodnoStanjeId;
        }
        return $this;
    }
    /**
     * Get Prezime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrezime()
    {
        return isset($this->Prezime) ? $this->Prezime : null;
    }
    /**
     * Set Prezime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $prezime
     * @return \StructType\UMAudit
     */
    public function setPrezime($prezime = null)
    {
        // validation for constraint: string
        if (!is_null($prezime) && !is_string($prezime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prezime, true), gettype($prezime)), __LINE__);
        }
        if (is_null($prezime) || (is_array($prezime) && empty($prezime))) {
            unset($this->Prezime);
        } else {
            $this->Prezime = $prezime;
        }
        return $this;
    }
    /**
     * Get Prilog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPrilog|null
     */
    public function getPrilog()
    {
        return isset($this->Prilog) ? $this->Prilog : null;
    }
    /**
     * Set Prilog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPrilog $prilog
     * @return \StructType\UMAudit
     */
    public function setPrilog(\ArrayType\ArrayOfPrilog $prilog = null)
    {
        if (is_null($prilog) || (is_array($prilog) && empty($prilog))) {
            unset($this->Prilog);
        } else {
            $this->Prilog = $prilog;
        }
        return $this;
    }
    /**
     * Get Username value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsername()
    {
        return isset($this->Username) ? $this->Username : null;
    }
    /**
     * Set Username value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $username
     * @return \StructType\UMAudit
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($username, true), gettype($username)), __LINE__);
        }
        if (is_null($username) || (is_array($username) && empty($username))) {
            unset($this->Username);
        } else {
            $this->Username = $username;
        }
        return $this;
    }
    /**
     * Get VrijemeKreiranja value
     * @return string|null
     */
    public function getVrijemeKreiranja()
    {
        return $this->VrijemeKreiranja;
    }
    /**
     * Set VrijemeKreiranja value
     * @param string $vrijemeKreiranja
     * @return \StructType\UMAudit
     */
    public function setVrijemeKreiranja($vrijemeKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($vrijemeKreiranja) && !is_string($vrijemeKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vrijemeKreiranja, true), gettype($vrijemeKreiranja)), __LINE__);
        }
        $this->VrijemeKreiranja = $vrijemeKreiranja;
        return $this;
    }
    /**
     * Get ZahtjevId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getZahtjevId()
    {
        return isset($this->ZahtjevId) ? $this->ZahtjevId : null;
    }
    /**
     * Set ZahtjevId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $zahtjevId
     * @return \StructType\UMAudit
     */
    public function setZahtjevId($zahtjevId = null)
    {
        // validation for constraint: int
        if (!is_null($zahtjevId) && !(is_int($zahtjevId) || ctype_digit($zahtjevId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zahtjevId, true), gettype($zahtjevId)), __LINE__);
        }
        if (is_null($zahtjevId) || (is_array($zahtjevId) && empty($zahtjevId))) {
            unset($this->ZahtjevId);
        } else {
            $this->ZahtjevId = $zahtjevId;
        }
        return $this;
    }
}
