<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TijekOtpadaInput StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TijekOtpadaInput
 * @subpackage Structs
 */
class TijekOtpadaInput extends AbstractStructBase
{
    /**
     * The BrojOrgJedinice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrojOrgJedinice;
    /**
     * The BrojPosiljke
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrojPosiljke;
    /**
     * The Datum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Datum;
    /**
     * The DatumZaprimanjaUvoznik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumZaprimanjaUvoznik;
    /**
     * The DrzavaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DrzavaID;
    /**
     * The IsFizickaOsoba
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsFizickaOsoba;
    /**
     * The IsUPKPravnaOsoba
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUPKPravnaOsoba;
    /**
     * The KljucniBrojeviUO_IO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKljucniBrojOtpadaModel
     */
    public $KljucniBrojeviUO_IO;
    /**
     * The KolicinaOtpadaKg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $KolicinaOtpadaKg;
    /**
     * The Kompostiranje
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Kompostiranje;
    /**
     * The LokacijaProdavateljaOtpadaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LokacijaProdavateljaOtpadaId;
    /**
     * The LokacijaProdavateljaOtpadaIzSUMPa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LokacijaProdavateljaOtpadaIzSUMPa;
    /**
     * The MRDOznakaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MRDOznakaId;
    /**
     * The Napomena
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Napomena;
    /**
     * The Nasipavanje
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Nasipavanje;
    /**
     * The NazivOsobeKojaOrganiziraOtpremu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NazivOsobeKojaOrganiziraOtpremu;
    /**
     * The NazivUvoznika
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NazivUvoznika;
    /**
     * The NotifikacijskiBroj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotifikacijskiBroj;
    /**
     * The NotifikacijskiBrojId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NotifikacijskiBrojId;
    /**
     * The NumerickaBrOznaka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumerickaBrOznaka;
    /**
     * The OIB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OIB;
    /**
     * The OIBBrojPutovnice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OIBBrojPutovnice;
    /**
     * The OIBKupca
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OIBKupca;
    /**
     * The OcevidnikProizvodId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OcevidnikProizvodId;
    /**
     * The OcevidnikUkidanjaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OcevidnikUkidanjaId;
    /**
     * The OntoID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OntoID;
    /**
     * The OpisOtpada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpisOtpada;
    /**
     * The OznakaNacinaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OznakaNacinaID;
    /**
     * The OznakaPosebneKategorijeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OznakaPosebneKategorijeID;
    /**
     * The OznakaPrilogaUredbeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OznakaPrilogaUredbeID;
    /**
     * The PFOsobaPosrednikId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PFOsobaPosrednikId;
    /**
     * The PodnositeljObavijesti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PodnositeljObavijesti;
    /**
     * The PorijekloOtpadaPostotak
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNaseljeJLSZupanijaPostotakOtpadaDTO
     */
    public $PorijekloOtpadaPostotak;
    /**
     * The Posrednik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Posrednik;
    /**
     * The PostupakOporabeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PostupakOporabeID;
    /**
     * The PostupakZbrinjavanjaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PostupakZbrinjavanjaID;
    /**
     * The PostupciOporabeIDs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $PostupciOporabeIDs;
    /**
     * The PostupciZbrinjavanjaIDs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $PostupciZbrinjavanjaIDs;
    /**
     * The Prilog3AId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Prilog3AId;
    /**
     * The Prilog3BId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Prilog3BId;
    /**
     * The Prilog3Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Prilog3Id;
    /**
     * The ProdavateljOtpada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PravnaOsobaObrt
     */
    public $ProdavateljOtpada;
    /**
     * The Proizvod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Proizvod;
    /**
     * The ProizvodiNaLokaciji
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProizvodNaLokacijiModel
     */
    public $ProizvodiNaLokaciji;
    /**
     * The RDPostupakID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RDPostupakID;
    /**
     * The RbrUpisaUOcevidnikUkidanjaSO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RbrUpisaUOcevidnikUkidanjaSO;
    /**
     * The RedniBrojIzjaveUDanu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RedniBrojIzjaveUDanu;
    /**
     * The TijekOtpadaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TijekOtpadaID;
    /**
     * The TipOtpadaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TipOtpadaId;
    /**
     * The VrstaDjelatnostiId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VrstaDjelatnostiId;
    /**
     * Constructor method for TijekOtpadaInput
     * @uses TijekOtpadaInput::setBrojOrgJedinice()
     * @uses TijekOtpadaInput::setBrojPosiljke()
     * @uses TijekOtpadaInput::setDatum()
     * @uses TijekOtpadaInput::setDatumZaprimanjaUvoznik()
     * @uses TijekOtpadaInput::setDrzavaID()
     * @uses TijekOtpadaInput::setIsFizickaOsoba()
     * @uses TijekOtpadaInput::setIsUPKPravnaOsoba()
     * @uses TijekOtpadaInput::setKljucniBrojeviUO_IO()
     * @uses TijekOtpadaInput::setKolicinaOtpadaKg()
     * @uses TijekOtpadaInput::setKompostiranje()
     * @uses TijekOtpadaInput::setLokacijaProdavateljaOtpadaId()
     * @uses TijekOtpadaInput::setLokacijaProdavateljaOtpadaIzSUMPa()
     * @uses TijekOtpadaInput::setMRDOznakaId()
     * @uses TijekOtpadaInput::setNapomena()
     * @uses TijekOtpadaInput::setNasipavanje()
     * @uses TijekOtpadaInput::setNazivOsobeKojaOrganiziraOtpremu()
     * @uses TijekOtpadaInput::setNazivUvoznika()
     * @uses TijekOtpadaInput::setNotifikacijskiBroj()
     * @uses TijekOtpadaInput::setNotifikacijskiBrojId()
     * @uses TijekOtpadaInput::setNumerickaBrOznaka()
     * @uses TijekOtpadaInput::setOIB()
     * @uses TijekOtpadaInput::setOIBBrojPutovnice()
     * @uses TijekOtpadaInput::setOIBKupca()
     * @uses TijekOtpadaInput::setOcevidnikProizvodId()
     * @uses TijekOtpadaInput::setOcevidnikUkidanjaId()
     * @uses TijekOtpadaInput::setOntoID()
     * @uses TijekOtpadaInput::setOpisOtpada()
     * @uses TijekOtpadaInput::setOznakaNacinaID()
     * @uses TijekOtpadaInput::setOznakaPosebneKategorijeID()
     * @uses TijekOtpadaInput::setOznakaPrilogaUredbeID()
     * @uses TijekOtpadaInput::setPFOsobaPosrednikId()
     * @uses TijekOtpadaInput::setPodnositeljObavijesti()
     * @uses TijekOtpadaInput::setPorijekloOtpadaPostotak()
     * @uses TijekOtpadaInput::setPosrednik()
     * @uses TijekOtpadaInput::setPostupakOporabeID()
     * @uses TijekOtpadaInput::setPostupakZbrinjavanjaID()
     * @uses TijekOtpadaInput::setPostupciOporabeIDs()
     * @uses TijekOtpadaInput::setPostupciZbrinjavanjaIDs()
     * @uses TijekOtpadaInput::setPrilog3AId()
     * @uses TijekOtpadaInput::setPrilog3BId()
     * @uses TijekOtpadaInput::setPrilog3Id()
     * @uses TijekOtpadaInput::setProdavateljOtpada()
     * @uses TijekOtpadaInput::setProizvod()
     * @uses TijekOtpadaInput::setProizvodiNaLokaciji()
     * @uses TijekOtpadaInput::setRDPostupakID()
     * @uses TijekOtpadaInput::setRbrUpisaUOcevidnikUkidanjaSO()
     * @uses TijekOtpadaInput::setRedniBrojIzjaveUDanu()
     * @uses TijekOtpadaInput::setTijekOtpadaID()
     * @uses TijekOtpadaInput::setTipOtpadaId()
     * @uses TijekOtpadaInput::setVrstaDjelatnostiId()
     * @param string $brojOrgJedinice
     * @param string $brojPosiljke
     * @param string $datum
     * @param string $datumZaprimanjaUvoznik
     * @param int $drzavaID
     * @param bool $isFizickaOsoba
     * @param bool $isUPKPravnaOsoba
     * @param \ArrayType\ArrayOfKljucniBrojOtpadaModel $kljucniBrojeviUO_IO
     * @param float $kolicinaOtpadaKg
     * @param bool $kompostiranje
     * @param int $lokacijaProdavateljaOtpadaId
     * @param bool $lokacijaProdavateljaOtpadaIzSUMPa
     * @param int $mRDOznakaId
     * @param string $napomena
     * @param bool $nasipavanje
     * @param string $nazivOsobeKojaOrganiziraOtpremu
     * @param string $nazivUvoznika
     * @param string $notifikacijskiBroj
     * @param int $notifikacijskiBrojId
     * @param string $numerickaBrOznaka
     * @param string $oIB
     * @param string $oIBBrojPutovnice
     * @param string $oIBKupca
     * @param int $ocevidnikProizvodId
     * @param int $ocevidnikUkidanjaId
     * @param int $ontoID
     * @param string $opisOtpada
     * @param int $oznakaNacinaID
     * @param int $oznakaPosebneKategorijeID
     * @param int $oznakaPrilogaUredbeID
     * @param int $pFOsobaPosrednikId
     * @param string $podnositeljObavijesti
     * @param \ArrayType\ArrayOfNaseljeJLSZupanijaPostotakOtpadaDTO $porijekloOtpadaPostotak
     * @param bool $posrednik
     * @param int $postupakOporabeID
     * @param int $postupakZbrinjavanjaID
     * @param \ArrayType\ArrayOfint $postupciOporabeIDs
     * @param \ArrayType\ArrayOfint $postupciZbrinjavanjaIDs
     * @param int $prilog3AId
     * @param int $prilog3BId
     * @param int $prilog3Id
     * @param \StructType\PravnaOsobaObrt $prodavateljOtpada
     * @param string $proizvod
     * @param \ArrayType\ArrayOfProizvodNaLokacijiModel $proizvodiNaLokaciji
     * @param int $rDPostupakID
     * @param string $rbrUpisaUOcevidnikUkidanjaSO
     * @param string $redniBrojIzjaveUDanu
     * @param int $tijekOtpadaID
     * @param int $tipOtpadaId
     * @param int $vrstaDjelatnostiId
     */
    public function __construct($brojOrgJedinice = null, $brojPosiljke = null, $datum = null, $datumZaprimanjaUvoznik = null, $drzavaID = null, $isFizickaOsoba = null, $isUPKPravnaOsoba = null, \ArrayType\ArrayOfKljucniBrojOtpadaModel $kljucniBrojeviUO_IO = null, $kolicinaOtpadaKg = null, $kompostiranje = null, $lokacijaProdavateljaOtpadaId = null, $lokacijaProdavateljaOtpadaIzSUMPa = null, $mRDOznakaId = null, $napomena = null, $nasipavanje = null, $nazivOsobeKojaOrganiziraOtpremu = null, $nazivUvoznika = null, $notifikacijskiBroj = null, $notifikacijskiBrojId = null, $numerickaBrOznaka = null, $oIB = null, $oIBBrojPutovnice = null, $oIBKupca = null, $ocevidnikProizvodId = null, $ocevidnikUkidanjaId = null, $ontoID = null, $opisOtpada = null, $oznakaNacinaID = null, $oznakaPosebneKategorijeID = null, $oznakaPrilogaUredbeID = null, $pFOsobaPosrednikId = null, $podnositeljObavijesti = null, \ArrayType\ArrayOfNaseljeJLSZupanijaPostotakOtpadaDTO $porijekloOtpadaPostotak = null, $posrednik = null, $postupakOporabeID = null, $postupakZbrinjavanjaID = null, \ArrayType\ArrayOfint $postupciOporabeIDs = null, \ArrayType\ArrayOfint $postupciZbrinjavanjaIDs = null, $prilog3AId = null, $prilog3BId = null, $prilog3Id = null, \StructType\PravnaOsobaObrt $prodavateljOtpada = null, $proizvod = null, \ArrayType\ArrayOfProizvodNaLokacijiModel $proizvodiNaLokaciji = null, $rDPostupakID = null, $rbrUpisaUOcevidnikUkidanjaSO = null, $redniBrojIzjaveUDanu = null, $tijekOtpadaID = null, $tipOtpadaId = null, $vrstaDjelatnostiId = null)
    {
        $this
            ->setBrojOrgJedinice($brojOrgJedinice)
            ->setBrojPosiljke($brojPosiljke)
            ->setDatum($datum)
            ->setDatumZaprimanjaUvoznik($datumZaprimanjaUvoznik)
            ->setDrzavaID($drzavaID)
            ->setIsFizickaOsoba($isFizickaOsoba)
            ->setIsUPKPravnaOsoba($isUPKPravnaOsoba)
            ->setKljucniBrojeviUO_IO($kljucniBrojeviUO_IO)
            ->setKolicinaOtpadaKg($kolicinaOtpadaKg)
            ->setKompostiranje($kompostiranje)
            ->setLokacijaProdavateljaOtpadaId($lokacijaProdavateljaOtpadaId)
            ->setLokacijaProdavateljaOtpadaIzSUMPa($lokacijaProdavateljaOtpadaIzSUMPa)
            ->setMRDOznakaId($mRDOznakaId)
            ->setNapomena($napomena)
            ->setNasipavanje($nasipavanje)
            ->setNazivOsobeKojaOrganiziraOtpremu($nazivOsobeKojaOrganiziraOtpremu)
            ->setNazivUvoznika($nazivUvoznika)
            ->setNotifikacijskiBroj($notifikacijskiBroj)
            ->setNotifikacijskiBrojId($notifikacijskiBrojId)
            ->setNumerickaBrOznaka($numerickaBrOznaka)
            ->setOIB($oIB)
            ->setOIBBrojPutovnice($oIBBrojPutovnice)
            ->setOIBKupca($oIBKupca)
            ->setOcevidnikProizvodId($ocevidnikProizvodId)
            ->setOcevidnikUkidanjaId($ocevidnikUkidanjaId)
            ->setOntoID($ontoID)
            ->setOpisOtpada($opisOtpada)
            ->setOznakaNacinaID($oznakaNacinaID)
            ->setOznakaPosebneKategorijeID($oznakaPosebneKategorijeID)
            ->setOznakaPrilogaUredbeID($oznakaPrilogaUredbeID)
            ->setPFOsobaPosrednikId($pFOsobaPosrednikId)
            ->setPodnositeljObavijesti($podnositeljObavijesti)
            ->setPorijekloOtpadaPostotak($porijekloOtpadaPostotak)
            ->setPosrednik($posrednik)
            ->setPostupakOporabeID($postupakOporabeID)
            ->setPostupakZbrinjavanjaID($postupakZbrinjavanjaID)
            ->setPostupciOporabeIDs($postupciOporabeIDs)
            ->setPostupciZbrinjavanjaIDs($postupciZbrinjavanjaIDs)
            ->setPrilog3AId($prilog3AId)
            ->setPrilog3BId($prilog3BId)
            ->setPrilog3Id($prilog3Id)
            ->setProdavateljOtpada($prodavateljOtpada)
            ->setProizvod($proizvod)
            ->setProizvodiNaLokaciji($proizvodiNaLokaciji)
            ->setRDPostupakID($rDPostupakID)
            ->setRbrUpisaUOcevidnikUkidanjaSO($rbrUpisaUOcevidnikUkidanjaSO)
            ->setRedniBrojIzjaveUDanu($redniBrojIzjaveUDanu)
            ->setTijekOtpadaID($tijekOtpadaID)
            ->setTipOtpadaId($tipOtpadaId)
            ->setVrstaDjelatnostiId($vrstaDjelatnostiId);
    }
    /**
     * Get BrojOrgJedinice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrojOrgJedinice()
    {
        return isset($this->BrojOrgJedinice) ? $this->BrojOrgJedinice : null;
    }
    /**
     * Set BrojOrgJedinice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brojOrgJedinice
     * @return \StructType\TijekOtpadaInput
     */
    public function setBrojOrgJedinice($brojOrgJedinice = null)
    {
        // validation for constraint: string
        if (!is_null($brojOrgJedinice) && !is_string($brojOrgJedinice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brojOrgJedinice, true), gettype($brojOrgJedinice)), __LINE__);
        }
        if (is_null($brojOrgJedinice) || (is_array($brojOrgJedinice) && empty($brojOrgJedinice))) {
            unset($this->BrojOrgJedinice);
        } else {
            $this->BrojOrgJedinice = $brojOrgJedinice;
        }
        return $this;
    }
    /**
     * Get BrojPosiljke value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrojPosiljke()
    {
        return isset($this->BrojPosiljke) ? $this->BrojPosiljke : null;
    }
    /**
     * Set BrojPosiljke value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brojPosiljke
     * @return \StructType\TijekOtpadaInput
     */
    public function setBrojPosiljke($brojPosiljke = null)
    {
        // validation for constraint: string
        if (!is_null($brojPosiljke) && !is_string($brojPosiljke)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brojPosiljke, true), gettype($brojPosiljke)), __LINE__);
        }
        if (is_null($brojPosiljke) || (is_array($brojPosiljke) && empty($brojPosiljke))) {
            unset($this->BrojPosiljke);
        } else {
            $this->BrojPosiljke = $brojPosiljke;
        }
        return $this;
    }
    /**
     * Get Datum value
     * @return string|null
     */
    public function getDatum()
    {
        return $this->Datum;
    }
    /**
     * Set Datum value
     * @param string $datum
     * @return \StructType\TijekOtpadaInput
     */
    public function setDatum($datum = null)
    {
        // validation for constraint: string
        if (!is_null($datum) && !is_string($datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datum, true), gettype($datum)), __LINE__);
        }
        $this->Datum = $datum;
        return $this;
    }
    /**
     * Get DatumZaprimanjaUvoznik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumZaprimanjaUvoznik()
    {
        return isset($this->DatumZaprimanjaUvoznik) ? $this->DatumZaprimanjaUvoznik : null;
    }
    /**
     * Set DatumZaprimanjaUvoznik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumZaprimanjaUvoznik
     * @return \StructType\TijekOtpadaInput
     */
    public function setDatumZaprimanjaUvoznik($datumZaprimanjaUvoznik = null)
    {
        // validation for constraint: string
        if (!is_null($datumZaprimanjaUvoznik) && !is_string($datumZaprimanjaUvoznik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumZaprimanjaUvoznik, true), gettype($datumZaprimanjaUvoznik)), __LINE__);
        }
        if (is_null($datumZaprimanjaUvoznik) || (is_array($datumZaprimanjaUvoznik) && empty($datumZaprimanjaUvoznik))) {
            unset($this->DatumZaprimanjaUvoznik);
        } else {
            $this->DatumZaprimanjaUvoznik = $datumZaprimanjaUvoznik;
        }
        return $this;
    }
    /**
     * Get DrzavaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDrzavaID()
    {
        return isset($this->DrzavaID) ? $this->DrzavaID : null;
    }
    /**
     * Set DrzavaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $drzavaID
     * @return \StructType\TijekOtpadaInput
     */
    public function setDrzavaID($drzavaID = null)
    {
        // validation for constraint: int
        if (!is_null($drzavaID) && !(is_int($drzavaID) || ctype_digit($drzavaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($drzavaID, true), gettype($drzavaID)), __LINE__);
        }
        if (is_null($drzavaID) || (is_array($drzavaID) && empty($drzavaID))) {
            unset($this->DrzavaID);
        } else {
            $this->DrzavaID = $drzavaID;
        }
        return $this;
    }
    /**
     * Get IsFizickaOsoba value
     * @return bool|null
     */
    public function getIsFizickaOsoba()
    {
        return $this->IsFizickaOsoba;
    }
    /**
     * Set IsFizickaOsoba value
     * @param bool $isFizickaOsoba
     * @return \StructType\TijekOtpadaInput
     */
    public function setIsFizickaOsoba($isFizickaOsoba = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFizickaOsoba) && !is_bool($isFizickaOsoba)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFizickaOsoba, true), gettype($isFizickaOsoba)), __LINE__);
        }
        $this->IsFizickaOsoba = $isFizickaOsoba;
        return $this;
    }
    /**
     * Get IsUPKPravnaOsoba value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUPKPravnaOsoba()
    {
        return isset($this->IsUPKPravnaOsoba) ? $this->IsUPKPravnaOsoba : null;
    }
    /**
     * Set IsUPKPravnaOsoba value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUPKPravnaOsoba
     * @return \StructType\TijekOtpadaInput
     */
    public function setIsUPKPravnaOsoba($isUPKPravnaOsoba = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUPKPravnaOsoba) && !is_bool($isUPKPravnaOsoba)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUPKPravnaOsoba, true), gettype($isUPKPravnaOsoba)), __LINE__);
        }
        if (is_null($isUPKPravnaOsoba) || (is_array($isUPKPravnaOsoba) && empty($isUPKPravnaOsoba))) {
            unset($this->IsUPKPravnaOsoba);
        } else {
            $this->IsUPKPravnaOsoba = $isUPKPravnaOsoba;
        }
        return $this;
    }
    /**
     * Get KljucniBrojeviUO_IO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKljucniBrojOtpadaModel|null
     */
    public function getKljucniBrojeviUO_IO()
    {
        return isset($this->KljucniBrojeviUO_IO) ? $this->KljucniBrojeviUO_IO : null;
    }
    /**
     * Set KljucniBrojeviUO_IO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKljucniBrojOtpadaModel $kljucniBrojeviUO_IO
     * @return \StructType\TijekOtpadaInput
     */
    public function setKljucniBrojeviUO_IO(\ArrayType\ArrayOfKljucniBrojOtpadaModel $kljucniBrojeviUO_IO = null)
    {
        if (is_null($kljucniBrojeviUO_IO) || (is_array($kljucniBrojeviUO_IO) && empty($kljucniBrojeviUO_IO))) {
            unset($this->KljucniBrojeviUO_IO);
        } else {
            $this->KljucniBrojeviUO_IO = $kljucniBrojeviUO_IO;
        }
        return $this;
    }
    /**
     * Get KolicinaOtpadaKg value
     * @return float|null
     */
    public function getKolicinaOtpadaKg()
    {
        return $this->KolicinaOtpadaKg;
    }
    /**
     * Set KolicinaOtpadaKg value
     * @param float $kolicinaOtpadaKg
     * @return \StructType\TijekOtpadaInput
     */
    public function setKolicinaOtpadaKg($kolicinaOtpadaKg = null)
    {
        // validation for constraint: float
        if (!is_null($kolicinaOtpadaKg) && !(is_float($kolicinaOtpadaKg) || is_numeric($kolicinaOtpadaKg))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kolicinaOtpadaKg, true), gettype($kolicinaOtpadaKg)), __LINE__);
        }
        $this->KolicinaOtpadaKg = $kolicinaOtpadaKg;
        return $this;
    }
    /**
     * Get Kompostiranje value
     * @return bool|null
     */
    public function getKompostiranje()
    {
        return $this->Kompostiranje;
    }
    /**
     * Set Kompostiranje value
     * @param bool $kompostiranje
     * @return \StructType\TijekOtpadaInput
     */
    public function setKompostiranje($kompostiranje = null)
    {
        // validation for constraint: boolean
        if (!is_null($kompostiranje) && !is_bool($kompostiranje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kompostiranje, true), gettype($kompostiranje)), __LINE__);
        }
        $this->Kompostiranje = $kompostiranje;
        return $this;
    }
    /**
     * Get LokacijaProdavateljaOtpadaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLokacijaProdavateljaOtpadaId()
    {
        return isset($this->LokacijaProdavateljaOtpadaId) ? $this->LokacijaProdavateljaOtpadaId : null;
    }
    /**
     * Set LokacijaProdavateljaOtpadaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lokacijaProdavateljaOtpadaId
     * @return \StructType\TijekOtpadaInput
     */
    public function setLokacijaProdavateljaOtpadaId($lokacijaProdavateljaOtpadaId = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaProdavateljaOtpadaId) && !(is_int($lokacijaProdavateljaOtpadaId) || ctype_digit($lokacijaProdavateljaOtpadaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaProdavateljaOtpadaId, true), gettype($lokacijaProdavateljaOtpadaId)), __LINE__);
        }
        if (is_null($lokacijaProdavateljaOtpadaId) || (is_array($lokacijaProdavateljaOtpadaId) && empty($lokacijaProdavateljaOtpadaId))) {
            unset($this->LokacijaProdavateljaOtpadaId);
        } else {
            $this->LokacijaProdavateljaOtpadaId = $lokacijaProdavateljaOtpadaId;
        }
        return $this;
    }
    /**
     * Get LokacijaProdavateljaOtpadaIzSUMPa value
     * @return bool|null
     */
    public function getLokacijaProdavateljaOtpadaIzSUMPa()
    {
        return $this->LokacijaProdavateljaOtpadaIzSUMPa;
    }
    /**
     * Set LokacijaProdavateljaOtpadaIzSUMPa value
     * @param bool $lokacijaProdavateljaOtpadaIzSUMPa
     * @return \StructType\TijekOtpadaInput
     */
    public function setLokacijaProdavateljaOtpadaIzSUMPa($lokacijaProdavateljaOtpadaIzSUMPa = null)
    {
        // validation for constraint: boolean
        if (!is_null($lokacijaProdavateljaOtpadaIzSUMPa) && !is_bool($lokacijaProdavateljaOtpadaIzSUMPa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lokacijaProdavateljaOtpadaIzSUMPa, true), gettype($lokacijaProdavateljaOtpadaIzSUMPa)), __LINE__);
        }
        $this->LokacijaProdavateljaOtpadaIzSUMPa = $lokacijaProdavateljaOtpadaIzSUMPa;
        return $this;
    }
    /**
     * Get MRDOznakaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMRDOznakaId()
    {
        return isset($this->MRDOznakaId) ? $this->MRDOznakaId : null;
    }
    /**
     * Set MRDOznakaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mRDOznakaId
     * @return \StructType\TijekOtpadaInput
     */
    public function setMRDOznakaId($mRDOznakaId = null)
    {
        // validation for constraint: int
        if (!is_null($mRDOznakaId) && !(is_int($mRDOznakaId) || ctype_digit($mRDOznakaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mRDOznakaId, true), gettype($mRDOznakaId)), __LINE__);
        }
        if (is_null($mRDOznakaId) || (is_array($mRDOznakaId) && empty($mRDOznakaId))) {
            unset($this->MRDOznakaId);
        } else {
            $this->MRDOznakaId = $mRDOznakaId;
        }
        return $this;
    }
    /**
     * Get Napomena value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNapomena()
    {
        return isset($this->Napomena) ? $this->Napomena : null;
    }
    /**
     * Set Napomena value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $napomena
     * @return \StructType\TijekOtpadaInput
     */
    public function setNapomena($napomena = null)
    {
        // validation for constraint: string
        if (!is_null($napomena) && !is_string($napomena)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($napomena, true), gettype($napomena)), __LINE__);
        }
        if (is_null($napomena) || (is_array($napomena) && empty($napomena))) {
            unset($this->Napomena);
        } else {
            $this->Napomena = $napomena;
        }
        return $this;
    }
    /**
     * Get Nasipavanje value
     * @return bool|null
     */
    public function getNasipavanje()
    {
        return $this->Nasipavanje;
    }
    /**
     * Set Nasipavanje value
     * @param bool $nasipavanje
     * @return \StructType\TijekOtpadaInput
     */
    public function setNasipavanje($nasipavanje = null)
    {
        // validation for constraint: boolean
        if (!is_null($nasipavanje) && !is_bool($nasipavanje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($nasipavanje, true), gettype($nasipavanje)), __LINE__);
        }
        $this->Nasipavanje = $nasipavanje;
        return $this;
    }
    /**
     * Get NazivOsobeKojaOrganiziraOtpremu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNazivOsobeKojaOrganiziraOtpremu()
    {
        return isset($this->NazivOsobeKojaOrganiziraOtpremu) ? $this->NazivOsobeKojaOrganiziraOtpremu : null;
    }
    /**
     * Set NazivOsobeKojaOrganiziraOtpremu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nazivOsobeKojaOrganiziraOtpremu
     * @return \StructType\TijekOtpadaInput
     */
    public function setNazivOsobeKojaOrganiziraOtpremu($nazivOsobeKojaOrganiziraOtpremu = null)
    {
        // validation for constraint: string
        if (!is_null($nazivOsobeKojaOrganiziraOtpremu) && !is_string($nazivOsobeKojaOrganiziraOtpremu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivOsobeKojaOrganiziraOtpremu, true), gettype($nazivOsobeKojaOrganiziraOtpremu)), __LINE__);
        }
        if (is_null($nazivOsobeKojaOrganiziraOtpremu) || (is_array($nazivOsobeKojaOrganiziraOtpremu) && empty($nazivOsobeKojaOrganiziraOtpremu))) {
            unset($this->NazivOsobeKojaOrganiziraOtpremu);
        } else {
            $this->NazivOsobeKojaOrganiziraOtpremu = $nazivOsobeKojaOrganiziraOtpremu;
        }
        return $this;
    }
    /**
     * Get NazivUvoznika value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNazivUvoznika()
    {
        return isset($this->NazivUvoznika) ? $this->NazivUvoznika : null;
    }
    /**
     * Set NazivUvoznika value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nazivUvoznika
     * @return \StructType\TijekOtpadaInput
     */
    public function setNazivUvoznika($nazivUvoznika = null)
    {
        // validation for constraint: string
        if (!is_null($nazivUvoznika) && !is_string($nazivUvoznika)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivUvoznika, true), gettype($nazivUvoznika)), __LINE__);
        }
        if (is_null($nazivUvoznika) || (is_array($nazivUvoznika) && empty($nazivUvoznika))) {
            unset($this->NazivUvoznika);
        } else {
            $this->NazivUvoznika = $nazivUvoznika;
        }
        return $this;
    }
    /**
     * Get NotifikacijskiBroj value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotifikacijskiBroj()
    {
        return isset($this->NotifikacijskiBroj) ? $this->NotifikacijskiBroj : null;
    }
    /**
     * Set NotifikacijskiBroj value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notifikacijskiBroj
     * @return \StructType\TijekOtpadaInput
     */
    public function setNotifikacijskiBroj($notifikacijskiBroj = null)
    {
        // validation for constraint: string
        if (!is_null($notifikacijskiBroj) && !is_string($notifikacijskiBroj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notifikacijskiBroj, true), gettype($notifikacijskiBroj)), __LINE__);
        }
        if (is_null($notifikacijskiBroj) || (is_array($notifikacijskiBroj) && empty($notifikacijskiBroj))) {
            unset($this->NotifikacijskiBroj);
        } else {
            $this->NotifikacijskiBroj = $notifikacijskiBroj;
        }
        return $this;
    }
    /**
     * Get NotifikacijskiBrojId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNotifikacijskiBrojId()
    {
        return isset($this->NotifikacijskiBrojId) ? $this->NotifikacijskiBrojId : null;
    }
    /**
     * Set NotifikacijskiBrojId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $notifikacijskiBrojId
     * @return \StructType\TijekOtpadaInput
     */
    public function setNotifikacijskiBrojId($notifikacijskiBrojId = null)
    {
        // validation for constraint: int
        if (!is_null($notifikacijskiBrojId) && !(is_int($notifikacijskiBrojId) || ctype_digit($notifikacijskiBrojId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($notifikacijskiBrojId, true), gettype($notifikacijskiBrojId)), __LINE__);
        }
        if (is_null($notifikacijskiBrojId) || (is_array($notifikacijskiBrojId) && empty($notifikacijskiBrojId))) {
            unset($this->NotifikacijskiBrojId);
        } else {
            $this->NotifikacijskiBrojId = $notifikacijskiBrojId;
        }
        return $this;
    }
    /**
     * Get NumerickaBrOznaka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumerickaBrOznaka()
    {
        return isset($this->NumerickaBrOznaka) ? $this->NumerickaBrOznaka : null;
    }
    /**
     * Set NumerickaBrOznaka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numerickaBrOznaka
     * @return \StructType\TijekOtpadaInput
     */
    public function setNumerickaBrOznaka($numerickaBrOznaka = null)
    {
        // validation for constraint: string
        if (!is_null($numerickaBrOznaka) && !is_string($numerickaBrOznaka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerickaBrOznaka, true), gettype($numerickaBrOznaka)), __LINE__);
        }
        if (is_null($numerickaBrOznaka) || (is_array($numerickaBrOznaka) && empty($numerickaBrOznaka))) {
            unset($this->NumerickaBrOznaka);
        } else {
            $this->NumerickaBrOznaka = $numerickaBrOznaka;
        }
        return $this;
    }
    /**
     * Get OIB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOIB()
    {
        return isset($this->OIB) ? $this->OIB : null;
    }
    /**
     * Set OIB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oIB
     * @return \StructType\TijekOtpadaInput
     */
    public function setOIB($oIB = null)
    {
        // validation for constraint: string
        if (!is_null($oIB) && !is_string($oIB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oIB, true), gettype($oIB)), __LINE__);
        }
        if (is_null($oIB) || (is_array($oIB) && empty($oIB))) {
            unset($this->OIB);
        } else {
            $this->OIB = $oIB;
        }
        return $this;
    }
    /**
     * Get OIBBrojPutovnice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOIBBrojPutovnice()
    {
        return isset($this->OIBBrojPutovnice) ? $this->OIBBrojPutovnice : null;
    }
    /**
     * Set OIBBrojPutovnice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oIBBrojPutovnice
     * @return \StructType\TijekOtpadaInput
     */
    public function setOIBBrojPutovnice($oIBBrojPutovnice = null)
    {
        // validation for constraint: string
        if (!is_null($oIBBrojPutovnice) && !is_string($oIBBrojPutovnice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oIBBrojPutovnice, true), gettype($oIBBrojPutovnice)), __LINE__);
        }
        if (is_null($oIBBrojPutovnice) || (is_array($oIBBrojPutovnice) && empty($oIBBrojPutovnice))) {
            unset($this->OIBBrojPutovnice);
        } else {
            $this->OIBBrojPutovnice = $oIBBrojPutovnice;
        }
        return $this;
    }
    /**
     * Get OIBKupca value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOIBKupca()
    {
        return isset($this->OIBKupca) ? $this->OIBKupca : null;
    }
    /**
     * Set OIBKupca value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oIBKupca
     * @return \StructType\TijekOtpadaInput
     */
    public function setOIBKupca($oIBKupca = null)
    {
        // validation for constraint: string
        if (!is_null($oIBKupca) && !is_string($oIBKupca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oIBKupca, true), gettype($oIBKupca)), __LINE__);
        }
        if (is_null($oIBKupca) || (is_array($oIBKupca) && empty($oIBKupca))) {
            unset($this->OIBKupca);
        } else {
            $this->OIBKupca = $oIBKupca;
        }
        return $this;
    }
    /**
     * Get OcevidnikProizvodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOcevidnikProizvodId()
    {
        return isset($this->OcevidnikProizvodId) ? $this->OcevidnikProizvodId : null;
    }
    /**
     * Set OcevidnikProizvodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ocevidnikProizvodId
     * @return \StructType\TijekOtpadaInput
     */
    public function setOcevidnikProizvodId($ocevidnikProizvodId = null)
    {
        // validation for constraint: int
        if (!is_null($ocevidnikProizvodId) && !(is_int($ocevidnikProizvodId) || ctype_digit($ocevidnikProizvodId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ocevidnikProizvodId, true), gettype($ocevidnikProizvodId)), __LINE__);
        }
        if (is_null($ocevidnikProizvodId) || (is_array($ocevidnikProizvodId) && empty($ocevidnikProizvodId))) {
            unset($this->OcevidnikProizvodId);
        } else {
            $this->OcevidnikProizvodId = $ocevidnikProizvodId;
        }
        return $this;
    }
    /**
     * Get OcevidnikUkidanjaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOcevidnikUkidanjaId()
    {
        return isset($this->OcevidnikUkidanjaId) ? $this->OcevidnikUkidanjaId : null;
    }
    /**
     * Set OcevidnikUkidanjaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ocevidnikUkidanjaId
     * @return \StructType\TijekOtpadaInput
     */
    public function setOcevidnikUkidanjaId($ocevidnikUkidanjaId = null)
    {
        // validation for constraint: int
        if (!is_null($ocevidnikUkidanjaId) && !(is_int($ocevidnikUkidanjaId) || ctype_digit($ocevidnikUkidanjaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ocevidnikUkidanjaId, true), gettype($ocevidnikUkidanjaId)), __LINE__);
        }
        if (is_null($ocevidnikUkidanjaId) || (is_array($ocevidnikUkidanjaId) && empty($ocevidnikUkidanjaId))) {
            unset($this->OcevidnikUkidanjaId);
        } else {
            $this->OcevidnikUkidanjaId = $ocevidnikUkidanjaId;
        }
        return $this;
    }
    /**
     * Get OntoID value
     * @return int|null
     */
    public function getOntoID()
    {
        return $this->OntoID;
    }
    /**
     * Set OntoID value
     * @param int $ontoID
     * @return \StructType\TijekOtpadaInput
     */
    public function setOntoID($ontoID = null)
    {
        // validation for constraint: int
        if (!is_null($ontoID) && !(is_int($ontoID) || ctype_digit($ontoID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ontoID, true), gettype($ontoID)), __LINE__);
        }
        $this->OntoID = $ontoID;
        return $this;
    }
    /**
     * Get OpisOtpada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpisOtpada()
    {
        return isset($this->OpisOtpada) ? $this->OpisOtpada : null;
    }
    /**
     * Set OpisOtpada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opisOtpada
     * @return \StructType\TijekOtpadaInput
     */
    public function setOpisOtpada($opisOtpada = null)
    {
        // validation for constraint: string
        if (!is_null($opisOtpada) && !is_string($opisOtpada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opisOtpada, true), gettype($opisOtpada)), __LINE__);
        }
        if (is_null($opisOtpada) || (is_array($opisOtpada) && empty($opisOtpada))) {
            unset($this->OpisOtpada);
        } else {
            $this->OpisOtpada = $opisOtpada;
        }
        return $this;
    }
    /**
     * Get OznakaNacinaID value
     * @return int|null
     */
    public function getOznakaNacinaID()
    {
        return $this->OznakaNacinaID;
    }
    /**
     * Set OznakaNacinaID value
     * @param int $oznakaNacinaID
     * @return \StructType\TijekOtpadaInput
     */
    public function setOznakaNacinaID($oznakaNacinaID = null)
    {
        // validation for constraint: int
        if (!is_null($oznakaNacinaID) && !(is_int($oznakaNacinaID) || ctype_digit($oznakaNacinaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oznakaNacinaID, true), gettype($oznakaNacinaID)), __LINE__);
        }
        $this->OznakaNacinaID = $oznakaNacinaID;
        return $this;
    }
    /**
     * Get OznakaPosebneKategorijeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOznakaPosebneKategorijeID()
    {
        return isset($this->OznakaPosebneKategorijeID) ? $this->OznakaPosebneKategorijeID : null;
    }
    /**
     * Set OznakaPosebneKategorijeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $oznakaPosebneKategorijeID
     * @return \StructType\TijekOtpadaInput
     */
    public function setOznakaPosebneKategorijeID($oznakaPosebneKategorijeID = null)
    {
        // validation for constraint: int
        if (!is_null($oznakaPosebneKategorijeID) && !(is_int($oznakaPosebneKategorijeID) || ctype_digit($oznakaPosebneKategorijeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oznakaPosebneKategorijeID, true), gettype($oznakaPosebneKategorijeID)), __LINE__);
        }
        if (is_null($oznakaPosebneKategorijeID) || (is_array($oznakaPosebneKategorijeID) && empty($oznakaPosebneKategorijeID))) {
            unset($this->OznakaPosebneKategorijeID);
        } else {
            $this->OznakaPosebneKategorijeID = $oznakaPosebneKategorijeID;
        }
        return $this;
    }
    /**
     * Get OznakaPrilogaUredbeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOznakaPrilogaUredbeID()
    {
        return isset($this->OznakaPrilogaUredbeID) ? $this->OznakaPrilogaUredbeID : null;
    }
    /**
     * Set OznakaPrilogaUredbeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $oznakaPrilogaUredbeID
     * @return \StructType\TijekOtpadaInput
     */
    public function setOznakaPrilogaUredbeID($oznakaPrilogaUredbeID = null)
    {
        // validation for constraint: int
        if (!is_null($oznakaPrilogaUredbeID) && !(is_int($oznakaPrilogaUredbeID) || ctype_digit($oznakaPrilogaUredbeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oznakaPrilogaUredbeID, true), gettype($oznakaPrilogaUredbeID)), __LINE__);
        }
        if (is_null($oznakaPrilogaUredbeID) || (is_array($oznakaPrilogaUredbeID) && empty($oznakaPrilogaUredbeID))) {
            unset($this->OznakaPrilogaUredbeID);
        } else {
            $this->OznakaPrilogaUredbeID = $oznakaPrilogaUredbeID;
        }
        return $this;
    }
    /**
     * Get PFOsobaPosrednikId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPFOsobaPosrednikId()
    {
        return isset($this->PFOsobaPosrednikId) ? $this->PFOsobaPosrednikId : null;
    }
    /**
     * Set PFOsobaPosrednikId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pFOsobaPosrednikId
     * @return \StructType\TijekOtpadaInput
     */
    public function setPFOsobaPosrednikId($pFOsobaPosrednikId = null)
    {
        // validation for constraint: int
        if (!is_null($pFOsobaPosrednikId) && !(is_int($pFOsobaPosrednikId) || ctype_digit($pFOsobaPosrednikId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pFOsobaPosrednikId, true), gettype($pFOsobaPosrednikId)), __LINE__);
        }
        if (is_null($pFOsobaPosrednikId) || (is_array($pFOsobaPosrednikId) && empty($pFOsobaPosrednikId))) {
            unset($this->PFOsobaPosrednikId);
        } else {
            $this->PFOsobaPosrednikId = $pFOsobaPosrednikId;
        }
        return $this;
    }
    /**
     * Get PodnositeljObavijesti value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPodnositeljObavijesti()
    {
        return isset($this->PodnositeljObavijesti) ? $this->PodnositeljObavijesti : null;
    }
    /**
     * Set PodnositeljObavijesti value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $podnositeljObavijesti
     * @return \StructType\TijekOtpadaInput
     */
    public function setPodnositeljObavijesti($podnositeljObavijesti = null)
    {
        // validation for constraint: string
        if (!is_null($podnositeljObavijesti) && !is_string($podnositeljObavijesti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($podnositeljObavijesti, true), gettype($podnositeljObavijesti)), __LINE__);
        }
        if (is_null($podnositeljObavijesti) || (is_array($podnositeljObavijesti) && empty($podnositeljObavijesti))) {
            unset($this->PodnositeljObavijesti);
        } else {
            $this->PodnositeljObavijesti = $podnositeljObavijesti;
        }
        return $this;
    }
    /**
     * Get PorijekloOtpadaPostotak value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNaseljeJLSZupanijaPostotakOtpadaDTO|null
     */
    public function getPorijekloOtpadaPostotak()
    {
        return isset($this->PorijekloOtpadaPostotak) ? $this->PorijekloOtpadaPostotak : null;
    }
    /**
     * Set PorijekloOtpadaPostotak value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNaseljeJLSZupanijaPostotakOtpadaDTO $porijekloOtpadaPostotak
     * @return \StructType\TijekOtpadaInput
     */
    public function setPorijekloOtpadaPostotak(\ArrayType\ArrayOfNaseljeJLSZupanijaPostotakOtpadaDTO $porijekloOtpadaPostotak = null)
    {
        if (is_null($porijekloOtpadaPostotak) || (is_array($porijekloOtpadaPostotak) && empty($porijekloOtpadaPostotak))) {
            unset($this->PorijekloOtpadaPostotak);
        } else {
            $this->PorijekloOtpadaPostotak = $porijekloOtpadaPostotak;
        }
        return $this;
    }
    /**
     * Get Posrednik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPosrednik()
    {
        return isset($this->Posrednik) ? $this->Posrednik : null;
    }
    /**
     * Set Posrednik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $posrednik
     * @return \StructType\TijekOtpadaInput
     */
    public function setPosrednik($posrednik = null)
    {
        // validation for constraint: boolean
        if (!is_null($posrednik) && !is_bool($posrednik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($posrednik, true), gettype($posrednik)), __LINE__);
        }
        if (is_null($posrednik) || (is_array($posrednik) && empty($posrednik))) {
            unset($this->Posrednik);
        } else {
            $this->Posrednik = $posrednik;
        }
        return $this;
    }
    /**
     * Get PostupakOporabeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPostupakOporabeID()
    {
        return isset($this->PostupakOporabeID) ? $this->PostupakOporabeID : null;
    }
    /**
     * Set PostupakOporabeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $postupakOporabeID
     * @return \StructType\TijekOtpadaInput
     */
    public function setPostupakOporabeID($postupakOporabeID = null)
    {
        // validation for constraint: int
        if (!is_null($postupakOporabeID) && !(is_int($postupakOporabeID) || ctype_digit($postupakOporabeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postupakOporabeID, true), gettype($postupakOporabeID)), __LINE__);
        }
        if (is_null($postupakOporabeID) || (is_array($postupakOporabeID) && empty($postupakOporabeID))) {
            unset($this->PostupakOporabeID);
        } else {
            $this->PostupakOporabeID = $postupakOporabeID;
        }
        return $this;
    }
    /**
     * Get PostupakZbrinjavanjaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPostupakZbrinjavanjaID()
    {
        return isset($this->PostupakZbrinjavanjaID) ? $this->PostupakZbrinjavanjaID : null;
    }
    /**
     * Set PostupakZbrinjavanjaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $postupakZbrinjavanjaID
     * @return \StructType\TijekOtpadaInput
     */
    public function setPostupakZbrinjavanjaID($postupakZbrinjavanjaID = null)
    {
        // validation for constraint: int
        if (!is_null($postupakZbrinjavanjaID) && !(is_int($postupakZbrinjavanjaID) || ctype_digit($postupakZbrinjavanjaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($postupakZbrinjavanjaID, true), gettype($postupakZbrinjavanjaID)), __LINE__);
        }
        if (is_null($postupakZbrinjavanjaID) || (is_array($postupakZbrinjavanjaID) && empty($postupakZbrinjavanjaID))) {
            unset($this->PostupakZbrinjavanjaID);
        } else {
            $this->PostupakZbrinjavanjaID = $postupakZbrinjavanjaID;
        }
        return $this;
    }
    /**
     * Get PostupciOporabeIDs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getPostupciOporabeIDs()
    {
        return isset($this->PostupciOporabeIDs) ? $this->PostupciOporabeIDs : null;
    }
    /**
     * Set PostupciOporabeIDs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $postupciOporabeIDs
     * @return \StructType\TijekOtpadaInput
     */
    public function setPostupciOporabeIDs(\ArrayType\ArrayOfint $postupciOporabeIDs = null)
    {
        if (is_null($postupciOporabeIDs) || (is_array($postupciOporabeIDs) && empty($postupciOporabeIDs))) {
            unset($this->PostupciOporabeIDs);
        } else {
            $this->PostupciOporabeIDs = $postupciOporabeIDs;
        }
        return $this;
    }
    /**
     * Get PostupciZbrinjavanjaIDs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getPostupciZbrinjavanjaIDs()
    {
        return isset($this->PostupciZbrinjavanjaIDs) ? $this->PostupciZbrinjavanjaIDs : null;
    }
    /**
     * Set PostupciZbrinjavanjaIDs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $postupciZbrinjavanjaIDs
     * @return \StructType\TijekOtpadaInput
     */
    public function setPostupciZbrinjavanjaIDs(\ArrayType\ArrayOfint $postupciZbrinjavanjaIDs = null)
    {
        if (is_null($postupciZbrinjavanjaIDs) || (is_array($postupciZbrinjavanjaIDs) && empty($postupciZbrinjavanjaIDs))) {
            unset($this->PostupciZbrinjavanjaIDs);
        } else {
            $this->PostupciZbrinjavanjaIDs = $postupciZbrinjavanjaIDs;
        }
        return $this;
    }
    /**
     * Get Prilog3AId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrilog3AId()
    {
        return isset($this->Prilog3AId) ? $this->Prilog3AId : null;
    }
    /**
     * Set Prilog3AId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prilog3AId
     * @return \StructType\TijekOtpadaInput
     */
    public function setPrilog3AId($prilog3AId = null)
    {
        // validation for constraint: int
        if (!is_null($prilog3AId) && !(is_int($prilog3AId) || ctype_digit($prilog3AId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prilog3AId, true), gettype($prilog3AId)), __LINE__);
        }
        if (is_null($prilog3AId) || (is_array($prilog3AId) && empty($prilog3AId))) {
            unset($this->Prilog3AId);
        } else {
            $this->Prilog3AId = $prilog3AId;
        }
        return $this;
    }
    /**
     * Get Prilog3BId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrilog3BId()
    {
        return isset($this->Prilog3BId) ? $this->Prilog3BId : null;
    }
    /**
     * Set Prilog3BId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prilog3BId
     * @return \StructType\TijekOtpadaInput
     */
    public function setPrilog3BId($prilog3BId = null)
    {
        // validation for constraint: int
        if (!is_null($prilog3BId) && !(is_int($prilog3BId) || ctype_digit($prilog3BId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prilog3BId, true), gettype($prilog3BId)), __LINE__);
        }
        if (is_null($prilog3BId) || (is_array($prilog3BId) && empty($prilog3BId))) {
            unset($this->Prilog3BId);
        } else {
            $this->Prilog3BId = $prilog3BId;
        }
        return $this;
    }
    /**
     * Get Prilog3Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrilog3Id()
    {
        return isset($this->Prilog3Id) ? $this->Prilog3Id : null;
    }
    /**
     * Set Prilog3Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prilog3Id
     * @return \StructType\TijekOtpadaInput
     */
    public function setPrilog3Id($prilog3Id = null)
    {
        // validation for constraint: int
        if (!is_null($prilog3Id) && !(is_int($prilog3Id) || ctype_digit($prilog3Id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prilog3Id, true), gettype($prilog3Id)), __LINE__);
        }
        if (is_null($prilog3Id) || (is_array($prilog3Id) && empty($prilog3Id))) {
            unset($this->Prilog3Id);
        } else {
            $this->Prilog3Id = $prilog3Id;
        }
        return $this;
    }
    /**
     * Get ProdavateljOtpada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PravnaOsobaObrt|null
     */
    public function getProdavateljOtpada()
    {
        return isset($this->ProdavateljOtpada) ? $this->ProdavateljOtpada : null;
    }
    /**
     * Set ProdavateljOtpada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PravnaOsobaObrt $prodavateljOtpada
     * @return \StructType\TijekOtpadaInput
     */
    public function setProdavateljOtpada(\StructType\PravnaOsobaObrt $prodavateljOtpada = null)
    {
        if (is_null($prodavateljOtpada) || (is_array($prodavateljOtpada) && empty($prodavateljOtpada))) {
            unset($this->ProdavateljOtpada);
        } else {
            $this->ProdavateljOtpada = $prodavateljOtpada;
        }
        return $this;
    }
    /**
     * Get Proizvod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProizvod()
    {
        return isset($this->Proizvod) ? $this->Proizvod : null;
    }
    /**
     * Set Proizvod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $proizvod
     * @return \StructType\TijekOtpadaInput
     */
    public function setProizvod($proizvod = null)
    {
        // validation for constraint: string
        if (!is_null($proizvod) && !is_string($proizvod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proizvod, true), gettype($proizvod)), __LINE__);
        }
        if (is_null($proizvod) || (is_array($proizvod) && empty($proizvod))) {
            unset($this->Proizvod);
        } else {
            $this->Proizvod = $proizvod;
        }
        return $this;
    }
    /**
     * Get ProizvodiNaLokaciji value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProizvodNaLokacijiModel|null
     */
    public function getProizvodiNaLokaciji()
    {
        return isset($this->ProizvodiNaLokaciji) ? $this->ProizvodiNaLokaciji : null;
    }
    /**
     * Set ProizvodiNaLokaciji value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProizvodNaLokacijiModel $proizvodiNaLokaciji
     * @return \StructType\TijekOtpadaInput
     */
    public function setProizvodiNaLokaciji(\ArrayType\ArrayOfProizvodNaLokacijiModel $proizvodiNaLokaciji = null)
    {
        if (is_null($proizvodiNaLokaciji) || (is_array($proizvodiNaLokaciji) && empty($proizvodiNaLokaciji))) {
            unset($this->ProizvodiNaLokaciji);
        } else {
            $this->ProizvodiNaLokaciji = $proizvodiNaLokaciji;
        }
        return $this;
    }
    /**
     * Get RDPostupakID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRDPostupakID()
    {
        return isset($this->RDPostupakID) ? $this->RDPostupakID : null;
    }
    /**
     * Set RDPostupakID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rDPostupakID
     * @return \StructType\TijekOtpadaInput
     */
    public function setRDPostupakID($rDPostupakID = null)
    {
        // validation for constraint: int
        if (!is_null($rDPostupakID) && !(is_int($rDPostupakID) || ctype_digit($rDPostupakID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rDPostupakID, true), gettype($rDPostupakID)), __LINE__);
        }
        if (is_null($rDPostupakID) || (is_array($rDPostupakID) && empty($rDPostupakID))) {
            unset($this->RDPostupakID);
        } else {
            $this->RDPostupakID = $rDPostupakID;
        }
        return $this;
    }
    /**
     * Get RbrUpisaUOcevidnikUkidanjaSO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRbrUpisaUOcevidnikUkidanjaSO()
    {
        return isset($this->RbrUpisaUOcevidnikUkidanjaSO) ? $this->RbrUpisaUOcevidnikUkidanjaSO : null;
    }
    /**
     * Set RbrUpisaUOcevidnikUkidanjaSO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rbrUpisaUOcevidnikUkidanjaSO
     * @return \StructType\TijekOtpadaInput
     */
    public function setRbrUpisaUOcevidnikUkidanjaSO($rbrUpisaUOcevidnikUkidanjaSO = null)
    {
        // validation for constraint: string
        if (!is_null($rbrUpisaUOcevidnikUkidanjaSO) && !is_string($rbrUpisaUOcevidnikUkidanjaSO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rbrUpisaUOcevidnikUkidanjaSO, true), gettype($rbrUpisaUOcevidnikUkidanjaSO)), __LINE__);
        }
        if (is_null($rbrUpisaUOcevidnikUkidanjaSO) || (is_array($rbrUpisaUOcevidnikUkidanjaSO) && empty($rbrUpisaUOcevidnikUkidanjaSO))) {
            unset($this->RbrUpisaUOcevidnikUkidanjaSO);
        } else {
            $this->RbrUpisaUOcevidnikUkidanjaSO = $rbrUpisaUOcevidnikUkidanjaSO;
        }
        return $this;
    }
    /**
     * Get RedniBrojIzjaveUDanu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRedniBrojIzjaveUDanu()
    {
        return isset($this->RedniBrojIzjaveUDanu) ? $this->RedniBrojIzjaveUDanu : null;
    }
    /**
     * Set RedniBrojIzjaveUDanu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $redniBrojIzjaveUDanu
     * @return \StructType\TijekOtpadaInput
     */
    public function setRedniBrojIzjaveUDanu($redniBrojIzjaveUDanu = null)
    {
        // validation for constraint: string
        if (!is_null($redniBrojIzjaveUDanu) && !is_string($redniBrojIzjaveUDanu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redniBrojIzjaveUDanu, true), gettype($redniBrojIzjaveUDanu)), __LINE__);
        }
        if (is_null($redniBrojIzjaveUDanu) || (is_array($redniBrojIzjaveUDanu) && empty($redniBrojIzjaveUDanu))) {
            unset($this->RedniBrojIzjaveUDanu);
        } else {
            $this->RedniBrojIzjaveUDanu = $redniBrojIzjaveUDanu;
        }
        return $this;
    }
    /**
     * Get TijekOtpadaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTijekOtpadaID()
    {
        return isset($this->TijekOtpadaID) ? $this->TijekOtpadaID : null;
    }
    /**
     * Set TijekOtpadaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tijekOtpadaID
     * @return \StructType\TijekOtpadaInput
     */
    public function setTijekOtpadaID($tijekOtpadaID = null)
    {
        // validation for constraint: int
        if (!is_null($tijekOtpadaID) && !(is_int($tijekOtpadaID) || ctype_digit($tijekOtpadaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tijekOtpadaID, true), gettype($tijekOtpadaID)), __LINE__);
        }
        if (is_null($tijekOtpadaID) || (is_array($tijekOtpadaID) && empty($tijekOtpadaID))) {
            unset($this->TijekOtpadaID);
        } else {
            $this->TijekOtpadaID = $tijekOtpadaID;
        }
        return $this;
    }
    /**
     * Get TipOtpadaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTipOtpadaId()
    {
        return isset($this->TipOtpadaId) ? $this->TipOtpadaId : null;
    }
    /**
     * Set TipOtpadaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tipOtpadaId
     * @return \StructType\TijekOtpadaInput
     */
    public function setTipOtpadaId($tipOtpadaId = null)
    {
        // validation for constraint: int
        if (!is_null($tipOtpadaId) && !(is_int($tipOtpadaId) || ctype_digit($tipOtpadaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipOtpadaId, true), gettype($tipOtpadaId)), __LINE__);
        }
        if (is_null($tipOtpadaId) || (is_array($tipOtpadaId) && empty($tipOtpadaId))) {
            unset($this->TipOtpadaId);
        } else {
            $this->TipOtpadaId = $tipOtpadaId;
        }
        return $this;
    }
    /**
     * Get VrstaDjelatnostiId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVrstaDjelatnostiId()
    {
        return isset($this->VrstaDjelatnostiId) ? $this->VrstaDjelatnostiId : null;
    }
    /**
     * Set VrstaDjelatnostiId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $vrstaDjelatnostiId
     * @return \StructType\TijekOtpadaInput
     */
    public function setVrstaDjelatnostiId($vrstaDjelatnostiId = null)
    {
        // validation for constraint: int
        if (!is_null($vrstaDjelatnostiId) && !(is_int($vrstaDjelatnostiId) || ctype_digit($vrstaDjelatnostiId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vrstaDjelatnostiId, true), gettype($vrstaDjelatnostiId)), __LINE__);
        }
        if (is_null($vrstaDjelatnostiId) || (is_array($vrstaDjelatnostiId) && empty($vrstaDjelatnostiId))) {
            unset($this->VrstaDjelatnostiId);
        } else {
            $this->VrstaDjelatnostiId = $vrstaDjelatnostiId;
        }
        return $this;
    }
}
