<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Privitak StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Privitak
 * @subpackage Structs
 */
class Privitak extends AbstractStructBase
{
    /**
     * The Datoteka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Datoteka;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The NazivDatoteke
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NazivDatoteke;
    /**
     * The Poruka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Poruka
     */
    public $Poruka;
    /**
     * The PorukaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PorukaID;
    /**
     * The PrivitakID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PrivitakID;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * The Putanja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Putanja;
    /**
     * The TipDatoteke
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipDatoteke;
    /**
     * Constructor method for Privitak
     * @uses Privitak::setDatoteka()
     * @uses Privitak::setDatumKreiranja()
     * @uses Privitak::setDatumPromjene()
     * @uses Privitak::setKreirao()
     * @uses Privitak::setNazivDatoteke()
     * @uses Privitak::setPoruka()
     * @uses Privitak::setPorukaID()
     * @uses Privitak::setPrivitakID()
     * @uses Privitak::setPromijenio()
     * @uses Privitak::setPutanja()
     * @uses Privitak::setTipDatoteke()
     * @param string $datoteka
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param string $kreirao
     * @param string $nazivDatoteke
     * @param \StructType\Poruka $poruka
     * @param int $porukaID
     * @param int $privitakID
     * @param string $promijenio
     * @param string $putanja
     * @param string $tipDatoteke
     */
    public function __construct($datoteka = null, $datumKreiranja = null, $datumPromjene = null, $kreirao = null, $nazivDatoteke = null, \StructType\Poruka $poruka = null, $porukaID = null, $privitakID = null, $promijenio = null, $putanja = null, $tipDatoteke = null)
    {
        $this
            ->setDatoteka($datoteka)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setKreirao($kreirao)
            ->setNazivDatoteke($nazivDatoteke)
            ->setPoruka($poruka)
            ->setPorukaID($porukaID)
            ->setPrivitakID($privitakID)
            ->setPromijenio($promijenio)
            ->setPutanja($putanja)
            ->setTipDatoteke($tipDatoteke);
    }
    /**
     * Get Datoteka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatoteka()
    {
        return isset($this->Datoteka) ? $this->Datoteka : null;
    }
    /**
     * Set Datoteka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datoteka
     * @return \StructType\Privitak
     */
    public function setDatoteka($datoteka = null)
    {
        // validation for constraint: string
        if (!is_null($datoteka) && !is_string($datoteka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datoteka, true), gettype($datoteka)), __LINE__);
        }
        if (is_null($datoteka) || (is_array($datoteka) && empty($datoteka))) {
            unset($this->Datoteka);
        } else {
            $this->Datoteka = $datoteka;
        }
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\Privitak
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\Privitak
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\Privitak
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get NazivDatoteke value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNazivDatoteke()
    {
        return isset($this->NazivDatoteke) ? $this->NazivDatoteke : null;
    }
    /**
     * Set NazivDatoteke value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nazivDatoteke
     * @return \StructType\Privitak
     */
    public function setNazivDatoteke($nazivDatoteke = null)
    {
        // validation for constraint: string
        if (!is_null($nazivDatoteke) && !is_string($nazivDatoteke)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivDatoteke, true), gettype($nazivDatoteke)), __LINE__);
        }
        if (is_null($nazivDatoteke) || (is_array($nazivDatoteke) && empty($nazivDatoteke))) {
            unset($this->NazivDatoteke);
        } else {
            $this->NazivDatoteke = $nazivDatoteke;
        }
        return $this;
    }
    /**
     * Get Poruka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Poruka|null
     */
    public function getPoruka()
    {
        return isset($this->Poruka) ? $this->Poruka : null;
    }
    /**
     * Set Poruka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Poruka $poruka
     * @return \StructType\Privitak
     */
    public function setPoruka(\StructType\Poruka $poruka = null)
    {
        if (is_null($poruka) || (is_array($poruka) && empty($poruka))) {
            unset($this->Poruka);
        } else {
            $this->Poruka = $poruka;
        }
        return $this;
    }
    /**
     * Get PorukaID value
     * @return int|null
     */
    public function getPorukaID()
    {
        return $this->PorukaID;
    }
    /**
     * Set PorukaID value
     * @param int $porukaID
     * @return \StructType\Privitak
     */
    public function setPorukaID($porukaID = null)
    {
        // validation for constraint: int
        if (!is_null($porukaID) && !(is_int($porukaID) || ctype_digit($porukaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($porukaID, true), gettype($porukaID)), __LINE__);
        }
        $this->PorukaID = $porukaID;
        return $this;
    }
    /**
     * Get PrivitakID value
     * @return int|null
     */
    public function getPrivitakID()
    {
        return $this->PrivitakID;
    }
    /**
     * Set PrivitakID value
     * @param int $privitakID
     * @return \StructType\Privitak
     */
    public function setPrivitakID($privitakID = null)
    {
        // validation for constraint: int
        if (!is_null($privitakID) && !(is_int($privitakID) || ctype_digit($privitakID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($privitakID, true), gettype($privitakID)), __LINE__);
        }
        $this->PrivitakID = $privitakID;
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\Privitak
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
    /**
     * Get Putanja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPutanja()
    {
        return isset($this->Putanja) ? $this->Putanja : null;
    }
    /**
     * Set Putanja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $putanja
     * @return \StructType\Privitak
     */
    public function setPutanja($putanja = null)
    {
        // validation for constraint: string
        if (!is_null($putanja) && !is_string($putanja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($putanja, true), gettype($putanja)), __LINE__);
        }
        if (is_null($putanja) || (is_array($putanja) && empty($putanja))) {
            unset($this->Putanja);
        } else {
            $this->Putanja = $putanja;
        }
        return $this;
    }
    /**
     * Get TipDatoteke value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipDatoteke()
    {
        return isset($this->TipDatoteke) ? $this->TipDatoteke : null;
    }
    /**
     * Set TipDatoteke value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipDatoteke
     * @return \StructType\Privitak
     */
    public function setTipDatoteke($tipDatoteke = null)
    {
        // validation for constraint: string
        if (!is_null($tipDatoteke) && !is_string($tipDatoteke)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipDatoteke, true), gettype($tipDatoteke)), __LINE__);
        }
        if (is_null($tipDatoteke) || (is_array($tipDatoteke) && empty($tipDatoteke))) {
            unset($this->TipDatoteke);
        } else {
            $this->TipDatoteke = $tipDatoteke;
        }
        return $this;
    }
}
