<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PravnaOsobaLokacijaNaselje StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PravnaOsobaLokacijaNaselje
 * @subpackage Structs
 */
class PravnaOsobaLokacijaNaselje extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The DatumBrisanja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumBrisanja;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumPromjene;
    /**
     * The IDPravnaOsobaLokacijaNaselje
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDPravnaOsobaLokacijaNaselje;
    /**
     * The Korisnik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Korisnik
     */
    public $Korisnik;
    /**
     * The KorisnikID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KorisnikID;
    /**
     * The Lokacija
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Lokacija
     */
    public $Lokacija;
    /**
     * The LokacijaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LokacijaID;
    /**
     * The Naselje
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Naselje
     */
    public $Naselje;
    /**
     * The NaseljeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NaseljeID;
    /**
     * The PFOOsoba
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PFOOsoba
     */
    public $PFOOsoba;
    /**
     * The PFOOsobaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PFOOsobaID;
    /**
     * Constructor method for PravnaOsobaLokacijaNaselje
     * @uses PravnaOsobaLokacijaNaselje::setAktivan()
     * @uses PravnaOsobaLokacijaNaselje::setDatumBrisanja()
     * @uses PravnaOsobaLokacijaNaselje::setDatumKreiranja()
     * @uses PravnaOsobaLokacijaNaselje::setDatumPromjene()
     * @uses PravnaOsobaLokacijaNaselje::setIDPravnaOsobaLokacijaNaselje()
     * @uses PravnaOsobaLokacijaNaselje::setKorisnik()
     * @uses PravnaOsobaLokacijaNaselje::setKorisnikID()
     * @uses PravnaOsobaLokacijaNaselje::setLokacija()
     * @uses PravnaOsobaLokacijaNaselje::setLokacijaID()
     * @uses PravnaOsobaLokacijaNaselje::setNaselje()
     * @uses PravnaOsobaLokacijaNaselje::setNaseljeID()
     * @uses PravnaOsobaLokacijaNaselje::setPFOOsoba()
     * @uses PravnaOsobaLokacijaNaselje::setPFOOsobaID()
     * @param bool $aktivan
     * @param string $datumBrisanja
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param int $iDPravnaOsobaLokacijaNaselje
     * @param \StructType\Korisnik $korisnik
     * @param int $korisnikID
     * @param \StructType\Lokacija $lokacija
     * @param int $lokacijaID
     * @param \StructType\Naselje $naselje
     * @param int $naseljeID
     * @param \StructType\PFOOsoba $pFOOsoba
     * @param int $pFOOsobaID
     */
    public function __construct($aktivan = null, $datumBrisanja = null, $datumKreiranja = null, $datumPromjene = null, $iDPravnaOsobaLokacijaNaselje = null, \StructType\Korisnik $korisnik = null, $korisnikID = null, \StructType\Lokacija $lokacija = null, $lokacijaID = null, \StructType\Naselje $naselje = null, $naseljeID = null, \StructType\PFOOsoba $pFOOsoba = null, $pFOOsobaID = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setDatumBrisanja($datumBrisanja)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setIDPravnaOsobaLokacijaNaselje($iDPravnaOsobaLokacijaNaselje)
            ->setKorisnik($korisnik)
            ->setKorisnikID($korisnikID)
            ->setLokacija($lokacija)
            ->setLokacijaID($lokacijaID)
            ->setNaselje($naselje)
            ->setNaseljeID($naseljeID)
            ->setPFOOsoba($pFOOsoba)
            ->setPFOOsobaID($pFOOsobaID);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\PravnaOsobaLokacijaNaselje
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get DatumBrisanja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumBrisanja()
    {
        return isset($this->DatumBrisanja) ? $this->DatumBrisanja : null;
    }
    /**
     * Set DatumBrisanja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumBrisanja
     * @return \StructType\PravnaOsobaLokacijaNaselje
     */
    public function setDatumBrisanja($datumBrisanja = null)
    {
        // validation for constraint: string
        if (!is_null($datumBrisanja) && !is_string($datumBrisanja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumBrisanja, true), gettype($datumBrisanja)), __LINE__);
        }
        if (is_null($datumBrisanja) || (is_array($datumBrisanja) && empty($datumBrisanja))) {
            unset($this->DatumBrisanja);
        } else {
            $this->DatumBrisanja = $datumBrisanja;
        }
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return isset($this->DatumKreiranja) ? $this->DatumKreiranja : null;
    }
    /**
     * Set DatumKreiranja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumKreiranja
     * @return \StructType\PravnaOsobaLokacijaNaselje
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        if (is_null($datumKreiranja) || (is_array($datumKreiranja) && empty($datumKreiranja))) {
            unset($this->DatumKreiranja);
        } else {
            $this->DatumKreiranja = $datumKreiranja;
        }
        return $this;
    }
    /**
     * Get DatumPromjene value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return isset($this->DatumPromjene) ? $this->DatumPromjene : null;
    }
    /**
     * Set DatumPromjene value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumPromjene
     * @return \StructType\PravnaOsobaLokacijaNaselje
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        if (is_null($datumPromjene) || (is_array($datumPromjene) && empty($datumPromjene))) {
            unset($this->DatumPromjene);
        } else {
            $this->DatumPromjene = $datumPromjene;
        }
        return $this;
    }
    /**
     * Get IDPravnaOsobaLokacijaNaselje value
     * @return int|null
     */
    public function getIDPravnaOsobaLokacijaNaselje()
    {
        return $this->IDPravnaOsobaLokacijaNaselje;
    }
    /**
     * Set IDPravnaOsobaLokacijaNaselje value
     * @param int $iDPravnaOsobaLokacijaNaselje
     * @return \StructType\PravnaOsobaLokacijaNaselje
     */
    public function setIDPravnaOsobaLokacijaNaselje($iDPravnaOsobaLokacijaNaselje = null)
    {
        // validation for constraint: int
        if (!is_null($iDPravnaOsobaLokacijaNaselje) && !(is_int($iDPravnaOsobaLokacijaNaselje) || ctype_digit($iDPravnaOsobaLokacijaNaselje))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDPravnaOsobaLokacijaNaselje, true), gettype($iDPravnaOsobaLokacijaNaselje)), __LINE__);
        }
        $this->IDPravnaOsobaLokacijaNaselje = $iDPravnaOsobaLokacijaNaselje;
        return $this;
    }
    /**
     * Get Korisnik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Korisnik|null
     */
    public function getKorisnik()
    {
        return isset($this->Korisnik) ? $this->Korisnik : null;
    }
    /**
     * Set Korisnik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Korisnik $korisnik
     * @return \StructType\PravnaOsobaLokacijaNaselje
     */
    public function setKorisnik(\StructType\Korisnik $korisnik = null)
    {
        if (is_null($korisnik) || (is_array($korisnik) && empty($korisnik))) {
            unset($this->Korisnik);
        } else {
            $this->Korisnik = $korisnik;
        }
        return $this;
    }
    /**
     * Get KorisnikID value
     * @return int|null
     */
    public function getKorisnikID()
    {
        return $this->KorisnikID;
    }
    /**
     * Set KorisnikID value
     * @param int $korisnikID
     * @return \StructType\PravnaOsobaLokacijaNaselje
     */
    public function setKorisnikID($korisnikID = null)
    {
        // validation for constraint: int
        if (!is_null($korisnikID) && !(is_int($korisnikID) || ctype_digit($korisnikID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($korisnikID, true), gettype($korisnikID)), __LINE__);
        }
        $this->KorisnikID = $korisnikID;
        return $this;
    }
    /**
     * Get Lokacija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Lokacija|null
     */
    public function getLokacija()
    {
        return isset($this->Lokacija) ? $this->Lokacija : null;
    }
    /**
     * Set Lokacija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Lokacija $lokacija
     * @return \StructType\PravnaOsobaLokacijaNaselje
     */
    public function setLokacija(\StructType\Lokacija $lokacija = null)
    {
        if (is_null($lokacija) || (is_array($lokacija) && empty($lokacija))) {
            unset($this->Lokacija);
        } else {
            $this->Lokacija = $lokacija;
        }
        return $this;
    }
    /**
     * Get LokacijaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLokacijaID()
    {
        return isset($this->LokacijaID) ? $this->LokacijaID : null;
    }
    /**
     * Set LokacijaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lokacijaID
     * @return \StructType\PravnaOsobaLokacijaNaselje
     */
    public function setLokacijaID($lokacijaID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaID) && !(is_int($lokacijaID) || ctype_digit($lokacijaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaID, true), gettype($lokacijaID)), __LINE__);
        }
        if (is_null($lokacijaID) || (is_array($lokacijaID) && empty($lokacijaID))) {
            unset($this->LokacijaID);
        } else {
            $this->LokacijaID = $lokacijaID;
        }
        return $this;
    }
    /**
     * Get Naselje value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Naselje|null
     */
    public function getNaselje()
    {
        return isset($this->Naselje) ? $this->Naselje : null;
    }
    /**
     * Set Naselje value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Naselje $naselje
     * @return \StructType\PravnaOsobaLokacijaNaselje
     */
    public function setNaselje(\StructType\Naselje $naselje = null)
    {
        if (is_null($naselje) || (is_array($naselje) && empty($naselje))) {
            unset($this->Naselje);
        } else {
            $this->Naselje = $naselje;
        }
        return $this;
    }
    /**
     * Get NaseljeID value
     * @return int|null
     */
    public function getNaseljeID()
    {
        return $this->NaseljeID;
    }
    /**
     * Set NaseljeID value
     * @param int $naseljeID
     * @return \StructType\PravnaOsobaLokacijaNaselje
     */
    public function setNaseljeID($naseljeID = null)
    {
        // validation for constraint: int
        if (!is_null($naseljeID) && !(is_int($naseljeID) || ctype_digit($naseljeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($naseljeID, true), gettype($naseljeID)), __LINE__);
        }
        $this->NaseljeID = $naseljeID;
        return $this;
    }
    /**
     * Get PFOOsoba value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PFOOsoba|null
     */
    public function getPFOOsoba()
    {
        return isset($this->PFOOsoba) ? $this->PFOOsoba : null;
    }
    /**
     * Set PFOOsoba value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PFOOsoba $pFOOsoba
     * @return \StructType\PravnaOsobaLokacijaNaselje
     */
    public function setPFOOsoba(\StructType\PFOOsoba $pFOOsoba = null)
    {
        if (is_null($pFOOsoba) || (is_array($pFOOsoba) && empty($pFOOsoba))) {
            unset($this->PFOOsoba);
        } else {
            $this->PFOOsoba = $pFOOsoba;
        }
        return $this;
    }
    /**
     * Get PFOOsobaID value
     * @return int|null
     */
    public function getPFOOsobaID()
    {
        return $this->PFOOsobaID;
    }
    /**
     * Set PFOOsobaID value
     * @param int $pFOOsobaID
     * @return \StructType\PravnaOsobaLokacijaNaselje
     */
    public function setPFOOsobaID($pFOOsobaID = null)
    {
        // validation for constraint: int
        if (!is_null($pFOOsobaID) && !(is_int($pFOOsobaID) || ctype_digit($pFOOsobaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pFOOsobaID, true), gettype($pFOOsobaID)), __LINE__);
        }
        $this->PFOOsobaID = $pFOOsobaID;
        return $this;
    }
}
