<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ONTO StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ONTO
 * @subpackage Structs
 */
class ONTO extends AbstractStructBase
{
    /**
     * The AutomatskoZatvaranje
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AutomatskoZatvaranje;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The DatumZatvaranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumZatvaranja;
    /**
     * The DatumZatvaranjaAutomatski
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumZatvaranjaAutomatski;
    /**
     * The Dokuments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDokument
     */
    public $Dokuments;
    /**
     * The Godina
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Godina;
    /**
     * The KljucniBrojOtpada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KljucniBrojOtpada
     */
    public $KljucniBrojOtpada;
    /**
     * The KljucniBrojOtpadaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KljucniBrojOtpadaID;
    /**
     * The KomunalniOtpad
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $KomunalniOtpad;
    /**
     * The KorisnikZatvorio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KorisnikZatvorio;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The Lokacija
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Lokacija
     */
    public $Lokacija;
    /**
     * The LokacijaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LokacijaId;
    /**
     * The LokacijaSjedisteID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LokacijaSjedisteID;
    /**
     * The ONTOID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ONTOID;
    /**
     * The ONTOStatu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ONTOStatu
     */
    public $ONTOStatu;
    /**
     * The ONTOStatusID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ONTOStatusID;
    /**
     * The ONTOTip
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ONTOTip;
    /**
     * The OdgovornaOsoba
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OdgovornaOsoba;
    /**
     * The OtkljucenjaOntoes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOtkljucenjaOnto
     */
    public $OtkljucenjaOntoes;
    /**
     * The PFOOsoba
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PFOOsoba
     */
    public $PFOOsoba;
    /**
     * The PLBrojcanik
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PLBrojcanik
     */
    public $PLBrojcanik;
    /**
     * The PrateciLists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPrateciList
     */
    public $PrateciLists;
    /**
     * The PrateciLists1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPrateciList
     */
    public $PrateciLists1;
    /**
     * The PrateciLists2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPrateciList
     */
    public $PrateciLists2;
    /**
     * The PravnaOsobaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PravnaOsobaID;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * The Sakriven
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Sakriven;
    /**
     * The TijekOtpadaPs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTijekOtpadaP
     */
    public $TijekOtpadaPs;
    /**
     * The TijekOtpadas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTijekOtpada
     */
    public $TijekOtpadas;
    /**
     * The UnosPrekoWebservisa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UnosPrekoWebservisa;
    /**
     * The VrijediDo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VrijediDo;
    /**
     * The VrijediOd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VrijediOd;
    /**
     * Constructor method for ONTO
     * @uses ONTO::setAutomatskoZatvaranje()
     * @uses ONTO::setDatumKreiranja()
     * @uses ONTO::setDatumPromjene()
     * @uses ONTO::setDatumZatvaranja()
     * @uses ONTO::setDatumZatvaranjaAutomatski()
     * @uses ONTO::setDokuments()
     * @uses ONTO::setGodina()
     * @uses ONTO::setKljucniBrojOtpada()
     * @uses ONTO::setKljucniBrojOtpadaID()
     * @uses ONTO::setKomunalniOtpad()
     * @uses ONTO::setKorisnikZatvorio()
     * @uses ONTO::setKreirao()
     * @uses ONTO::setLokacija()
     * @uses ONTO::setLokacijaId()
     * @uses ONTO::setLokacijaSjedisteID()
     * @uses ONTO::setONTOID()
     * @uses ONTO::setONTOStatu()
     * @uses ONTO::setONTOStatusID()
     * @uses ONTO::setONTOTip()
     * @uses ONTO::setOdgovornaOsoba()
     * @uses ONTO::setOtkljucenjaOntoes()
     * @uses ONTO::setPFOOsoba()
     * @uses ONTO::setPLBrojcanik()
     * @uses ONTO::setPrateciLists()
     * @uses ONTO::setPrateciLists1()
     * @uses ONTO::setPrateciLists2()
     * @uses ONTO::setPravnaOsobaID()
     * @uses ONTO::setPromijenio()
     * @uses ONTO::setSakriven()
     * @uses ONTO::setTijekOtpadaPs()
     * @uses ONTO::setTijekOtpadas()
     * @uses ONTO::setUnosPrekoWebservisa()
     * @uses ONTO::setVrijediDo()
     * @uses ONTO::setVrijediOd()
     * @param bool $automatskoZatvaranje
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param string $datumZatvaranja
     * @param string $datumZatvaranjaAutomatski
     * @param \ArrayType\ArrayOfDokument $dokuments
     * @param int $godina
     * @param \StructType\KljucniBrojOtpada $kljucniBrojOtpada
     * @param int $kljucniBrojOtpadaID
     * @param bool $komunalniOtpad
     * @param string $korisnikZatvorio
     * @param string $kreirao
     * @param \StructType\Lokacija $lokacija
     * @param int $lokacijaId
     * @param int $lokacijaSjedisteID
     * @param int $oNTOID
     * @param \StructType\ONTOStatu $oNTOStatu
     * @param int $oNTOStatusID
     * @param int $oNTOTip
     * @param string $odgovornaOsoba
     * @param \ArrayType\ArrayOfOtkljucenjaOnto $otkljucenjaOntoes
     * @param \StructType\PFOOsoba $pFOOsoba
     * @param \StructType\PLBrojcanik $pLBrojcanik
     * @param \ArrayType\ArrayOfPrateciList $prateciLists
     * @param \ArrayType\ArrayOfPrateciList $prateciLists1
     * @param \ArrayType\ArrayOfPrateciList $prateciLists2
     * @param int $pravnaOsobaID
     * @param string $promijenio
     * @param bool $sakriven
     * @param \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs
     * @param \ArrayType\ArrayOfTijekOtpada $tijekOtpadas
     * @param bool $unosPrekoWebservisa
     * @param string $vrijediDo
     * @param string $vrijediOd
     */
    public function __construct($automatskoZatvaranje = null, $datumKreiranja = null, $datumPromjene = null, $datumZatvaranja = null, $datumZatvaranjaAutomatski = null, \ArrayType\ArrayOfDokument $dokuments = null, $godina = null, \StructType\KljucniBrojOtpada $kljucniBrojOtpada = null, $kljucniBrojOtpadaID = null, $komunalniOtpad = null, $korisnikZatvorio = null, $kreirao = null, \StructType\Lokacija $lokacija = null, $lokacijaId = null, $lokacijaSjedisteID = null, $oNTOID = null, \StructType\ONTOStatu $oNTOStatu = null, $oNTOStatusID = null, $oNTOTip = null, $odgovornaOsoba = null, \ArrayType\ArrayOfOtkljucenjaOnto $otkljucenjaOntoes = null, \StructType\PFOOsoba $pFOOsoba = null, \StructType\PLBrojcanik $pLBrojcanik = null, \ArrayType\ArrayOfPrateciList $prateciLists = null, \ArrayType\ArrayOfPrateciList $prateciLists1 = null, \ArrayType\ArrayOfPrateciList $prateciLists2 = null, $pravnaOsobaID = null, $promijenio = null, $sakriven = null, \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs = null, \ArrayType\ArrayOfTijekOtpada $tijekOtpadas = null, $unosPrekoWebservisa = null, $vrijediDo = null, $vrijediOd = null)
    {
        $this
            ->setAutomatskoZatvaranje($automatskoZatvaranje)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setDatumZatvaranja($datumZatvaranja)
            ->setDatumZatvaranjaAutomatski($datumZatvaranjaAutomatski)
            ->setDokuments($dokuments)
            ->setGodina($godina)
            ->setKljucniBrojOtpada($kljucniBrojOtpada)
            ->setKljucniBrojOtpadaID($kljucniBrojOtpadaID)
            ->setKomunalniOtpad($komunalniOtpad)
            ->setKorisnikZatvorio($korisnikZatvorio)
            ->setKreirao($kreirao)
            ->setLokacija($lokacija)
            ->setLokacijaId($lokacijaId)
            ->setLokacijaSjedisteID($lokacijaSjedisteID)
            ->setONTOID($oNTOID)
            ->setONTOStatu($oNTOStatu)
            ->setONTOStatusID($oNTOStatusID)
            ->setONTOTip($oNTOTip)
            ->setOdgovornaOsoba($odgovornaOsoba)
            ->setOtkljucenjaOntoes($otkljucenjaOntoes)
            ->setPFOOsoba($pFOOsoba)
            ->setPLBrojcanik($pLBrojcanik)
            ->setPrateciLists($prateciLists)
            ->setPrateciLists1($prateciLists1)
            ->setPrateciLists2($prateciLists2)
            ->setPravnaOsobaID($pravnaOsobaID)
            ->setPromijenio($promijenio)
            ->setSakriven($sakriven)
            ->setTijekOtpadaPs($tijekOtpadaPs)
            ->setTijekOtpadas($tijekOtpadas)
            ->setUnosPrekoWebservisa($unosPrekoWebservisa)
            ->setVrijediDo($vrijediDo)
            ->setVrijediOd($vrijediOd);
    }
    /**
     * Get AutomatskoZatvaranje value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAutomatskoZatvaranje()
    {
        return isset($this->AutomatskoZatvaranje) ? $this->AutomatskoZatvaranje : null;
    }
    /**
     * Set AutomatskoZatvaranje value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $automatskoZatvaranje
     * @return \StructType\ONTO
     */
    public function setAutomatskoZatvaranje($automatskoZatvaranje = null)
    {
        // validation for constraint: boolean
        if (!is_null($automatskoZatvaranje) && !is_bool($automatskoZatvaranje)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($automatskoZatvaranje, true), gettype($automatskoZatvaranje)), __LINE__);
        }
        if (is_null($automatskoZatvaranje) || (is_array($automatskoZatvaranje) && empty($automatskoZatvaranje))) {
            unset($this->AutomatskoZatvaranje);
        } else {
            $this->AutomatskoZatvaranje = $automatskoZatvaranje;
        }
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\ONTO
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\ONTO
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get DatumZatvaranja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumZatvaranja()
    {
        return isset($this->DatumZatvaranja) ? $this->DatumZatvaranja : null;
    }
    /**
     * Set DatumZatvaranja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumZatvaranja
     * @return \StructType\ONTO
     */
    public function setDatumZatvaranja($datumZatvaranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumZatvaranja) && !is_string($datumZatvaranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumZatvaranja, true), gettype($datumZatvaranja)), __LINE__);
        }
        if (is_null($datumZatvaranja) || (is_array($datumZatvaranja) && empty($datumZatvaranja))) {
            unset($this->DatumZatvaranja);
        } else {
            $this->DatumZatvaranja = $datumZatvaranja;
        }
        return $this;
    }
    /**
     * Get DatumZatvaranjaAutomatski value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumZatvaranjaAutomatski()
    {
        return isset($this->DatumZatvaranjaAutomatski) ? $this->DatumZatvaranjaAutomatski : null;
    }
    /**
     * Set DatumZatvaranjaAutomatski value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumZatvaranjaAutomatski
     * @return \StructType\ONTO
     */
    public function setDatumZatvaranjaAutomatski($datumZatvaranjaAutomatski = null)
    {
        // validation for constraint: string
        if (!is_null($datumZatvaranjaAutomatski) && !is_string($datumZatvaranjaAutomatski)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumZatvaranjaAutomatski, true), gettype($datumZatvaranjaAutomatski)), __LINE__);
        }
        if (is_null($datumZatvaranjaAutomatski) || (is_array($datumZatvaranjaAutomatski) && empty($datumZatvaranjaAutomatski))) {
            unset($this->DatumZatvaranjaAutomatski);
        } else {
            $this->DatumZatvaranjaAutomatski = $datumZatvaranjaAutomatski;
        }
        return $this;
    }
    /**
     * Get Dokuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDokument|null
     */
    public function getDokuments()
    {
        return isset($this->Dokuments) ? $this->Dokuments : null;
    }
    /**
     * Set Dokuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDokument $dokuments
     * @return \StructType\ONTO
     */
    public function setDokuments(\ArrayType\ArrayOfDokument $dokuments = null)
    {
        if (is_null($dokuments) || (is_array($dokuments) && empty($dokuments))) {
            unset($this->Dokuments);
        } else {
            $this->Dokuments = $dokuments;
        }
        return $this;
    }
    /**
     * Get Godina value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGodina()
    {
        return isset($this->Godina) ? $this->Godina : null;
    }
    /**
     * Set Godina value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $godina
     * @return \StructType\ONTO
     */
    public function setGodina($godina = null)
    {
        // validation for constraint: int
        if (!is_null($godina) && !(is_int($godina) || ctype_digit($godina))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($godina, true), gettype($godina)), __LINE__);
        }
        if (is_null($godina) || (is_array($godina) && empty($godina))) {
            unset($this->Godina);
        } else {
            $this->Godina = $godina;
        }
        return $this;
    }
    /**
     * Get KljucniBrojOtpada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KljucniBrojOtpada|null
     */
    public function getKljucniBrojOtpada()
    {
        return isset($this->KljucniBrojOtpada) ? $this->KljucniBrojOtpada : null;
    }
    /**
     * Set KljucniBrojOtpada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\KljucniBrojOtpada $kljucniBrojOtpada
     * @return \StructType\ONTO
     */
    public function setKljucniBrojOtpada(\StructType\KljucniBrojOtpada $kljucniBrojOtpada = null)
    {
        if (is_null($kljucniBrojOtpada) || (is_array($kljucniBrojOtpada) && empty($kljucniBrojOtpada))) {
            unset($this->KljucniBrojOtpada);
        } else {
            $this->KljucniBrojOtpada = $kljucniBrojOtpada;
        }
        return $this;
    }
    /**
     * Get KljucniBrojOtpadaID value
     * @return int|null
     */
    public function getKljucniBrojOtpadaID()
    {
        return $this->KljucniBrojOtpadaID;
    }
    /**
     * Set KljucniBrojOtpadaID value
     * @param int $kljucniBrojOtpadaID
     * @return \StructType\ONTO
     */
    public function setKljucniBrojOtpadaID($kljucniBrojOtpadaID = null)
    {
        // validation for constraint: int
        if (!is_null($kljucniBrojOtpadaID) && !(is_int($kljucniBrojOtpadaID) || ctype_digit($kljucniBrojOtpadaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kljucniBrojOtpadaID, true), gettype($kljucniBrojOtpadaID)), __LINE__);
        }
        $this->KljucniBrojOtpadaID = $kljucniBrojOtpadaID;
        return $this;
    }
    /**
     * Get KomunalniOtpad value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKomunalniOtpad()
    {
        return isset($this->KomunalniOtpad) ? $this->KomunalniOtpad : null;
    }
    /**
     * Set KomunalniOtpad value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $komunalniOtpad
     * @return \StructType\ONTO
     */
    public function setKomunalniOtpad($komunalniOtpad = null)
    {
        // validation for constraint: boolean
        if (!is_null($komunalniOtpad) && !is_bool($komunalniOtpad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($komunalniOtpad, true), gettype($komunalniOtpad)), __LINE__);
        }
        if (is_null($komunalniOtpad) || (is_array($komunalniOtpad) && empty($komunalniOtpad))) {
            unset($this->KomunalniOtpad);
        } else {
            $this->KomunalniOtpad = $komunalniOtpad;
        }
        return $this;
    }
    /**
     * Get KorisnikZatvorio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKorisnikZatvorio()
    {
        return isset($this->KorisnikZatvorio) ? $this->KorisnikZatvorio : null;
    }
    /**
     * Set KorisnikZatvorio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $korisnikZatvorio
     * @return \StructType\ONTO
     */
    public function setKorisnikZatvorio($korisnikZatvorio = null)
    {
        // validation for constraint: string
        if (!is_null($korisnikZatvorio) && !is_string($korisnikZatvorio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($korisnikZatvorio, true), gettype($korisnikZatvorio)), __LINE__);
        }
        if (is_null($korisnikZatvorio) || (is_array($korisnikZatvorio) && empty($korisnikZatvorio))) {
            unset($this->KorisnikZatvorio);
        } else {
            $this->KorisnikZatvorio = $korisnikZatvorio;
        }
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\ONTO
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get Lokacija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Lokacija|null
     */
    public function getLokacija()
    {
        return isset($this->Lokacija) ? $this->Lokacija : null;
    }
    /**
     * Set Lokacija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Lokacija $lokacija
     * @return \StructType\ONTO
     */
    public function setLokacija(\StructType\Lokacija $lokacija = null)
    {
        if (is_null($lokacija) || (is_array($lokacija) && empty($lokacija))) {
            unset($this->Lokacija);
        } else {
            $this->Lokacija = $lokacija;
        }
        return $this;
    }
    /**
     * Get LokacijaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLokacijaId()
    {
        return isset($this->LokacijaId) ? $this->LokacijaId : null;
    }
    /**
     * Set LokacijaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lokacijaId
     * @return \StructType\ONTO
     */
    public function setLokacijaId($lokacijaId = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaId) && !(is_int($lokacijaId) || ctype_digit($lokacijaId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaId, true), gettype($lokacijaId)), __LINE__);
        }
        if (is_null($lokacijaId) || (is_array($lokacijaId) && empty($lokacijaId))) {
            unset($this->LokacijaId);
        } else {
            $this->LokacijaId = $lokacijaId;
        }
        return $this;
    }
    /**
     * Get LokacijaSjedisteID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLokacijaSjedisteID()
    {
        return isset($this->LokacijaSjedisteID) ? $this->LokacijaSjedisteID : null;
    }
    /**
     * Set LokacijaSjedisteID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lokacijaSjedisteID
     * @return \StructType\ONTO
     */
    public function setLokacijaSjedisteID($lokacijaSjedisteID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaSjedisteID) && !(is_int($lokacijaSjedisteID) || ctype_digit($lokacijaSjedisteID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaSjedisteID, true), gettype($lokacijaSjedisteID)), __LINE__);
        }
        if (is_null($lokacijaSjedisteID) || (is_array($lokacijaSjedisteID) && empty($lokacijaSjedisteID))) {
            unset($this->LokacijaSjedisteID);
        } else {
            $this->LokacijaSjedisteID = $lokacijaSjedisteID;
        }
        return $this;
    }
    /**
     * Get ONTOID value
     * @return int|null
     */
    public function getONTOID()
    {
        return $this->ONTOID;
    }
    /**
     * Set ONTOID value
     * @param int $oNTOID
     * @return \StructType\ONTO
     */
    public function setONTOID($oNTOID = null)
    {
        // validation for constraint: int
        if (!is_null($oNTOID) && !(is_int($oNTOID) || ctype_digit($oNTOID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oNTOID, true), gettype($oNTOID)), __LINE__);
        }
        $this->ONTOID = $oNTOID;
        return $this;
    }
    /**
     * Get ONTOStatu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ONTOStatu|null
     */
    public function getONTOStatu()
    {
        return isset($this->ONTOStatu) ? $this->ONTOStatu : null;
    }
    /**
     * Set ONTOStatu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ONTOStatu $oNTOStatu
     * @return \StructType\ONTO
     */
    public function setONTOStatu(\StructType\ONTOStatu $oNTOStatu = null)
    {
        if (is_null($oNTOStatu) || (is_array($oNTOStatu) && empty($oNTOStatu))) {
            unset($this->ONTOStatu);
        } else {
            $this->ONTOStatu = $oNTOStatu;
        }
        return $this;
    }
    /**
     * Get ONTOStatusID value
     * @return int|null
     */
    public function getONTOStatusID()
    {
        return $this->ONTOStatusID;
    }
    /**
     * Set ONTOStatusID value
     * @param int $oNTOStatusID
     * @return \StructType\ONTO
     */
    public function setONTOStatusID($oNTOStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($oNTOStatusID) && !(is_int($oNTOStatusID) || ctype_digit($oNTOStatusID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oNTOStatusID, true), gettype($oNTOStatusID)), __LINE__);
        }
        $this->ONTOStatusID = $oNTOStatusID;
        return $this;
    }
    /**
     * Get ONTOTip value
     * @return int|null
     */
    public function getONTOTip()
    {
        return $this->ONTOTip;
    }
    /**
     * Set ONTOTip value
     * @param int $oNTOTip
     * @return \StructType\ONTO
     */
    public function setONTOTip($oNTOTip = null)
    {
        // validation for constraint: int
        if (!is_null($oNTOTip) && !(is_int($oNTOTip) || ctype_digit($oNTOTip))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oNTOTip, true), gettype($oNTOTip)), __LINE__);
        }
        $this->ONTOTip = $oNTOTip;
        return $this;
    }
    /**
     * Get OdgovornaOsoba value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOdgovornaOsoba()
    {
        return isset($this->OdgovornaOsoba) ? $this->OdgovornaOsoba : null;
    }
    /**
     * Set OdgovornaOsoba value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $odgovornaOsoba
     * @return \StructType\ONTO
     */
    public function setOdgovornaOsoba($odgovornaOsoba = null)
    {
        // validation for constraint: string
        if (!is_null($odgovornaOsoba) && !is_string($odgovornaOsoba)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($odgovornaOsoba, true), gettype($odgovornaOsoba)), __LINE__);
        }
        if (is_null($odgovornaOsoba) || (is_array($odgovornaOsoba) && empty($odgovornaOsoba))) {
            unset($this->OdgovornaOsoba);
        } else {
            $this->OdgovornaOsoba = $odgovornaOsoba;
        }
        return $this;
    }
    /**
     * Get OtkljucenjaOntoes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOtkljucenjaOnto|null
     */
    public function getOtkljucenjaOntoes()
    {
        return isset($this->OtkljucenjaOntoes) ? $this->OtkljucenjaOntoes : null;
    }
    /**
     * Set OtkljucenjaOntoes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOtkljucenjaOnto $otkljucenjaOntoes
     * @return \StructType\ONTO
     */
    public function setOtkljucenjaOntoes(\ArrayType\ArrayOfOtkljucenjaOnto $otkljucenjaOntoes = null)
    {
        if (is_null($otkljucenjaOntoes) || (is_array($otkljucenjaOntoes) && empty($otkljucenjaOntoes))) {
            unset($this->OtkljucenjaOntoes);
        } else {
            $this->OtkljucenjaOntoes = $otkljucenjaOntoes;
        }
        return $this;
    }
    /**
     * Get PFOOsoba value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PFOOsoba|null
     */
    public function getPFOOsoba()
    {
        return isset($this->PFOOsoba) ? $this->PFOOsoba : null;
    }
    /**
     * Set PFOOsoba value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PFOOsoba $pFOOsoba
     * @return \StructType\ONTO
     */
    public function setPFOOsoba(\StructType\PFOOsoba $pFOOsoba = null)
    {
        if (is_null($pFOOsoba) || (is_array($pFOOsoba) && empty($pFOOsoba))) {
            unset($this->PFOOsoba);
        } else {
            $this->PFOOsoba = $pFOOsoba;
        }
        return $this;
    }
    /**
     * Get PLBrojcanik value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PLBrojcanik|null
     */
    public function getPLBrojcanik()
    {
        return isset($this->PLBrojcanik) ? $this->PLBrojcanik : null;
    }
    /**
     * Set PLBrojcanik value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PLBrojcanik $pLBrojcanik
     * @return \StructType\ONTO
     */
    public function setPLBrojcanik(\StructType\PLBrojcanik $pLBrojcanik = null)
    {
        if (is_null($pLBrojcanik) || (is_array($pLBrojcanik) && empty($pLBrojcanik))) {
            unset($this->PLBrojcanik);
        } else {
            $this->PLBrojcanik = $pLBrojcanik;
        }
        return $this;
    }
    /**
     * Get PrateciLists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPrateciList|null
     */
    public function getPrateciLists()
    {
        return isset($this->PrateciLists) ? $this->PrateciLists : null;
    }
    /**
     * Set PrateciLists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPrateciList $prateciLists
     * @return \StructType\ONTO
     */
    public function setPrateciLists(\ArrayType\ArrayOfPrateciList $prateciLists = null)
    {
        if (is_null($prateciLists) || (is_array($prateciLists) && empty($prateciLists))) {
            unset($this->PrateciLists);
        } else {
            $this->PrateciLists = $prateciLists;
        }
        return $this;
    }
    /**
     * Get PrateciLists1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPrateciList|null
     */
    public function getPrateciLists1()
    {
        return isset($this->PrateciLists1) ? $this->PrateciLists1 : null;
    }
    /**
     * Set PrateciLists1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPrateciList $prateciLists1
     * @return \StructType\ONTO
     */
    public function setPrateciLists1(\ArrayType\ArrayOfPrateciList $prateciLists1 = null)
    {
        if (is_null($prateciLists1) || (is_array($prateciLists1) && empty($prateciLists1))) {
            unset($this->PrateciLists1);
        } else {
            $this->PrateciLists1 = $prateciLists1;
        }
        return $this;
    }
    /**
     * Get PrateciLists2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPrateciList|null
     */
    public function getPrateciLists2()
    {
        return isset($this->PrateciLists2) ? $this->PrateciLists2 : null;
    }
    /**
     * Set PrateciLists2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPrateciList $prateciLists2
     * @return \StructType\ONTO
     */
    public function setPrateciLists2(\ArrayType\ArrayOfPrateciList $prateciLists2 = null)
    {
        if (is_null($prateciLists2) || (is_array($prateciLists2) && empty($prateciLists2))) {
            unset($this->PrateciLists2);
        } else {
            $this->PrateciLists2 = $prateciLists2;
        }
        return $this;
    }
    /**
     * Get PravnaOsobaID value
     * @return int|null
     */
    public function getPravnaOsobaID()
    {
        return $this->PravnaOsobaID;
    }
    /**
     * Set PravnaOsobaID value
     * @param int $pravnaOsobaID
     * @return \StructType\ONTO
     */
    public function setPravnaOsobaID($pravnaOsobaID = null)
    {
        // validation for constraint: int
        if (!is_null($pravnaOsobaID) && !(is_int($pravnaOsobaID) || ctype_digit($pravnaOsobaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pravnaOsobaID, true), gettype($pravnaOsobaID)), __LINE__);
        }
        $this->PravnaOsobaID = $pravnaOsobaID;
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\ONTO
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
    /**
     * Get Sakriven value
     * @return bool|null
     */
    public function getSakriven()
    {
        return $this->Sakriven;
    }
    /**
     * Set Sakriven value
     * @param bool $sakriven
     * @return \StructType\ONTO
     */
    public function setSakriven($sakriven = null)
    {
        // validation for constraint: boolean
        if (!is_null($sakriven) && !is_bool($sakriven)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sakriven, true), gettype($sakriven)), __LINE__);
        }
        $this->Sakriven = $sakriven;
        return $this;
    }
    /**
     * Get TijekOtpadaPs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTijekOtpadaP|null
     */
    public function getTijekOtpadaPs()
    {
        return isset($this->TijekOtpadaPs) ? $this->TijekOtpadaPs : null;
    }
    /**
     * Set TijekOtpadaPs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs
     * @return \StructType\ONTO
     */
    public function setTijekOtpadaPs(\ArrayType\ArrayOfTijekOtpadaP $tijekOtpadaPs = null)
    {
        if (is_null($tijekOtpadaPs) || (is_array($tijekOtpadaPs) && empty($tijekOtpadaPs))) {
            unset($this->TijekOtpadaPs);
        } else {
            $this->TijekOtpadaPs = $tijekOtpadaPs;
        }
        return $this;
    }
    /**
     * Get TijekOtpadas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTijekOtpada|null
     */
    public function getTijekOtpadas()
    {
        return isset($this->TijekOtpadas) ? $this->TijekOtpadas : null;
    }
    /**
     * Set TijekOtpadas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTijekOtpada $tijekOtpadas
     * @return \StructType\ONTO
     */
    public function setTijekOtpadas(\ArrayType\ArrayOfTijekOtpada $tijekOtpadas = null)
    {
        if (is_null($tijekOtpadas) || (is_array($tijekOtpadas) && empty($tijekOtpadas))) {
            unset($this->TijekOtpadas);
        } else {
            $this->TijekOtpadas = $tijekOtpadas;
        }
        return $this;
    }
    /**
     * Get UnosPrekoWebservisa value
     * @return bool|null
     */
    public function getUnosPrekoWebservisa()
    {
        return $this->UnosPrekoWebservisa;
    }
    /**
     * Set UnosPrekoWebservisa value
     * @param bool $unosPrekoWebservisa
     * @return \StructType\ONTO
     */
    public function setUnosPrekoWebservisa($unosPrekoWebservisa = null)
    {
        // validation for constraint: boolean
        if (!is_null($unosPrekoWebservisa) && !is_bool($unosPrekoWebservisa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unosPrekoWebservisa, true), gettype($unosPrekoWebservisa)), __LINE__);
        }
        $this->UnosPrekoWebservisa = $unosPrekoWebservisa;
        return $this;
    }
    /**
     * Get VrijediDo value
     * @return string|null
     */
    public function getVrijediDo()
    {
        return $this->VrijediDo;
    }
    /**
     * Set VrijediDo value
     * @param string $vrijediDo
     * @return \StructType\ONTO
     */
    public function setVrijediDo($vrijediDo = null)
    {
        // validation for constraint: string
        if (!is_null($vrijediDo) && !is_string($vrijediDo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vrijediDo, true), gettype($vrijediDo)), __LINE__);
        }
        $this->VrijediDo = $vrijediDo;
        return $this;
    }
    /**
     * Get VrijediOd value
     * @return string|null
     */
    public function getVrijediOd()
    {
        return $this->VrijediOd;
    }
    /**
     * Set VrijediOd value
     * @param string $vrijediOd
     * @return \StructType\ONTO
     */
    public function setVrijediOd($vrijediOd = null)
    {
        // validation for constraint: string
        if (!is_null($vrijediOd) && !is_string($vrijediOd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vrijediOd, true), gettype($vrijediOd)), __LINE__);
        }
        $this->VrijediOd = $vrijediOd;
        return $this;
    }
}
