<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KategorijaDokumenta StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:KategorijaDokumenta
 * @subpackage Structs
 */
class KategorijaDokumenta extends AbstractStructBase
{
    /**
     * The Aktivan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Aktivan;
    /**
     * The KategorijaDokumentaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $KategorijaDokumentaID;
    /**
     * The Naziv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Naziv;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The DokumentKategorijaDokumentas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDokumentKategorijaDokumenta
     */
    public $DokumentKategorijaDokumentas;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * Constructor method for KategorijaDokumenta
     * @uses KategorijaDokumenta::setAktivan()
     * @uses KategorijaDokumenta::setKategorijaDokumentaID()
     * @uses KategorijaDokumenta::setNaziv()
     * @uses KategorijaDokumenta::setDatumKreiranja()
     * @uses KategorijaDokumenta::setDatumPromjene()
     * @uses KategorijaDokumenta::setDokumentKategorijaDokumentas()
     * @uses KategorijaDokumenta::setKreirao()
     * @uses KategorijaDokumenta::setPromijenio()
     * @param bool $aktivan
     * @param int $kategorijaDokumentaID
     * @param string $naziv
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param \ArrayType\ArrayOfDokumentKategorijaDokumenta $dokumentKategorijaDokumentas
     * @param string $kreirao
     * @param string $promijenio
     */
    public function __construct($aktivan = null, $kategorijaDokumentaID = null, $naziv = null, $datumKreiranja = null, $datumPromjene = null, \ArrayType\ArrayOfDokumentKategorijaDokumenta $dokumentKategorijaDokumentas = null, $kreirao = null, $promijenio = null)
    {
        $this
            ->setAktivan($aktivan)
            ->setKategorijaDokumentaID($kategorijaDokumentaID)
            ->setNaziv($naziv)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setDokumentKategorijaDokumentas($dokumentKategorijaDokumentas)
            ->setKreirao($kreirao)
            ->setPromijenio($promijenio);
    }
    /**
     * Get Aktivan value
     * @return bool|null
     */
    public function getAktivan()
    {
        return $this->Aktivan;
    }
    /**
     * Set Aktivan value
     * @param bool $aktivan
     * @return \StructType\KategorijaDokumenta
     */
    public function setAktivan($aktivan = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktivan) && !is_bool($aktivan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktivan, true), gettype($aktivan)), __LINE__);
        }
        $this->Aktivan = $aktivan;
        return $this;
    }
    /**
     * Get KategorijaDokumentaID value
     * @return int|null
     */
    public function getKategorijaDokumentaID()
    {
        return $this->KategorijaDokumentaID;
    }
    /**
     * Set KategorijaDokumentaID value
     * @param int $kategorijaDokumentaID
     * @return \StructType\KategorijaDokumenta
     */
    public function setKategorijaDokumentaID($kategorijaDokumentaID = null)
    {
        // validation for constraint: int
        if (!is_null($kategorijaDokumentaID) && !(is_int($kategorijaDokumentaID) || ctype_digit($kategorijaDokumentaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kategorijaDokumentaID, true), gettype($kategorijaDokumentaID)), __LINE__);
        }
        $this->KategorijaDokumentaID = $kategorijaDokumentaID;
        return $this;
    }
    /**
     * Get Naziv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaziv()
    {
        return isset($this->Naziv) ? $this->Naziv : null;
    }
    /**
     * Set Naziv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naziv
     * @return \StructType\KategorijaDokumenta
     */
    public function setNaziv($naziv = null)
    {
        // validation for constraint: string
        if (!is_null($naziv) && !is_string($naziv)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naziv, true), gettype($naziv)), __LINE__);
        }
        if (is_null($naziv) || (is_array($naziv) && empty($naziv))) {
            unset($this->Naziv);
        } else {
            $this->Naziv = $naziv;
        }
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\KategorijaDokumenta
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\KategorijaDokumenta
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get DokumentKategorijaDokumentas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDokumentKategorijaDokumenta|null
     */
    public function getDokumentKategorijaDokumentas()
    {
        return isset($this->DokumentKategorijaDokumentas) ? $this->DokumentKategorijaDokumentas : null;
    }
    /**
     * Set DokumentKategorijaDokumentas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDokumentKategorijaDokumenta $dokumentKategorijaDokumentas
     * @return \StructType\KategorijaDokumenta
     */
    public function setDokumentKategorijaDokumentas(\ArrayType\ArrayOfDokumentKategorijaDokumenta $dokumentKategorijaDokumentas = null)
    {
        if (is_null($dokumentKategorijaDokumentas) || (is_array($dokumentKategorijaDokumentas) && empty($dokumentKategorijaDokumentas))) {
            unset($this->DokumentKategorijaDokumentas);
        } else {
            $this->DokumentKategorijaDokumentas = $dokumentKategorijaDokumentas;
        }
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\KategorijaDokumenta
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\KategorijaDokumenta
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
}
