<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DozvolaKBDTO StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DozvolaKBDTO
 * @subpackage Structs
 */
class DozvolaKBDTO extends AbstractStructBase
{
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumPromjene;
    /**
     * The DozvolaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DozvolaID;
    /**
     * The IDDozvolaKB
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IDDozvolaKB;
    /**
     * The KljucniBrojOtpada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\KljucniBrojOtpadaDTO
     */
    public $KljucniBrojOtpada;
    /**
     * The KljucniBrojOtpadaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $KljucniBrojOtpadaID;
    /**
     * Constructor method for DozvolaKBDTO
     * @uses DozvolaKBDTO::setDatumKreiranja()
     * @uses DozvolaKBDTO::setDatumPromjene()
     * @uses DozvolaKBDTO::setDozvolaID()
     * @uses DozvolaKBDTO::setIDDozvolaKB()
     * @uses DozvolaKBDTO::setKljucniBrojOtpada()
     * @uses DozvolaKBDTO::setKljucniBrojOtpadaID()
     * @param string $datumKreiranja
     * @param string $datumPromjene
     * @param int $dozvolaID
     * @param int $iDDozvolaKB
     * @param \StructType\KljucniBrojOtpadaDTO $kljucniBrojOtpada
     * @param int $kljucniBrojOtpadaID
     */
    public function __construct($datumKreiranja = null, $datumPromjene = null, $dozvolaID = null, $iDDozvolaKB = null, \StructType\KljucniBrojOtpadaDTO $kljucniBrojOtpada = null, $kljucniBrojOtpadaID = null)
    {
        $this
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumPromjene($datumPromjene)
            ->setDozvolaID($dozvolaID)
            ->setIDDozvolaKB($iDDozvolaKB)
            ->setKljucniBrojOtpada($kljucniBrojOtpada)
            ->setKljucniBrojOtpadaID($kljucniBrojOtpadaID);
    }
    /**
     * Get DatumKreiranja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return isset($this->DatumKreiranja) ? $this->DatumKreiranja : null;
    }
    /**
     * Set DatumKreiranja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumKreiranja
     * @return \StructType\DozvolaKBDTO
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        if (is_null($datumKreiranja) || (is_array($datumKreiranja) && empty($datumKreiranja))) {
            unset($this->DatumKreiranja);
        } else {
            $this->DatumKreiranja = $datumKreiranja;
        }
        return $this;
    }
    /**
     * Get DatumPromjene value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return isset($this->DatumPromjene) ? $this->DatumPromjene : null;
    }
    /**
     * Set DatumPromjene value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumPromjene
     * @return \StructType\DozvolaKBDTO
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        if (is_null($datumPromjene) || (is_array($datumPromjene) && empty($datumPromjene))) {
            unset($this->DatumPromjene);
        } else {
            $this->DatumPromjene = $datumPromjene;
        }
        return $this;
    }
    /**
     * Get DozvolaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDozvolaID()
    {
        return isset($this->DozvolaID) ? $this->DozvolaID : null;
    }
    /**
     * Set DozvolaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $dozvolaID
     * @return \StructType\DozvolaKBDTO
     */
    public function setDozvolaID($dozvolaID = null)
    {
        // validation for constraint: int
        if (!is_null($dozvolaID) && !(is_int($dozvolaID) || ctype_digit($dozvolaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dozvolaID, true), gettype($dozvolaID)), __LINE__);
        }
        if (is_null($dozvolaID) || (is_array($dozvolaID) && empty($dozvolaID))) {
            unset($this->DozvolaID);
        } else {
            $this->DozvolaID = $dozvolaID;
        }
        return $this;
    }
    /**
     * Get IDDozvolaKB value
     * @return int|null
     */
    public function getIDDozvolaKB()
    {
        return $this->IDDozvolaKB;
    }
    /**
     * Set IDDozvolaKB value
     * @param int $iDDozvolaKB
     * @return \StructType\DozvolaKBDTO
     */
    public function setIDDozvolaKB($iDDozvolaKB = null)
    {
        // validation for constraint: int
        if (!is_null($iDDozvolaKB) && !(is_int($iDDozvolaKB) || ctype_digit($iDDozvolaKB))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDDozvolaKB, true), gettype($iDDozvolaKB)), __LINE__);
        }
        $this->IDDozvolaKB = $iDDozvolaKB;
        return $this;
    }
    /**
     * Get KljucniBrojOtpada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\KljucniBrojOtpadaDTO|null
     */
    public function getKljucniBrojOtpada()
    {
        return isset($this->KljucniBrojOtpada) ? $this->KljucniBrojOtpada : null;
    }
    /**
     * Set KljucniBrojOtpada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\KljucniBrojOtpadaDTO $kljucniBrojOtpada
     * @return \StructType\DozvolaKBDTO
     */
    public function setKljucniBrojOtpada(\StructType\KljucniBrojOtpadaDTO $kljucniBrojOtpada = null)
    {
        if (is_null($kljucniBrojOtpada) || (is_array($kljucniBrojOtpada) && empty($kljucniBrojOtpada))) {
            unset($this->KljucniBrojOtpada);
        } else {
            $this->KljucniBrojOtpada = $kljucniBrojOtpada;
        }
        return $this;
    }
    /**
     * Get KljucniBrojOtpadaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKljucniBrojOtpadaID()
    {
        return isset($this->KljucniBrojOtpadaID) ? $this->KljucniBrojOtpadaID : null;
    }
    /**
     * Set KljucniBrojOtpadaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $kljucniBrojOtpadaID
     * @return \StructType\DozvolaKBDTO
     */
    public function setKljucniBrojOtpadaID($kljucniBrojOtpadaID = null)
    {
        // validation for constraint: int
        if (!is_null($kljucniBrojOtpadaID) && !(is_int($kljucniBrojOtpadaID) || ctype_digit($kljucniBrojOtpadaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kljucniBrojOtpadaID, true), gettype($kljucniBrojOtpadaID)), __LINE__);
        }
        if (is_null($kljucniBrojOtpadaID) || (is_array($kljucniBrojOtpadaID) && empty($kljucniBrojOtpadaID))) {
            unset($this->KljucniBrojOtpadaID);
        } else {
            $this->KljucniBrojOtpadaID = $kljucniBrojOtpadaID;
        }
        return $this;
    }
}
