<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dokument StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Dokument
 * @subpackage Structs
 */
class Dokument extends AbstractStructBase
{
    /**
     * The Datoteka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Datoteka;
    /**
     * The DatumKreiranja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumKreiranja;
    /**
     * The DatumNastanka
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DatumNastanka;
    /**
     * The DatumPromjene
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DatumPromjene;
    /**
     * The DokumentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DokumentID;
    /**
     * The DokumentKategorijaDokumentas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDokumentKategorijaDokumenta
     */
    public $DokumentKategorijaDokumentas;
    /**
     * The Kreirao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kreirao;
    /**
     * The Lokacija
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Lokacija
     */
    public $Lokacija;
    /**
     * The Lokacija1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Lokacija
     */
    public $Lokacija1;
    /**
     * The LokacijaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LokacijaID;
    /**
     * The NazivDokumenta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NazivDokumenta;
    /**
     * The ONTO
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ONTO
     */
    public $ONTO;
    /**
     * The ONTOID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ONTOID;
    /**
     * The Opis
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Opis;
    /**
     * The PrateciList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PrateciList
     */
    public $PrateciList;
    /**
     * The PrateciListID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrateciListID;
    /**
     * The Promijenio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Promijenio;
    /**
     * The Putanja
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Putanja;
    /**
     * The TijekOtpada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TijekOtpada
     */
    public $TijekOtpada;
    /**
     * The TijekOtpadaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TijekOtpadaID;
    /**
     * The TijekOtpadaP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TijekOtpadaP
     */
    public $TijekOtpadaP;
    /**
     * The TijekOtpadaPID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TijekOtpadaPID;
    /**
     * The TipDatoteke
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipDatoteke;
    /**
     * The VlasnikLokacijaID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VlasnikLokacijaID;
    /**
     * Constructor method for Dokument
     * @uses Dokument::setDatoteka()
     * @uses Dokument::setDatumKreiranja()
     * @uses Dokument::setDatumNastanka()
     * @uses Dokument::setDatumPromjene()
     * @uses Dokument::setDokumentID()
     * @uses Dokument::setDokumentKategorijaDokumentas()
     * @uses Dokument::setKreirao()
     * @uses Dokument::setLokacija()
     * @uses Dokument::setLokacija1()
     * @uses Dokument::setLokacijaID()
     * @uses Dokument::setNazivDokumenta()
     * @uses Dokument::setONTO()
     * @uses Dokument::setONTOID()
     * @uses Dokument::setOpis()
     * @uses Dokument::setPrateciList()
     * @uses Dokument::setPrateciListID()
     * @uses Dokument::setPromijenio()
     * @uses Dokument::setPutanja()
     * @uses Dokument::setTijekOtpada()
     * @uses Dokument::setTijekOtpadaID()
     * @uses Dokument::setTijekOtpadaP()
     * @uses Dokument::setTijekOtpadaPID()
     * @uses Dokument::setTipDatoteke()
     * @uses Dokument::setVlasnikLokacijaID()
     * @param string $datoteka
     * @param string $datumKreiranja
     * @param string $datumNastanka
     * @param string $datumPromjene
     * @param int $dokumentID
     * @param \ArrayType\ArrayOfDokumentKategorijaDokumenta $dokumentKategorijaDokumentas
     * @param string $kreirao
     * @param \StructType\Lokacija $lokacija
     * @param \StructType\Lokacija $lokacija1
     * @param int $lokacijaID
     * @param string $nazivDokumenta
     * @param \StructType\ONTO $oNTO
     * @param int $oNTOID
     * @param string $opis
     * @param \StructType\PrateciList $prateciList
     * @param int $prateciListID
     * @param string $promijenio
     * @param string $putanja
     * @param \StructType\TijekOtpada $tijekOtpada
     * @param int $tijekOtpadaID
     * @param \StructType\TijekOtpadaP $tijekOtpadaP
     * @param int $tijekOtpadaPID
     * @param string $tipDatoteke
     * @param int $vlasnikLokacijaID
     */
    public function __construct($datoteka = null, $datumKreiranja = null, $datumNastanka = null, $datumPromjene = null, $dokumentID = null, \ArrayType\ArrayOfDokumentKategorijaDokumenta $dokumentKategorijaDokumentas = null, $kreirao = null, \StructType\Lokacija $lokacija = null, \StructType\Lokacija $lokacija1 = null, $lokacijaID = null, $nazivDokumenta = null, \StructType\ONTO $oNTO = null, $oNTOID = null, $opis = null, \StructType\PrateciList $prateciList = null, $prateciListID = null, $promijenio = null, $putanja = null, \StructType\TijekOtpada $tijekOtpada = null, $tijekOtpadaID = null, \StructType\TijekOtpadaP $tijekOtpadaP = null, $tijekOtpadaPID = null, $tipDatoteke = null, $vlasnikLokacijaID = null)
    {
        $this
            ->setDatoteka($datoteka)
            ->setDatumKreiranja($datumKreiranja)
            ->setDatumNastanka($datumNastanka)
            ->setDatumPromjene($datumPromjene)
            ->setDokumentID($dokumentID)
            ->setDokumentKategorijaDokumentas($dokumentKategorijaDokumentas)
            ->setKreirao($kreirao)
            ->setLokacija($lokacija)
            ->setLokacija1($lokacija1)
            ->setLokacijaID($lokacijaID)
            ->setNazivDokumenta($nazivDokumenta)
            ->setONTO($oNTO)
            ->setONTOID($oNTOID)
            ->setOpis($opis)
            ->setPrateciList($prateciList)
            ->setPrateciListID($prateciListID)
            ->setPromijenio($promijenio)
            ->setPutanja($putanja)
            ->setTijekOtpada($tijekOtpada)
            ->setTijekOtpadaID($tijekOtpadaID)
            ->setTijekOtpadaP($tijekOtpadaP)
            ->setTijekOtpadaPID($tijekOtpadaPID)
            ->setTipDatoteke($tipDatoteke)
            ->setVlasnikLokacijaID($vlasnikLokacijaID);
    }
    /**
     * Get Datoteka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatoteka()
    {
        return isset($this->Datoteka) ? $this->Datoteka : null;
    }
    /**
     * Set Datoteka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datoteka
     * @return \StructType\Dokument
     */
    public function setDatoteka($datoteka = null)
    {
        // validation for constraint: string
        if (!is_null($datoteka) && !is_string($datoteka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datoteka, true), gettype($datoteka)), __LINE__);
        }
        if (is_null($datoteka) || (is_array($datoteka) && empty($datoteka))) {
            unset($this->Datoteka);
        } else {
            $this->Datoteka = $datoteka;
        }
        return $this;
    }
    /**
     * Get DatumKreiranja value
     * @return string|null
     */
    public function getDatumKreiranja()
    {
        return $this->DatumKreiranja;
    }
    /**
     * Set DatumKreiranja value
     * @param string $datumKreiranja
     * @return \StructType\Dokument
     */
    public function setDatumKreiranja($datumKreiranja = null)
    {
        // validation for constraint: string
        if (!is_null($datumKreiranja) && !is_string($datumKreiranja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumKreiranja, true), gettype($datumKreiranja)), __LINE__);
        }
        $this->DatumKreiranja = $datumKreiranja;
        return $this;
    }
    /**
     * Get DatumNastanka value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumNastanka()
    {
        return isset($this->DatumNastanka) ? $this->DatumNastanka : null;
    }
    /**
     * Set DatumNastanka value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumNastanka
     * @return \StructType\Dokument
     */
    public function setDatumNastanka($datumNastanka = null)
    {
        // validation for constraint: string
        if (!is_null($datumNastanka) && !is_string($datumNastanka)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumNastanka, true), gettype($datumNastanka)), __LINE__);
        }
        if (is_null($datumNastanka) || (is_array($datumNastanka) && empty($datumNastanka))) {
            unset($this->DatumNastanka);
        } else {
            $this->DatumNastanka = $datumNastanka;
        }
        return $this;
    }
    /**
     * Get DatumPromjene value
     * @return string|null
     */
    public function getDatumPromjene()
    {
        return $this->DatumPromjene;
    }
    /**
     * Set DatumPromjene value
     * @param string $datumPromjene
     * @return \StructType\Dokument
     */
    public function setDatumPromjene($datumPromjene = null)
    {
        // validation for constraint: string
        if (!is_null($datumPromjene) && !is_string($datumPromjene)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumPromjene, true), gettype($datumPromjene)), __LINE__);
        }
        $this->DatumPromjene = $datumPromjene;
        return $this;
    }
    /**
     * Get DokumentID value
     * @return int|null
     */
    public function getDokumentID()
    {
        return $this->DokumentID;
    }
    /**
     * Set DokumentID value
     * @param int $dokumentID
     * @return \StructType\Dokument
     */
    public function setDokumentID($dokumentID = null)
    {
        // validation for constraint: int
        if (!is_null($dokumentID) && !(is_int($dokumentID) || ctype_digit($dokumentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dokumentID, true), gettype($dokumentID)), __LINE__);
        }
        $this->DokumentID = $dokumentID;
        return $this;
    }
    /**
     * Get DokumentKategorijaDokumentas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDokumentKategorijaDokumenta|null
     */
    public function getDokumentKategorijaDokumentas()
    {
        return isset($this->DokumentKategorijaDokumentas) ? $this->DokumentKategorijaDokumentas : null;
    }
    /**
     * Set DokumentKategorijaDokumentas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDokumentKategorijaDokumenta $dokumentKategorijaDokumentas
     * @return \StructType\Dokument
     */
    public function setDokumentKategorijaDokumentas(\ArrayType\ArrayOfDokumentKategorijaDokumenta $dokumentKategorijaDokumentas = null)
    {
        if (is_null($dokumentKategorijaDokumentas) || (is_array($dokumentKategorijaDokumentas) && empty($dokumentKategorijaDokumentas))) {
            unset($this->DokumentKategorijaDokumentas);
        } else {
            $this->DokumentKategorijaDokumentas = $dokumentKategorijaDokumentas;
        }
        return $this;
    }
    /**
     * Get Kreirao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKreirao()
    {
        return isset($this->Kreirao) ? $this->Kreirao : null;
    }
    /**
     * Set Kreirao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kreirao
     * @return \StructType\Dokument
     */
    public function setKreirao($kreirao = null)
    {
        // validation for constraint: string
        if (!is_null($kreirao) && !is_string($kreirao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kreirao, true), gettype($kreirao)), __LINE__);
        }
        if (is_null($kreirao) || (is_array($kreirao) && empty($kreirao))) {
            unset($this->Kreirao);
        } else {
            $this->Kreirao = $kreirao;
        }
        return $this;
    }
    /**
     * Get Lokacija value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Lokacija|null
     */
    public function getLokacija()
    {
        return isset($this->Lokacija) ? $this->Lokacija : null;
    }
    /**
     * Set Lokacija value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Lokacija $lokacija
     * @return \StructType\Dokument
     */
    public function setLokacija(\StructType\Lokacija $lokacija = null)
    {
        if (is_null($lokacija) || (is_array($lokacija) && empty($lokacija))) {
            unset($this->Lokacija);
        } else {
            $this->Lokacija = $lokacija;
        }
        return $this;
    }
    /**
     * Get Lokacija1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Lokacija|null
     */
    public function getLokacija1()
    {
        return isset($this->Lokacija1) ? $this->Lokacija1 : null;
    }
    /**
     * Set Lokacija1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Lokacija $lokacija1
     * @return \StructType\Dokument
     */
    public function setLokacija1(\StructType\Lokacija $lokacija1 = null)
    {
        if (is_null($lokacija1) || (is_array($lokacija1) && empty($lokacija1))) {
            unset($this->Lokacija1);
        } else {
            $this->Lokacija1 = $lokacija1;
        }
        return $this;
    }
    /**
     * Get LokacijaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLokacijaID()
    {
        return isset($this->LokacijaID) ? $this->LokacijaID : null;
    }
    /**
     * Set LokacijaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lokacijaID
     * @return \StructType\Dokument
     */
    public function setLokacijaID($lokacijaID = null)
    {
        // validation for constraint: int
        if (!is_null($lokacijaID) && !(is_int($lokacijaID) || ctype_digit($lokacijaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lokacijaID, true), gettype($lokacijaID)), __LINE__);
        }
        if (is_null($lokacijaID) || (is_array($lokacijaID) && empty($lokacijaID))) {
            unset($this->LokacijaID);
        } else {
            $this->LokacijaID = $lokacijaID;
        }
        return $this;
    }
    /**
     * Get NazivDokumenta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNazivDokumenta()
    {
        return isset($this->NazivDokumenta) ? $this->NazivDokumenta : null;
    }
    /**
     * Set NazivDokumenta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nazivDokumenta
     * @return \StructType\Dokument
     */
    public function setNazivDokumenta($nazivDokumenta = null)
    {
        // validation for constraint: string
        if (!is_null($nazivDokumenta) && !is_string($nazivDokumenta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazivDokumenta, true), gettype($nazivDokumenta)), __LINE__);
        }
        if (is_null($nazivDokumenta) || (is_array($nazivDokumenta) && empty($nazivDokumenta))) {
            unset($this->NazivDokumenta);
        } else {
            $this->NazivDokumenta = $nazivDokumenta;
        }
        return $this;
    }
    /**
     * Get ONTO value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ONTO|null
     */
    public function getONTO()
    {
        return isset($this->ONTO) ? $this->ONTO : null;
    }
    /**
     * Set ONTO value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ONTO $oNTO
     * @return \StructType\Dokument
     */
    public function setONTO(\StructType\ONTO $oNTO = null)
    {
        if (is_null($oNTO) || (is_array($oNTO) && empty($oNTO))) {
            unset($this->ONTO);
        } else {
            $this->ONTO = $oNTO;
        }
        return $this;
    }
    /**
     * Get ONTOID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getONTOID()
    {
        return isset($this->ONTOID) ? $this->ONTOID : null;
    }
    /**
     * Set ONTOID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $oNTOID
     * @return \StructType\Dokument
     */
    public function setONTOID($oNTOID = null)
    {
        // validation for constraint: int
        if (!is_null($oNTOID) && !(is_int($oNTOID) || ctype_digit($oNTOID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oNTOID, true), gettype($oNTOID)), __LINE__);
        }
        if (is_null($oNTOID) || (is_array($oNTOID) && empty($oNTOID))) {
            unset($this->ONTOID);
        } else {
            $this->ONTOID = $oNTOID;
        }
        return $this;
    }
    /**
     * Get Opis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpis()
    {
        return isset($this->Opis) ? $this->Opis : null;
    }
    /**
     * Set Opis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $opis
     * @return \StructType\Dokument
     */
    public function setOpis($opis = null)
    {
        // validation for constraint: string
        if (!is_null($opis) && !is_string($opis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($opis, true), gettype($opis)), __LINE__);
        }
        if (is_null($opis) || (is_array($opis) && empty($opis))) {
            unset($this->Opis);
        } else {
            $this->Opis = $opis;
        }
        return $this;
    }
    /**
     * Get PrateciList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PrateciList|null
     */
    public function getPrateciList()
    {
        return isset($this->PrateciList) ? $this->PrateciList : null;
    }
    /**
     * Set PrateciList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PrateciList $prateciList
     * @return \StructType\Dokument
     */
    public function setPrateciList(\StructType\PrateciList $prateciList = null)
    {
        if (is_null($prateciList) || (is_array($prateciList) && empty($prateciList))) {
            unset($this->PrateciList);
        } else {
            $this->PrateciList = $prateciList;
        }
        return $this;
    }
    /**
     * Get PrateciListID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrateciListID()
    {
        return isset($this->PrateciListID) ? $this->PrateciListID : null;
    }
    /**
     * Set PrateciListID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $prateciListID
     * @return \StructType\Dokument
     */
    public function setPrateciListID($prateciListID = null)
    {
        // validation for constraint: int
        if (!is_null($prateciListID) && !(is_int($prateciListID) || ctype_digit($prateciListID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prateciListID, true), gettype($prateciListID)), __LINE__);
        }
        if (is_null($prateciListID) || (is_array($prateciListID) && empty($prateciListID))) {
            unset($this->PrateciListID);
        } else {
            $this->PrateciListID = $prateciListID;
        }
        return $this;
    }
    /**
     * Get Promijenio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromijenio()
    {
        return isset($this->Promijenio) ? $this->Promijenio : null;
    }
    /**
     * Set Promijenio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $promijenio
     * @return \StructType\Dokument
     */
    public function setPromijenio($promijenio = null)
    {
        // validation for constraint: string
        if (!is_null($promijenio) && !is_string($promijenio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promijenio, true), gettype($promijenio)), __LINE__);
        }
        if (is_null($promijenio) || (is_array($promijenio) && empty($promijenio))) {
            unset($this->Promijenio);
        } else {
            $this->Promijenio = $promijenio;
        }
        return $this;
    }
    /**
     * Get Putanja value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPutanja()
    {
        return isset($this->Putanja) ? $this->Putanja : null;
    }
    /**
     * Set Putanja value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $putanja
     * @return \StructType\Dokument
     */
    public function setPutanja($putanja = null)
    {
        // validation for constraint: string
        if (!is_null($putanja) && !is_string($putanja)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($putanja, true), gettype($putanja)), __LINE__);
        }
        if (is_null($putanja) || (is_array($putanja) && empty($putanja))) {
            unset($this->Putanja);
        } else {
            $this->Putanja = $putanja;
        }
        return $this;
    }
    /**
     * Get TijekOtpada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TijekOtpada|null
     */
    public function getTijekOtpada()
    {
        return isset($this->TijekOtpada) ? $this->TijekOtpada : null;
    }
    /**
     * Set TijekOtpada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TijekOtpada $tijekOtpada
     * @return \StructType\Dokument
     */
    public function setTijekOtpada(\StructType\TijekOtpada $tijekOtpada = null)
    {
        if (is_null($tijekOtpada) || (is_array($tijekOtpada) && empty($tijekOtpada))) {
            unset($this->TijekOtpada);
        } else {
            $this->TijekOtpada = $tijekOtpada;
        }
        return $this;
    }
    /**
     * Get TijekOtpadaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTijekOtpadaID()
    {
        return isset($this->TijekOtpadaID) ? $this->TijekOtpadaID : null;
    }
    /**
     * Set TijekOtpadaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tijekOtpadaID
     * @return \StructType\Dokument
     */
    public function setTijekOtpadaID($tijekOtpadaID = null)
    {
        // validation for constraint: int
        if (!is_null($tijekOtpadaID) && !(is_int($tijekOtpadaID) || ctype_digit($tijekOtpadaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tijekOtpadaID, true), gettype($tijekOtpadaID)), __LINE__);
        }
        if (is_null($tijekOtpadaID) || (is_array($tijekOtpadaID) && empty($tijekOtpadaID))) {
            unset($this->TijekOtpadaID);
        } else {
            $this->TijekOtpadaID = $tijekOtpadaID;
        }
        return $this;
    }
    /**
     * Get TijekOtpadaP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TijekOtpadaP|null
     */
    public function getTijekOtpadaP()
    {
        return isset($this->TijekOtpadaP) ? $this->TijekOtpadaP : null;
    }
    /**
     * Set TijekOtpadaP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TijekOtpadaP $tijekOtpadaP
     * @return \StructType\Dokument
     */
    public function setTijekOtpadaP(\StructType\TijekOtpadaP $tijekOtpadaP = null)
    {
        if (is_null($tijekOtpadaP) || (is_array($tijekOtpadaP) && empty($tijekOtpadaP))) {
            unset($this->TijekOtpadaP);
        } else {
            $this->TijekOtpadaP = $tijekOtpadaP;
        }
        return $this;
    }
    /**
     * Get TijekOtpadaPID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTijekOtpadaPID()
    {
        return isset($this->TijekOtpadaPID) ? $this->TijekOtpadaPID : null;
    }
    /**
     * Set TijekOtpadaPID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tijekOtpadaPID
     * @return \StructType\Dokument
     */
    public function setTijekOtpadaPID($tijekOtpadaPID = null)
    {
        // validation for constraint: int
        if (!is_null($tijekOtpadaPID) && !(is_int($tijekOtpadaPID) || ctype_digit($tijekOtpadaPID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tijekOtpadaPID, true), gettype($tijekOtpadaPID)), __LINE__);
        }
        if (is_null($tijekOtpadaPID) || (is_array($tijekOtpadaPID) && empty($tijekOtpadaPID))) {
            unset($this->TijekOtpadaPID);
        } else {
            $this->TijekOtpadaPID = $tijekOtpadaPID;
        }
        return $this;
    }
    /**
     * Get TipDatoteke value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipDatoteke()
    {
        return isset($this->TipDatoteke) ? $this->TipDatoteke : null;
    }
    /**
     * Set TipDatoteke value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipDatoteke
     * @return \StructType\Dokument
     */
    public function setTipDatoteke($tipDatoteke = null)
    {
        // validation for constraint: string
        if (!is_null($tipDatoteke) && !is_string($tipDatoteke)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipDatoteke, true), gettype($tipDatoteke)), __LINE__);
        }
        if (is_null($tipDatoteke) || (is_array($tipDatoteke) && empty($tipDatoteke))) {
            unset($this->TipDatoteke);
        } else {
            $this->TipDatoteke = $tipDatoteke;
        }
        return $this;
    }
    /**
     * Get VlasnikLokacijaID value
     * @return int|null
     */
    public function getVlasnikLokacijaID()
    {
        return $this->VlasnikLokacijaID;
    }
    /**
     * Set VlasnikLokacijaID value
     * @param int $vlasnikLokacijaID
     * @return \StructType\Dokument
     */
    public function setVlasnikLokacijaID($vlasnikLokacijaID = null)
    {
        // validation for constraint: int
        if (!is_null($vlasnikLokacijaID) && !(is_int($vlasnikLokacijaID) || ctype_digit($vlasnikLokacijaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vlasnikLokacijaID, true), gettype($vlasnikLokacijaID)), __LINE__);
        }
        $this->VlasnikLokacijaID = $vlasnikLokacijaID;
        return $this;
    }
}
